package pl.magot.vetch.ancal.agenda;

import java.util.ArrayList;
import java.util.Calendar;

import pl.magot.vetch.ancal.dataview.AbstractDataView;
import pl.magot.vetch.ancal.dataview.DataViewItem;
import pl.magot.vetch.ancal.views.ViewWeekDayItem;
import android.graphics.Paint;
import android.view.ViewGroup.LayoutParams;
import android.widget.LinearLayout;

import com.droidwave.offlinecalendar.OfflineCalendar;

public class AgendaViewWeek extends AbstractAgendaView {
	// fields
	private ArrayList<ViewWeekDayItem> vecDayItems = new ArrayList<ViewWeekDayItem>();
	protected LinearLayout llayParentWeek = null;
	Calendar calWeekStart = Calendar.getInstance();

	// fields
	private Paint mpt = new Paint();

	// methods
	public AgendaViewWeek(OfflineCalendar main) {
		super(main);

		LinearLayout.LayoutParams layParams = new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, main.getViewSpaceHeight());

		// create parent content layout for week view (don't know why not works
		// for
		// llayParent
		llayParentWeek = new LinearLayout(main);
		llayParentWeek.setPadding(0, 0, 0, 0);
		llayParentWeek.setOrientation(LinearLayout.HORIZONTAL);
		llayParentWeek.setLayoutParams(layParams);
	}

	@Override
	public int getViewType() {
		return viewMode.WEEK;
	}

	@Override
	public int getViewIndex() {
		return 2;
	}

	private ViewWeekDayItem.OnItemClick mWeekDayItemClick = new ViewWeekDayItem.OnItemClick() {
		public void OnClick(ViewWeekDayItem item) {
			OnDayItemClick(item);
		}
	};

	@Override
	public void rebuild() {
		llayParent.removeAllViews();
		llayParentWeek.removeAllViews();

		final int iParentWidth = main.getViewSpaceWidth();
		final int iParentHeight = main.getViewSpaceHeight() - 5;
		int iDefaultWidth = 0;
		int iWidth = 0;

		final int iSpaceWidthTime = ViewWeekDayItem.GetSpaceWidthTime(mpt,
				main.prefs.b24HourMode);
		final int iSpaceHeightHeader = ViewWeekDayItem
				.GetSpaceHeightHeader(mpt);

		// build 7 days week view
		vecDayItems.clear();
		for (int iDay = 0; iDay < 7; iDay++) {
			ViewWeekDayItem item = new ViewWeekDayItem(main, iSpaceHeightHeader);

			// set event
			item.SetItemClick(mWeekDayItemClick);

			// set size
			if (iDay == 0) {
				item.SetTimeMargin(iSpaceWidthTime, main.prefs.b24HourMode);
				iDefaultWidth = (iParentWidth - iSpaceWidthTime) / 7;
				iWidth = iDefaultWidth + iSpaceWidthTime;
			} else {
				iWidth = iDefaultWidth;
			}
			item.SetSize(iWidth, iParentHeight);

			// add to layout
			vecDayItems.add(item);
			llayParentWeek.addView(item);
		}

		llayParent.addView(llayParentWeek);
	}

	public void OnDayItemClick(ViewWeekDayItem item) {
		Calendar calDate = Calendar.getInstance();
		calDate.setTimeInMillis(item.GetDate().getTimeInMillis());
		main.setAgendaView(AbstractAgendaView.viewMode.DAY, calDate);
	}

	@Override
	public void RebuildViewAppointments(AbstractDataView dataView) {
		final boolean bIsViewToday = IsViewToday();
		final int iCurrentHour = getTodayCurrentHour();

		calWeekStart.setTimeInMillis(GetViewStartDate().getTimeInMillis());
		calWeekStart.setFirstDayOfWeek(main.prefs.iFirstDayOfWeek);

		// setup weekdays data
		Calendar calDateToday = main.getDateToday();
		for (int iDay = 0; iDay < 7; iDay++) {
			ViewWeekDayItem item = vecDayItems.get(iDay);
			item.ClearTimeItems();
			item.SetDate(calWeekStart, calDateToday);
			item.SetCurrentHour((bIsViewToday) ? iCurrentHour : -1);
			calWeekStart.add(Calendar.DAY_OF_YEAR, 1);
		}

		// rebuild view
		for (int i = 0; i < dataView.GetRowsCountTotal(); i++) {
			// get data item
			DataViewItem row = dataView.GetRow(i, this.getViewType());
			if (row != null) {
				// iterate repeat week days in data item
				for (int iDay = 0; iDay < 7; iDay++) {
					// get item visible date
					if (row.GetVisibleDay(iDay)) {
						// get week day item
						ViewWeekDayItem item = vecDayItems.get(iDay);
						item.AddTimeItem(row.GetStartHour(), row
								.GetStartMinute(), row.iDurationInMinutes);
					}
				}

			}
		}

		llayParentWeek.requestLayout();
		llayParentWeek.invalidate();
	}

	@Override
	public void rebuildViewNotes(AbstractDataView dataView) {
	}

	@Override
	public void rebuildViewTasks(AbstractDataView dataView) {
	}

	@Override
	public void updateTimeFormat() {
		int iParentWidth = main.getViewSpaceWidth();
		int iParentHeight = main.getViewSpaceHeight();
		int iDefaultWidth = 0;
		int iWidth = 0;

		final int iSpaceWidthTime = ViewWeekDayItem.GetSpaceWidthTime(mpt,
				main.prefs.b24HourMode);

		for (int iDay = 0; iDay < 7; iDay++) {
			ViewWeekDayItem item = vecDayItems.get(iDay);
			if (iDay == 0) {
				item.SetTimeMargin(iSpaceWidthTime, main.prefs.b24HourMode);
				iDefaultWidth = (iParentWidth - iSpaceWidthTime) / 7;
				iWidth = iDefaultWidth + iSpaceWidthTime;
			} else {
				iWidth = iDefaultWidth;
			}
			item.SetSize(iWidth, iParentHeight);
		}
	}
}
