package pl.magot.vetch.ancal.database;

import android.database.Cursor;

public class DataTable {
	// fields
	private DataRow dataRow = null;

	// methods
	public DataTable(DataRow dataRow) {
		this.dataRow = dataRow;
	}

	public Database GetUserDb() {
		return dataRow.GetUserDb();
	}

	public String GetTableName() {
		return dataRow.GetTableName();
	}

	public DataRow GetDataRow() {
		return dataRow;
	}

	public boolean CreateTable() {
		if (GetUserDb().tableExists(GetTableName())) {
			return true;
		} else {
			return GetUserDb()
					.execSQL(
							GetSqlTableDefinition(GetTableName(), dataRow
									.GetTableDef()));
		}
	}

	public String GetSqlTableDefinition(String sTableName,
			DataField[] vecTableDef) {
		String def = "CREATE TABLE " + sTableName + " (";
		for (int i = 0; i < vecTableDef.length; i++) {
			def += vecTableDef[i].GetColumnDefinition();
			if (i < (vecTableDef.length - 1))
				def += ", ";
		}
		def += ")";
		return def;
	}

	public long InsertValues() {
		long lRowId = GetUserDb().getSQLiteDb().insert(GetTableName(), null,
				dataRow.GetContentValues());
		return lRowId;
	}

	public long UpdateValues(long lRowId) {
		String sWhere = String.format("_ID = %d", lRowId);
		long lRowsUpdated = GetUserDb().getSQLiteDb().update(GetTableName(),
				dataRow.GetContentValues(), sWhere, null);
		return lRowsUpdated;
	}

	public long DeleteDataRow(long lRowId) {
		String sWhere = String.format("_ID = %d", lRowId);
		long lRowsUpdated = GetUserDb().getSQLiteDb().delete(GetTableName(),
				sWhere, null);
		return lRowsUpdated;
	}

	public Cursor LocateDataRow(long lRowId) {
		final String s = "select * from %s where _ID = %d";
		String sql = String.format(s, GetTableName(), lRowId);
		Cursor cr = GetUserDb().getSQLiteDb().rawQuery(sql, null);
		// if cursor valid, set first data row as current
		if ((cr != null) && (cr.getCount() > 0))
			cr.moveToFirst();
		return cr;
	}

	public Cursor LocateAlarmDataRow(int iType, long lRefID) {
		final String s = "select * from %s where Type = %d and RefID = %d";
		String sql = String.format(s, GetTableName(), iType, lRefID);
		Cursor cr = GetUserDb().getSQLiteDb().rawQuery(sql, null);

		// if cursor valid, set first data row as current
		if ((cr != null) && (cr.getCount() > 0))
			cr.moveToFirst();
		else
			cr.close();

		return cr;
	}

	public Database.Result UpdateData(boolean bInsertMode, long lEditRowId) {
		Database.Result result = Database.Result.errUnknown;
		if (GetUserDb().isOpened()) {
			try {
				dataRow.SetValuesForDataRow();
			} catch (Exception e) {
				return Database.Result.errCantSetValuesForDataRow;
			}
			// select update mode
			if (bInsertMode) {
				// insert new data row
				long lRowId = InsertValues();
				if (lRowId > 0) {
					result = Database.Result.Success;
				} else {
					result = Database.Result.errCantInsertNewData;
				}
			} else {
				// update existing data row
				long lRowsUpdated = UpdateValues(lEditRowId);
				if (lRowsUpdated == 1) {
					result = Database.Result.Success;
				} else {
					result = Database.Result.errCantUpdateData;
				}
			}
		} else {
			result = Database.Result.errNoDbAccess;
		}
		return result;
	}

	public Database.Result DeleteData(long iRowId) {
		Database.Result result = Database.Result.errUnknown;
		if (GetUserDb().isOpened()) {
			if (GetUserDb().tableExists(GetTableName())) {
				long lRowsDeleted = DeleteDataRow(iRowId);
				if (lRowsDeleted == 1) {
					result = Database.Result.Success;
				} else {
					result = Database.Result.errCantDeleteData;
				}
			} else {
				result = Database.Result.errTableNotExists;
			}
		} else {
			result = Database.Result.errNoDbAccess;
		}
		return result;
	}

	public Database.Result GetRowDataForEdit(long lRowId) {
		Database.Result result = Database.Result.errUnknown;
		// get requested data row
		Cursor cr = LocateDataRow(lRowId);
		if (cr == null) {
			result = Database.Result.errCantGetData;
		} else {
			if (cr.getCount() > 0) {
				if (dataRow.GetValuesFromCursor(cr)) {
					try {
						dataRow.GetValuesFromDataRow();
					} catch (Exception e) {
						return Database.Result.errCantGetValuesFromDataRow;
					}
					result = Database.Result.Success;
				} else {
					result = Database.Result.errCantGetDataFromTable;
				}
				cr.close();
			} else {
				result = Database.Result.errCantFindData;
			}
		}
		return result;
	}
}
