package pl.magot.vetch.ancal.database;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;

import com.droidwave.offlinecalendar.R;

public class Database {
	// types
	public enum Result {
		Success, errUnknown, errCantInsertNewData, errCantUpdateData, errCantCreateTable, errNoDbAccess, errCantGetDataFromTable, errCantFindData, errCantGetData, errCantDeleteData, errTableNotExists, errCantSetValuesForDataRow, errCantGetValuesFromDataRow,
	};

	private static final Map<Result, Integer> errDescs = new HashMap<Result, Integer>();
	{
		errDescs
				.put(Result.errCantInsertNewData, R.string.errCantInsertNewData);
		errDescs.put(Result.errCantUpdateData, R.string.errCantUpdateData);
		errDescs.put(Result.errCantCreateTable, R.string.errCantCreateTable);
		errDescs.put(Result.errNoDbAccess, R.string.errNoDbAccess);
		errDescs.put(Result.errCantFindData, R.string.errCantFindData);
		errDescs.put(Result.errCantGetData, R.string.errCantGetData);
		errDescs.put(Result.errCantDeleteData, R.string.errCantDeleteData);
		errDescs.put(Result.errTableNotExists, R.string.errTableNotExists);
		errDescs.put(Result.errCantSetValuesForDataRow,
				R.string.errCantSetValuesForDataRow);
		errDescs.put(Result.errCantGetValuesFromDataRow,
				R.string.errCantGetValuesFromDataRow);
	}
	// fields
	public static final String sTableNameAppointments = "Appointments";
	public static final String sTableNameTasks = "Tasks";
	public static final String sTableNameNotes = "Notes";
	public static final String sTableNameAlarms = "Alarms";

	// fields
	private final String dbName = "AnCalDatabase.db";
	private Context ctx = null;
	private SQLiteDatabase db = null;
	private Result resultDbTablesCreated = Result.errUnknown;

	// methods
	public Database(Context context) {
		ctx = context;
		Open();
		createTables();
	}

	public final String Name() {
		return dbName;
	}

	public static int getErrDesc(Result result) {
		Integer msgId = errDescs.get(result);
		if (msgId == null) {
			msgId = R.string.errUnknown;
		}
		return msgId;
	}

	public boolean Open() {
		boolean bSuccess = false;
		// open / create database
		db = ctx.openOrCreateDatabase(dbName, Context.MODE_PRIVATE, null);
		// test result
		if (isOpened()) {
			bSuccess = true;
		} else {
			db = null;
		}
		return bSuccess;
	}

	public void close() {
		if (isOpened())
			db.close();
	}

	public boolean isOpened() {
		if (db != null)
			return true;
		return false;
	}

	public SQLiteDatabase getSQLiteDb() {
		return db;
	}

	public boolean delete() {
		close();
		return ctx.deleteDatabase(dbName);
	}

	public boolean execSQL(String sql) {
		boolean bSuccess = false;
		try {
			if (isOpened())
				db.execSQL(sql);
			bSuccess = true;
		} catch (SQLException e) {
		}
		return bSuccess;
	}

	public boolean tableExists(String sTableName) {
		boolean bResult = false;
		if (isOpened()) {
			String sql = "select name from sqlite_master where type = 'table' and name = '%s'";
			sql = String.format(sql, sTableName);
			Cursor cr = db.rawQuery(sql, null);
			if (cr.getCount() > 0)
				bResult = true;
			cr.close();
		}
		return bResult;
	}

	private void createTables() {
		resultDbTablesCreated = Result.errUnknown;
		if (isOpened()) {
			Vector<DataRow> vecDataRows = new Vector<DataRow>();
			vecDataRows.add(new DataRowAppointment(this));
			vecDataRows.add(new DataRowTask(this));
			vecDataRows.add(new DataRowNote(this));
			vecDataRows.add(new DataRowAlarm(this));

			for (int i = 0; i < vecDataRows.size(); i++) {
				DataTable dataTable = new DataTable(vecDataRows.get(i));
				if (dataTable.CreateTable()) {
					resultDbTablesCreated = Result.Success;
				} else {
					resultDbTablesCreated = Result.errCantCreateTable;
					break;
				}
			}
		} else {
			resultDbTablesCreated = Result.errNoDbAccess;
		}
	}

	public boolean tablesCreated() {
		return resultDbTablesCreated == Result.Success;
	}

	public synchronized boolean DatabaseReady() {
		return (isOpened() && tablesCreated());
	}

	public Result tablesCreationResult() {
		return resultDbTablesCreated;
	}

	public void finalize() {
		db.close();
	}
}
