package pl.magot.vetch.ancal.reminder;

import java.util.ArrayList;
import java.util.Calendar;

import pl.magot.vetch.ancal.Utils;
import pl.magot.vetch.ancal.views.ViewToastMsg;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Vibrator;
import android.util.Log;
import android.widget.Toast;

import com.droidwave.offlinecalendar.R;

public class AlarmReminder {
	private Context context = null;
	protected AlarmService.AlarmPrefs prefs = null;
	protected Utils utils = null;
	private ArrayList<AlarmDataViewItem> alarmItems = new ArrayList<AlarmDataViewItem>();
	private NotificationManager mNM = null;
	private final int iNotifyID1 = 1;
	private int iLastAlarmsHash = 0;
	private Calendar calHashToday = Calendar.getInstance();
	// TODO: leo 18 Jan 2011: add custom alarm sounds
	private String msgYouHaveASTS = "";
	private String msgYouHaveTS = "";
	private String msgYouHaveAS = "";
	private String msgASTS = "";
	private String msgTS = "";
	private String msgAS = "";
	private String strReminder = "";
	private String sAppName = "";

	public AlarmReminder(Context ctx, AlarmService.AlarmPrefs prefs, Utils utils) {
		this.context = ctx;
		this.prefs = prefs;
		this.utils = utils;

		sAppName = this.context.getString(R.string.app_name);
		mNM = (NotificationManager) ctx
				.getSystemService(Context.NOTIFICATION_SERVICE);
		removeNotify();

		// localize strings
		msgYouHaveASTS = utils.GetResStr(R.string.msgYouHaveASTS);
		msgYouHaveTS = utils.GetResStr(R.string.msgYouHaveTS);
		msgYouHaveAS = utils.GetResStr(R.string.msgYouHaveAS);
		msgASTS = utils.GetResStr(R.string.msgASTS);
		msgTS = utils.GetResStr(R.string.msgTS);
		msgAS = utils.GetResStr(R.string.msgAS);
		strReminder = utils.GetResStr(R.string.strReminder);
	}

	public void clear() {
		alarmItems.clear();
	}

	public void removeNotify() {
		mNM.cancel(iNotifyID1);
	}

	public void addAlarmData(ArrayList<AlarmDataViewItem> items) {
		this.alarmItems.addAll(items);
	}

	private boolean isAlarm() {
		return (alarmItems.size() > 0);
	}

	private int getItemsCount(int iOrderFilter) {
		int iCount = 0;
		for (int index = 0; index < alarmItems.size(); index++) {
			AlarmDataViewItem item = alarmItems.get(index);
			if (item.GetOrder() == iOrderFilter)
				iCount++;
		}
		return iCount;
	}

	private String getPopupMsg(int iCountAppts, int iCountTasks) {
		String msg = String.format(msgYouHaveASTS, iCountAppts, iCountTasks);
		if ((iCountAppts == 0) && (iCountTasks > 0))
			msg = String.format(msgYouHaveTS, iCountTasks);
		if ((iCountTasks == 0) && (iCountAppts > 0))
			msg = String.format(msgYouHaveAS, iCountAppts);
		return msg;
	}

	private String getStatusMsg(int iCountAppts, int iCountTasks) {
		String msg = String.format(msgASTS, iCountAppts, iCountTasks);
		if ((iCountAppts == 0) && (iCountTasks > 0))
			msg = String.format(msgTS, iCountTasks);
		if ((iCountTasks == 0) && (iCountAppts > 0))
			msg = String.format(msgAS, iCountAppts);
		return msg;
	}

	private String getTodayHashString() {
		calHashToday.setTimeInMillis(System.currentTimeMillis());
		return Integer.toString(calHashToday.get(Calendar.YEAR))
				+ Integer.toString(calHashToday.get(Calendar.MONTH))
				+ Integer.toString(calHashToday.get(Calendar.DAY_OF_MONTH));
	}

	private String getAlarmsHashString() {
		String sMsg = "";
		for (int index = 0; index < alarmItems.size(); index++) {
			AlarmDataViewItem item = alarmItems.get(index);
			sMsg += item.GetHashString();
		}
		// add today hash, for changing hash for next day compare (repeat
		// appointments)
		sMsg += getTodayHashString();
		return sMsg;
	}

	private boolean alarmsChanged() {
		String sAlarmsHashString = getAlarmsHashString();
		if (sAlarmsHashString.hashCode() == iLastAlarmsHash)
			return false;
		iLastAlarmsHash = sAlarmsHashString.hashCode();
		return true;
	}

	private void putDataItemsToBundle(Bundle data, int iOrderFilter) {
		int iKeyIndex = 0;
		for (int i = 0; i < alarmItems.size(); i++) {
			AlarmDataViewItem item = alarmItems.get(i);
			if (item.GetOrder() == iOrderFilter) {
				String sKey = "_" + Integer.toString(iOrderFilter) + "_"
						+ Integer.toString(iKeyIndex);

				data.putLong("rowid" + sKey, item.GetID());
				data.putString("text" + sKey, item.GetText(utils,
						prefs.b24HourMode));

				iKeyIndex++;
			}
		}
		data.putInt("typetotal_" + Integer.toString(iOrderFilter), iKeyIndex);
	}

	private PendingIntent getAlarmDialogIntent() {
		Intent intentAlarmDialog = new Intent(
				"android.intent.action.AnCal.ACTION_MODE_VIEW_ALARMDIALOG");
		Bundle data = new Bundle();
		putDataItemsToBundle(data, AlarmDataViewItem.iOrderAppts);
		putDataItemsToBundle(data, AlarmDataViewItem.iOrderTasks);
		intentAlarmDialog.putExtras(data);
		// return PendingIntent.getActivity(this.context, 0, intentAlarmDialog,
		// PendingIntent.FLAG_CANCEL_CURRENT);
		return PendingIntent.getActivity(this.context, 0, intentAlarmDialog, 0);
	}

	public void showNotification() {
		if (isAlarm()) {
			int iCountAppts = getItemsCount(AlarmDataViewItem.iOrderAppts);
			int iCountTasks = getItemsCount(AlarmDataViewItem.iOrderTasks);

			// is there something to show ?
			if ((iCountAppts > 0) || (iCountTasks > 0)) {
				// check if alarms changed from last time
				if (alarmsChanged()) {
					// remove last notify from status bar
					removeNotify();

					// make notify text
					final String sTitle = sAppName + ": " + strReminder;
					String sMessage = getPopupMsg(iCountAppts, iCountTasks);

					// make notify status
					String sStatus = getStatusMsg(iCountAppts, iCountTasks);

					// show popup message
					ViewToastMsg viewToastMsg = new ViewToastMsg(this.context,
							sTitle, sMessage);
					Toast toast = new Toast(this.context);
					toast.setDuration(Toast.LENGTH_LONG);
					toast.setView(viewToastMsg);
					toast.show();

					// show status bar notification item
					Notification notifyItem = new Notification(
							R.drawable.stat_notify_alarm, sStatus, System
									.currentTimeMillis());

					AlarmSound sound = new AlarmSound(context);
					sound.play();

					Log.i(this.getClass().getName(), "Vibrator is starting");
					Vibrator v = (Vibrator) context
							.getSystemService(Context.VIBRATOR_SERVICE);
					v.vibrate(2000);
					// .vibrate(pattern, 0);
					// v.cancel();
					Log.i(this.getClass().getName(), "Vibrator is stopped");

					notifyItem.defaults = Notification.DEFAULT_SOUND
							| Notification.DEFAULT_LIGHTS;
					notifyItem.setLatestEventInfo(this.context, strReminder,
							sStatus, getAlarmDialogIntent());

					// run
					mNM.notify(iNotifyID1, notifyItem);
				}
			}
		} else {
			removeNotify();
			iLastAlarmsHash = 0;
		}
	}
}
