/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.ContactsContract;
import android.util.Log;
import android.webkit.WebView;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.cordova.ContactAccessor;
import org.apache.cordova.api.CordovaInterface;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactAccessorSdk5
extends ContactAccessor {
    private static final long MAX_PHOTO_SIZE = 0x100000L;
    private static final String EMAIL_REGEXP = ".+@.+\\.+.+";
    private static final Map<String, String> dbMap = new HashMap<String, String>();

    public ContactAccessorSdk5(WebView view, CordovaInterface context) {
        this.mApp = context;
        this.mView = view;
    }

    @Override
    public JSONArray search(JSONArray fields, JSONObject options) {
        String searchTerm = "";
        int limit = Integer.MAX_VALUE;
        boolean multiple = true;
        if (options != null) {
            searchTerm = options.optString("filter");
            searchTerm = searchTerm.length() == 0 ? "%" : "%" + searchTerm + "%";
            try {
                multiple = options.getBoolean("multiple");
                if (!multiple) {
                    limit = 1;
                }
            }
            catch (JSONException e) {}
        } else {
            searchTerm = "%";
        }
        HashMap<String, Boolean> populate = this.buildPopulationSet(fields);
        ContactAccessor.WhereOptions whereOptions = this.buildWhereClause(fields, searchTerm);
        Cursor idCursor = this.mApp.getActivity().getContentResolver().query(ContactsContract.Data.CONTENT_URI, new String[]{"contact_id"}, whereOptions.getWhere(), whereOptions.getWhereArgs(), "contact_id ASC");
        HashSet<String> contactIds = new HashSet<String>();
        int idColumn = -1;
        while (idCursor.moveToNext()) {
            if (idColumn < 0) {
                idColumn = idCursor.getColumnIndex("contact_id");
            }
            contactIds.add(idCursor.getString(idColumn));
        }
        idCursor.close();
        ContactAccessor.WhereOptions idOptions = this.buildIdClause(contactIds, searchTerm);
        HashSet<String> columnsToFetch = new HashSet<String>();
        columnsToFetch.add("contact_id");
        columnsToFetch.add("raw_contact_id");
        columnsToFetch.add("mimetype");
        if (this.isRequired("displayName", populate)) {
            columnsToFetch.add("data1");
        }
        if (this.isRequired("name", populate)) {
            columnsToFetch.add("data3");
            columnsToFetch.add("data2");
            columnsToFetch.add("data5");
            columnsToFetch.add("data4");
            columnsToFetch.add("data6");
        }
        if (this.isRequired("phoneNumbers", populate)) {
            columnsToFetch.add("_id");
            columnsToFetch.add("data1");
            columnsToFetch.add("data2");
        }
        if (this.isRequired("emails", populate)) {
            columnsToFetch.add("_id");
            columnsToFetch.add("data1");
            columnsToFetch.add("data2");
        }
        if (this.isRequired("addresses", populate)) {
            columnsToFetch.add("_id");
            columnsToFetch.add("data2");
            columnsToFetch.add("data1");
            columnsToFetch.add("data4");
            columnsToFetch.add("data7");
            columnsToFetch.add("data8");
            columnsToFetch.add("data9");
            columnsToFetch.add("data10");
        }
        if (this.isRequired("organizations", populate)) {
            columnsToFetch.add("_id");
            columnsToFetch.add("data2");
            columnsToFetch.add("data5");
            columnsToFetch.add("data1");
            columnsToFetch.add("data4");
        }
        if (this.isRequired("ims", populate)) {
            columnsToFetch.add("_id");
            columnsToFetch.add("data1");
            columnsToFetch.add("data2");
        }
        if (this.isRequired("note", populate)) {
            columnsToFetch.add("data1");
        }
        if (this.isRequired("nickname", populate)) {
            columnsToFetch.add("data1");
        }
        if (this.isRequired("urls", populate)) {
            columnsToFetch.add("_id");
            columnsToFetch.add("data1");
            columnsToFetch.add("data2");
        }
        if (this.isRequired("birthday", populate)) {
            columnsToFetch.add("data1");
            columnsToFetch.add("data2");
        }
        if (this.isRequired("photos", populate)) {
            columnsToFetch.add("_id");
        }
        Cursor c = this.mApp.getActivity().getContentResolver().query(ContactsContract.Data.CONTENT_URI, columnsToFetch.toArray(new String[0]), idOptions.getWhere(), idOptions.getWhereArgs(), "contact_id ASC");
        JSONArray contacts = this.populateContactArray(limit, populate, c);
        return contacts;
    }

    @Override
    public JSONObject getContactById(String id) throws JSONException {
        Cursor c = this.mApp.getActivity().getContentResolver().query(ContactsContract.Data.CONTENT_URI, null, "contact_id = ? ", new String[]{id}, "contact_id ASC");
        JSONArray fields = new JSONArray();
        fields.put((Object)"*");
        HashMap<String, Boolean> populate = this.buildPopulationSet(fields);
        JSONArray contacts = this.populateContactArray(1, populate, c);
        if (contacts.length() == 1) {
            return contacts.getJSONObject(0);
        }
        return null;
    }

    private JSONArray populateContactArray(int limit, HashMap<String, Boolean> populate, Cursor c) {
        String contactId = "";
        String rawId = "";
        String oldContactId = "";
        boolean newContact = true;
        String mimetype = "";
        JSONArray contacts = new JSONArray();
        JSONObject contact = new JSONObject();
        JSONArray organizations = new JSONArray();
        JSONArray addresses = new JSONArray();
        JSONArray phones = new JSONArray();
        JSONArray emails = new JSONArray();
        JSONArray ims = new JSONArray();
        JSONArray websites = new JSONArray();
        JSONArray photos = new JSONArray();
        int colContactId = c.getColumnIndex("contact_id");
        int colRawContactId = c.getColumnIndex("raw_contact_id");
        int colMimetype = c.getColumnIndex("mimetype");
        int colDisplayName = c.getColumnIndex("data1");
        int colNote = c.getColumnIndex("data1");
        int colNickname = c.getColumnIndex("data1");
        int colBirthday = c.getColumnIndex("data1");
        int colEventType = c.getColumnIndex("data2");
        if (c.getCount() > 0) {
            while (c.moveToNext() && contacts.length() <= limit - 1) {
                try {
                    contactId = c.getString(colContactId);
                    rawId = c.getString(colRawContactId);
                    if (c.getPosition() == 0) {
                        oldContactId = contactId;
                    }
                    if (!oldContactId.equals(contactId)) {
                        contacts.put((Object)this.populateContact(contact, organizations, addresses, phones, emails, ims, websites, photos));
                        contact = new JSONObject();
                        organizations = new JSONArray();
                        addresses = new JSONArray();
                        phones = new JSONArray();
                        emails = new JSONArray();
                        ims = new JSONArray();
                        websites = new JSONArray();
                        photos = new JSONArray();
                        newContact = true;
                    }
                    if (newContact) {
                        newContact = false;
                        contact.put("id", (Object)contactId);
                        contact.put("rawId", (Object)rawId);
                    }
                    if ((mimetype = c.getString(colMimetype)).equals("vnd.android.cursor.item/name")) {
                        contact.put("displayName", (Object)c.getString(colDisplayName));
                    }
                    if (mimetype.equals("vnd.android.cursor.item/name") && this.isRequired("name", populate)) {
                        contact.put("name", (Object)this.nameQuery(c));
                    } else if (mimetype.equals("vnd.android.cursor.item/phone_v2") && this.isRequired("phoneNumbers", populate)) {
                        phones.put((Object)this.phoneQuery(c));
                    } else if (mimetype.equals("vnd.android.cursor.item/email_v2") && this.isRequired("emails", populate)) {
                        emails.put((Object)this.emailQuery(c));
                    } else if (mimetype.equals("vnd.android.cursor.item/postal-address_v2") && this.isRequired("addresses", populate)) {
                        addresses.put((Object)this.addressQuery(c));
                    } else if (mimetype.equals("vnd.android.cursor.item/organization") && this.isRequired("organizations", populate)) {
                        organizations.put((Object)this.organizationQuery(c));
                    } else if (mimetype.equals("vnd.android.cursor.item/im") && this.isRequired("ims", populate)) {
                        ims.put((Object)this.imQuery(c));
                    } else if (mimetype.equals("vnd.android.cursor.item/note") && this.isRequired("note", populate)) {
                        contact.put("note", (Object)c.getString(colNote));
                    } else if (mimetype.equals("vnd.android.cursor.item/nickname") && this.isRequired("nickname", populate)) {
                        contact.put("nickname", (Object)c.getString(colNickname));
                    } else if (mimetype.equals("vnd.android.cursor.item/website") && this.isRequired("urls", populate)) {
                        websites.put((Object)this.websiteQuery(c));
                    } else if (mimetype.equals("vnd.android.cursor.item/contact_event")) {
                        if (this.isRequired("birthday", populate) && 3 == c.getInt(colEventType)) {
                            contact.put("birthday", (Object)c.getString(colBirthday));
                        }
                    } else if (mimetype.equals("vnd.android.cursor.item/photo") && this.isRequired("photos", populate)) {
                        photos.put((Object)this.photoQuery(c, contactId));
                    }
                }
                catch (JSONException e) {
                    Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
                }
                oldContactId = contactId;
            }
            if (contacts.length() < limit) {
                contacts.put((Object)this.populateContact(contact, organizations, addresses, phones, emails, ims, websites, photos));
            }
        }
        c.close();
        return contacts;
    }

    private ContactAccessor.WhereOptions buildIdClause(Set<String> contactIds, String searchTerm) {
        ContactAccessor.WhereOptions options = new ContactAccessor.WhereOptions();
        if (searchTerm.equals("%")) {
            options.setWhere("(contact_id LIKE ? )");
            options.setWhereArgs(new String[]{searchTerm});
            return options;
        }
        Iterator<String> it = contactIds.iterator();
        StringBuffer buffer = new StringBuffer("(");
        while (it.hasNext()) {
            buffer.append("'" + it.next() + "'");
            if (!it.hasNext()) continue;
            buffer.append(",");
        }
        buffer.append(")");
        options.setWhere("contact_id IN " + buffer.toString());
        options.setWhereArgs(null);
        return options;
    }

    private JSONObject populateContact(JSONObject contact, JSONArray organizations, JSONArray addresses, JSONArray phones, JSONArray emails, JSONArray ims, JSONArray websites, JSONArray photos) {
        try {
            if (organizations.length() > 0) {
                contact.put("organizations", (Object)organizations);
            }
            if (addresses.length() > 0) {
                contact.put("addresses", (Object)addresses);
            }
            if (phones.length() > 0) {
                contact.put("phoneNumbers", (Object)phones);
            }
            if (emails.length() > 0) {
                contact.put("emails", (Object)emails);
            }
            if (ims.length() > 0) {
                contact.put("ims", (Object)ims);
            }
            if (websites.length() > 0) {
                contact.put("urls", (Object)websites);
            }
            if (photos.length() > 0) {
                contact.put("photos", (Object)photos);
            }
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return contact;
    }

    private ContactAccessor.WhereOptions buildWhereClause(JSONArray fields, String searchTerm) {
        ArrayList<String> where = new ArrayList<String>();
        ArrayList<String> whereArgs = new ArrayList<String>();
        ContactAccessor.WhereOptions options = new ContactAccessor.WhereOptions();
        if (this.isWildCardSearch(fields)) {
            if ("%".equals(searchTerm)) {
                options.setWhere("(display_name LIKE ? )");
                options.setWhereArgs(new String[]{searchTerm});
                return options;
            }
            where.add("(" + dbMap.get("displayName") + " LIKE ? )");
            whereArgs.add(searchTerm);
            where.add("(" + dbMap.get("name") + " LIKE ? AND " + "mimetype" + " = ? )");
            whereArgs.add(searchTerm);
            whereArgs.add("vnd.android.cursor.item/name");
            where.add("(" + dbMap.get("nickname") + " LIKE ? AND " + "mimetype" + " = ? )");
            whereArgs.add(searchTerm);
            whereArgs.add("vnd.android.cursor.item/nickname");
            where.add("(" + dbMap.get("phoneNumbers") + " LIKE ? AND " + "mimetype" + " = ? )");
            whereArgs.add(searchTerm);
            whereArgs.add("vnd.android.cursor.item/phone_v2");
            where.add("(" + dbMap.get("emails") + " LIKE ? AND " + "mimetype" + " = ? )");
            whereArgs.add(searchTerm);
            whereArgs.add("vnd.android.cursor.item/email_v2");
            where.add("(" + dbMap.get("addresses") + " LIKE ? AND " + "mimetype" + " = ? )");
            whereArgs.add(searchTerm);
            whereArgs.add("vnd.android.cursor.item/postal-address_v2");
            where.add("(" + dbMap.get("ims") + " LIKE ? AND " + "mimetype" + " = ? )");
            whereArgs.add(searchTerm);
            whereArgs.add("vnd.android.cursor.item/im");
            where.add("(" + dbMap.get("organizations") + " LIKE ? AND " + "mimetype" + " = ? )");
            whereArgs.add(searchTerm);
            whereArgs.add("vnd.android.cursor.item/organization");
            where.add("(" + dbMap.get("note") + " LIKE ? AND " + "mimetype" + " = ? )");
            whereArgs.add(searchTerm);
            whereArgs.add("vnd.android.cursor.item/note");
            where.add("(" + dbMap.get("urls") + " LIKE ? AND " + "mimetype" + " = ? )");
            whereArgs.add(searchTerm);
            whereArgs.add("vnd.android.cursor.item/website");
        }
        if ("%".equals(searchTerm)) {
            options.setWhere("(display_name LIKE ? )");
            options.setWhereArgs(new String[]{searchTerm});
            return options;
        }
        try {
            for (int i = 0; i < fields.length(); ++i) {
                String key = fields.getString(i);
                if (key.equals("id")) {
                    where.add("(" + dbMap.get(key) + " = ? )");
                    whereArgs.add(searchTerm.substring(1, searchTerm.length() - 1));
                    continue;
                }
                if (key.startsWith("displayName")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? )");
                    whereArgs.add(searchTerm);
                    continue;
                }
                if (key.startsWith("name")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/name");
                    continue;
                }
                if (key.startsWith("nickname")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/nickname");
                    continue;
                }
                if (key.startsWith("phoneNumbers")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/phone_v2");
                    continue;
                }
                if (key.startsWith("emails")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/email_v2");
                    continue;
                }
                if (key.startsWith("addresses")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/postal-address_v2");
                    continue;
                }
                if (key.startsWith("ims")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/im");
                    continue;
                }
                if (key.startsWith("organizations")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/organization");
                    continue;
                }
                if (key.startsWith("note")) {
                    where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                    whereArgs.add(searchTerm);
                    whereArgs.add("vnd.android.cursor.item/note");
                    continue;
                }
                if (!key.startsWith("urls")) continue;
                where.add("(" + dbMap.get(key) + " LIKE ? AND " + "mimetype" + " = ? )");
                whereArgs.add(searchTerm);
                whereArgs.add("vnd.android.cursor.item/website");
            }
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        StringBuffer selection = new StringBuffer();
        for (int i = 0; i < where.size(); ++i) {
            selection.append((String)where.get(i));
            if (i == where.size() - 1) continue;
            selection.append(" OR ");
        }
        options.setWhere(selection.toString());
        String[] selectionArgs = new String[whereArgs.size()];
        for (int i = 0; i < whereArgs.size(); ++i) {
            selectionArgs[i] = (String)whereArgs.get(i);
        }
        options.setWhereArgs(selectionArgs);
        return options;
    }

    private boolean isWildCardSearch(JSONArray fields) {
        if (fields.length() == 1) {
            try {
                if ("*".equals(fields.getString(0))) {
                    return true;
                }
            }
            catch (JSONException e) {
                return false;
            }
        }
        return false;
    }

    private JSONObject organizationQuery(Cursor cursor) {
        JSONObject organization = new JSONObject();
        try {
            organization.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            organization.put("pref", false);
            organization.put("type", (Object)this.getOrgType(cursor.getInt(cursor.getColumnIndex("data2"))));
            organization.put("department", (Object)cursor.getString(cursor.getColumnIndex("data5")));
            organization.put("name", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            organization.put("title", (Object)cursor.getString(cursor.getColumnIndex("data4")));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return organization;
    }

    private JSONObject addressQuery(Cursor cursor) {
        JSONObject address = new JSONObject();
        try {
            address.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            address.put("pref", false);
            address.put("type", (Object)this.getAddressType(cursor.getInt(cursor.getColumnIndex("data2"))));
            address.put("formatted", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            address.put("streetAddress", (Object)cursor.getString(cursor.getColumnIndex("data4")));
            address.put("locality", (Object)cursor.getString(cursor.getColumnIndex("data7")));
            address.put("region", (Object)cursor.getString(cursor.getColumnIndex("data8")));
            address.put("postalCode", (Object)cursor.getString(cursor.getColumnIndex("data9")));
            address.put("country", (Object)cursor.getString(cursor.getColumnIndex("data10")));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return address;
    }

    private JSONObject nameQuery(Cursor cursor) {
        JSONObject contactName = new JSONObject();
        try {
            String familyName = cursor.getString(cursor.getColumnIndex("data3"));
            String givenName = cursor.getString(cursor.getColumnIndex("data2"));
            String middleName = cursor.getString(cursor.getColumnIndex("data5"));
            String honorificPrefix = cursor.getString(cursor.getColumnIndex("data4"));
            String honorificSuffix = cursor.getString(cursor.getColumnIndex("data6"));
            StringBuffer formatted = new StringBuffer("");
            if (honorificPrefix != null) {
                formatted.append(honorificPrefix + " ");
            }
            if (givenName != null) {
                formatted.append(givenName + " ");
            }
            if (middleName != null) {
                formatted.append(middleName + " ");
            }
            if (familyName != null) {
                formatted.append(familyName);
            }
            if (honorificSuffix != null) {
                formatted.append(" " + honorificSuffix);
            }
            contactName.put("familyName", (Object)familyName);
            contactName.put("givenName", (Object)givenName);
            contactName.put("middleName", (Object)middleName);
            contactName.put("honorificPrefix", (Object)honorificPrefix);
            contactName.put("honorificSuffix", (Object)honorificSuffix);
            contactName.put("formatted", (Object)formatted);
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return contactName;
    }

    private JSONObject phoneQuery(Cursor cursor) {
        JSONObject phoneNumber = new JSONObject();
        try {
            phoneNumber.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            phoneNumber.put("pref", false);
            phoneNumber.put("value", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            phoneNumber.put("type", (Object)this.getPhoneType(cursor.getInt(cursor.getColumnIndex("data2"))));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        catch (Exception excp) {
            Log.e((String)"ContactsAccessor", (String)excp.getMessage(), (Throwable)excp);
        }
        return phoneNumber;
    }

    private JSONObject emailQuery(Cursor cursor) {
        JSONObject email = new JSONObject();
        try {
            email.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            email.put("pref", false);
            email.put("value", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            email.put("type", (Object)this.getContactType(cursor.getInt(cursor.getColumnIndex("data2"))));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return email;
    }

    private JSONObject imQuery(Cursor cursor) {
        JSONObject im = new JSONObject();
        try {
            im.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            im.put("pref", false);
            im.put("value", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            String type = cursor.getString(cursor.getColumnIndex("data5"));
            im.put("type", (Object)this.getImType(new Integer(type)));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return im;
    }

    private JSONObject websiteQuery(Cursor cursor) {
        JSONObject website = new JSONObject();
        try {
            website.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            website.put("pref", false);
            website.put("value", (Object)cursor.getString(cursor.getColumnIndex("data1")));
            website.put("type", (Object)this.getContactType(cursor.getInt(cursor.getColumnIndex("data2"))));
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return website;
    }

    private JSONObject photoQuery(Cursor cursor, String contactId) {
        JSONObject photo = new JSONObject();
        try {
            photo.put("id", (Object)cursor.getString(cursor.getColumnIndex("_id")));
            photo.put("pref", false);
            photo.put("type", (Object)"url");
            Uri person = ContentUris.withAppendedId((Uri)ContactsContract.Contacts.CONTENT_URI, (long)new Long(contactId));
            Uri photoUri = Uri.withAppendedPath((Uri)person, (String)"photo");
            photo.put("value", (Object)photoUri.toString());
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return photo;
    }

    @Override
    public String save(JSONObject contact) {
        AccountManager mgr = AccountManager.get((Context)this.mApp.getActivity());
        Account[] accounts = mgr.getAccounts();
        String accountName = null;
        String accountType = null;
        if (accounts.length == 1) {
            accountName = accounts[0].name;
            accountType = accounts[0].type;
        } else if (accounts.length > 1) {
            for (Account a : accounts) {
                if (!a.type.contains("eas") || !a.name.matches(EMAIL_REGEXP)) continue;
                accountName = a.name;
                accountType = a.type;
                break;
            }
            if (accountName == null) {
                for (Account a : accounts) {
                    if (!a.type.contains("com.google") || !a.name.matches(EMAIL_REGEXP)) continue;
                    accountName = a.name;
                    accountType = a.type;
                    break;
                }
            }
            if (accountName == null) {
                for (Account a : accounts) {
                    if (!a.name.matches(EMAIL_REGEXP)) continue;
                    accountName = a.name;
                    accountType = a.type;
                    break;
                }
            }
        }
        String id = this.getJsonString(contact, "id");
        if (id == null) {
            return this.createNewContact(contact, accountType, accountName);
        }
        return this.modifyContact(id, contact, accountType, accountName);
    }

    private String modifyContact(String id, JSONObject contact, String accountType, String accountName) {
        int rawId = new Integer(this.getJsonString(contact, "rawId"));
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.RawContacts.CONTENT_URI).withValue("account_type", (Object)accountType).withValue("account_name", (Object)accountName).build());
        try {
            String displayName = this.getJsonString(contact, "displayName");
            JSONObject name = contact.getJSONObject("name");
            if (displayName != null || name != null) {
                String honorificSuffix;
                String honorificPrefix;
                String givenName;
                String middleName;
                String familyName;
                ContentProviderOperation.Builder builder = ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("contact_id=? AND mimetype=?", new String[]{id, "vnd.android.cursor.item/name"});
                if (displayName != null) {
                    builder.withValue("data1", (Object)displayName);
                }
                if ((familyName = this.getJsonString(name, "familyName")) != null) {
                    builder.withValue("data3", (Object)familyName);
                }
                if ((middleName = this.getJsonString(name, "middleName")) != null) {
                    builder.withValue("data5", (Object)middleName);
                }
                if ((givenName = this.getJsonString(name, "givenName")) != null) {
                    builder.withValue("data2", (Object)givenName);
                }
                if ((honorificPrefix = this.getJsonString(name, "honorificPrefix")) != null) {
                    builder.withValue("data4", (Object)honorificPrefix);
                }
                if ((honorificSuffix = this.getJsonString(name, "honorificSuffix")) != null) {
                    builder.withValue("data6", (Object)honorificSuffix);
                }
                ops.add(builder.build());
            }
        }
        catch (JSONException e1) {
            Log.d((String)"ContactsAccessor", (String)"Could not get name");
        }
        JSONArray phones = null;
        try {
            phones = contact.getJSONArray("phoneNumbers");
            if (phones != null) {
                if (phones.length() == 0) {
                    ops.add(ContentProviderOperation.newDelete((Uri)ContactsContract.Data.CONTENT_URI).withSelection("raw_contact_id=? AND mimetype=?", new String[]{"" + rawId, "vnd.android.cursor.item/phone_v2"}).build());
                } else {
                    for (int i = 0; i < phones.length(); ++i) {
                        JSONObject phone = (JSONObject)phones.get(i);
                        String phoneId = this.getJsonString(phone, "id");
                        if (phoneId == null) {
                            ContentValues contentValues = new ContentValues();
                            contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                            contentValues.put("mimetype", "vnd.android.cursor.item/phone_v2");
                            contentValues.put("data1", this.getJsonString(phone, "value"));
                            contentValues.put("data2", Integer.valueOf(this.getPhoneType(this.getJsonString(phone, "type"))));
                            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                            continue;
                        }
                        ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{phoneId, "vnd.android.cursor.item/phone_v2"}).withValue("data1", (Object)this.getJsonString(phone, "value")).withValue("data2", (Object)this.getPhoneType(this.getJsonString(phone, "type"))).build());
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get phone numbers");
        }
        JSONArray emails = null;
        try {
            emails = contact.getJSONArray("emails");
            if (emails != null) {
                if (emails.length() == 0) {
                    ops.add(ContentProviderOperation.newDelete((Uri)ContactsContract.Data.CONTENT_URI).withSelection("raw_contact_id=? AND mimetype=?", new String[]{"" + rawId, "vnd.android.cursor.item/email_v2"}).build());
                } else {
                    for (int i = 0; i < emails.length(); ++i) {
                        JSONObject email = (JSONObject)emails.get(i);
                        String emailId = this.getJsonString(email, "id");
                        if (emailId == null) {
                            ContentValues contentValues = new ContentValues();
                            contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                            contentValues.put("mimetype", "vnd.android.cursor.item/email_v2");
                            contentValues.put("data1", this.getJsonString(email, "value"));
                            contentValues.put("data2", Integer.valueOf(this.getContactType(this.getJsonString(email, "type"))));
                            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                            continue;
                        }
                        ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{emailId, "vnd.android.cursor.item/email_v2"}).withValue("data1", (Object)this.getJsonString(email, "value")).withValue("data2", (Object)this.getContactType(this.getJsonString(email, "type"))).build());
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get emails");
        }
        JSONArray addresses = null;
        try {
            addresses = contact.getJSONArray("addresses");
            if (addresses != null) {
                if (addresses.length() == 0) {
                    ops.add(ContentProviderOperation.newDelete((Uri)ContactsContract.Data.CONTENT_URI).withSelection("raw_contact_id=? AND mimetype=?", new String[]{"" + rawId, "vnd.android.cursor.item/postal-address_v2"}).build());
                } else {
                    for (int i = 0; i < addresses.length(); ++i) {
                        JSONObject address = (JSONObject)addresses.get(i);
                        String addressId = this.getJsonString(address, "id");
                        if (addressId == null) {
                            ContentValues contentValues = new ContentValues();
                            contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                            contentValues.put("mimetype", "vnd.android.cursor.item/postal-address_v2");
                            contentValues.put("data2", Integer.valueOf(this.getAddressType(this.getJsonString(address, "type"))));
                            contentValues.put("data1", this.getJsonString(address, "formatted"));
                            contentValues.put("data4", this.getJsonString(address, "streetAddress"));
                            contentValues.put("data7", this.getJsonString(address, "locality"));
                            contentValues.put("data8", this.getJsonString(address, "region"));
                            contentValues.put("data9", this.getJsonString(address, "postalCode"));
                            contentValues.put("data10", this.getJsonString(address, "country"));
                            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                            continue;
                        }
                        ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{addressId, "vnd.android.cursor.item/postal-address_v2"}).withValue("data2", (Object)this.getAddressType(this.getJsonString(address, "type"))).withValue("data1", (Object)this.getJsonString(address, "formatted")).withValue("data4", (Object)this.getJsonString(address, "streetAddress")).withValue("data7", (Object)this.getJsonString(address, "locality")).withValue("data8", (Object)this.getJsonString(address, "region")).withValue("data9", (Object)this.getJsonString(address, "postalCode")).withValue("data10", (Object)this.getJsonString(address, "country")).build());
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get addresses");
        }
        JSONArray organizations = null;
        try {
            organizations = contact.getJSONArray("organizations");
            if (organizations != null) {
                if (organizations.length() == 0) {
                    ops.add(ContentProviderOperation.newDelete((Uri)ContactsContract.Data.CONTENT_URI).withSelection("raw_contact_id=? AND mimetype=?", new String[]{"" + rawId, "vnd.android.cursor.item/organization"}).build());
                } else {
                    for (int i = 0; i < organizations.length(); ++i) {
                        JSONObject org = (JSONObject)organizations.get(i);
                        String orgId = this.getJsonString(org, "id");
                        if (orgId == null) {
                            ContentValues contentValues = new ContentValues();
                            contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                            contentValues.put("mimetype", "vnd.android.cursor.item/organization");
                            contentValues.put("data2", Integer.valueOf(this.getOrgType(this.getJsonString(org, "type"))));
                            contentValues.put("data5", this.getJsonString(org, "department"));
                            contentValues.put("data1", this.getJsonString(org, "name"));
                            contentValues.put("data4", this.getJsonString(org, "title"));
                            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                            continue;
                        }
                        ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{orgId, "vnd.android.cursor.item/organization"}).withValue("data2", (Object)this.getOrgType(this.getJsonString(org, "type"))).withValue("data5", (Object)this.getJsonString(org, "department")).withValue("data1", (Object)this.getJsonString(org, "name")).withValue("data4", (Object)this.getJsonString(org, "title")).build());
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get organizations");
        }
        JSONArray ims = null;
        try {
            ims = contact.getJSONArray("ims");
            if (ims != null) {
                if (ims.length() == 0) {
                    ops.add(ContentProviderOperation.newDelete((Uri)ContactsContract.Data.CONTENT_URI).withSelection("raw_contact_id=? AND mimetype=?", new String[]{"" + rawId, "vnd.android.cursor.item/im"}).build());
                } else {
                    for (int i = 0; i < ims.length(); ++i) {
                        JSONObject im = (JSONObject)ims.get(i);
                        String imId = this.getJsonString(im, "id");
                        if (imId == null) {
                            ContentValues contentValues = new ContentValues();
                            contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                            contentValues.put("mimetype", "vnd.android.cursor.item/im");
                            contentValues.put("data1", this.getJsonString(im, "value"));
                            contentValues.put("data2", Integer.valueOf(this.getImType(this.getJsonString(im, "type"))));
                            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                            continue;
                        }
                        ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{imId, "vnd.android.cursor.item/im"}).withValue("data1", (Object)this.getJsonString(im, "value")).withValue("data2", (Object)this.getContactType(this.getJsonString(im, "type"))).build());
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get emails");
        }
        String note = this.getJsonString(contact, "note");
        ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("contact_id=? AND mimetype=?", new String[]{id, "vnd.android.cursor.item/note"}).withValue("data1", (Object)note).build());
        String nickname = this.getJsonString(contact, "nickname");
        if (nickname != null) {
            ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("contact_id=? AND mimetype=?", new String[]{id, "vnd.android.cursor.item/nickname"}).withValue("data1", (Object)nickname).build());
        }
        JSONArray websites = null;
        try {
            websites = contact.getJSONArray("urls");
            if (websites != null) {
                if (websites.length() == 0) {
                    Log.d((String)"ContactsAccessor", (String)"This means we should be deleting all the phone numbers.");
                    ops.add(ContentProviderOperation.newDelete((Uri)ContactsContract.Data.CONTENT_URI).withSelection("raw_contact_id=? AND mimetype=?", new String[]{"" + rawId, "vnd.android.cursor.item/website"}).build());
                } else {
                    for (int i = 0; i < websites.length(); ++i) {
                        JSONObject website = (JSONObject)websites.get(i);
                        String websiteId = this.getJsonString(website, "id");
                        if (websiteId == null) {
                            ContentValues contentValues = new ContentValues();
                            contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                            contentValues.put("mimetype", "vnd.android.cursor.item/website");
                            contentValues.put("data1", this.getJsonString(website, "value"));
                            contentValues.put("data2", Integer.valueOf(this.getContactType(this.getJsonString(website, "type"))));
                            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                            continue;
                        }
                        ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{websiteId, "vnd.android.cursor.item/website"}).withValue("data1", (Object)this.getJsonString(website, "value")).withValue("data2", (Object)this.getContactType(this.getJsonString(website, "type"))).build());
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get websites");
        }
        String birthday = this.getJsonString(contact, "birthday");
        if (birthday != null) {
            ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("contact_id=? AND mimetype=? AND data2=?", new String[]{id, "vnd.android.cursor.item/contact_event", new String("3")}).withValue("data2", (Object)3).withValue("data1", (Object)birthday).build());
        }
        JSONArray photos = null;
        try {
            photos = contact.getJSONArray("photos");
            if (photos != null) {
                if (photos.length() == 0) {
                    ops.add(ContentProviderOperation.newDelete((Uri)ContactsContract.Data.CONTENT_URI).withSelection("raw_contact_id=? AND mimetype=?", new String[]{"" + rawId, "vnd.android.cursor.item/photo"}).build());
                } else {
                    for (int i = 0; i < photos.length(); ++i) {
                        JSONObject photo = (JSONObject)photos.get(i);
                        String photoId = this.getJsonString(photo, "id");
                        byte[] bytes = this.getPhotoBytes(this.getJsonString(photo, "value"));
                        if (photoId == null) {
                            ContentValues contentValues = new ContentValues();
                            contentValues.put("raw_contact_id", Integer.valueOf(rawId));
                            contentValues.put("mimetype", "vnd.android.cursor.item/photo");
                            contentValues.put("is_super_primary", Integer.valueOf(1));
                            contentValues.put("data15", bytes);
                            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValues(contentValues).build());
                            continue;
                        }
                        ops.add(ContentProviderOperation.newUpdate((Uri)ContactsContract.Data.CONTENT_URI).withSelection("_id=? AND mimetype=?", new String[]{photoId, "vnd.android.cursor.item/photo"}).withValue("is_super_primary", (Object)1).withValue("data15", (Object)bytes).build());
                    }
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get photos");
        }
        boolean retVal = true;
        try {
            this.mApp.getActivity().getContentResolver().applyBatch("com.android.contacts", ops);
        }
        catch (RemoteException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            Log.e((String)"ContactsAccessor", (String)Log.getStackTraceString((Throwable)e), (Throwable)e);
            retVal = false;
        }
        catch (OperationApplicationException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
            Log.e((String)"ContactsAccessor", (String)Log.getStackTraceString((Throwable)e), (Throwable)e);
            retVal = false;
        }
        if (retVal) {
            return id;
        }
        return null;
    }

    private void insertWebsite(ArrayList<ContentProviderOperation> ops, JSONObject website) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/website").withValue("data1", (Object)this.getJsonString(website, "value")).withValue("data2", (Object)this.getContactType(this.getJsonString(website, "type"))).build());
    }

    private void insertIm(ArrayList<ContentProviderOperation> ops, JSONObject im) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/im").withValue("data1", (Object)this.getJsonString(im, "value")).withValue("data2", (Object)this.getImType(this.getJsonString(im, "type"))).build());
    }

    private void insertOrganization(ArrayList<ContentProviderOperation> ops, JSONObject org) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/organization").withValue("data2", (Object)this.getOrgType(this.getJsonString(org, "type"))).withValue("data5", (Object)this.getJsonString(org, "department")).withValue("data1", (Object)this.getJsonString(org, "name")).withValue("data4", (Object)this.getJsonString(org, "title")).build());
    }

    private void insertAddress(ArrayList<ContentProviderOperation> ops, JSONObject address) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/postal-address_v2").withValue("data2", (Object)this.getAddressType(this.getJsonString(address, "type"))).withValue("data1", (Object)this.getJsonString(address, "formatted")).withValue("data4", (Object)this.getJsonString(address, "streetAddress")).withValue("data7", (Object)this.getJsonString(address, "locality")).withValue("data8", (Object)this.getJsonString(address, "region")).withValue("data9", (Object)this.getJsonString(address, "postalCode")).withValue("data10", (Object)this.getJsonString(address, "country")).build());
    }

    private void insertEmail(ArrayList<ContentProviderOperation> ops, JSONObject email) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/email_v2").withValue("data1", (Object)this.getJsonString(email, "value")).withValue("data2", (Object)this.getContactType(this.getJsonString(email, "type"))).build());
    }

    private void insertPhone(ArrayList<ContentProviderOperation> ops, JSONObject phone) {
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/phone_v2").withValue("data1", (Object)this.getJsonString(phone, "value")).withValue("data2", (Object)this.getPhoneType(this.getJsonString(phone, "type"))).build());
    }

    private void insertPhoto(ArrayList<ContentProviderOperation> ops, JSONObject photo) {
        byte[] bytes = this.getPhotoBytes(this.getJsonString(photo, "value"));
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("is_super_primary", (Object)1).withValue("mimetype", (Object)"vnd.android.cursor.item/photo").withValue("data15", (Object)bytes).build());
    }

    private byte[] getPhotoBytes(String filename) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int bytesRead = 0;
            byte[] data = new byte[8192];
            InputStream in = this.getPathFromUri(filename);
            for (long totalBytesRead = 0L; (bytesRead = in.read(data, 0, data.length)) != -1 && totalBytesRead <= 0x100000L; totalBytesRead += (long)bytesRead) {
                buffer.write(data, 0, bytesRead);
            }
            in.close();
            buffer.flush();
        }
        catch (FileNotFoundException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return buffer.toByteArray();
    }

    private InputStream getPathFromUri(String path) throws IOException {
        if (path.startsWith("content:")) {
            Uri uri = Uri.parse((String)path);
            return this.mApp.getActivity().getContentResolver().openInputStream(uri);
        }
        if (path.startsWith("http:") || path.startsWith("https:") || path.startsWith("file:")) {
            URL url = new URL(path);
            return url.openStream();
        }
        return new FileInputStream(path);
    }

    private String createNewContact(JSONObject contact, String accountType, String accountName) {
        String nickname;
        ArrayList<ContentProviderOperation> ops = new ArrayList<ContentProviderOperation>();
        ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.RawContacts.CONTENT_URI).withValue("account_type", (Object)accountType).withValue("account_name", (Object)accountName).build());
        try {
            JSONObject name = contact.optJSONObject("name");
            String displayName = contact.getString("displayName");
            if (displayName != null || name != null) {
                ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/name").withValue("data1", (Object)displayName).withValue("data3", (Object)this.getJsonString(name, "familyName")).withValue("data5", (Object)this.getJsonString(name, "middleName")).withValue("data2", (Object)this.getJsonString(name, "givenName")).withValue("data4", (Object)this.getJsonString(name, "honorificPrefix")).withValue("data6", (Object)this.getJsonString(name, "honorificSuffix")).build());
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get name object");
        }
        JSONArray phones = null;
        try {
            phones = contact.getJSONArray("phoneNumbers");
            if (phones != null) {
                for (int i = 0; i < phones.length(); ++i) {
                    JSONObject phone = (JSONObject)phones.get(i);
                    this.insertPhone(ops, phone);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get phone numbers");
        }
        JSONArray emails = null;
        try {
            emails = contact.getJSONArray("emails");
            if (emails != null) {
                for (int i = 0; i < emails.length(); ++i) {
                    JSONObject email = (JSONObject)emails.get(i);
                    this.insertEmail(ops, email);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get emails");
        }
        JSONArray addresses = null;
        try {
            addresses = contact.getJSONArray("addresses");
            if (addresses != null) {
                for (int i = 0; i < addresses.length(); ++i) {
                    JSONObject address = (JSONObject)addresses.get(i);
                    this.insertAddress(ops, address);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get addresses");
        }
        JSONArray organizations = null;
        try {
            organizations = contact.getJSONArray("organizations");
            if (organizations != null) {
                for (int i = 0; i < organizations.length(); ++i) {
                    JSONObject org = (JSONObject)organizations.get(i);
                    this.insertOrganization(ops, org);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get organizations");
        }
        JSONArray ims = null;
        try {
            ims = contact.getJSONArray("ims");
            if (ims != null) {
                for (int i = 0; i < ims.length(); ++i) {
                    JSONObject im = (JSONObject)ims.get(i);
                    this.insertIm(ops, im);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get emails");
        }
        String note = this.getJsonString(contact, "note");
        if (note != null) {
            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/note").withValue("data1", (Object)note).build());
        }
        if ((nickname = this.getJsonString(contact, "nickname")) != null) {
            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/nickname").withValue("data1", (Object)nickname).build());
        }
        JSONArray websites = null;
        try {
            websites = contact.getJSONArray("urls");
            if (websites != null) {
                for (int i = 0; i < websites.length(); ++i) {
                    JSONObject website = (JSONObject)websites.get(i);
                    this.insertWebsite(ops, website);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get websites");
        }
        String birthday = this.getJsonString(contact, "birthday");
        if (birthday != null) {
            ops.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValue("mimetype", (Object)"vnd.android.cursor.item/contact_event").withValue("data2", (Object)3).withValue("data1", (Object)birthday).build());
        }
        JSONArray photos = null;
        try {
            photos = contact.getJSONArray("photos");
            if (photos != null) {
                for (int i = 0; i < photos.length(); ++i) {
                    JSONObject photo = (JSONObject)photos.get(i);
                    this.insertPhoto(ops, photo);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)"Could not get photos");
        }
        String newId = null;
        try {
            ContentProviderResult[] cpResults = this.mApp.getActivity().getContentResolver().applyBatch("com.android.contacts", ops);
            if (cpResults.length >= 0) {
                newId = cpResults[0].uri.getLastPathSegment();
            }
        }
        catch (RemoteException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        catch (OperationApplicationException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return newId;
    }

    @Override
    public boolean remove(String id) {
        int result = 0;
        Cursor cursor = this.mApp.getActivity().getContentResolver().query(ContactsContract.Contacts.CONTENT_URI, null, "_id = ?", new String[]{id}, null);
        if (cursor.getCount() == 1) {
            cursor.moveToFirst();
            String lookupKey = cursor.getString(cursor.getColumnIndex("lookup"));
            Uri uri = Uri.withAppendedPath((Uri)ContactsContract.Contacts.CONTENT_LOOKUP_URI, (String)lookupKey);
            result = this.mApp.getActivity().getContentResolver().delete(uri, null, null);
        } else {
            Log.d((String)"ContactsAccessor", (String)"Could not find contact with ID");
        }
        return result > 0;
    }

    private int getPhoneType(String string) {
        int type = 7;
        if (string != null) {
            if ("home".equals(string.toLowerCase())) {
                return 1;
            }
            if ("mobile".equals(string.toLowerCase())) {
                return 2;
            }
            if ("work".equals(string.toLowerCase())) {
                return 3;
            }
            if ("work fax".equals(string.toLowerCase())) {
                return 4;
            }
            if ("home fax".equals(string.toLowerCase())) {
                return 5;
            }
            if ("fax".equals(string.toLowerCase())) {
                return 4;
            }
            if ("pager".equals(string.toLowerCase())) {
                return 6;
            }
            if ("other".equals(string.toLowerCase())) {
                return 7;
            }
            if ("car".equals(string.toLowerCase())) {
                return 9;
            }
            if ("company main".equals(string.toLowerCase())) {
                return 10;
            }
            if ("isdn".equals(string.toLowerCase())) {
                return 11;
            }
            if ("main".equals(string.toLowerCase())) {
                return 12;
            }
            if ("other fax".equals(string.toLowerCase())) {
                return 13;
            }
            if ("radio".equals(string.toLowerCase())) {
                return 14;
            }
            if ("telex".equals(string.toLowerCase())) {
                return 15;
            }
            if ("work mobile".equals(string.toLowerCase())) {
                return 17;
            }
            if ("work pager".equals(string.toLowerCase())) {
                return 18;
            }
            if ("assistant".equals(string.toLowerCase())) {
                return 19;
            }
            if ("mms".equals(string.toLowerCase())) {
                return 20;
            }
            if ("callback".equals(string.toLowerCase())) {
                return 8;
            }
            if ("tty ttd".equals(string.toLowerCase())) {
                return 16;
            }
            if ("custom".equals(string.toLowerCase())) {
                return 0;
            }
        }
        return type;
    }

    private String getPhoneType(int type) {
        String stringType;
        switch (type) {
            case 0: {
                stringType = "custom";
                break;
            }
            case 5: {
                stringType = "home fax";
                break;
            }
            case 4: {
                stringType = "work fax";
                break;
            }
            case 1: {
                stringType = "home";
                break;
            }
            case 2: {
                stringType = "mobile";
                break;
            }
            case 6: {
                stringType = "pager";
                break;
            }
            case 3: {
                stringType = "work";
                break;
            }
            case 8: {
                stringType = "callback";
                break;
            }
            case 9: {
                stringType = "car";
                break;
            }
            case 10: {
                stringType = "company main";
                break;
            }
            case 13: {
                stringType = "other fax";
                break;
            }
            case 14: {
                stringType = "radio";
                break;
            }
            case 15: {
                stringType = "telex";
                break;
            }
            case 16: {
                stringType = "tty tdd";
                break;
            }
            case 17: {
                stringType = "work mobile";
                break;
            }
            case 18: {
                stringType = "work pager";
                break;
            }
            case 19: {
                stringType = "assistant";
                break;
            }
            case 20: {
                stringType = "mms";
                break;
            }
            case 11: {
                stringType = "isdn";
                break;
            }
            default: {
                stringType = "other";
            }
        }
        return stringType;
    }

    private int getContactType(String string) {
        int type = 3;
        if (string != null) {
            if ("home".equals(string.toLowerCase())) {
                return 1;
            }
            if ("work".equals(string.toLowerCase())) {
                return 2;
            }
            if ("other".equals(string.toLowerCase())) {
                return 3;
            }
            if ("mobile".equals(string.toLowerCase())) {
                return 4;
            }
            if ("custom".equals(string.toLowerCase())) {
                return 0;
            }
        }
        return type;
    }

    private String getContactType(int type) {
        String stringType;
        switch (type) {
            case 0: {
                stringType = "custom";
                break;
            }
            case 1: {
                stringType = "home";
                break;
            }
            case 2: {
                stringType = "work";
                break;
            }
            case 4: {
                stringType = "mobile";
                break;
            }
            default: {
                stringType = "other";
            }
        }
        return stringType;
    }

    private int getOrgType(String string) {
        int type = 2;
        if (string != null) {
            if ("work".equals(string.toLowerCase())) {
                return 1;
            }
            if ("other".equals(string.toLowerCase())) {
                return 2;
            }
            if ("custom".equals(string.toLowerCase())) {
                return 0;
            }
        }
        return type;
    }

    private String getOrgType(int type) {
        String stringType;
        switch (type) {
            case 0: {
                stringType = "custom";
                break;
            }
            case 1: {
                stringType = "work";
                break;
            }
            default: {
                stringType = "other";
            }
        }
        return stringType;
    }

    private int getAddressType(String string) {
        int type = 3;
        if (string != null) {
            if ("work".equals(string.toLowerCase())) {
                return 2;
            }
            if ("other".equals(string.toLowerCase())) {
                return 3;
            }
            if ("home".equals(string.toLowerCase())) {
                return 1;
            }
        }
        return type;
    }

    private String getAddressType(int type) {
        String stringType;
        switch (type) {
            case 1: {
                stringType = "home";
                break;
            }
            case 2: {
                stringType = "work";
                break;
            }
            default: {
                stringType = "other";
            }
        }
        return stringType;
    }

    private int getImType(String string) {
        int type = -1;
        if (string != null) {
            if ("aim".equals(string.toLowerCase())) {
                return 0;
            }
            if ("google talk".equals(string.toLowerCase())) {
                return 5;
            }
            if ("icq".equals(string.toLowerCase())) {
                return 6;
            }
            if ("jabber".equals(string.toLowerCase())) {
                return 7;
            }
            if ("msn".equals(string.toLowerCase())) {
                return 1;
            }
            if ("netmeeting".equals(string.toLowerCase())) {
                return 8;
            }
            if ("qq".equals(string.toLowerCase())) {
                return 4;
            }
            if ("skype".equals(string.toLowerCase())) {
                return 3;
            }
            if ("yahoo".equals(string.toLowerCase())) {
                return 2;
            }
        }
        return type;
    }

    private String getImType(int type) {
        String stringType;
        switch (type) {
            case 0: {
                stringType = "AIM";
                break;
            }
            case 5: {
                stringType = "Google Talk";
                break;
            }
            case 6: {
                stringType = "ICQ";
                break;
            }
            case 7: {
                stringType = "Jabber";
                break;
            }
            case 1: {
                stringType = "MSN";
                break;
            }
            case 8: {
                stringType = "NetMeeting";
                break;
            }
            case 4: {
                stringType = "QQ";
                break;
            }
            case 3: {
                stringType = "Skype";
                break;
            }
            case 2: {
                stringType = "Yahoo";
                break;
            }
            default: {
                stringType = "custom";
            }
        }
        return stringType;
    }

    static {
        dbMap.put("id", "contact_id");
        dbMap.put("displayName", "display_name");
        dbMap.put("name", "data1");
        dbMap.put("name.formatted", "data1");
        dbMap.put("name.familyName", "data3");
        dbMap.put("name.givenName", "data2");
        dbMap.put("name.middleName", "data5");
        dbMap.put("name.honorificPrefix", "data4");
        dbMap.put("name.honorificSuffix", "data6");
        dbMap.put("nickname", "data1");
        dbMap.put("phoneNumbers", "data1");
        dbMap.put("phoneNumbers.value", "data1");
        dbMap.put("emails", "data1");
        dbMap.put("emails.value", "data1");
        dbMap.put("addresses", "data1");
        dbMap.put("addresses.formatted", "data1");
        dbMap.put("addresses.streetAddress", "data4");
        dbMap.put("addresses.locality", "data7");
        dbMap.put("addresses.region", "data8");
        dbMap.put("addresses.postalCode", "data9");
        dbMap.put("addresses.country", "data10");
        dbMap.put("ims", "data1");
        dbMap.put("ims.value", "data1");
        dbMap.put("organizations", "data1");
        dbMap.put("organizations.name", "data1");
        dbMap.put("organizations.department", "data5");
        dbMap.put("organizations.title", "data4");
        dbMap.put("birthday", "vnd.android.cursor.item/contact_event");
        dbMap.put("note", "data1");
        dbMap.put("photos.value", "vnd.android.cursor.item/photo");
        dbMap.put("urls", "data1");
        dbMap.put("urls.value", "data1");
    }
}

