/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.cordova.GeoBroker;
import org.apache.cordova.api.CallbackContext;

public class CordovaLocationListener
implements LocationListener {
    public static int PERMISSION_DENIED = 1;
    public static int POSITION_UNAVAILABLE = 2;
    public static int TIMEOUT = 3;
    protected LocationManager locationManager;
    private GeoBroker owner;
    protected boolean running = false;
    public HashMap<String, CallbackContext> watches = new HashMap();
    private List<CallbackContext> callbacks = new ArrayList<CallbackContext>();
    private String TAG = "[Cordova Location Listener]";

    public CordovaLocationListener(LocationManager manager, GeoBroker broker, String tag) {
        this.locationManager = manager;
        this.owner = broker;
        this.TAG = tag;
    }

    protected void fail(int code, String message) {
        for (CallbackContext callbackContext : this.callbacks) {
            this.owner.fail(code, message, callbackContext);
        }
        if (this.owner.isGlobalListener(this)) {
            Log.d((String)this.TAG, (String)"Stopping global listener");
            this.stop();
        }
        this.callbacks.clear();
        Iterator<CallbackContext> it = this.watches.values().iterator();
        while (it.hasNext()) {
            this.owner.fail(code, message, it.next());
        }
    }

    private void win(Location loc) {
        for (CallbackContext callbackContext : this.callbacks) {
            this.owner.win(loc, callbackContext);
        }
        if (this.owner.isGlobalListener(this)) {
            Log.d((String)this.TAG, (String)"Stopping global listener");
            this.stop();
        }
        this.callbacks.clear();
        Iterator<CallbackContext> it = this.watches.values().iterator();
        while (it.hasNext()) {
            this.owner.win(loc, it.next());
        }
    }

    public void onProviderDisabled(String provider) {
        Log.d((String)this.TAG, (String)("Location provider '" + provider + "' disabled."));
        this.fail(POSITION_UNAVAILABLE, "GPS provider disabled.");
    }

    public void onProviderEnabled(String provider) {
        Log.d((String)this.TAG, (String)("Location provider " + provider + " has been enabled"));
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        Log.d((String)this.TAG, (String)("The status of the provider " + provider + " has changed"));
        if (status == 0) {
            Log.d((String)this.TAG, (String)(provider + " is OUT OF SERVICE"));
            this.fail(POSITION_UNAVAILABLE, "Provider " + provider + " is out of service.");
        } else if (status == 1) {
            Log.d((String)this.TAG, (String)(provider + " is TEMPORARILY_UNAVAILABLE"));
        } else {
            Log.d((String)this.TAG, (String)(provider + " is AVAILABLE"));
        }
    }

    public void onLocationChanged(Location location) {
        Log.d((String)this.TAG, (String)"The location has been updated!");
        this.win(location);
    }

    public int size() {
        return this.watches.size() + this.callbacks.size();
    }

    public void addWatch(String timerId, CallbackContext callbackContext) {
        this.watches.put(timerId, callbackContext);
        if (this.size() == 1) {
            this.start();
        }
    }

    public void addCallback(CallbackContext callbackContext) {
        this.callbacks.add(callbackContext);
        if (this.size() == 1) {
            this.start();
        }
    }

    public void clearWatch(String timerId) {
        if (this.watches.containsKey(timerId)) {
            this.watches.remove(timerId);
        }
        if (this.size() == 0) {
            this.stop();
        }
    }

    public void destroy() {
        this.stop();
    }

    protected void start() {
        if (!this.running) {
            if (this.locationManager.getProvider("network") != null) {
                this.running = true;
                this.locationManager.requestLocationUpdates("network", 60000L, 10.0f, (LocationListener)this);
            } else {
                this.fail(POSITION_UNAVAILABLE, "Network provider is not available.");
            }
        }
    }

    private void stop() {
        if (this.running) {
            this.locationManager.removeUpdates((LocationListener)this);
            this.running = false;
        }
    }
}

