/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.webkit.CookieManager;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.cordova.Config;
import org.apache.cordova.FileProgressResult;
import org.apache.cordova.FileUploadResult;
import org.apache.cordova.FileUtils;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileTransfer
extends CordovaPlugin {
    private static final String LOG_TAG = "FileTransfer";
    private static final String LINE_START = "--";
    private static final String LINE_END = "\r\n";
    private static final String BOUNDARY = "+++++";
    public static int FILE_NOT_FOUND_ERR = 1;
    public static int INVALID_URL_ERR = 2;
    public static int CONNECTION_ERR = 3;
    public static int ABORTED_ERR = 4;
    private static HashMap<String, RequestContext> activeRequests = new HashMap();
    private static final int MAX_BUFFER_SIZE = 16384;
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }};

    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (action.equals("upload") || action.equals("download")) {
            String source = args.getString(0);
            String target = args.getString(1);
            if (action.equals("upload")) {
                try {
                    source = URLDecoder.decode(source, "UTF-8");
                    this.upload(source, target, args, callbackContext);
                }
                catch (UnsupportedEncodingException e) {
                    callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.MALFORMED_URL_EXCEPTION, "UTF-8 error."));
                }
            } else {
                this.download(source, target, args, callbackContext);
            }
            return true;
        }
        if (action.equals("abort")) {
            String objectId = args.getString(0);
            this.abort(objectId);
            callbackContext.success();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upload(final String source, final String target, JSONArray args, CallbackContext callbackContext) throws JSONException {
        URL url;
        Log.d((String)LOG_TAG, (String)("upload " + source + " to " + target));
        final String fileKey = FileTransfer.getArgument(args, 2, "file");
        final String fileName = FileTransfer.getArgument(args, 3, "image.jpg");
        final String mimeType = FileTransfer.getArgument(args, 4, "image/jpeg");
        final JSONObject params = args.optJSONObject(5) == null ? new JSONObject() : args.optJSONObject(5);
        final boolean trustEveryone = args.optBoolean(6);
        final boolean chunkedMode = args.optBoolean(7) || args.isNull(7);
        final JSONObject headers = args.optJSONObject(8) == null ? params.optJSONObject("headers") : args.optJSONObject(8);
        final String objectId = args.getString(9);
        Log.d((String)LOG_TAG, (String)("fileKey: " + fileKey));
        Log.d((String)LOG_TAG, (String)("fileName: " + fileName));
        Log.d((String)LOG_TAG, (String)("mimeType: " + mimeType));
        Log.d((String)LOG_TAG, (String)("params: " + params));
        Log.d((String)LOG_TAG, (String)("trustEveryone: " + trustEveryone));
        Log.d((String)LOG_TAG, (String)("chunkedMode: " + chunkedMode));
        Log.d((String)LOG_TAG, (String)("headers: " + headers));
        Log.d((String)LOG_TAG, (String)("objectId: " + objectId));
        try {
            url = new URL(target);
        }
        catch (MalformedURLException e) {
            JSONObject error = FileTransfer.createFileTransferError(INVALID_URL_ERR, source, target, 0);
            Log.e((String)LOG_TAG, (String)error.toString(), (Throwable)e);
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
            return;
        }
        final boolean useHttps = url.getProtocol().toLowerCase().equals("https");
        final RequestContext context = new RequestContext(source, target, callbackContext);
        HashMap<String, RequestContext> hashMap = activeRequests;
        synchronized (hashMap) {
            activeRequests.put(objectId, context);
        }
        this.cordova.getThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JSONObject error;
                if (context.aborted) {
                    return;
                }
                HttpURLConnection conn = null;
                HostnameVerifier oldHostnameVerifier = null;
                SSLSocketFactory oldSocketFactory = null;
                int totalBytes = 0;
                int fixedLength = -1;
                try {
                    String responseString;
                    FileUploadResult result = new FileUploadResult();
                    FileProgressResult progress = new FileProgressResult();
                    if (useHttps) {
                        if (!trustEveryone) {
                            conn = (HttpsURLConnection)url.openConnection();
                        } else {
                            HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                            oldSocketFactory = FileTransfer.trustAllHosts(https);
                            oldHostnameVerifier = https.getHostnameVerifier();
                            https.setHostnameVerifier(DO_NOT_VERIFY);
                            conn = https;
                        }
                    } else {
                        conn = (HttpURLConnection)url.openConnection();
                    }
                    conn.setDoInput(true);
                    conn.setDoOutput(true);
                    conn.setUseCaches(false);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty("Connection", "Keep-Alive");
                    conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=+++++");
                    String cookie = CookieManager.getInstance().getCookie(target);
                    if (cookie != null) {
                        conn.setRequestProperty("Cookie", cookie);
                    }
                    if (headers != null) {
                        try {
                            Iterator iter = headers.keys();
                            while (iter.hasNext()) {
                                String headerKey = iter.next().toString();
                                JSONArray headerValues = headers.optJSONArray(headerKey);
                                if (headerValues == null) {
                                    headerValues = new JSONArray();
                                    headerValues.put((Object)headers.getString(headerKey));
                                }
                                conn.setRequestProperty(headerKey, headerValues.getString(0));
                                for (int i = 1; i < headerValues.length(); ++i) {
                                    conn.addRequestProperty(headerKey, headerValues.getString(i));
                                }
                            }
                        }
                        catch (JSONException e1) {
                            // empty catch block
                        }
                    }
                    String extraParams = "";
                    try {
                        Iterator iter = params.keys();
                        while (iter.hasNext()) {
                            Object key = iter.next();
                            if (String.valueOf(key).equals("headers")) continue;
                            extraParams = extraParams + "--+++++\r\n";
                            extraParams = extraParams + "Content-Disposition: form-data; name=\"" + key.toString() + "\";";
                            extraParams = extraParams + "\r\n\r\n";
                            extraParams = extraParams + params.getString(key.toString());
                            extraParams = extraParams + FileTransfer.LINE_END;
                        }
                    }
                    catch (JSONException e) {
                        Log.e((String)FileTransfer.LOG_TAG, (String)e.getMessage(), (Throwable)e);
                    }
                    extraParams = extraParams + "--+++++\r\n";
                    extraParams = extraParams + "Content-Disposition: form-data; name=\"" + fileKey + "\";" + " filename=\"";
                    byte[] extraBytes = extraParams.getBytes("UTF-8");
                    String midParams = "\"\r\nContent-Type: " + mimeType + FileTransfer.LINE_END + FileTransfer.LINE_END;
                    String tailParams = "\r\n--+++++--\r\n";
                    byte[] fileNameBytes = fileName.getBytes("UTF-8");
                    InputStream sourceInputStream = FileTransfer.this.getPathFromUri(source);
                    int stringLength = extraBytes.length + midParams.length() + tailParams.length() + fileNameBytes.length;
                    Log.d((String)FileTransfer.LOG_TAG, (String)("String Length: " + stringLength));
                    if (sourceInputStream instanceof FileInputStream) {
                        fixedLength = (int)((FileInputStream)sourceInputStream).getChannel().size() + stringLength;
                        progress.setLengthComputable(true);
                        progress.setTotal(fixedLength);
                    }
                    Log.d((String)FileTransfer.LOG_TAG, (String)("Content Length: " + fixedLength));
                    boolean useChunkedMode = chunkedMode && (Build.VERSION.SDK_INT < 8 || useHttps);
                    boolean bl = useChunkedMode = useChunkedMode || fixedLength == -1;
                    if (useChunkedMode) {
                        conn.setChunkedStreamingMode(16384);
                        conn.setRequestProperty("Transfer-Encoding", "chunked");
                    } else {
                        conn.setFixedLengthStreamingMode(fixedLength);
                    }
                    DataOutputStream dos = null;
                    try {
                        dos = new DataOutputStream(conn.getOutputStream());
                        RequestContext requestContext = context;
                        synchronized (requestContext) {
                            block76: {
                                if (!context.aborted) break block76;
                                return;
                            }
                            context.currentOutputStream = dos;
                        }
                        dos.write(extraBytes);
                        dos.write(fileNameBytes);
                        dos.writeBytes(midParams);
                        int bytesAvailable = sourceInputStream.available();
                        int bufferSize = Math.min(bytesAvailable, 16384);
                        byte[] buffer = new byte[bufferSize];
                        int bytesRead = sourceInputStream.read(buffer, 0, bufferSize);
                        long prevBytesRead = 0L;
                        while (bytesRead > 0) {
                            result.setBytesSent(totalBytes += bytesRead);
                            dos.write(buffer, 0, bytesRead);
                            if ((long)totalBytes > prevBytesRead + 102400L) {
                                prevBytesRead = totalBytes;
                                Log.d((String)FileTransfer.LOG_TAG, (String)("Uploaded " + totalBytes + " of " + fixedLength + " bytes"));
                            }
                            bytesAvailable = sourceInputStream.available();
                            bufferSize = Math.min(bytesAvailable, 16384);
                            bytesRead = sourceInputStream.read(buffer, 0, bufferSize);
                            progress.setLoaded(totalBytes);
                            PluginResult progressResult = new PluginResult(PluginResult.Status.OK, progress.toJSONObject());
                            progressResult.setKeepCallback(true);
                            context.sendPluginResult(progressResult);
                        }
                        dos.writeBytes(tailParams);
                        dos.flush();
                    }
                    finally {
                        FileTransfer.safeClose(sourceInputStream);
                        FileTransfer.safeClose(dos);
                    }
                    context.currentOutputStream = null;
                    int responseCode = conn.getResponseCode();
                    InputStream inStream = null;
                    try {
                        inStream = FileTransfer.getInputStream(conn);
                        RequestContext bytesRead = context;
                        synchronized (bytesRead) {
                            block78: {
                                if (!context.aborted) break block78;
                                return;
                            }
                            context.currentInputStream = inStream;
                        }
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        byte[] buffer = new byte[1024];
                        int bytesRead2 = 0;
                        while ((bytesRead2 = inStream.read(buffer)) > 0) {
                            out.write(buffer, 0, bytesRead2);
                        }
                        responseString = out.toString("UTF-8");
                    }
                    finally {
                        context.currentInputStream = null;
                        FileTransfer.safeClose(inStream);
                    }
                    Log.d((String)FileTransfer.LOG_TAG, (String)"got response from server");
                    Log.d((String)FileTransfer.LOG_TAG, (String)responseString.substring(0, Math.min(256, responseString.length())));
                    result.setResponseCode(responseCode);
                    result.setResponse(responseString);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.OK, result.toJSONObject()));
                }
                catch (FileNotFoundException e) {
                    error = FileTransfer.createFileTransferError(FILE_NOT_FOUND_ERR, source, target, conn);
                    Log.e((String)FileTransfer.LOG_TAG, (String)error.toString(), (Throwable)e);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
                }
                catch (IOException e) {
                    error = FileTransfer.createFileTransferError(CONNECTION_ERR, source, target, conn);
                    Log.e((String)FileTransfer.LOG_TAG, (String)error.toString(), (Throwable)e);
                    Log.e((String)FileTransfer.LOG_TAG, (String)("Failed after uploading " + totalBytes + " of " + fixedLength + " bytes."));
                    context.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
                }
                catch (JSONException e) {
                    Log.e((String)FileTransfer.LOG_TAG, (String)e.getMessage(), (Throwable)e);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
                }
                catch (Throwable t) {
                    error = FileTransfer.createFileTransferError(CONNECTION_ERR, source, target, conn);
                    Log.e((String)FileTransfer.LOG_TAG, (String)error.toString(), (Throwable)t);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
                }
                finally {
                    HashMap e = activeRequests;
                    synchronized (e) {
                        activeRequests.remove(objectId);
                    }
                    if (conn != null) {
                        if (trustEveryone && useHttps) {
                            HttpsURLConnection https = (HttpsURLConnection)conn;
                            https.setHostnameVerifier(oldHostnameVerifier);
                            https.setSSLSocketFactory(oldSocketFactory);
                        }
                        conn.disconnect();
                    }
                }
            }
        });
    }

    private static void safeClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static InputStream getInputStream(HttpURLConnection conn) throws IOException {
        if (Build.VERSION.SDK_INT < 11) {
            return new DoneHandlerInputStream(conn.getInputStream());
        }
        return conn.getInputStream();
    }

    private static SSLSocketFactory trustAllHosts(HttpsURLConnection connection) {
        SSLSocketFactory oldFactory = connection.getSSLSocketFactory();
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory newFactory = sc.getSocketFactory();
            connection.setSSLSocketFactory(newFactory);
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        return oldFactory;
    }

    private static JSONObject createFileTransferError(int errorCode, String source, String target, HttpURLConnection connection) {
        Integer httpStatus = null;
        if (connection != null) {
            try {
                httpStatus = connection.getResponseCode();
            }
            catch (IOException e) {
                Log.w((String)LOG_TAG, (String)"Error getting HTTP status code from connection.", (Throwable)e);
            }
        }
        return FileTransfer.createFileTransferError(errorCode, source, target, httpStatus);
    }

    private static JSONObject createFileTransferError(int errorCode, String source, String target, Integer httpStatus) {
        JSONObject error = null;
        try {
            error = new JSONObject();
            error.put("code", errorCode);
            error.put("source", (Object)source);
            error.put("target", (Object)target);
            if (httpStatus != null) {
                error.put("http_status", (Object)httpStatus);
            }
        }
        catch (JSONException e) {
            Log.e((String)LOG_TAG, (String)e.getMessage(), (Throwable)e);
        }
        return error;
    }

    private static String getArgument(JSONArray args, int position, String defaultString) {
        String arg = defaultString;
        if (args.length() >= position && ((arg = args.optString(position)) == null || "null".equals(arg))) {
            arg = defaultString;
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(final String source, final String target, JSONArray args, CallbackContext callbackContext) throws JSONException {
        URL url;
        Log.d((String)LOG_TAG, (String)("download " + source + " to " + target));
        final boolean trustEveryone = args.optBoolean(2);
        final String objectId = args.getString(3);
        try {
            url = new URL(source);
        }
        catch (MalformedURLException e) {
            JSONObject error = FileTransfer.createFileTransferError(INVALID_URL_ERR, source, target, 0);
            Log.e((String)LOG_TAG, (String)error.toString(), (Throwable)e);
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
            return;
        }
        final boolean useHttps = url.getProtocol().toLowerCase().equals("https");
        if (!Config.isUrlWhiteListed(source)) {
            Log.w((String)LOG_TAG, (String)("Source URL is not in white list: '" + source + "'"));
            JSONObject error = FileTransfer.createFileTransferError(CONNECTION_ERR, source, target, 401);
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
            return;
        }
        final RequestContext context = new RequestContext(source, target, callbackContext);
        HashMap<String, RequestContext> hashMap = activeRequests;
        synchronized (hashMap) {
            activeRequests.put(objectId, context);
        }
        this.cordova.getThreadPool().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                JSONObject error;
                if (context.aborted) {
                    return;
                }
                HttpURLConnection connection = null;
                HostnameVerifier oldHostnameVerifier = null;
                SSLSocketFactory oldSocketFactory = null;
                try {
                    Serializable file = FileTransfer.this.getFileFromPath(target);
                    file.getParentFile().mkdirs();
                    if (useHttps) {
                        if (!trustEveryone) {
                            connection = (HttpsURLConnection)url.openConnection();
                        } else {
                            HttpsURLConnection https = (HttpsURLConnection)url.openConnection();
                            oldSocketFactory = FileTransfer.trustAllHosts(https);
                            oldHostnameVerifier = https.getHostnameVerifier();
                            https.setHostnameVerifier(DO_NOT_VERIFY);
                            connection = https;
                        }
                    } else {
                        connection = (HttpURLConnection)url.openConnection();
                    }
                    connection.setRequestMethod("GET");
                    String cookie = CookieManager.getInstance().getCookie(source);
                    if (cookie != null) {
                        connection.setRequestProperty("cookie", cookie);
                    }
                    connection.connect();
                    Log.d((String)FileTransfer.LOG_TAG, (String)("Download file:" + url));
                    FileProgressResult progress = new FileProgressResult();
                    if (connection.getContentEncoding() == null) {
                        progress.setLengthComputable(true);
                        progress.setTotal(connection.getContentLength());
                    }
                    FileOutputStream outputStream = null;
                    InputStream inputStream = null;
                    try {
                        inputStream = FileTransfer.getInputStream(connection);
                        outputStream = new FileOutputStream((File)file);
                        RequestContext requestContext = context;
                        synchronized (requestContext) {
                            block51: {
                                if (!context.aborted) break block51;
                                return;
                            }
                            context.currentInputStream = inputStream;
                        }
                        byte[] buffer = new byte[16384];
                        int bytesRead = 0;
                        long totalBytes = 0L;
                        while ((bytesRead = inputStream.read(buffer)) > 0) {
                            outputStream.write(buffer, 0, bytesRead);
                            progress.setLoaded(totalBytes += (long)bytesRead);
                            PluginResult progressResult = new PluginResult(PluginResult.Status.OK, progress.toJSONObject());
                            progressResult.setKeepCallback(true);
                            context.sendPluginResult(progressResult);
                        }
                    }
                    finally {
                        context.currentInputStream = null;
                        FileTransfer.safeClose(inputStream);
                        FileTransfer.safeClose(outputStream);
                    }
                    Log.d((String)FileTransfer.LOG_TAG, (String)("Saved file: " + target));
                    FileUtils fileUtil = new FileUtils();
                    JSONObject fileEntry = fileUtil.getEntry((File)file);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.OK, fileEntry));
                }
                catch (FileNotFoundException e) {
                    error = FileTransfer.createFileTransferError(FILE_NOT_FOUND_ERR, source, target, connection);
                    Log.e((String)FileTransfer.LOG_TAG, (String)error.toString(), (Throwable)e);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
                }
                catch (IOException e) {
                    error = FileTransfer.createFileTransferError(CONNECTION_ERR, source, target, connection);
                    Log.e((String)FileTransfer.LOG_TAG, (String)error.toString(), (Throwable)e);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
                }
                catch (JSONException e) {
                    Log.e((String)FileTransfer.LOG_TAG, (String)e.getMessage(), (Throwable)e);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
                }
                catch (Throwable e) {
                    error = FileTransfer.createFileTransferError(CONNECTION_ERR, source, target, connection);
                    Log.e((String)FileTransfer.LOG_TAG, (String)error.toString(), (Throwable)e);
                    context.sendPluginResult(new PluginResult(PluginResult.Status.IO_EXCEPTION, error));
                }
                finally {
                    HashMap e = activeRequests;
                    synchronized (e) {
                        activeRequests.remove(objectId);
                    }
                    if (connection != null) {
                        if (trustEveryone && useHttps) {
                            HttpsURLConnection https = (HttpsURLConnection)connection;
                            https.setHostnameVerifier(oldHostnameVerifier);
                            https.setSSLSocketFactory(oldSocketFactory);
                        }
                        connection.disconnect();
                    }
                }
            }
        });
    }

    private InputStream getPathFromUri(String path) throws FileNotFoundException {
        if (path.startsWith("content:")) {
            Uri uri = Uri.parse((String)path);
            return this.cordova.getActivity().getContentResolver().openInputStream(uri);
        }
        if (path.startsWith("file://")) {
            int question = path.indexOf("?");
            if (question == -1) {
                return new FileInputStream(path.substring(7));
            }
            return new FileInputStream(path.substring(7, question));
        }
        return new FileInputStream(path);
    }

    private File getFileFromPath(String path) throws FileNotFoundException {
        String prefix = "file://";
        File file = path.startsWith(prefix) ? new File(path.substring(prefix.length())) : new File(path);
        if (file.getParent() == null) {
            throw new FileNotFoundException();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abort(String objectId) {
        RequestContext context;
        HashMap<String, RequestContext> hashMap = activeRequests;
        synchronized (hashMap) {
            context = activeRequests.remove(objectId);
        }
        if (context != null) {
            JSONObject error = FileTransfer.createFileTransferError(ABORTED_ERR, context.source, context.target, -1);
            RequestContext requestContext = context;
            synchronized (requestContext) {
                context.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, error));
                context.aborted = true;
            }
            this.cordova.getThreadPool().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    RequestContext requestContext = context;
                    synchronized (requestContext) {
                        FileTransfer.safeClose(context.currentInputStream);
                        FileTransfer.safeClose(context.currentOutputStream);
                    }
                }
            });
        }
    }

    private static final class DoneHandlerInputStream
    extends FilterInputStream {
        private boolean done;

        public DoneHandlerInputStream(InputStream stream) {
            super(stream);
        }

        public int read() throws IOException {
            int result = this.done ? -1 : super.read();
            this.done = result == -1;
            return result;
        }

        public int read(byte[] buffer) throws IOException {
            int result = this.done ? -1 : super.read(buffer);
            this.done = result == -1;
            return result;
        }

        public int read(byte[] bytes, int offset, int count) throws IOException {
            int result = this.done ? -1 : super.read(bytes, offset, count);
            this.done = result == -1;
            return result;
        }
    }

    private static final class RequestContext {
        String source;
        String target;
        CallbackContext callbackContext;
        InputStream currentInputStream;
        OutputStream currentOutputStream;
        boolean aborted;

        RequestContext(String source, String target, CallbackContext callbackContext) {
            this.source = source;
            this.target = target;
            this.callbackContext = callbackContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendPluginResult(PluginResult pluginResult) {
            RequestContext requestContext = this;
            synchronized (requestContext) {
                if (!this.aborted) {
                    this.callbackContext.sendPluginResult(pluginResult);
                }
            }
        }
    }
}

