/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.location.Location;
import android.location.LocationManager;
import org.apache.cordova.CordovaLocationListener;
import org.apache.cordova.GPSListener;
import org.apache.cordova.NetworkListener;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GeoBroker
extends CordovaPlugin {
    private GPSListener gpsListener;
    private NetworkListener networkListener;
    private LocationManager locationManager;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        if (this.locationManager == null) {
            this.locationManager = (LocationManager)this.cordova.getActivity().getSystemService("location");
            this.networkListener = new NetworkListener(this.locationManager, this);
            this.gpsListener = new GPSListener(this.locationManager, this);
        }
        if (this.locationManager.isProviderEnabled("gps") || this.locationManager.isProviderEnabled("network")) {
            if (action.equals("getLocation")) {
                boolean enableHighAccuracy = args.getBoolean(0);
                int maximumAge = args.getInt(1);
                Location last = this.locationManager.getLastKnownLocation(enableHighAccuracy ? "gps" : "network");
                if (last != null && System.currentTimeMillis() - last.getTime() <= (long)maximumAge) {
                    PluginResult result = new PluginResult(PluginResult.Status.OK, this.returnLocationJSON(last));
                    callbackContext.sendPluginResult(result);
                    return true;
                } else {
                    this.getCurrentLocation(callbackContext, enableHighAccuracy);
                }
                return true;
            } else if (action.equals("addWatch")) {
                String id = args.getString(0);
                boolean enableHighAccuracy = args.getBoolean(1);
                this.addWatch(id, callbackContext, enableHighAccuracy);
                return true;
            } else {
                if (!action.equals("clearWatch")) return false;
                String id = args.getString(0);
                this.clearWatch(id);
            }
            return true;
        } else {
            PluginResult.Status status = PluginResult.Status.NO_RESULT;
            String message = "Location API is not available for this device.";
            PluginResult result = new PluginResult(status, message);
            callbackContext.sendPluginResult(result);
        }
        return true;
    }

    private void clearWatch(String id) {
        this.gpsListener.clearWatch(id);
        this.networkListener.clearWatch(id);
    }

    private void getCurrentLocation(CallbackContext callbackContext, boolean enableHighAccuracy) {
        if (enableHighAccuracy) {
            this.gpsListener.addCallback(callbackContext);
        } else {
            this.networkListener.addCallback(callbackContext);
        }
    }

    private void addWatch(String timerId, CallbackContext callbackContext, boolean enableHighAccuracy) {
        if (enableHighAccuracy) {
            this.gpsListener.addWatch(timerId, callbackContext);
        } else {
            this.networkListener.addWatch(timerId, callbackContext);
        }
    }

    public void onDestroy() {
        if (this.networkListener != null) {
            this.networkListener.destroy();
            this.networkListener = null;
        }
        if (this.gpsListener != null) {
            this.gpsListener.destroy();
            this.gpsListener = null;
        }
    }

    public void onReset() {
        this.onDestroy();
    }

    public JSONObject returnLocationJSON(Location loc) {
        JSONObject o = new JSONObject();
        try {
            o.put("latitude", loc.getLatitude());
            o.put("longitude", loc.getLongitude());
            o.put("altitude", loc.hasAltitude() ? Double.valueOf(loc.getAltitude()) : null);
            o.put("accuracy", (double)loc.getAccuracy());
            o.put("heading", loc.hasBearing() ? (loc.hasSpeed() ? Float.valueOf(loc.getBearing()) : null) : null);
            o.put("speed", (double)loc.getSpeed());
            o.put("timestamp", loc.getTime());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return o;
    }

    public void win(Location loc, CallbackContext callbackContext) {
        PluginResult result = new PluginResult(PluginResult.Status.OK, this.returnLocationJSON(loc));
        callbackContext.sendPluginResult(result);
    }

    public void fail(int code, String msg, CallbackContext callbackContext) {
        JSONObject obj = new JSONObject();
        String backup = null;
        try {
            obj.put("code", code);
            obj.put("message", (Object)msg);
        }
        catch (JSONException e) {
            obj = null;
            backup = "{'code':" + code + ",'message':'" + msg.replaceAll("'", "'") + "'}";
        }
        PluginResult result = obj != null ? new PluginResult(PluginResult.Status.ERROR, obj) : new PluginResult(PluginResult.Status.ERROR, backup);
        callbackContext.sendPluginResult(result);
    }

    public boolean isGlobalListener(CordovaLocationListener listener) {
        if (this.gpsListener != null && this.networkListener != null) {
            return this.gpsListener.equals(listener) || this.networkListener.equals(listener);
        }
        return false;
    }
}

