/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.text.format.DateFormat;
import android.text.format.Time;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.cordova.GlobalizationError;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Globalization
extends CordovaPlugin {
    public static final String GETLOCALENAME = "getLocaleName";
    public static final String DATETOSTRING = "dateToString";
    public static final String STRINGTODATE = "stringToDate";
    public static final String GETDATEPATTERN = "getDatePattern";
    public static final String GETDATENAMES = "getDateNames";
    public static final String ISDAYLIGHTSAVINGSTIME = "isDayLightSavingsTime";
    public static final String GETFIRSTDAYOFWEEK = "getFirstDayOfWeek";
    public static final String NUMBERTOSTRING = "numberToString";
    public static final String STRINGTONUMBER = "stringToNumber";
    public static final String GETNUMBERPATTERN = "getNumberPattern";
    public static final String GETCURRENCYPATTERN = "getCurrencyPattern";
    public static final String GETPREFERREDLANGUAGE = "getPreferredLanguage";
    public static final String OPTIONS = "options";
    public static final String FORMATLENGTH = "formatLength";
    public static final String MEDIUM = "medium";
    public static final String LONG = "long";
    public static final String FULL = "full";
    public static final String SELECTOR = "selector";
    public static final String DATE = "date";
    public static final String TIME = "time";
    public static final String DATESTRING = "dateString";
    public static final String TYPE = "type";
    public static final String ITEM = "item";
    public static final String NARROW = "narrow";
    public static final String WIDE = "wide";
    public static final String MONTHS = "months";
    public static final String DAYS = "days";
    public static final String NUMBER = "number";
    public static final String NUMBERSTRING = "numberString";
    public static final String PERCENT = "percent";
    public static final String CURRENCY = "currency";
    public static final String CURRENCYCODE = "currencyCode";

    public boolean execute(String action, JSONArray data, CallbackContext callbackContext) {
        JSONObject obj = new JSONObject();
        try {
            if (action.equals(GETLOCALENAME)) {
                obj = this.getLocaleName();
            } else if (action.equals(GETPREFERREDLANGUAGE)) {
                obj = this.getPreferredLanguage();
            } else if (action.equalsIgnoreCase(DATETOSTRING)) {
                obj = this.getDateToString(data);
            } else if (action.equalsIgnoreCase(STRINGTODATE)) {
                obj = this.getStringtoDate(data);
            } else if (action.equalsIgnoreCase(GETDATEPATTERN)) {
                obj = this.getDatePattern(data);
            } else if (action.equalsIgnoreCase(GETDATENAMES)) {
                if (Build.VERSION.SDK_INT < 9) {
                    throw new GlobalizationError("UNKNOWN_ERROR");
                }
                obj = this.getDateNames(data);
            } else if (action.equalsIgnoreCase(ISDAYLIGHTSAVINGSTIME)) {
                obj = this.getIsDayLightSavingsTime(data);
            } else if (action.equalsIgnoreCase(GETFIRSTDAYOFWEEK)) {
                obj = this.getFirstDayOfWeek(data);
            } else if (action.equalsIgnoreCase(NUMBERTOSTRING)) {
                obj = this.getNumberToString(data);
            } else if (action.equalsIgnoreCase(STRINGTONUMBER)) {
                obj = this.getStringToNumber(data);
            } else if (action.equalsIgnoreCase(GETNUMBERPATTERN)) {
                obj = this.getNumberPattern(data);
            } else if (action.equalsIgnoreCase(GETCURRENCYPATTERN)) {
                obj = this.getCurrencyPattern(data);
            } else {
                return false;
            }
            callbackContext.success(obj);
        }
        catch (GlobalizationError ge) {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.ERROR, ge.toJson()));
        }
        catch (Exception e) {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
        }
        return true;
    }

    private JSONObject getLocaleName() throws GlobalizationError {
        JSONObject obj = new JSONObject();
        try {
            obj.put("value", (Object)Locale.getDefault().toString());
            return obj;
        }
        catch (Exception e) {
            throw new GlobalizationError("UNKNOWN_ERROR");
        }
    }

    private JSONObject getPreferredLanguage() throws GlobalizationError {
        JSONObject obj = new JSONObject();
        try {
            obj.put("value", (Object)Locale.getDefault().getDisplayLanguage().toString());
            return obj;
        }
        catch (Exception e) {
            throw new GlobalizationError("UNKNOWN_ERROR");
        }
    }

    private JSONObject getDateToString(JSONArray options) throws GlobalizationError {
        JSONObject obj = new JSONObject();
        try {
            Date date = new Date((Long)options.getJSONObject(0).get(DATE));
            JSONObject datePattern = this.getDatePattern(options);
            SimpleDateFormat fmt = new SimpleDateFormat(datePattern.getString("pattern"));
            return obj.put("value", (Object)fmt.format(date));
        }
        catch (Exception ge) {
            throw new GlobalizationError("FORMATTING_ERROR");
        }
    }

    private JSONObject getStringtoDate(JSONArray options) throws GlobalizationError {
        JSONObject obj = new JSONObject();
        try {
            SimpleDateFormat fmt = new SimpleDateFormat(this.getDatePattern(options).getString("pattern"));
            Date date = fmt.parse(options.getJSONObject(0).get(DATESTRING).toString());
            Time time = new Time();
            time.set(date.getTime());
            obj.put("year", time.year);
            obj.put("month", time.month);
            obj.put("day", time.monthDay);
            obj.put("hour", time.hour);
            obj.put("minute", time.minute);
            obj.put("second", time.second);
            obj.put("millisecond", (Object)new Long(0L));
            return obj;
        }
        catch (Exception ge) {
            throw new GlobalizationError("PARSING_ERROR");
        }
    }

    private JSONObject getDatePattern(JSONArray options) throws GlobalizationError {
        JSONObject obj = new JSONObject();
        try {
            SimpleDateFormat fmtDate = (SimpleDateFormat)DateFormat.getDateFormat((Context)this.cordova.getActivity());
            SimpleDateFormat fmtTime = (SimpleDateFormat)DateFormat.getTimeFormat((Context)this.cordova.getActivity());
            String fmt = fmtDate.toLocalizedPattern() + " " + fmtTime.toLocalizedPattern();
            if (options.getJSONObject(0).length() > 1) {
                if (!((JSONObject)options.getJSONObject(0).get(OPTIONS)).isNull(FORMATLENGTH)) {
                    String fmtOpt = (String)((JSONObject)options.getJSONObject(0).get(OPTIONS)).get(FORMATLENGTH);
                    if (fmtOpt.equalsIgnoreCase(MEDIUM)) {
                        fmtDate = (SimpleDateFormat)DateFormat.getMediumDateFormat((Context)this.cordova.getActivity());
                    } else if (fmtOpt.equalsIgnoreCase(LONG) || fmtOpt.equalsIgnoreCase(FULL)) {
                        fmtDate = (SimpleDateFormat)DateFormat.getLongDateFormat((Context)this.cordova.getActivity());
                    }
                }
                fmt = fmtDate.toLocalizedPattern() + " " + fmtTime.toLocalizedPattern();
                if (!((JSONObject)options.getJSONObject(0).get(OPTIONS)).isNull(SELECTOR)) {
                    String selOpt = (String)((JSONObject)options.getJSONObject(0).get(OPTIONS)).get(SELECTOR);
                    if (selOpt.equalsIgnoreCase(DATE)) {
                        fmt = fmtDate.toLocalizedPattern();
                    } else if (selOpt.equalsIgnoreCase(TIME)) {
                        fmt = fmtTime.toLocalizedPattern();
                    }
                }
            }
            TimeZone tz = TimeZone.getTimeZone(Time.getCurrentTimezone());
            obj.put("pattern", (Object)fmt);
            obj.put("timezone", (Object)tz.getDisplayName(tz.inDaylightTime(Calendar.getInstance().getTime()), 0));
            obj.put("utc_offset", tz.getRawOffset() / 1000);
            obj.put("dst_offset", tz.getDSTSavings() / 1000);
            return obj;
        }
        catch (Exception ge) {
            throw new GlobalizationError("PATTERN_ERROR");
        }
    }

    @TargetApi(value=9)
    private JSONObject getDateNames(JSONArray options) throws GlobalizationError {
        JSONObject obj = new JSONObject();
        JSONArray value = new JSONArray();
        ArrayList<String> namesList = new ArrayList<String>();
        try {
            int method;
            int type = 0;
            int item = 0;
            if (options.getJSONObject(0).length() > 0) {
                String t;
                if (!((JSONObject)options.getJSONObject(0).get(OPTIONS)).isNull(TYPE) && (t = (String)((JSONObject)options.getJSONObject(0).get(OPTIONS)).get(TYPE)).equalsIgnoreCase(NARROW)) {
                    ++type;
                }
                if (!((JSONObject)options.getJSONObject(0).get(OPTIONS)).isNull(ITEM) && (t = (String)((JSONObject)options.getJSONObject(0).get(OPTIONS)).get(ITEM)).equalsIgnoreCase(DAYS)) {
                    item += 10;
                }
            }
            final Map<String, Integer> namesMap = (method = item + type) == 1 ? Calendar.getInstance().getDisplayNames(2, 1, Locale.getDefault()) : (method == 10 ? Calendar.getInstance().getDisplayNames(7, 2, Locale.getDefault()) : (method == 11 ? Calendar.getInstance().getDisplayNames(7, 1, Locale.getDefault()) : Calendar.getInstance().getDisplayNames(2, 2, Locale.getDefault())));
            for (String name : namesMap.keySet()) {
                namesList.add(name);
            }
            Collections.sort(namesList, new Comparator<String>(){

                @Override
                public int compare(String arg0, String arg1) {
                    return ((Integer)namesMap.get(arg0)).compareTo((Integer)namesMap.get(arg1));
                }
            });
            for (int i = 0; i < namesList.size(); ++i) {
                value.put(namesList.get(i));
            }
            return obj.put("value", (Object)value);
        }
        catch (Exception ge) {
            throw new GlobalizationError("UNKNOWN_ERROR");
        }
    }

    private JSONObject getIsDayLightSavingsTime(JSONArray options) throws GlobalizationError {
        JSONObject obj = new JSONObject();
        boolean dst = false;
        try {
            Date date = new Date((Long)options.getJSONObject(0).get(DATE));
            TimeZone tz = TimeZone.getTimeZone(Time.getCurrentTimezone());
            dst = tz.inDaylightTime(date);
            return obj.put("dst", dst);
        }
        catch (Exception ge) {
            throw new GlobalizationError("UNKNOWN_ERROR");
        }
    }

    private JSONObject getFirstDayOfWeek(JSONArray options) throws GlobalizationError {
        JSONObject obj = new JSONObject();
        try {
            int value = Calendar.getInstance(Locale.getDefault()).getFirstDayOfWeek();
            return obj.put("value", value);
        }
        catch (Exception ge) {
            throw new GlobalizationError("UNKNOWN_ERROR");
        }
    }

    private JSONObject getNumberToString(JSONArray options) throws GlobalizationError {
        JSONObject obj = new JSONObject();
        String value = "";
        try {
            DecimalFormat fmt = this.getNumberFormatInstance(options);
            value = fmt.format(options.getJSONObject(0).get(NUMBER));
            return obj.put("value", (Object)value);
        }
        catch (Exception ge) {
            throw new GlobalizationError("FORMATTING_ERROR");
        }
    }

    private JSONObject getStringToNumber(JSONArray options) throws GlobalizationError {
        JSONObject obj = new JSONObject();
        try {
            DecimalFormat fmt = this.getNumberFormatInstance(options);
            Number value = fmt.parse((String)options.getJSONObject(0).get(NUMBERSTRING));
            return obj.put("value", (Object)value);
        }
        catch (Exception ge) {
            throw new GlobalizationError("PARSING_ERROR");
        }
    }

    private JSONObject getNumberPattern(JSONArray options) throws GlobalizationError {
        JSONObject obj = new JSONObject();
        try {
            DecimalFormat fmt = (DecimalFormat)DecimalFormat.getInstance(Locale.getDefault());
            String symbol = String.valueOf(fmt.getDecimalFormatSymbols().getDecimalSeparator());
            if (options.getJSONObject(0).length() > 0 && !((JSONObject)options.getJSONObject(0).get(OPTIONS)).isNull(TYPE)) {
                String fmtOpt = (String)((JSONObject)options.getJSONObject(0).get(OPTIONS)).get(TYPE);
                if (fmtOpt.equalsIgnoreCase(CURRENCY)) {
                    fmt = (DecimalFormat)DecimalFormat.getCurrencyInstance(Locale.getDefault());
                    symbol = fmt.getDecimalFormatSymbols().getCurrencySymbol();
                } else if (fmtOpt.equalsIgnoreCase(PERCENT)) {
                    fmt = (DecimalFormat)DecimalFormat.getPercentInstance(Locale.getDefault());
                    symbol = String.valueOf(fmt.getDecimalFormatSymbols().getPercent());
                }
            }
            obj.put("pattern", (Object)fmt.toPattern());
            obj.put("symbol", (Object)symbol);
            obj.put("fraction", fmt.getMinimumFractionDigits());
            obj.put("rounding", (Object)new Integer(0));
            obj.put("positive", (Object)fmt.getPositivePrefix());
            obj.put("negative", (Object)fmt.getNegativePrefix());
            obj.put("decimal", (Object)String.valueOf(fmt.getDecimalFormatSymbols().getDecimalSeparator()));
            obj.put("grouping", (Object)String.valueOf(fmt.getDecimalFormatSymbols().getGroupingSeparator()));
            return obj;
        }
        catch (Exception ge) {
            throw new GlobalizationError("PATTERN_ERROR");
        }
    }

    private JSONObject getCurrencyPattern(JSONArray options) throws GlobalizationError {
        JSONObject obj = new JSONObject();
        try {
            String code = options.getJSONObject(0).getString(CURRENCYCODE);
            DecimalFormat fmt = (DecimalFormat)DecimalFormat.getCurrencyInstance(Locale.getDefault());
            Currency currency = Currency.getInstance(code);
            fmt.setCurrency(currency);
            obj.put("pattern", (Object)fmt.toPattern());
            obj.put("code", (Object)currency.getCurrencyCode());
            obj.put("fraction", fmt.getMinimumFractionDigits());
            obj.put("rounding", (Object)new Integer(0));
            obj.put("decimal", (Object)String.valueOf(fmt.getDecimalFormatSymbols().getDecimalSeparator()));
            obj.put("grouping", (Object)String.valueOf(fmt.getDecimalFormatSymbols().getGroupingSeparator()));
            return obj;
        }
        catch (Exception ge) {
            throw new GlobalizationError("FORMATTING_ERROR");
        }
    }

    private DecimalFormat getNumberFormatInstance(JSONArray options) throws JSONException {
        DecimalFormat fmt = (DecimalFormat)DecimalFormat.getInstance(Locale.getDefault());
        try {
            if (options.getJSONObject(0).length() > 1 && !((JSONObject)options.getJSONObject(0).get(OPTIONS)).isNull(TYPE)) {
                String fmtOpt = (String)((JSONObject)options.getJSONObject(0).get(OPTIONS)).get(TYPE);
                if (fmtOpt.equalsIgnoreCase(CURRENCY)) {
                    fmt = (DecimalFormat)DecimalFormat.getCurrencyInstance(Locale.getDefault());
                } else if (fmtOpt.equalsIgnoreCase(PERCENT)) {
                    fmt = (DecimalFormat)DecimalFormat.getPercentInstance(Locale.getDefault());
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return fmt;
    }
}

