/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.cordova.Config;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.api.CallbackContext;
import org.apache.cordova.api.CordovaPlugin;
import org.apache.cordova.api.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"SetJavaScriptEnabled"})
public class InAppBrowser
extends CordovaPlugin {
    private static final String NULL = "null";
    protected static final String LOG_TAG = "InAppBrowser";
    private static final String SELF = "_self";
    private static final String SYSTEM = "_system";
    private static final String LOCATION = "location";
    private static final String EXIT_EVENT = "exit";
    private static final String LOAD_START_EVENT = "loadstart";
    private static final String LOAD_STOP_EVENT = "loadstop";
    private Dialog dialog;
    private WebView inAppWebView;
    private EditText edittext;
    private boolean showLocationBar = true;
    private CallbackContext callbackContext;

    @Override
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        this.callbackContext = callbackContext;
        try {
            PluginResult pluginResult;
            if (action.equals("open")) {
                String url = args.getString(0);
                String target = args.optString(1);
                if (target == null || target.equals("") || target.equals(NULL)) {
                    target = SELF;
                }
                HashMap<String, Boolean> features = this.parseFeature(args.optString(2));
                Log.d((String)LOG_TAG, (String)("target = " + target));
                url = this.updateUrl(url);
                if (SELF.equals(target)) {
                    Log.d((String)LOG_TAG, (String)"in self");
                    if (url.startsWith("file://") || url.startsWith("javascript:") || Config.isUrlWhiteListed(url)) {
                        this.webView.loadUrl(url);
                    } else {
                        result = this.showWebPage(url, features);
                    }
                } else if (SYSTEM.equals(target)) {
                    Log.d((String)LOG_TAG, (String)"in system");
                    result = this.openExternal(url);
                } else {
                    Log.d((String)LOG_TAG, (String)"in blank");
                    result = this.showWebPage(url, features);
                }
            } else if (action.equals("close")) {
                this.closeDialog();
                pluginResult = new PluginResult(PluginResult.Status.OK);
                pluginResult.setKeepCallback(false);
                this.callbackContext.sendPluginResult(pluginResult);
            } else {
                status = PluginResult.Status.INVALID_ACTION;
            }
            pluginResult = new PluginResult(status, result);
            pluginResult.setKeepCallback(true);
            this.callbackContext.sendPluginResult(pluginResult);
        }
        catch (JSONException e) {
            this.callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
        }
        return true;
    }

    private HashMap<String, Boolean> parseFeature(String optString) {
        if (optString.equals(NULL)) {
            return null;
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        StringTokenizer features = new StringTokenizer(optString, ",");
        while (features.hasMoreElements()) {
            StringTokenizer option = new StringTokenizer(features.nextToken(), "=");
            if (!option.hasMoreElements()) continue;
            String key = option.nextToken();
            Boolean value = option.nextToken().equals("no") ? Boolean.FALSE : Boolean.TRUE;
            map.put(key, value);
        }
        return map;
    }

    private String updateUrl(String url) {
        Uri newUrl = Uri.parse((String)url);
        if (newUrl.isRelative()) {
            url = this.webView.getUrl().substring(0, this.webView.getUrl().lastIndexOf("/") + 1) + url;
        }
        return url;
    }

    public String openExternal(String url) {
        try {
            Intent intent = null;
            intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            this.cordova.getActivity().startActivity(intent);
            return "";
        }
        catch (ActivityNotFoundException e) {
            Log.d((String)LOG_TAG, (String)("InAppBrowser: Error loading url " + url + ":" + e.toString()));
            return e.toString();
        }
    }

    private void closeDialog() {
        try {
            JSONObject obj = new JSONObject();
            obj.put("type", (Object)EXIT_EVENT);
            this.sendUpdate(obj, false);
        }
        catch (JSONException ex) {
            Log.d((String)LOG_TAG, (String)"Should never happen");
        }
        if (this.dialog != null) {
            this.dialog.dismiss();
        }
    }

    private void goBack() {
        if (this.inAppWebView.canGoBack()) {
            this.inAppWebView.goBack();
        }
    }

    private void goForward() {
        if (this.inAppWebView.canGoForward()) {
            this.inAppWebView.goForward();
        }
    }

    private void navigate(String url) {
        InputMethodManager imm = (InputMethodManager)this.cordova.getActivity().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.edittext.getWindowToken(), 0);
        if (!url.startsWith("http") && !url.startsWith("file:")) {
            this.inAppWebView.loadUrl("http://" + url);
        } else {
            this.inAppWebView.loadUrl(url);
        }
        this.inAppWebView.requestFocus();
    }

    private boolean getShowLocationBar() {
        return this.showLocationBar;
    }

    public String showWebPage(final String url, HashMap<String, Boolean> features) {
        this.showLocationBar = true;
        if (features != null) {
            this.showLocationBar = features.get(LOCATION);
        }
        final CordovaWebView thatWebView = this.webView;
        Runnable runnable = new Runnable(){

            private int dpToPixels(int dipValue) {
                int value = (int)TypedValue.applyDimension((int)1, (float)dipValue, (DisplayMetrics)InAppBrowser.this.cordova.getActivity().getResources().getDisplayMetrics());
                return value;
            }

            public void run() {
                InAppBrowser.this.dialog = new Dialog((Context)InAppBrowser.this.cordova.getActivity(), 16973830);
                ((InAppBrowser)InAppBrowser.this).dialog.getWindow().getAttributes().windowAnimations = 16973826;
                InAppBrowser.this.dialog.requestWindowFeature(1);
                InAppBrowser.this.dialog.setCancelable(true);
                InAppBrowser.this.dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialog) {
                        try {
                            JSONObject obj = new JSONObject();
                            obj.put("type", (Object)InAppBrowser.EXIT_EVENT);
                            InAppBrowser.this.sendUpdate(obj, false);
                        }
                        catch (JSONException e) {
                            Log.d((String)InAppBrowser.LOG_TAG, (String)"Should never happen");
                        }
                    }
                });
                LinearLayout main = new LinearLayout((Context)InAppBrowser.this.cordova.getActivity());
                main.setOrientation(1);
                RelativeLayout toolbar = new RelativeLayout((Context)InAppBrowser.this.cordova.getActivity());
                toolbar.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, this.dpToPixels(44)));
                toolbar.setPadding(this.dpToPixels(2), this.dpToPixels(2), this.dpToPixels(2), this.dpToPixels(2));
                toolbar.setHorizontalGravity(3);
                toolbar.setVerticalGravity(48);
                RelativeLayout actionButtonContainer = new RelativeLayout((Context)InAppBrowser.this.cordova.getActivity());
                actionButtonContainer.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
                actionButtonContainer.setHorizontalGravity(3);
                actionButtonContainer.setVerticalGravity(16);
                actionButtonContainer.setId(1);
                Button back = new Button((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams backLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
                backLayoutParams.addRule(5);
                back.setLayoutParams((ViewGroup.LayoutParams)backLayoutParams);
                back.setContentDescription((CharSequence)"Back Button");
                back.setId(2);
                back.setText((CharSequence)"<");
                back.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InAppBrowser.this.goBack();
                    }
                });
                Button forward = new Button((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams forwardLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
                forwardLayoutParams.addRule(1, 2);
                forward.setLayoutParams((ViewGroup.LayoutParams)forwardLayoutParams);
                forward.setContentDescription((CharSequence)"Forward Button");
                forward.setId(3);
                forward.setText((CharSequence)">");
                forward.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InAppBrowser.this.goForward();
                    }
                });
                InAppBrowser.this.edittext = new EditText((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams textLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
                textLayoutParams.addRule(1, 1);
                textLayoutParams.addRule(0, 5);
                InAppBrowser.this.edittext.setLayoutParams((ViewGroup.LayoutParams)textLayoutParams);
                InAppBrowser.this.edittext.setId(4);
                InAppBrowser.this.edittext.setSingleLine(true);
                InAppBrowser.this.edittext.setText((CharSequence)url);
                InAppBrowser.this.edittext.setInputType(16);
                InAppBrowser.this.edittext.setImeOptions(2);
                InAppBrowser.this.edittext.setInputType(0);
                InAppBrowser.this.edittext.setOnKeyListener(new View.OnKeyListener(){

                    public boolean onKey(View v, int keyCode, KeyEvent event) {
                        if (event.getAction() == 0 && keyCode == 66) {
                            InAppBrowser.this.navigate(InAppBrowser.this.edittext.getText().toString());
                            return true;
                        }
                        return false;
                    }
                });
                Button close = new Button((Context)InAppBrowser.this.cordova.getActivity());
                RelativeLayout.LayoutParams closeLayoutParams = new RelativeLayout.LayoutParams(-2, -1);
                closeLayoutParams.addRule(11);
                close.setLayoutParams((ViewGroup.LayoutParams)closeLayoutParams);
                forward.setContentDescription((CharSequence)"Close Button");
                close.setId(5);
                close.setText((CharSequence)"Done");
                close.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        InAppBrowser.this.closeDialog();
                    }
                });
                InAppBrowser.this.inAppWebView = new WebView((Context)InAppBrowser.this.cordova.getActivity());
                InAppBrowser.this.inAppWebView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                InAppBrowser.this.inAppWebView.setWebChromeClient(new WebChromeClient());
                InAppBrowserClient client = new InAppBrowserClient(thatWebView, InAppBrowser.this.edittext);
                InAppBrowser.this.inAppWebView.setWebViewClient((WebViewClient)client);
                WebSettings settings = InAppBrowser.this.inAppWebView.getSettings();
                settings.setJavaScriptEnabled(true);
                settings.setJavaScriptCanOpenWindowsAutomatically(true);
                settings.setBuiltInZoomControls(true);
                settings.setPluginsEnabled(true);
                settings.setDatabaseEnabled(true);
                String databasePath = InAppBrowser.this.cordova.getActivity().getApplicationContext().getDir("inAppBrowserDB", 0).getPath();
                settings.setDatabasePath(databasePath);
                settings.setDomStorageEnabled(true);
                InAppBrowser.this.inAppWebView.loadUrl(url);
                InAppBrowser.this.inAppWebView.setId(6);
                InAppBrowser.this.inAppWebView.getSettings().setLoadWithOverviewMode(true);
                InAppBrowser.this.inAppWebView.getSettings().setUseWideViewPort(true);
                InAppBrowser.this.inAppWebView.requestFocus();
                InAppBrowser.this.inAppWebView.requestFocusFromTouch();
                actionButtonContainer.addView((View)back);
                actionButtonContainer.addView((View)forward);
                toolbar.addView((View)actionButtonContainer);
                toolbar.addView((View)InAppBrowser.this.edittext);
                toolbar.addView((View)close);
                if (InAppBrowser.this.getShowLocationBar()) {
                    main.addView((View)toolbar);
                }
                main.addView((View)InAppBrowser.this.inAppWebView);
                WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
                lp.copyFrom(InAppBrowser.this.dialog.getWindow().getAttributes());
                lp.width = -1;
                lp.height = -1;
                InAppBrowser.this.dialog.setContentView((View)main);
                InAppBrowser.this.dialog.show();
                InAppBrowser.this.dialog.getWindow().setAttributes(lp);
            }
        };
        this.cordova.getActivity().runOnUiThread(runnable);
        return "";
    }

    private void sendUpdate(JSONObject obj, boolean keepCallback) {
        PluginResult result = new PluginResult(PluginResult.Status.OK, obj);
        result.setKeepCallback(keepCallback);
        this.callbackContext.sendPluginResult(result);
    }

    public class InAppBrowserClient
    extends WebViewClient {
        EditText edittext;
        CordovaWebView webView;

        public InAppBrowserClient(CordovaWebView webView, EditText mEditText) {
            this.webView = webView;
            this.edittext = mEditText;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            String newloc = url.startsWith("http:") || url.startsWith("https:") || url.startsWith("file:") ? url : "http://" + url;
            if (!newloc.equals(this.edittext.getText().toString())) {
                this.edittext.setText((CharSequence)newloc);
            }
            try {
                JSONObject obj = new JSONObject();
                obj.put("type", (Object)InAppBrowser.LOAD_START_EVENT);
                obj.put("url", (Object)newloc);
                InAppBrowser.this.sendUpdate(obj, true);
            }
            catch (JSONException ex) {
                Log.d((String)InAppBrowser.LOG_TAG, (String)"Should never happen");
            }
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            try {
                JSONObject obj = new JSONObject();
                obj.put("type", (Object)InAppBrowser.LOAD_STOP_EVENT);
                obj.put("url", (Object)url);
                InAppBrowser.this.sendUpdate(obj, true);
            }
            catch (JSONException ex) {
                Log.d((String)InAppBrowser.LOG_TAG, (String)"Should never happen");
            }
        }
    }
}

