//Variables globales

var scrollPosition = 0;
var _menu = null;
var _definitionsPage = null;
var _externalPage = null;
var _historyPage = null;
var _deleteLink = null;
var _aboutPage = null;
var _definitionList = null;
var _searchList = null;
var _searchBox = null;
var _descriptionPage = null;

//Funciones

startUp = function(){
	_menu = $('#menu');
	_definitionsPage = $('#definitionsPage');
	_externalPage = $('#externalPage');
	_historyPage = $('#historyPage');
	_deleteLink = $('.deleteLink');
	_aboutPage = $('#aboutPage');
	_searchBox = $('#searchBox');
	_definitionList = $('#definitionList');
	_searchList = $('#searchList');
	_descriptionPage = $('#descriptionPage');
}

var showMenu = function(){
	_menu.css('display','block');
	document.addEventListener('backbutton', hideMenu, false);
}

var hideMenu = function(){
	_menu.css('display','none');
	document.removeEventListener('backbutton', hideMenu, false);
}

var showIframe = function(){
	$('#descriptionPage').css('display','block');
}

var deleteFromHistory = function(id){
	h = new History();
	h.deleteItem(id);
}

var emptyHistory = function(){
	h = new History();
	h.empty();
}

var closeAbout = function(){
	document.removeEventListener('backbutton',closeAbout, false);
	_aboutPage.css('display','none');	
}

var showAbout = function(){
	_menu.css('display','none');
	_aboutPage.css('display','block');
	document.addEventListener('backbutton',closeAbout, false);
}

var closeHistory = function(){
	document.removeEventListener('backbutton',closeHistory, false);
	_historyPage.css('display','none');	
}

var showHistory = function(){
	_menu.css('display','none');
	_historyPage.css('display','block');
	loadHistory(); //Se recarga el historial
	document.addEventListener('backbutton',closeHistory, false);
}

loadAll = function(){
	if(_searchBox.val() == ""){
		d = new Definition();
		rows = d.loadAll();
		fillList(rows, _definitionList); //Llena la lista
	}
}

var view = function(id){
	d = new Definition();
	definition = d.view(id);
	$('#word').html(definition.item(0).name);
	$('#description').html(definition.item(0).description);
	h = new History();
	h.add(id); //Se guarda la consulta en el historial
}

var closeDescription = function(){
	document.removeEventListener('backbutton',closeDescription, false);
	_descriptionPage.css('display','none');	
}

var showDescription = function(id){
	_descriptionPage.css('display','block');
	_descriptionPage.css('z-index','1');
	document.addEventListener('backbutton',closeDescription, false);
	view(id);
}

fillList = function(rows, list){
	if(rows.length == 0){
		list.append('<li>No hay resultados</li>');
	}else{
		for(i=0; i<rows.length; i++){
			list.append('<li onclick="showDescription('+rows.item(i).id+')">'+rows.item(i).name+'</li>');
		}
	}
}

var loadHistory = function(){
	h = new History();
	rows = h.load();
		$('#historyList').empty();
	for(i=0;i<rows.length;i++){
		$("#historyList").append('\
			<li>\
			<span onclick="showDescription('+rows.item(i).word_id+',this)">'+rows.item(i).name+'</span>\
			<span href="#" class="deleteLink" id="'+rows.item(i).word_id+'"><img src="img/delete-icon.png" width="20"></span>\
			</li>\
		');		
	}	
}

search = function(text){
	definition = new Definition();
	rows = definition.search(text);
	$('#definitionContainer').css('display','none');
	_searchList.empty();
	fillList(rows,_searchList);
	$('#searchContainer').css('display','block');
}

closeApp = function(){
	navigator.app.exitApp();
}

//Eventos

$(document).ready(function(){
	document.addEventListener('deviceready',function(){
		startUp();		

		loadAll();
		$('#initMessage').remove();

		//Se carga el historial
		loadHistory();

		//Evento para cuando se aprete el botón de menú (Android)
		document.addEventListener('menubutton', showMenu, false);

		//Hacer click en el botón de historial (menú)
		$('#historyButton').on('click',showHistory);

		//Hacer click en el botón de about (menú)
		$('#aboutButton').on('click',showAbout);

		//Evento al hacer click en el boton de eliminar de un elemento
		_deleteLink.live('click',function(){
			id = $($(this).parent()).attr('id');
			$($(this).parent()).remove();
			deleteFromHistory(id);
		});

		//Hacer click en el botón de vaciar historial
		$('#emptyLink').on('click', function(){
			$('#historyList').empty();
			emptyHistory();
		});

		//Se ingresa una palabra en la barra de busqueda
		_searchBox.keyup(function(){
			text = this.value;
			if(text != ""){
				search(text);
			}else{
				$('#searchContainer').css('display','none');
				$('#definitionContainer').css('display','block');
			}
		});

	}, false);
});		
