"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.legacyIvyPluginEnabled = exports.profilingEnabled = exports.cachingBasePath = exports.cachingDisabled = exports.allowMinify = exports.shouldBeautify = exports.allowMangle = void 0;
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const path = require("path");
function isDisabled(variable) {
    return variable === '0' || variable.toLowerCase() === 'false';
}
function isEnabled(variable) {
    return variable === '1' || variable.toLowerCase() === 'true';
}
function isPresent(variable) {
    return typeof variable === 'string' && variable !== '';
}
// Optimization and mangling
const debugOptimizeVariable = process.env['NG_BUILD_DEBUG_OPTIMIZE'];
const debugOptimize = (() => {
    if (!isPresent(debugOptimizeVariable) || isDisabled(debugOptimizeVariable)) {
        return {
            mangle: true,
            minify: true,
            beautify: false,
        };
    }
    const debugValue = {
        mangle: false,
        minify: false,
        beautify: true,
    };
    if (isEnabled(debugOptimizeVariable)) {
        return debugValue;
    }
    for (const part of debugOptimizeVariable.split(',')) {
        switch (part.trim().toLowerCase()) {
            case 'mangle':
                debugValue.mangle = true;
                break;
            case 'minify':
                debugValue.minify = true;
                break;
            case 'beautify':
                debugValue.beautify = true;
                break;
        }
    }
    return debugValue;
})();
const mangleVariable = process.env['NG_BUILD_MANGLE'];
exports.allowMangle = isPresent(mangleVariable)
    ? !isDisabled(mangleVariable)
    : debugOptimize.mangle;
exports.shouldBeautify = debugOptimize.beautify;
exports.allowMinify = debugOptimize.minify;
// Build cache
const cacheVariable = process.env['NG_BUILD_CACHE'];
exports.cachingDisabled = isPresent(cacheVariable) && isDisabled(cacheVariable);
exports.cachingBasePath = (() => {
    if (exports.cachingDisabled || !isPresent(cacheVariable) || isEnabled(cacheVariable)) {
        return null;
    }
    if (!path.isAbsolute(cacheVariable)) {
        throw new Error('NG_BUILD_CACHE path value must be absolute.');
    }
    return cacheVariable;
})();
// Build profiling
const profilingVariable = process.env['NG_BUILD_PROFILING'];
exports.profilingEnabled = isPresent(profilingVariable) && isEnabled(profilingVariable);
// Legacy Webpack plugin with Ivy
const legacyIvyVariable = process.env['NG_BUILD_IVY_LEGACY'];
exports.legacyIvyPluginEnabled = isPresent(legacyIvyVariable) && !isDisabled(legacyIvyVariable);
