(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/ngcc/src/host/ngcc_host", ["require", "exports", "typescript"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isSwitchableVariableDeclaration = exports.POST_R3_MARKER = exports.PRE_R3_MARKER = void 0;
    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var ts = require("typescript");
    exports.PRE_R3_MARKER = '__PRE_R3__';
    exports.POST_R3_MARKER = '__POST_R3__';
    function isSwitchableVariableDeclaration(node) {
        return ts.isVariableDeclaration(node) && !!node.initializer &&
            ts.isIdentifier(node.initializer) && node.initializer.text.endsWith(exports.PRE_R3_MARKER);
    }
    exports.isSwitchableVariableDeclaration = isSwitchableVariableDeclaration;
});
//# sourceMappingURL=data:application/json;base64,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