(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/ngcc/src/ngcc_options", ["require", "exports", "os", "@angular/compiler-cli/src/ngtsc/file_system", "@angular/compiler-cli/src/ngtsc/logging", "@angular/compiler-cli/src/perform_compile", "@angular/compiler-cli/ngcc/src/packages/entry_point", "@angular/compiler-cli/ngcc/src/path_mappings", "@angular/compiler-cli/ngcc/src/writing/in_place_file_writer", "@angular/compiler-cli/ngcc/src/writing/new_entry_point_file_writer"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.getMaxNumberOfWorkers = exports.clearTsConfigCache = exports.getSharedSetup = void 0;
    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var os = require("os");
    var file_system_1 = require("@angular/compiler-cli/src/ngtsc/file_system");
    var logging_1 = require("@angular/compiler-cli/src/ngtsc/logging");
    var perform_compile_1 = require("@angular/compiler-cli/src/perform_compile");
    var entry_point_1 = require("@angular/compiler-cli/ngcc/src/packages/entry_point");
    var path_mappings_1 = require("@angular/compiler-cli/ngcc/src/path_mappings");
    var in_place_file_writer_1 = require("@angular/compiler-cli/ngcc/src/writing/in_place_file_writer");
    var new_entry_point_file_writer_1 = require("@angular/compiler-cli/ngcc/src/writing/new_entry_point_file_writer");
    /**
     * Instantiate common utilities that are always used and fix up options with defaults, as necessary.
     *
     * NOTE: Avoid eagerly instantiating anything that might not be used when running sync/async.
     */
    function getSharedSetup(options) {
        var fileSystem = file_system_1.getFileSystem();
        var absBasePath = file_system_1.absoluteFrom(options.basePath);
        var projectPath = fileSystem.dirname(absBasePath);
        var tsConfig = options.tsConfigPath !== null ? getTsConfig(options.tsConfigPath || projectPath) : null;
        var basePath = options.basePath, targetEntryPointPath = options.targetEntryPointPath, _a = options.propertiesToConsider, propertiesToConsider = _a === void 0 ? entry_point_1.SUPPORTED_FORMAT_PROPERTIES : _a, _b = options.typingsOnly, typingsOnly = _b === void 0 ? false : _b, _c = options.compileAllFormats, compileAllFormats = _c === void 0 ? true : _c, _d = options.createNewEntryPointFormats, createNewEntryPointFormats = _d === void 0 ? false : _d, _e = options.logger, logger = _e === void 0 ? new logging_1.ConsoleLogger(logging_1.LogLevel.info) : _e, _f = options.pathMappings, pathMappings = _f === void 0 ? path_mappings_1.getPathMappingsFromTsConfig(fileSystem, tsConfig, projectPath) : _f, _g = options.async, async = _g === void 0 ? false : _g, _h = options.errorOnFailedEntryPoint, errorOnFailedEntryPoint = _h === void 0 ? false : _h, _j = options.enableI18nLegacyMessageIdFormat, enableI18nLegacyMessageIdFormat = _j === void 0 ? true : _j, _k = options.invalidateEntryPointManifest, invalidateEntryPointManifest = _k === void 0 ? false : _k, tsConfigPath = options.tsConfigPath;
        if (!!targetEntryPointPath) {
            // targetEntryPointPath forces us to error if an entry-point fails.
            errorOnFailedEntryPoint = true;
        }
        if (typingsOnly) {
            // If we only want to process the typings then we do not want to waste time trying to process
            // multiple JS formats.
            compileAllFormats = false;
        }
        checkForSolutionStyleTsConfig(fileSystem, logger, projectPath, options.tsConfigPath, tsConfig);
        return {
            basePath: basePath,
            targetEntryPointPath: targetEntryPointPath,
            propertiesToConsider: propertiesToConsider,
            typingsOnly: typingsOnly,
            compileAllFormats: compileAllFormats,
            createNewEntryPointFormats: createNewEntryPointFormats,
            logger: logger,
            pathMappings: pathMappings,
            async: async,
            errorOnFailedEntryPoint: errorOnFailedEntryPoint,
            enableI18nLegacyMessageIdFormat: enableI18nLegacyMessageIdFormat,
            invalidateEntryPointManifest: invalidateEntryPointManifest,
            tsConfigPath: tsConfigPath,
            fileSystem: fileSystem,
            absBasePath: absBasePath,
            projectPath: projectPath,
            tsConfig: tsConfig,
            getFileWriter: function (pkgJsonUpdater) { return createNewEntryPointFormats ?
                new new_entry_point_file_writer_1.NewEntryPointFileWriter(fileSystem, logger, errorOnFailedEntryPoint, pkgJsonUpdater) :
                new in_place_file_writer_1.InPlaceFileWriter(fileSystem, logger, errorOnFailedEntryPoint); },
        };
    }
    exports.getSharedSetup = getSharedSetup;
    var tsConfigCache = null;
    var tsConfigPathCache = null;
    /**
     * Get the parsed configuration object for the given `tsConfigPath`.
     *
     * This function will cache the previous parsed configuration object to avoid unnecessary processing
     * of the tsconfig.json in the case that it is requested repeatedly.
     *
     * This makes the assumption, which is true as of writing, that the contents of tsconfig.json and
     * its dependencies will not change during the life of the process running ngcc.
     */
    function getTsConfig(tsConfigPath) {
        if (tsConfigPath !== tsConfigPathCache) {
            tsConfigPathCache = tsConfigPath;
            tsConfigCache = perform_compile_1.readConfiguration(tsConfigPath);
        }
        return tsConfigCache;
    }
    function clearTsConfigCache() {
        tsConfigPathCache = null;
        tsConfigCache = null;
    }
    exports.clearTsConfigCache = clearTsConfigCache;
    function checkForSolutionStyleTsConfig(fileSystem, logger, projectPath, tsConfigPath, tsConfig) {
        if (tsConfigPath !== null && !tsConfigPath && tsConfig !== null &&
            tsConfig.rootNames.length === 0 && tsConfig.projectReferences !== undefined &&
            tsConfig.projectReferences.length > 0) {
            logger.warn("The inferred tsconfig file \"" + tsConfig.project + "\" appears to be \"solution-style\" " +
                "since it contains no root files but does contain project references.\n" +
                "This is probably not wanted, since ngcc is unable to infer settings like \"paths\" mappings from such a file.\n" +
                "Perhaps you should have explicitly specified one of the referenced projects using the --tsconfig option. For example:\n\n" +
                tsConfig.projectReferences.map(function (ref) { return "  ngcc ... --tsconfig \"" + ref.originalPath + "\"\n"; })
                    .join('') +
                "\nFind out more about solution-style tsconfig at https://devblogs.microsoft.com/typescript/announcing-typescript-3-9/#solution-style-tsconfig.\n" +
                "If you did intend to use this file, then you can hide this warning by providing it explicitly:\n\n" +
                ("  ngcc ... --tsconfig \"" + fileSystem.relative(projectPath, tsConfig.project) + "\""));
        }
    }
    /**
     * Determines the maximum number of workers to use for parallel execution. This can be set using the
     * NGCC_MAX_WORKERS environment variable, or is computed based on the number of available CPUs. One
     * CPU core is always reserved for the master process, so we take the number of CPUs minus one, with
     * a maximum of 4 workers. We don't scale the number of workers beyond 4 by default, as it takes
     * considerably more memory and CPU cycles while not offering a substantial improvement in time.
     */
    function getMaxNumberOfWorkers() {
        var maxWorkers = process.env.NGCC_MAX_WORKERS;
        if (maxWorkers === undefined) {
            // Use up to 4 CPU cores for workers, always reserving one for master.
            return Math.max(1, Math.min(4, os.cpus().length - 1));
        }
        var numericMaxWorkers = +maxWorkers.trim();
        if (!Number.isInteger(numericMaxWorkers)) {
            throw new Error('NGCC_MAX_WORKERS should be an integer.');
        }
        else if (numericMaxWorkers < 1) {
            throw new Error('NGCC_MAX_WORKERS should be at least 1.');
        }
        return numericMaxWorkers;
    }
    exports.getMaxNumberOfWorkers = getMaxNumberOfWorkers;
});
//# sourceMappingURL=data:application/json;base64,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