/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/typecheck/api/api", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.UpdateMode = void 0;
    var UpdateMode;
    (function (UpdateMode) {
        /**
         * A complete update creates a completely new overlay of type-checking code on top of the user's
         * original program, which doesn't include type-checking code from previous calls to
         * `updateFiles`.
         */
        UpdateMode[UpdateMode["Complete"] = 0] = "Complete";
        /**
         * An incremental update changes the contents of some files in the type-checking program without
         * reverting any prior changes.
         */
        UpdateMode[UpdateMode["Incremental"] = 1] = "Incremental";
    })(UpdateMode = exports.UpdateMode || (exports.UpdateMode = {}));
});
//# sourceMappingURL=data:application/json;base64,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