/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/ngtsc/typecheck/api/checker", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.OptimizeFor = void 0;
    /**
     * Describes the scope of the caller's interest in template type-checking results.
     */
    var OptimizeFor;
    (function (OptimizeFor) {
        /**
         * Indicates that a consumer of a `TemplateTypeChecker` is only interested in results for a given
         * file, and wants them as fast as possible.
         *
         * Calling `TemplateTypeChecker` methods successively for multiple files while specifying
         * `OptimizeFor.SingleFile` can result in significant unnecessary overhead overall.
         */
        OptimizeFor[OptimizeFor["SingleFile"] = 0] = "SingleFile";
        /**
         * Indicates that a consumer of a `TemplateTypeChecker` intends to query for results pertaining to
         * the entire user program, and so the type-checker should internally optimize for this case.
         *
         * Initial calls to retrieve type-checking information may take longer, but repeated calls to
         * gather information for the whole user program will be significantly faster with this mode of
         * optimization.
         */
        OptimizeFor[OptimizeFor["WholeProgram"] = 1] = "WholeProgram";
    })(OptimizeFor = exports.OptimizeFor || (exports.OptimizeFor = {}));
});
//# sourceMappingURL=data:application/json;base64,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