/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ɵɵinjectAttribute } from '../render3/instructions/di_attr';
import { makeParamDecorator } from '../util/decorators';
function CREATE_ATTRIBUTE_DECORATOR__PRE_R3__() {
    return makeParamDecorator('Attribute', (attributeName) => ({ attributeName }));
}
export function CREATE_ATTRIBUTE_DECORATOR__POST_R3__() {
    return makeParamDecorator('Attribute', (attributeName) => ({ attributeName, __NG_ELEMENT_ID__: () => ɵɵinjectAttribute(attributeName) }));
}
const CREATE_ATTRIBUTE_DECORATOR_IMPL = CREATE_ATTRIBUTE_DECORATOR__PRE_R3__;
/**
 * Attribute decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export const Attribute = CREATE_ATTRIBUTE_DECORATOR_IMPL();
//# sourceMappingURL=data:application/json;base64,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