/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { getUrlScheme, Identifiers, syntaxError } from '@angular/compiler';
import { ANALYZE_FOR_ENTRY_COMPONENTS, ChangeDetectionStrategy, ChangeDetectorRef, ComponentFactory, ComponentFactoryResolver, ComponentRef, ElementRef, Injector, LOCALE_ID, NgModuleFactory, NgModuleRef, QueryList, Renderer2, SecurityContext, TemplateRef, TRANSLATIONS_FORMAT, ViewContainerRef, ViewEncapsulation, ɵand, ɵccf, ɵcmf, ɵCodegenComponentFactoryResolver, ɵcrt, ɵdid, ɵeld, ɵEMPTY_ARRAY, ɵEMPTY_MAP, ɵinlineInterpolate, ɵinterpolate, ɵmod, ɵmpd, ɵncd, ɵnov, ɵpad, ɵpid, ɵpod, ɵppd, ɵprd, ɵqud, ɵReflectionCapabilities as ReflectionCapabilities, ɵregisterModuleFactory, ɵstringify as stringify, ɵted, ɵunv, ɵvid } from '@angular/core';
export const MODULE_SUFFIX = '';
const builtinExternalReferences = createBuiltinExternalReferencesMap();
export class JitReflector {
    constructor() {
        this.reflectionCapabilities = new ReflectionCapabilities();
    }
    componentModuleUrl(type, cmpMetadata) {
        const moduleId = cmpMetadata.moduleId;
        if (typeof moduleId === 'string') {
            const scheme = getUrlScheme(moduleId);
            return scheme ? moduleId : `package:${moduleId}${MODULE_SUFFIX}`;
        }
        else if (moduleId !== null && moduleId !== void 0) {
            throw syntaxError(`moduleId should be a string in "${stringify(type)}". See https://goo.gl/wIDDiL for more information.\n` +
                `If you're using Webpack you should inline the template and the styles, see https://goo.gl/X2J8zc.`);
        }
        return `./${stringify(type)}`;
    }
    parameters(typeOrFunc) {
        return this.reflectionCapabilities.parameters(typeOrFunc);
    }
    tryAnnotations(typeOrFunc) {
        return this.annotations(typeOrFunc);
    }
    annotations(typeOrFunc) {
        return this.reflectionCapabilities.annotations(typeOrFunc);
    }
    shallowAnnotations(typeOrFunc) {
        throw new Error('Not supported in JIT mode');
    }
    propMetadata(typeOrFunc) {
        return this.reflectionCapabilities.propMetadata(typeOrFunc);
    }
    hasLifecycleHook(type, lcProperty) {
        return this.reflectionCapabilities.hasLifecycleHook(type, lcProperty);
    }
    guards(type) {
        return this.reflectionCapabilities.guards(type);
    }
    resolveExternalReference(ref) {
        return builtinExternalReferences.get(ref) || ref.runtime;
    }
}
function createBuiltinExternalReferencesMap() {
    const map = new Map();
    map.set(Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS, ANALYZE_FOR_ENTRY_COMPONENTS);
    map.set(Identifiers.ElementRef, ElementRef);
    map.set(Identifiers.NgModuleRef, NgModuleRef);
    map.set(Identifiers.ViewContainerRef, ViewContainerRef);
    map.set(Identifiers.ChangeDetectorRef, ChangeDetectorRef);
    map.set(Identifiers.Renderer2, Renderer2);
    map.set(Identifiers.QueryList, QueryList);
    map.set(Identifiers.TemplateRef, TemplateRef);
    map.set(Identifiers.CodegenComponentFactoryResolver, ɵCodegenComponentFactoryResolver);
    map.set(Identifiers.ComponentFactoryResolver, ComponentFactoryResolver);
    map.set(Identifiers.ComponentFactory, ComponentFactory);
    map.set(Identifiers.ComponentRef, ComponentRef);
    map.set(Identifiers.NgModuleFactory, NgModuleFactory);
    map.set(Identifiers.createModuleFactory, ɵcmf);
    map.set(Identifiers.moduleDef, ɵmod);
    map.set(Identifiers.moduleProviderDef, ɵmpd);
    map.set(Identifiers.RegisterModuleFactoryFn, ɵregisterModuleFactory);
    map.set(Identifiers.Injector, Injector);
    map.set(Identifiers.ViewEncapsulation, ViewEncapsulation);
    map.set(Identifiers.ChangeDetectionStrategy, ChangeDetectionStrategy);
    map.set(Identifiers.SecurityContext, SecurityContext);
    map.set(Identifiers.LOCALE_ID, LOCALE_ID);
    map.set(Identifiers.TRANSLATIONS_FORMAT, TRANSLATIONS_FORMAT);
    map.set(Identifiers.inlineInterpolate, ɵinlineInterpolate);
    map.set(Identifiers.interpolate, ɵinterpolate);
    map.set(Identifiers.EMPTY_ARRAY, ɵEMPTY_ARRAY);
    map.set(Identifiers.EMPTY_MAP, ɵEMPTY_MAP);
    map.set(Identifiers.viewDef, ɵvid);
    map.set(Identifiers.elementDef, ɵeld);
    map.set(Identifiers.anchorDef, ɵand);
    map.set(Identifiers.textDef, ɵted);
    map.set(Identifiers.directiveDef, ɵdid);
    map.set(Identifiers.providerDef, ɵprd);
    map.set(Identifiers.queryDef, ɵqud);
    map.set(Identifiers.pureArrayDef, ɵpad);
    map.set(Identifiers.pureObjectDef, ɵpod);
    map.set(Identifiers.purePipeDef, ɵppd);
    map.set(Identifiers.pipeDef, ɵpid);
    map.set(Identifiers.nodeValue, ɵnov);
    map.set(Identifiers.ngContentDef, ɵncd);
    map.set(Identifiers.unwrapValue, ɵunv);
    map.set(Identifiers.createRendererType2, ɵcrt);
    map.set(Identifiers.createComponentFactory, ɵccf);
    return map;
}
//# sourceMappingURL=data:application/json;base64,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