/**
 * @license Angular v11.2.14
 * (c) 2010-2021 Google LLC. https://angular.io/
 * License: MIT
 */

import { CompileMetadataResolver } from '@angular/compiler';
import { Compiler } from '@angular/core';
import { CompilerConfig } from '@angular/compiler';
import { CompileReflector } from '@angular/compiler';
import { CompilerFactory } from '@angular/core';
import { CompilerOptions } from '@angular/core';
import { ComponentFactory } from '@angular/core';
import { Injector } from '@angular/core';
import { JitEvaluator } from '@angular/compiler';
import { ModuleWithComponentFactories } from '@angular/core';
import { NgModuleCompiler } from '@angular/compiler';
import { NgModuleFactory } from '@angular/core';
import { PlatformRef } from '@angular/core';
import { Provider } from '@angular/core';
import { ResourceLoader } from '@angular/compiler';
import { StaticProvider } from '@angular/core';
import { StyleCompiler } from '@angular/compiler';
import { SummaryResolver } from '@angular/compiler';
import { TemplateParser } from '@angular/compiler';
import { Type } from '@angular/core';
import { Version } from '@angular/core';
import { ViewCompiler } from '@angular/compiler';
import { ɵConsole } from '@angular/core';

/**
 * @publicApi
 */
import * as ɵngcc0 from '@angular/core';
export declare class JitCompilerFactory implements CompilerFactory {
    private _defaultOptions;
    createCompiler(options?: CompilerOptions[]): Compiler;
}

/**
 * @publicApi
 */
export declare const platformBrowserDynamic: (extraProviders?: StaticProvider[] | undefined) => PlatformRef;

/**
 * @publicApi
 */
export declare const RESOURCE_CACHE_PROVIDER: Provider[];

/**
 * @publicApi
 */
export declare const VERSION: Version;

/**
 * An implementation of ResourceLoader that uses a template cache to avoid doing an actual
 * ResourceLoader.
 *
 * The template cache needs to be built and loaded into window.$templateCache
 * via a separate mechanism.
 *
 * @publicApi
 */
export declare class ɵangular_packages_platform_browser_dynamic_platform_browser_dynamic_a extends ResourceLoader {
    private _cache;
    constructor();
    get(url: string): Promise<string>;
}

export declare const ɵCOMPILER_PROVIDERS__POST_R3__: StaticProvider[];

export declare class ɵCompilerImpl implements Compiler {
    private _metadataResolver;
    private _delegate;
    readonly injector: Injector;
    constructor(injector: Injector, _metadataResolver: CompileMetadataResolver, templateParser: TemplateParser, styleCompiler: StyleCompiler, viewCompiler: ViewCompiler, ngModuleCompiler: NgModuleCompiler, summaryResolver: SummaryResolver<Type<any>>, compileReflector: CompileReflector, jitEvaluator: JitEvaluator, compilerConfig: CompilerConfig, console: ɵConsole);
    private getExtraNgModuleProviders;
    compileModuleSync<T>(moduleType: Type<T>): NgModuleFactory<T>;
    compileModuleAsync<T>(moduleType: Type<T>): Promise<NgModuleFactory<T>>;
    compileModuleAndAllComponentsSync<T>(moduleType: Type<T>): ModuleWithComponentFactories<T>;
    compileModuleAndAllComponentsAsync<T>(moduleType: Type<T>): Promise<ModuleWithComponentFactories<T>>;
    loadAotSummaries(summaries: () => any[]): void;
    hasAotSummary(ref: Type<any>): boolean;
    getComponentFactory<T>(component: Type<T>): ComponentFactory<T>;
    clearCache(): void;
    clearCacheFor(type: Type<any>): void;
    getModuleId(moduleType: Type<any>): string | undefined;
}

/**
 * @publicApi
 */
export declare const ɵINTERNAL_BROWSER_DYNAMIC_PLATFORM_PROVIDERS: StaticProvider[];

/**
 * A platform that included corePlatform and the compiler.
 *
 * @publicApi
 */
export declare const ɵplatformCoreDynamic: (extraProviders?: StaticProvider[] | undefined) => PlatformRef;

export declare class ɵResourceLoaderImpl extends ResourceLoader {
    get(url: string): Promise<string>;
    static ɵfac: ɵngcc0.ɵɵFactoryDef<ɵResourceLoaderImpl, never>;
    static ɵprov: ɵngcc0.ɵɵInjectableDef<ɵResourceLoaderImpl>;
}

export { }

//# sourceMappingURL=platform-browser-dynamic.d.ts.map