/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { __read, __spread } from "tslib";
import { ERROR_DEBUG_CONTEXT, ERROR_LOGGER, ERROR_ORIGINAL_ERROR, ERROR_TYPE } from './util/errors';
export function getType(error) {
    return error[ERROR_TYPE];
}
export function getDebugContext(error) {
    return error[ERROR_DEBUG_CONTEXT];
}
export function getOriginalError(error) {
    return error[ERROR_ORIGINAL_ERROR];
}
export function getErrorLogger(error) {
    return error[ERROR_LOGGER] || defaultErrorLogger;
}
function defaultErrorLogger(console) {
    var values = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        values[_i - 1] = arguments[_i];
    }
    console.error.apply(console, __spread(values));
}
//# sourceMappingURL=data:application/json;base64,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