package com.gcstar.scanner;

import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

public class GCstarScanner extends Activity implements OnClickListener {
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        Button button = (Button) findViewById(R.id.start);
        button.setOnClickListener(this);
    }
    
    @Override
    public void onStart()
    {
        restore();
        
        _ipField = (EditText) findViewById(R.id.ip);
        _portField = (EditText) findViewById(R.id.port);
        
        _ipField.setText(_ip);
        _portField.setText(_sport);
        super.onStart();
    }
    
    public void restore()
    {
        SharedPreferences settings = getPreferences(Context.MODE_PRIVATE);

        _ip = settings.getString("ip", "");
        _sport = settings.getString("port", "50007");
        _port = Integer.parseInt(_sport);
    }
    
    @Override
    public Object onRetainNonConfigurationInstance()
    {
        return(_socket);
    }
    
    public void onClick(View arg0)
    {
        String ip = _ipField.getText().toString();
        String port = _portField.getText().toString();
        int iport = Integer.parseInt(port);
        if (!_ip.equals(ip) || (_port != iport))
        {
            closeSocket();
            _ip = ip;
            _port = iport;
        }
        SharedPreferences settings = getPreferences(Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = settings.edit();
        editor.putString("ip", _ip);
        editor.putString("port", port);
        editor.commit();

        Intent intent = new Intent("com.google.zxing.client.android.SCAN");
        intent.putExtra("SCAN_MODE", "PRODUCT_MODE");
        startActivityForResult(intent, 0);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent)
    {
        if (requestCode == 0)
        {
            if (resultCode == RESULT_OK)
            {
                String contents = intent.getStringExtra("SCAN_RESULT");
                String format = intent.getStringExtra("SCAN_RESULT_FORMAT");
                sendResults(format, contents);
            }
            else if (resultCode == RESULT_CANCELED)
            {
            }
        }
    }
    
    private void sendResults(String format, String content)
    {
        restore();
        if (_socket == null)
        {
            _socket = (Socket)getLastNonConfigurationInstance();
            if ((_socket == null) || _socket.isClosed())
            {
                if (!openSocket())
                {
                    return;
                }
            }
            try
            {
                _output = new PrintStream(_socket.getOutputStream());
            }
            catch (IOException e)
            {
            }
        }
        if (_output == null)
        {
            return;
        }
        String xmlOut = new String("<scans><scan format='" + format + "'>" + content + "</scan></scans>\n");
        _output.print(xmlOut);
    }
    
    private boolean openSocket()
    {
        try
        {
            _socket = new Socket(_ip, _port);
        }
        catch (IOException e)
        {
            System.out.println(e);
            Toast.makeText(this, "Error during connection: " + e, Toast.LENGTH_LONG).show();
            return false;
        }
        return true;
    }
    
    private void closeSocket()
    {
        if (_socket != null)
        {
            try
            {
                _socket.close();
            }
            catch (IOException e)
            {
            }
            _socket = null;
        }
    }
    
    private EditText _ipField;
    private EditText _portField;
    private String _ip;
    private String _sport;
    private int _port;
    private Socket _socket;
    private PrintStream _output;
}