/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.ghostsq.commander.ColorsKeeper;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;
import java.io.InputStream;

public class TextViewer
extends Activity {
    public static final String TAG = "TextViewerActivity";
    private static final String SP_ENC = "encoding";
    public static final String STRURI = "string:";
    public static final String STRKEY = "string";
    private static final int VIEW_BOT = 595;
    private static final int VIEW_TOP = 590;
    private static final int VIEW_ENC = 363;
    private ScrollView scrollView;
    public TextView text_view;
    public Uri uri;
    public String encoding;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            boolean ct_enabled = this.requestWindowFeature(7);
            this.setContentView(2130903058);
            SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this);
            int fs = Integer.parseInt(shared_pref != null ? shared_pref.getString("font_size", "12") : "12");
            this.text_view = (TextView)this.findViewById(2131230883);
            if (this.text_view == null) {
                Log.e((String)TAG, (String)"No text view to show the content!");
                this.finish();
                return;
            }
            this.text_view.setTextSize((float)fs);
            this.text_view.setTypeface(Typeface.create((String)"monospace", (int)0));
            ColorsKeeper ck = new ColorsKeeper((Context)this);
            ck.restore();
            this.text_view.setBackgroundColor(ck.bgrColor);
            this.text_view.setTextColor(ck.fgrColor);
            if (ct_enabled) {
                this.getWindow().setFeatureInt(7, 2130903041);
                TextView act_name_tv = (TextView)this.findViewById(2131230781);
                if (act_name_tv != null) {
                    act_name_tv.setText(2131362075);
                }
            }
            this.scrollView = (ScrollView)this.findViewById(2131230804);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onStart() {
        super.onStart();
        SharedPreferences prefs = this.getPreferences(0);
        if (prefs != null) {
            this.encoding = prefs.getString(SP_ENC, "");
        }
        this.uri = this.getIntent().getData();
        if (!this.loadData()) {
            this.finish();
        }
        TextView file_name_tv = (TextView)this.findViewById(2131230782);
        if (this.uri != null) {
            String path = this.uri.getPath();
            if (file_name_tv != null && path != null && path.length() > 0) {
                String label_text = " - " + this.uri.getPath();
                String frgm = this.uri.getFragment();
                if (frgm != null) {
                    label_text = label_text + " (" + frgm + ")";
                }
                file_name_tv.setText((CharSequence)label_text);
            }
        }
    }

    protected void onPause() {
        super.onPause();
        SharedPreferences.Editor editor = this.getPreferences(0).edit();
        editor.putString(SP_ENC, this.encoding == null ? "" : this.encoding);
        editor.commit();
    }

    protected void onSaveInstanceState(Bundle toSaveState) {
        Log.i((String)TAG, (String)("Saving State: " + this.encoding));
        toSaveState.putString(SP_ENC, this.encoding == null ? "" : this.encoding);
        super.onSaveInstanceState(toSaveState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.encoding = savedInstanceState.getString(SP_ENC);
        }
        Log.i((String)TAG, (String)("Restored State " + this.encoding));
        super.onRestoreInstanceState(savedInstanceState);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        char c = (char)event.getUnicodeChar();
        switch (c) {
            case 'q': {
                this.finish();
                return true;
            }
            case 'g': {
                return this.dispatchCommand(590);
            }
            case 'G': {
                return this.dispatchCommand(595);
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        menu2.clear();
        menu2.add(0, 590, 0, (CharSequence)this.getString(2131362170)).setIcon(17301541);
        menu2.add(0, 595, 0, (CharSequence)this.getString(2131362171)).setIcon(17301538);
        menu2.add(0, 363, 0, (CharSequence)Utils.getEncodingDescr((Context)this, this.encoding, 1)).setIcon(17301660);
        return true;
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        if (this.dispatchCommand(item.getItemId())) {
            return true;
        }
        return super.onMenuItemSelected(featureId, item);
    }

    public boolean dispatchCommand(int id2) {
        switch (id2) {
            case 595: {
                this.scrollView.fullScroll(130);
                return true;
            }
            case 590: {
                this.scrollView.fullScroll(33);
                return true;
            }
            case 363: {
                int cen = Integer.parseInt(Utils.getEncodingDescr((Context)this, this.encoding, 0));
                new AlertDialog.Builder((Context)this).setTitle(2131362172).setSingleChoiceItems(2131296263, cen, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int i) {
                        TextViewer.this.encoding = TextViewer.this.getResources().getStringArray(2131296264)[i];
                        Log.i((String)TextViewer.TAG, (String)("Chosen encoding: " + TextViewer.this.encoding));
                        dialog.dismiss();
                        TextViewer.this.loadData();
                    }
                }).show();
                return true;
            }
        }
        return false;
    }

    private final boolean loadData() {
        if (this.uri != null) {
            try {
                String scheme = this.uri.getScheme();
                if (STRKEY.equals(scheme)) {
                    Intent i = this.getIntent();
                    String str = i.getStringExtra(STRKEY);
                    if (str != null) {
                        this.text_view.setText((CharSequence)str);
                        return true;
                    }
                    return false;
                }
                new DataLoadTask().execute(new Void[0]);
                return true;
            }
            catch (OutOfMemoryError e) {
                Log.e((String)TAG, (String)this.uri.toString(), (Throwable)e);
                Toast.makeText((Context)this, (CharSequence)this.getString(2131362175, new Object[]{this.uri.getPath()}), (int)1).show();
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)this.uri.toString(), (Throwable)e);
                Toast.makeText((Context)this, (CharSequence)(this.getString(2131361905) + e.getLocalizedMessage()), (int)1).show();
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataLoadTask
    extends AsyncTask<Void, String, CharSequence> {
        private DataLoadTask() {
        }

        protected CharSequence doInBackground(Void ... v) {
            Uri uri = TextViewer.this.uri;
            try {
                String scheme = uri.getScheme();
                CommanderAdapter ca = null;
                InputStream is = null;
                if ("content".equals(scheme)) {
                    is = TextViewer.this.getContentResolver().openInputStream(uri);
                } else {
                    ca = CA.CreateAdapterInstance(scheme, (Context)TextViewer.this);
                    if (ca != null) {
                        Credentials crd = null;
                        try {
                            crd = (Credentials)TextViewer.this.getIntent().getParcelableExtra(Credentials.KEY);
                        }
                        catch (Exception e) {
                            Log.e((String)TextViewer.TAG, (String)"on taking credentials from parcel", (Throwable)e);
                        }
                        ca.setCredentials(crd);
                        is = ca.getContent(uri);
                    }
                }
                if (is != null) {
                    CharSequence cs = Utils.readStreamToBuffer(is, TextViewer.this.encoding);
                    if (ca != null) {
                        ca.closeStream(is);
                        ca.prepareToDestroy();
                    } else {
                        is.close();
                    }
                    return cs;
                }
            }
            catch (OutOfMemoryError e) {
                Log.e((String)TextViewer.TAG, (String)uri.toString(), (Throwable)e);
                this.publishProgress(new String[]{TextViewer.this.getString(2131362175, new Object[]{uri.getPath()})});
            }
            catch (Throwable e) {
                Log.e((String)TextViewer.TAG, (String)uri.toString(), (Throwable)e);
                this.publishProgress(new String[]{TextViewer.this.getString(2131361905) + e.getLocalizedMessage()});
            }
            return null;
        }

        protected void onProgressUpdate(String ... err) {
            Toast.makeText((Context)TextViewer.this, (CharSequence)err[0], (int)1).show();
        }

        protected void onPostExecute(CharSequence cs) {
            try {
                TextViewer.this.text_view.setText(cs);
            }
            catch (Throwable e) {
                this.onProgressUpdate(TextViewer.this.getString(2131361905) + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }
}

