/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.widget.AdapterView;
import com.ghostsq.commander.TextViewer;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.utils.MnfUtils;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppsAdapter
extends CommanderAdapterBase {
    private static final String TAG = "AppsAdapter";
    public static final String DEFAULT_LOC = "apps:";
    public static final int LAUNCH_CMD = 9176;
    public static final int MANAGE_CMD = 7161;
    public static final int CREATE_APP_SHORTCUT = 3123;
    public final PackageManager pm;
    public PackageInfo[] pkgInfos;
    private final String MANIFEST = "Manifest";
    private final String ACTIVITIES = "Activities";
    private final String PROVIDERS = "Providers";
    private final String SERVICES = "Services";
    private String MANAGE;
    private String SHORTCUTS;
    private CommanderAdapter.Item[] compItems;
    private ActivityInfo[] actInfos;
    private ProviderInfo[] prvInfos;
    private ServiceInfo[] srvInfos;
    private ResolveInfo[] resInfos;
    private IntentFilter[] intFilters;
    private MnfUtils manUtl;
    private Uri uri;
    private String[] flagsStrs;

    public AppsAdapter(Context ctx_) {
        super(ctx_, 258);
        this.pm = this.ctx.getPackageManager();
        this.pkgInfos = null;
        this.MANIFEST = "Manifest";
        this.ACTIVITIES = "Activities";
        this.PROVIDERS = "Providers";
        this.SERVICES = "Services";
        this.MANAGE = "Manage";
        this.SHORTCUTS = "Shortcuts";
        this.compItems = null;
        this.actInfos = null;
        this.prvInfos = null;
        this.srvInfos = null;
        this.resInfos = null;
        this.intFilters = null;
        this.manUtl = null;
        this.flagsStrs = new String[]{"SYSTEM", "DEBUGGABLE", "HAS_CODE", "PERSISTENT", "FACTORY_TEST", "ALLOW_TASK_REPARENTING", "ALLOW_CLEAR_USER_DATA", "UPDATED_SYSTEM_APP", "TEST_ONLY", "SUPPORTS_SMALL_SCREENS", "SUPPORTS_NORMAL_SCREENS", "SUPPORTS_LARGE_SCREENS", "RESIZEABLE_FOR_SCREENS", "SUPPORTS_SCREEN_DENSITIES", "VM_SAFE_MODE", "ALLOW_BACKUP", "KILL_AFTER_RESTORE", "RESTORE_ANY_VERSION", "EXTERNAL_STORAGE", "SUPPORTS_XLARGE_SCREENS", "NEVER_ENCRYPT", "FORWARD_LOCK", "CANT_SAVE_STATE"};
        this.parentLink = "..";
        this.MANAGE = this.s(2131362186);
        this.SHORTCUTS = this.s(2131362187);
    }

    @Override
    public String getScheme() {
        return "apps";
    }

    @Override
    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case SORTING: 
            case F5: 
            case F8: 
            case SZ: 
            case SEL_UNS: 
            case SEND: 
            case CHKBL: {
                return true;
            }
        }
        return super.hasFeature(feature);
    }

    @Override
    public int setMode(int mask, int val) {
        if ((mask & 1) == 0) {
            super.setMode(mask, val);
        }
        return this.mode;
    }

    @Override
    protected void onReadComplete() {
        if (this.reader instanceof ListEngine) {
            ListEngine list_engine = (ListEngine)this.reader;
            this.pkgInfos = list_engine.getItems();
            this.reSort();
            this.setCount(this.pkgInfos != null ? this.pkgInfos.length + 1 : 1);
        }
    }

    public String toString() {
        return this.uri.toString();
    }

    @Override
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void setUri(Uri uri_) {
        this.uri = uri_;
    }

    @Override
    public boolean readSource(Uri tmp_uri, String pbod) {
        try {
            String a;
            this.dirty = true;
            this.setCount(1);
            this.compItems = null;
            this.pkgInfos = null;
            this.actInfos = null;
            this.prvInfos = null;
            this.srvInfos = null;
            this.resInfos = null;
            this.intFilters = null;
            super.setMode(512, 0);
            if (this.reader != null && this.reader.reqStop()) {
                Thread.sleep(500L);
                if (this.reader.isAlive()) {
                    Log.e((String)TAG, (String)"Busy!");
                    return false;
                }
            }
            if (tmp_uri != null) {
                this.uri = tmp_uri;
            }
            if ((a = this.uri.getAuthority()) == null || a.length() == 0) {
                this.manUtl = null;
                this.notify(-1);
                this.reader = new ListEngine(this.readerHandler, pbod);
                this.reader.start();
                return true;
            }
            String path = this.uri.getPath();
            if (path == null || path.length() <= 1) {
                ArrayList<CommanderAdapter.Item> ial = new ArrayList<CommanderAdapter.Item>();
                this.setCount(1);
                CommanderAdapter.Item manage_item = new CommanderAdapter.Item(this.MANAGE);
                manage_item.setIcon(this.pm.getApplicationIcon("com.android.settings"));
                manage_item.icon_id = 2130837504;
                ial.add(manage_item);
                CommanderAdapter.Item manifest_item = new CommanderAdapter.Item("Manifest");
                manifest_item.icon_id = 2130837546;
                ial.add(manifest_item);
                PackageInfo pi = this.pm.getPackageInfo(a, 13);
                if (pi.activities != null && pi.activities.length > 0) {
                    CommanderAdapter.Item activities_item = new CommanderAdapter.Item("Activities");
                    activities_item.dir = true;
                    activities_item.size = pi.activities.length;
                    ial.add(activities_item);
                }
                if (pi.providers != null && pi.providers.length > 0) {
                    CommanderAdapter.Item providers_item = new CommanderAdapter.Item("Providers");
                    providers_item.dir = true;
                    providers_item.size = pi.providers.length;
                    ial.add(providers_item);
                }
                if (pi.services != null && pi.services.length > 0) {
                    CommanderAdapter.Item services_item = new CommanderAdapter.Item("Services");
                    services_item.dir = true;
                    services_item.size = pi.services.length;
                    ial.add(services_item);
                }
                CommanderAdapter.Item shortcuts_item = new CommanderAdapter.Item(this.SHORTCUTS);
                shortcuts_item.dir = true;
                ial.add(shortcuts_item);
                this.compItems = new CommanderAdapter.Item[ial.size()];
                ial.toArray(this.compItems);
                this.setCount(this.compItems.length + 1);
                this.notify(pbod);
                return true;
            }
            super.setMode(0, 512);
            List ps = this.uri.getPathSegments();
            if (ps != null && ps.size() >= 1) {
                if (this.SHORTCUTS.equals(ps.get(0))) {
                    Intent[] ins = new Intent[]{new Intent("android.intent.action.CREATE_SHORTCUT"), new Intent("android.intent.action.MAIN")};
                    this.resInfos = this.getResolvers(ins, a);
                    if (this.resInfos != null) {
                        this.setCount(this.resInfos.length + 1);
                    }
                } else if (ps.size() >= 2 && "Activities".equals(ps.get(0))) {
                    if (this.manUtl == null) {
                        this.manUtl = new MnfUtils(this.pm, a);
                    }
                    this.intFilters = this.manUtl.getIntentFilters((String)ps.get(1));
                    if (this.intFilters != null) {
                        this.setCount(this.intFilters.length + 1);
                    }
                } else {
                    PackageInfo pi = this.pm.getPackageInfo(a, 13);
                    if ("Activities".equals(ps.get(0))) {
                        this.actInfos = pi.activities != null ? pi.activities : new ActivityInfo[]{};
                        this.reSort();
                        this.setCount(this.actInfos.length + 1);
                    } else if ("Providers".equals(ps.get(0))) {
                        this.prvInfos = pi.providers != null ? pi.providers : new ProviderInfo[]{};
                        this.setCount(this.prvInfos.length + 1);
                    } else if ("Services".equals(ps.get(0))) {
                        this.srvInfos = pi.services != null ? pi.services : new ServiceInfo[]{};
                        this.setCount(this.srvInfos.length + 1);
                    }
                }
                this.notify(pbod);
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)(this.uri != null ? this.uri.toString() : null), (Throwable)e);
            this.notify(this.uri != null ? this.s(2131361905) + this.s(2131362188) + ":\n" + this.uri.getAuthority() : this.s(2131361904), pbod);
            return false;
        }
        this.notify(this.s(2131361904), pbod);
        return false;
    }

    @Override
    protected void reSort() {
        if (this.pkgInfos != null) {
            PackageInfoComparator comp = new PackageInfoComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
            Arrays.sort(this.pkgInfos, comp);
        } else if (this.actInfos != null) {
            ActivityInfoComparator comp = new ActivityInfoComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
            Arrays.sort(this.actInfos, comp);
        } else if (this.prvInfos != null) {
            // empty if block
        }
    }

    private final ResolveInfo[] getResolvers(Intent[] ins, String package_name) {
        try {
            int fl = 96;
            ArrayList<ResolveInfo> tmp_list = new ArrayList<ResolveInfo>();
            for (Intent in : ins) {
                List resolves = this.pm.queryIntentActivities(in, 96);
                for (ResolveInfo res : resolves) {
                    if (!package_name.equals(res.activityInfo.applicationInfo.packageName)) continue;
                    tmp_list.add(res);
                }
            }
            if (tmp_list.size() > 0) {
                ResolveInfo[] ret = new ResolveInfo[tmp_list.size()];
                return tmp_list.toArray(ret);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("For: " + package_name), (Throwable)e);
        }
        return null;
    }

    private static <T> ArrayList<T> bitsToItems(SparseBooleanArray cis, T[] items) {
        try {
            if (items == null) {
                return null;
            }
            ArrayList<T> al = new ArrayList<T>();
            for (int i = 0; i < cis.size(); ++i) {
                int k;
                if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
                al.add(items[k - 1]);
            }
            return al;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("bitsToNames()'s Exception: " + e));
            return null;
        }
    }

    private final String getGroupName(int gid) {
        switch (gid) {
            case 0: {
                return "root";
            }
            case 1000: {
                return "system";
            }
            case 1001: {
                return "radio";
            }
            case 1002: {
                return "bluetooth";
            }
            case 1003: {
                return "graphics";
            }
            case 1004: {
                return "input";
            }
            case 1005: {
                return "audio";
            }
            case 1006: {
                return "camera";
            }
            case 1007: {
                return "log";
            }
            case 1008: {
                return "compass";
            }
            case 1009: {
                return "mount";
            }
            case 1010: {
                return "wifi";
            }
            case 1011: {
                return "adb";
            }
            case 1012: {
                return "install";
            }
            case 1013: {
                return "media";
            }
            case 1014: {
                return "dhcp";
            }
            case 1015: {
                return "sdcard_rw";
            }
            case 1016: {
                return "vpn";
            }
            case 1017: {
                return "keystore";
            }
            case 1018: {
                return "usb";
            }
            case 1019: {
                return "drm";
            }
            case 1020: {
                return "available";
            }
            case 1021: {
                return "gps";
            }
            case 1023: {
                return "media_rw";
            }
            case 1024: {
                return "mtp";
            }
            case 1025: {
                return "nfc";
            }
            case 1026: {
                return "drmrpc";
            }
            case 2000: {
                return "shell";
            }
            case 2001: {
                return "cache";
            }
            case 2002: {
                return "diag";
            }
            case 3001: {
                return "net_bt_admin";
            }
            case 3002: {
                return "net_bt";
            }
            case 3003: {
                return "inet";
            }
            case 3004: {
                return "net_raw";
            }
            case 3005: {
                return "net_admin";
            }
            case 9998: {
                return "misc";
            }
            case 9999: {
                return "nobody";
            }
        }
        return gid >= 10000 ? "app_" + (gid - 10000) : "?";
    }

    @Override
    public void reqItemsSize(SparseBooleanArray cis) {
        ArrayList<Object> pl = null;
        if (this.pkgInfos == null) {
            pl = new ArrayList(1);
            try {
                pl.add(this.pm.getPackageInfo(this.uri.getAuthority(), 0));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)this.uri.getAuthority(), (Throwable)e);
            }
        } else {
            pl = AppsAdapter.bitsToItems(cis, this.pkgInfos);
        }
        if (pl == null || pl.size() == 0) {
            this.notErr();
            return;
        }
        String cs = ": ";
        StringBuffer sb = new StringBuffer(1024);
        for (int i = 0; i < pl.size(); ++i) {
            try {
                ApplicationInfo ai;
                PackageInfo pi = this.pm.getPackageInfo(((PackageInfo)pl.get((int)i)).packageName, 4352);
                if (pi == null) continue;
                String v = null;
                int vc = 0;
                String size = null;
                String date = null;
                String flags = null;
                String gids = null;
                try {
                    v = pi.versionName;
                    vc = pi.versionCode;
                    if (pi.gids != null && pi.gids.length > 0) {
                        StringBuffer gsb = new StringBuffer(128);
                        for (int gi = 0; gi < pi.gids.length; ++gi) {
                            if (gi > 0) {
                                gsb.append(", ");
                            }
                            int g = pi.gids[gi];
                            gsb.append(g).append("(").append(this.getGroupName(g)).append(")");
                        }
                        gids = gsb.toString();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                sb.append(this.s(2131362188)).append(": ").append(pi.packageName);
                if (v != null) {
                    sb.append("\n").append(this.s(2131362189)).append(": ").append(v);
                }
                if (vc > 0) {
                    sb.append("\n").append(this.s(2131362190)).append(": ").append(vc);
                }
                if ((ai = pi.applicationInfo) != null) {
                    File asdf = new File(ai.sourceDir);
                    date = this.getLocalDateTimeStr(new Date(asdf.lastModified()));
                    size = Utils.getHumanSize(asdf.length());
                    StringBuffer fsb = new StringBuffer(512);
                    int ff = ai.flags;
                    for (int fi = 0; fi < this.flagsStrs.length; ++fi) {
                        if ((1 << fi & ff) == 0) continue;
                        if (fsb.length() > 0) {
                            fsb.append(" | ");
                        }
                        fsb.append(this.flagsStrs[fi]);
                    }
                    fsb.append(" (").append(Integer.toHexString(ff)).append(")");
                    flags = fsb.toString();
                    sb.append("\n").append(this.s(2131362191)).append(": ").append(ai.targetSdkVersion);
                    sb.append("\n").append("UID").append(": ").append(ai.uid);
                    if (gids != null) {
                        sb.append("\n").append("GIDs").append(": ").append(gids);
                    }
                    sb.append("\n").append(this.s(2131361805)).append(": ").append(ai.sourceDir);
                    if (date != null) {
                        sb.append("\n").append(this.s(2131362192)).append(": ").append(date);
                    }
                    if (size != null) {
                        sb.append("\n").append(this.s(2131362193)).append(": ").append(size);
                    }
                    sb.append("\n").append(this.s(2131362194)).append(": ").append(ai.processName);
                    if (ai.className != null) {
                        sb.append("\n").append(this.s(2131362195)).append(": ").append(ai.className);
                    }
                    if (ai.taskAffinity != null) {
                        sb.append("\n").append(this.s(2131362196)).append(": ").append(ai.taskAffinity);
                    }
                }
                StringBuffer psb = new StringBuffer(512);
                if (pi.requestedPermissions != null) {
                    for (int rpi = 0; rpi < pi.requestedPermissions.length; ++rpi) {
                        String p;
                        if (rpi > 0) {
                            psb.append(", ");
                        }
                        if ((p = pi.requestedPermissions[rpi]).startsWith("android.permission.")) {
                            p = p.substring(19);
                        }
                        psb.append(p);
                    }
                }
                if (pi.permissions != null) {
                    psb.append("\nDeclared:\n");
                    for (int dpi = 0; dpi < pi.permissions.length; ++dpi) {
                        if (dpi > 0) {
                            psb.append(", ");
                        }
                        psb.append(pi.permissions[dpi].toString());
                    }
                }
                if (psb.length() > 0) {
                    sb.append("\n").append(this.s(2131362197)).append(": ").append(psb.toString());
                }
                if (flags != null) {
                    sb.append("\n\n").append(this.s(2131362198)).append(": ").append(flags);
                }
                sb.append("\n");
                if (pi.signatures == null) continue;
                sb.append("\nSignatures:\n");
                for (int si = 0; si < pi.signatures.length; ++si) {
                    if (si > 0) {
                        sb.append(", ");
                    }
                    sb.append(pi.signatures[si].toCharsString());
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.notify(sb.toString(), -3, 870);
    }

    @Override
    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        ArrayList<CommanderAdapter.Item> il;
        if (this.pkgInfos != null) {
            ArrayList<PackageInfo> pl = AppsAdapter.bitsToItems(cis, this.pkgInfos);
            if (pl == null || pl.size() == 0) {
                this.notify(this.s(2131361955), -2);
                return false;
            }
            this.notify(-1);
            this.commander.startEngine(new CopyFromEngine(pl, to.getReceiver()));
            return true;
        }
        if (this.compItems != null && (il = AppsAdapter.bitsToItems(cis, this.compItems)) != null) {
            for (int i = 0; i < il.size(); ++i) {
                if (!"Manifest".equals(il.get((int)i).name)) continue;
                try {
                    String tmp_fn;
                    FileOutputStream fos;
                    String m;
                    ApplicationInfo ai = this.pm.getApplicationInfo(this.uri.getAuthority(), 0);
                    if (this.manUtl == null) {
                        this.manUtl = new MnfUtils(this.pm, ai.packageName);
                    }
                    if ((m = this.manUtl.extractManifest()) != null && m.length() > 0 && (fos = this.ctx.openFileOutput(tmp_fn = ai.packageName + ".xml", 3)) != null) {
                        OutputStreamWriter osw = new OutputStreamWriter(fos);
                        osw.write(m);
                        osw.close();
                        String[] paths = new String[]{this.ctx.getFileStreamPath(tmp_fn).getAbsolutePath()};
                        boolean ok = to.receiveItems(paths, 0);
                        if (!ok) {
                            this.notify(-2);
                        }
                        return ok;
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.notErr();
    }

    @Override
    public boolean createFile(String fileURI) {
        return this.notErr();
    }

    @Override
    public void createFolder(String new_name) {
        this.notErr();
    }

    @Override
    public boolean deleteItems(SparseBooleanArray cis) {
        if (this.pkgInfos == null) {
            return this.notErr();
        }
        ArrayList<PackageInfo> al = AppsAdapter.bitsToItems(cis, this.pkgInfos);
        if (al == null) {
            return false;
        }
        for (int i = 0; i < al.size(); ++i) {
            Intent in = new Intent("android.intent.action.DELETE", Uri.parse((String)("package:" + al.get((int)i).packageName)));
            this.commander.issue(in, 0);
        }
        return true;
    }

    @Override
    public boolean receiveItems(String[] full_names, int move_mode) {
        return this.notErr();
    }

    @Override
    public boolean renameItem(int position, String newName, boolean c) {
        return this.notErr();
    }

    @Override
    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        try {
            if (acmi.position > 0) {
                if (this.pkgInfos != null) {
                    ApplicationInfo ai = this.pkgInfos[acmi.position - 1].applicationInfo;
                    if (ai != null) {
                        String name = ai.loadLabel(this.pm).toString();
                        menu2.add(0, 9176, 0, (CharSequence)(this.ctx.getString(2131361937) + " \"" + name + "\""));
                    }
                    menu2.add(0, 7161, 0, (CharSequence)this.MANAGE);
                    menu2.add(0, 236, 0, 2131361895);
                } else if (this.resInfos != null) {
                    ResolveInfo ri = this.resInfos[acmi.position - 1];
                    if (ri.filter != null && ri.filter.matchAction("android.intent.action.MAIN")) {
                        menu2.add(0, 3123, 0, (CharSequence)this.ctx.getString(2131361864));
                    }
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, null, (Throwable)e);
        }
        super.populateContextMenu(menu2, acmi, num);
    }

    @Override
    public void doIt(int command_id, SparseBooleanArray cis) {
        try {
            if (this.pkgInfos != null) {
                ArrayList<PackageInfo> pl = AppsAdapter.bitsToItems(cis, this.pkgInfos);
                if (pl == null || pl.size() == 0) {
                    return;
                }
                ApplicationInfo ai = pl.get((int)0).applicationInfo;
                if (ai == null) {
                    return;
                }
                if (7161 == command_id) {
                    this.managePackage(ai.packageName);
                    return;
                }
                if (9176 == command_id) {
                    Intent in = this.pm.getLaunchIntentForPackage(ai.packageName);
                    this.commander.issue(in, 0);
                    return;
                }
            } else if (this.resInfos != null && 3123 == command_id) {
                ArrayList<ResolveInfo> rl = AppsAdapter.bitsToItems(cis, this.resInfos);
                if (rl == null || rl.size() == 0) {
                    return;
                }
                for (int i = 0; i < rl.size(); ++i) {
                    ActivityInfo ai = rl.get((int)i).activityInfo;
                    if (ai == null) continue;
                    Bitmap ico = null;
                    Drawable drawable2 = ai.loadIcon(this.pm);
                    if (drawable2 instanceof BitmapDrawable) {
                        BitmapDrawable bd = (BitmapDrawable)drawable2;
                        ico = bd.getBitmap();
                    }
                    this.createDesktopShortcut(new ComponentName(ai.applicationInfo.packageName, ai.name), ai.loadLabel(this.pm).toString(), ico);
                }
                return;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Can't do the command " + command_id), (Throwable)e);
        }
    }

    @Override
    public void openItem(int position) {
        try {
            if (this.pkgInfos != null) {
                if (position == 0) {
                    this.commander.Navigate(Uri.parse((String)"home:"), null, null);
                } else if (position <= this.pkgInfos.length) {
                    PackageInfo pi = this.pkgInfos[position - 1];
                    this.commander.Navigate(this.uri.buildUpon().authority(pi.packageName).build(), null, null);
                }
            } else if (this.actInfos != null) {
                if (position == 0) {
                    this.commander.Navigate(this.uri.buildUpon().path(null).build(), null, "Activities");
                } else if (position <= this.actInfos.length) {
                    ActivityInfo act = this.actInfos[position - 1];
                    if (act.exported) {
                        this.commander.Navigate(this.uri.buildUpon().appendPath(act.name).build(), null, null);
                    } else {
                        this.commander.showInfo(this.s(2131362199));
                    }
                }
            } else if (this.prvInfos != null || this.srvInfos != null) {
                if (position == 0) {
                    this.commander.Navigate(this.uri.buildUpon().path(null).build(), null, "Providers");
                } else if (position <= this.prvInfos.length) {
                    // empty if block
                }
            } else if (this.resInfos != null) {
                if (position == 0) {
                    List paths = this.uri.getPathSegments();
                    if (paths == null) {
                        this.commander.Navigate(this.uri.buildUpon().path(null).build(), null, null);
                    }
                    String p = paths.size() > 1 ? (String)paths.get(paths.size() - 2) : null;
                    String n = (String)paths.get(paths.size() - 1);
                    this.commander.Navigate(this.uri.buildUpon().path(p).build(), null, n);
                } else if (position <= this.resInfos.length) {
                    ResolveInfo ri = this.resInfos[position - 1];
                    ActivityInfo ai = ri.activityInfo;
                    if (ri.filter.hasAction("android.intent.action.CREATE_SHORTCUT")) {
                        Intent in = new Intent("android.intent.action.CREATE_SHORTCUT");
                        in.setComponent(new ComponentName(ai.packageName, ai.name));
                        this.commander.issue(in, 2131230755);
                    } else if (ri.filter.hasAction("android.intent.action.MAIN")) {
                        Intent in = new Intent("android.intent.action.MAIN");
                        in.setComponent(new ComponentName(ai.packageName, ai.name));
                        this.commander.issue(in, 0);
                    }
                }
            } else if (this.intFilters != null) {
                if (position == 0) {
                    List paths = this.uri.getPathSegments();
                    if (paths == null) {
                        this.commander.Navigate(this.uri.buildUpon().path(null).build(), null, null);
                    }
                    String p = paths.size() > 1 ? (String)paths.get(paths.size() - 2) : null;
                    String n = (String)paths.get(paths.size() - 1);
                    this.commander.Navigate(this.uri.buildUpon().path(p).build(), null, n);
                }
            } else {
                if (position == 0) {
                    this.commander.Navigate(Uri.parse((String)DEFAULT_LOC), null, this.uri.getAuthority());
                    return;
                }
                String name = this.getItemName(position, false);
                if (this.MANAGE.equals(name)) {
                    this.managePackage(this.uri.getAuthority());
                } else if ("Manifest".equals(name)) {
                    String m;
                    String a = this.uri.getAuthority();
                    ApplicationInfo ai = this.pm.getApplicationInfo(a, 0);
                    if (this.manUtl == null) {
                        this.manUtl = new MnfUtils(this.pm, a);
                    }
                    if ((m = this.manUtl.extractManifest()) != null) {
                        Intent in = new Intent(this.ctx, TextViewer.class);
                        in.setData(Uri.parse((String)"string:"));
                        in.putExtra("string", m);
                        this.commander.issue(in, 0);
                    }
                } else {
                    this.commander.Navigate(this.uri.buildUpon().path(name).build(), null, null);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)(this.uri.toString() + " " + position), (Throwable)e);
        }
    }

    private final void managePackage(String p) {
        try {
            Intent in = new Intent("android.intent.action.VIEW");
            in.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            in.putExtra("com.android.settings.ApplicationPkgName", p);
            in.putExtra("pkg", p);
            List acts = this.pm.queryIntentActivities(in, 0);
            if (acts.size() > 0) {
                this.commander.issue(in, 0);
            } else {
                in = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)p, null));
                acts = this.pm.queryIntentActivities(in, 0);
                if (acts.size() > 0) {
                    this.commander.issue(in, 0);
                } else {
                    Log.e((String)TAG, (String)"Failed to resolve activity for InstalledAppDetails");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getItemName(int position, boolean full) {
        if (position < 0) {
            return null;
        }
        if (position == 0) {
            return this.parentLink;
        }
        try {
            int idx = position - 1;
            if (this.pkgInfos != null) {
                return position <= this.pkgInfos.length ? this.pkgInfos[idx].packageName : null;
            }
            if (this.compItems != null) {
                return position <= this.compItems.length ? this.compItems[idx].name : null;
            }
            if (this.actInfos != null) {
                return position <= this.actInfos.length ? this.actInfos[idx].name : null;
            }
            if (this.prvInfos != null) {
                return position <= this.prvInfos.length ? this.prvInfos[idx].toString() : null;
            }
            if (this.srvInfos != null) {
                return position <= this.srvInfos.length ? this.srvInfos[idx].toString() : null;
            }
            if (this.resInfos != null) {
                return position <= this.resInfos.length ? this.resInfos[idx].toString() : null;
            }
            if (this.intFilters != null) {
                return position <= this.intFilters.length ? this.intFilters[idx].toString() : null;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("pos=" + position), (Throwable)e);
        }
        return null;
    }

    public Object getItem(int position) {
        CommanderAdapter.Item item = new CommanderAdapter.Item();
        if (position == 0) {
            item.name = this.parentLink;
            item.dir = true;
            return item;
        }
        item.name = "???";
        if (this.pkgInfos != null) {
            if (position >= 0 && position <= this.pkgInfos.length) {
                PackageInfo pi = this.pkgInfos[position - 1];
                ApplicationInfo ai = pi.applicationInfo;
                item.dir = false;
                item.name = ai != null ? ai.loadLabel(this.pm).toString() : pi.packageName;
                item.sel = false;
                File asdf = new File(ai.sourceDir);
                item.date = new Date(asdf.lastModified());
                item.size = asdf.length();
                if (ai != null) {
                    item.attr = ai.packageName;
                }
                item.setIcon(ai.loadIcon(this.pm));
                item.origin = new File(ai.sourceDir);
            }
        } else if (this.actInfos != null) {
            if (position <= this.actInfos.length) {
                ActivityInfo ai = this.actInfos[position - 1];
                item.name = ai.loadLabel(this.pm).toString();
                if (!ai.exported) {
                    item.name = item.name + " - private";
                }
                item.attr = ai.name;
                item.setIcon(ai.loadIcon(this.pm));
            }
        } else if (this.prvInfos != null) {
            if (position <= this.prvInfos.length) {
                ProviderInfo pi = this.prvInfos[position - 1];
                item.name = pi.loadLabel(this.pm).toString();
                item.attr = pi.name;
                item.setIcon(pi.loadIcon(this.pm));
            }
        } else if (this.srvInfos != null) {
            if (position <= this.srvInfos.length) {
                ServiceInfo si = this.srvInfos[position - 1];
                item.name = si.loadLabel(this.pm).toString();
                item.attr = si.name;
                item.setIcon(si.loadIcon(this.pm));
            }
        } else if (this.resInfos != null) {
            try {
                if (position <= this.resInfos.length) {
                    ResolveInfo ri = this.resInfos[position - 1];
                    IntentFilter inf = ri.filter;
                    if (inf != null) {
                        ActivityInfo ai = ri.activityInfo;
                        item.name = ai.loadLabel(this.pm).toString();
                        item.attr = ai.name;
                        item.setIcon(ai.loadIcon(this.pm));
                        if (ri.filter.hasAction("android.intent.action.CREATE_SHORTCUT")) {
                            item.name = item.name + " - CREATE_SHORTCUT";
                        }
                        if (ri.filter.hasAction("android.intent.action.MAIN")) {
                            item.name = item.name + " - MAIN";
                        }
                    } else {
                        item.name = ri.loadLabel(this.pm).toString();
                        item.attr = ri.toString();
                    }
                    item.setIcon(ri.loadIcon(this.pm));
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("pos=" + position), (Throwable)e);
            }
        } else if (this.intFilters != null) {
            if (position <= this.intFilters.length) {
                int i;
                IntentFilter inf = this.intFilters[position - 1];
                String action = inf.getAction(0);
                item.name = action != null ? action : inf.toString();
                StringBuilder sb = new StringBuilder(128);
                int n = inf.countDataTypes();
                if (n > 0) {
                    sb.append("types=");
                    for (i = 0; i < n; ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        String dt = inf.getDataType(i);
                        sb.append(dt);
                    }
                    sb.append("; ");
                }
                if ((n = inf.countCategories()) > 0) {
                    sb.append("categories=");
                    for (i = 0; i < n; ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        String ct = inf.getCategory(i);
                        sb.append(ct);
                    }
                    sb.append("; ");
                }
                if ((n = inf.countDataSchemes()) > 0) {
                    sb.append("schemes=");
                    for (i = 0; i < n; ++i) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        String ds = inf.getDataScheme(i);
                        sb.append(ds);
                    }
                }
                item.attr = sb.toString();
            }
        } else if (position <= this.compItems.length) {
            return this.compItems[position - 1];
        }
        return item;
    }

    @Override
    protected int getPredictedAttributesLength() {
        return 36;
    }

    private final void createDesktopShortcut(ComponentName cn, String name, Bitmap ico) {
        Intent shortcutIntent = new Intent();
        shortcutIntent.setComponent(cn);
        shortcutIntent.setData(this.uri);
        Intent intent = new Intent();
        intent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)shortcutIntent);
        intent.putExtra("android.intent.extra.shortcut.NAME", name);
        if (ico != null) {
            intent.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)ico);
        }
        intent.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
        this.ctx.sendBroadcast(intent);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActivityInfoComparator
    implements Comparator<ActivityInfo> {
        private int type;
        private boolean ascending;
        public final PackageManager pm_;

        public ActivityInfoComparator(int type_, boolean case_ignore_, boolean ascending_) {
            this.pm_ = AppsAdapter.this.pm;
            this.type = type_;
            this.ascending = ascending_;
        }

        @Override
        public int compare(ActivityInfo ai1, ActivityInfo ai2) {
            int ext_cmp = 0;
            try {
                switch (this.type) {
                    case 48: {
                        if (ai1.packageName == null) break;
                        ext_cmp = ai1.name.compareTo(ai2.name);
                    }
                }
                if (ext_cmp == 0) {
                    String cn1 = ai1.loadLabel(this.pm_).toString();
                    String cn2 = ai2.loadLabel(this.pm_).toString();
                    ext_cmp = cn1.compareTo(cn2);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return this.ascending ? ext_cmp : -ext_cmp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PackageInfoComparator
    implements Comparator<PackageInfo> {
        int type;
        boolean ascending;
        ApplicationInfo.DisplayNameComparator aidnc;

        public PackageInfoComparator(int type_, boolean case_ignore_, boolean ascending_) {
            this.aidnc = new ApplicationInfo.DisplayNameComparator(AppsAdapter.this.pm);
            this.type = type_;
            this.ascending = ascending_;
        }

        @Override
        public int compare(PackageInfo pi1, PackageInfo pi2) {
            int ext_cmp = 0;
            try {
                switch (this.type) {
                    case 48: {
                        if (pi1.packageName == null) break;
                        ext_cmp = pi1.packageName.compareTo(pi2.packageName);
                        break;
                    }
                    case 16: {
                        File asdf1 = new File(pi1.applicationInfo.sourceDir);
                        File asdf2 = new File(pi2.applicationInfo.sourceDir);
                        ext_cmp = asdf1.length() - asdf2.length() < 0L ? -1 : 1;
                        break;
                    }
                    case 32: {
                        File asdf1 = new File(pi1.applicationInfo.sourceDir);
                        File asdf2 = new File(pi2.applicationInfo.sourceDir);
                        int n = ext_cmp = asdf1.lastModified() - asdf2.lastModified() < 0L ? -1 : 1;
                    }
                }
                if (ext_cmp == 0) {
                    ext_cmp = this.aidnc.compare(pi1.applicationInfo, pi2.applicationInfo);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return this.ascending ? ext_cmp : -ext_cmp;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CopyFromEngine
    extends Engine {
        private ArrayList<PackageInfo> pl;

        CopyFromEngine(ArrayList<PackageInfo> list_, Engines.IReciever recipient_) {
            super(recipient_);
            this.pl = list_;
        }

        @Override
        public void run() {
            String tmp_path = Utils.mbAddSl(AppsAdapter.this.createTempDir());
            for (int i = 0; i < this.pl.size(); ++i) {
                ApplicationInfo ai = this.pl.get((int)i).applicationInfo;
                if (ai == null) continue;
                try {
                    PackageInfo pi = AppsAdapter.this.pm.getPackageInfo(this.pl.get((int)i).packageName, 4352);
                    String tmp_n = tmp_path + pi.packageName + "_" + pi.versionName + ".apk";
                    FileInputStream fis = new FileInputStream(ai.sourceDir);
                    FileOutputStream fos = new FileOutputStream(tmp_n);
                    Utils.copyBytes(fis, fos);
                    continue;
                }
                catch (Exception e) {
                    Log.e((String)this.TAG, (String)"tmp apk creation", (Throwable)e);
                }
            }
            this.sendReceiveReq(new File(tmp_path));
        }
    }

    class ListEngine
    extends Engine {
        private PackageInfo[] items_tmp;
        public String pass_back_on_done;

        ListEngine(Handler h, String pass_back_on_done_) {
            super.setHandler(h);
            this.pass_back_on_done = pass_back_on_done_;
        }

        public PackageInfo[] getItems() {
            return this.items_tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                AppsAdapter.this.Init(null);
                List all_packages = AppsAdapter.this.pm.getInstalledPackages(0);
                this.items_tmp = new PackageInfo[all_packages.size()];
                all_packages.toArray(this.items_tmp);
                Arrays.sort(this.items_tmp, new PackageInfoComparator(AppsAdapter.this.mode & 0x30, (AppsAdapter.this.mode & 0x80) != 0, AppsAdapter.this.ascending));
                this.sendProgress(null, -3, this.pass_back_on_done);
            }
            catch (Exception e) {
                this.sendProgress("Fail", -2, this.pass_back_on_done);
            }
            catch (OutOfMemoryError err) {
                this.sendProgress("Out Of Memory", -2, this.pass_back_on_done);
            }
            finally {
                super.run();
            }
        }
    }
}

