/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.ItemComparator;
import com.ghostsq.commander.adapters.ThumbnailsThread;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

@TargetApi(value=11)
public class ContentAdapter
extends CommanderAdapterBase
implements Engines.IReciever {
    private static final String TAG = "ContentAdapter";
    public static final String SCHEME = "content:";
    public static final int FILES = Utils.mbAddSl(MediaStore.Files.getContentUri((String)"external").getPath()).hashCode();
    public static final int AUDIO = Utils.mbAddSl(MediaStore.Audio.Media.EXTERNAL_CONTENT_URI.getPath()).hashCode();
    public static final int ALBUMS = Utils.mbAddSl(MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI.getPath()).hashCode();
    public static final int ARTISTS;
    public static final int GENRES;
    public static final int PLAYLISTS;
    public static final int VIDEO;
    public static final int IMAGES;
    private static final int[] parent_types;
    private int content_type;
    private Uri content_uri;
    protected CommanderAdapter.Item[] items = null;
    private ThumbnailsThread tht = null;

    public ContentAdapter(Context ctx_) {
        super(ctx_);
    }

    public String getScheme() {
        return "content";
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case LOCAL: 
            case F8: {
                return true;
            }
            case SEND: 
            case FS: 
            case F2: 
            case F6: {
                return false;
            }
        }
        return super.hasFeature(feature);
    }

    public String toString() {
        return this.getUri().toString();
    }

    public int setMode(int mask, int val) {
        if ((mask & 1) == 0) {
            super.setMode(mask, val);
        }
        return this.mode;
    }

    public Uri getUri() {
        return this.content_uri;
    }

    public void setUri(Uri uri) {
        this.content_uri = uri;
        this.content_type = ContentAdapter.getType(uri);
    }

    public static final void populateHomeContextMenu(Context ctx, ContextMenu menu2) {
        String vs = ctx.getString(2131361939);
        menu2.add(0, ALBUMS, 0, (CharSequence)(vs + " \"Albums\""));
        menu2.add(0, ARTISTS, 0, (CharSequence)(vs + " \"Artists\""));
        menu2.add(0, GENRES, 0, (CharSequence)(vs + " \"Genres\""));
        menu2.add(0, PLAYLISTS, 0, (CharSequence)(vs + " \"Playlists\""));
    }

    public static final int getType(Uri uri) {
        if (uri == null) {
            return -1;
        }
        return Utils.mbAddSl(uri.getPath()).hashCode();
    }

    public static final Uri getUri(int id2) {
        if (id2 == FILES) {
            return MediaStore.Files.getContentUri((String)"external");
        }
        if (id2 == AUDIO) {
            return MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
        }
        if (id2 == ALBUMS) {
            return MediaStore.Audio.Albums.EXTERNAL_CONTENT_URI;
        }
        if (id2 == ARTISTS) {
            return MediaStore.Audio.Artists.EXTERNAL_CONTENT_URI;
        }
        if (id2 == GENRES) {
            return MediaStore.Audio.Genres.EXTERNAL_CONTENT_URI;
        }
        if (id2 == PLAYLISTS) {
            return MediaStore.Audio.Playlists.EXTERNAL_CONTENT_URI;
        }
        if (id2 == VIDEO) {
            return MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
        }
        if (id2 == IMAGES) {
            return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
        }
        return null;
    }

    public static final int getIconId(int id2) {
        if (id2 == AUDIO) {
            return 2130837508;
        }
        if (id2 == VIDEO) {
            return 2130837544;
        }
        if (id2 == IMAGES) {
            return 2130837525;
        }
        return 2130837541;
    }

    private static final String[] getProjection(int id2) {
        if (id2 == ALBUMS) {
            return new String[]{"_id", "album", "numsongs", "artist"};
        }
        if (id2 == ARTISTS) {
            return new String[]{"_id", "artist", "number_of_tracks", "number_of_albums"};
        }
        if (id2 == GENRES) {
            return new String[]{"_id", "name"};
        }
        if (id2 == PLAYLISTS) {
            return new String[]{"_id", "name"};
        }
        return new String[]{"_id", "title", "_data", "date_modified", "_size"};
    }

    private static final String getQueryParamName(int id2) {
        if (id2 == ALBUMS) {
            return "album";
        }
        if (id2 == GENRES) {
            return "genre";
        }
        if (id2 == ARTISTS) {
            return "artist";
        }
        if (id2 == PLAYLISTS) {
            return "playlist";
        }
        return null;
    }

    private final String getField(int id2) {
        if (id2 == this.content_type) {
            return "_id";
        }
        if (id2 == ALBUMS) {
            return "album_id";
        }
        if (id2 == GENRES) {
            return "genre_id";
        }
        if (id2 == ARTISTS) {
            return "artist_id";
        }
        if (id2 == PLAYLISTS) {
            return "playlist_id";
        }
        return null;
    }

    public boolean readSource(Uri new_uri, String pass_back_on_done) {
        try {
            if (new_uri != null) {
                this.setUri(new_uri);
            } else if (this.content_uri == null) {
                return false;
            }
            String[] projection = ContentAdapter.getProjection(this.content_type);
            ContentResolver cr = this.ctx.getContentResolver();
            if (cr == null) {
                return false;
            }
            StringBuilder sb = new StringBuilder();
            ArrayList<String> sp = new ArrayList<String>();
            for (int i = 0; i < parent_types.length; ++i) {
                String parent_id = this.content_uri.getQueryParameter(ContentAdapter.getQueryParamName(parent_types[i]));
                if (parent_id == null) continue;
                if (sb.length() > 0) {
                    sb.append(" and ");
                }
                sb.append(this.getField(parent_types[i]) + " = ? ");
                sp.add(parent_id);
            }
            Cursor cursor = cr.query(this.content_uri, projection, sb.length() > 0 ? sb.toString() : null, sp.size() > 0 ? sp.toArray(new String[sp.size()]) : null, null);
            if (cursor != null) {
                try {
                    if (cursor.getCount() > 0) {
                        cursor.moveToFirst();
                        ArrayList<CommanderAdapter.Item> tmp_list = new ArrayList<CommanderAdapter.Item>();
                        int icon_id = ContentAdapter.getIconId(this.content_type);
                        int pci = cursor.getColumnIndex("_data");
                        int sci = cursor.getColumnIndex("_size");
                        int dci = cursor.getColumnIndex("date_modified");
                        do {
                            CommanderAdapter.Item item = new CommanderAdapter.Item();
                            Uri item_uri = this.content_uri.buildUpon().appendEncodedPath("" + cursor.getLong(0)).build();
                            item.origin = item_uri;
                            item.name = cursor.getString(1);
                            if (item.name == null) {
                                Log.e((String)TAG, (String)("Item " + item_uri + " has no name"));
                                item.name = "(?)";
                            }
                            boolean bl = item.dir = this.content_type == ALBUMS || this.content_type == ARTISTS || this.content_type == GENRES;
                            if ("title".equals(projection[1])) {
                                item.attr = cursor.getString(pci);
                                item.size = cursor.getLong(sci);
                                item.date = new Date(cursor.getLong(dci) * 1000L);
                                File f = new File(item.attr);
                                if (!f.exists()) {
                                    item.colorCache = -65536;
                                    item.icon_id = 2130837509;
                                } else {
                                    item.icon_id = icon_id;
                                }
                            }
                            tmp_list.add(item);
                        } while (cursor.moveToNext());
                        cursor.close();
                        this.items = new CommanderAdapter.Item[tmp_list.size()];
                        tmp_list.toArray(this.items);
                        this.reSort(this.items);
                    } else {
                        this.items = new CommanderAdapter.Item[0];
                    }
                    super.setCount(this.items.length);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)"inner", (Throwable)e);
                }
            }
            this.notify(pass_back_on_done);
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"outer", (Throwable)e);
            this.notify(e.getMessage(), -2);
        }
        catch (OutOfMemoryError err) {
            Log.e((String)TAG, (String)"Out Of Memory", (Throwable)err);
            this.notify(this.s(2131361991), -2);
        }
        return false;
    }

    protected void reSort() {
        this.reSort(this.items);
    }

    public void reSort(CommanderAdapter.Item[] items_) {
        if (items_ == null) {
            return;
        }
        ItemComparator comp = new ItemComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Arrays.sort(items_, comp);
    }

    public void openItem(int position) {
        if (position == 0) {
            for (int i = 0; i < parent_types.length; ++i) {
                String parent_id = this.content_uri.getQueryParameter(ContentAdapter.getQueryParamName(parent_types[i]));
                if (parent_id == null) continue;
                this.commander.Navigate(ContentAdapter.getUri(parent_types[i]), null, null);
                return;
            }
            this.commander.Navigate(Uri.parse((String)"home:"), null, null);
            return;
        }
        CommanderAdapter.Item item = this.items[position - 1];
        if (item.dir) {
            String qp = ContentAdapter.getQueryParamName(this.content_type);
            if (qp == null) {
                return;
            }
            List ups = ((Uri)item.origin).getPathSegments();
            if (ups == null || ups.size() == 0) {
                return;
            }
            String ctr_id = (String)ups.get(ups.size() - 1);
            Uri.Builder bld = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI.buildUpon();
            bld.encodedQuery(qp + "=" + ctr_id);
            this.commander.Navigate(bld.build(), null, null);
        }
    }

    public Uri getItemUri(int position) {
        try {
            String item_name = this.getItemName(position, true);
            return Uri.parse((String)(SCHEME + Utils.escapePath(item_name)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getItemName(int position, boolean full) {
        if (position < 0 || this.items == null || position > this.items.length) {
            return position == 0 ? this.parentLink : null;
        }
        if (full) {
            String dirName = Utils.mbAddSl(this.content_uri.getPath());
            return position == 0 ? new File(dirName).getParent() : dirName + this.items[position - 1].name;
        }
        if (position == 0) {
            return this.parentLink;
        }
        String name = this.items[position - 1].name;
        if (name != null) {
            return name.replace("/", "");
        }
        return null;
    }

    public void reqItemsSize(SparseBooleanArray cis) {
    }

    public boolean renameItem(int position, String newName, boolean copy) {
        if (position <= 0 || position > this.items.length) {
            return false;
        }
        try {
            ContentResolver cr = this.ctx.getContentResolver();
            ContentValues cv = new ContentValues();
            CommanderAdapter.Item item = this.items[position - 1];
            return 1 == cr.update((Uri)item.origin, cv, null, null);
        }
        catch (Exception e) {
            this.commander.showError(this.ctx.getString(2131361996, new Object[]{e.getMessage()}));
            return false;
        }
    }

    public CommanderAdapter.Item getItem(Uri u) {
        try {
            if (!"ms".equals(u.getScheme())) {
                return null;
            }
            File f = new File(u.getPath());
            if (f.exists()) {
                CommanderAdapter.Item item = new CommanderAdapter.Item(f.getName());
                item.size = f.length();
                item.date = new Date(f.lastModified());
                item.dir = f.isDirectory();
                return item;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream getContent(Uri u, long skip) {
        return null;
    }

    public OutputStream saveContent(Uri u) {
        return null;
    }

    public boolean createFile(String fileURI) {
        return false;
    }

    public void createFolder(String new_name) {
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        try {
            CommanderAdapter.Item[] list = this.bitsToItems(cis);
            if (list != null) {
                this.notify(-1);
                this.commander.startEngine(new DeleteEngine(list));
            }
        }
        catch (Exception e) {
            this.notify(e.getMessage(), -2);
        }
        return false;
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        boolean ok = to.receiveItems(this.bitsToNames(cis), 0);
        if (!ok) {
            this.notify(-2);
            return ok;
        }
        return ok;
    }

    public boolean receiveItems(String[] uris, int move_mode) {
        return false;
    }

    public void prepareToDestroy() {
        super.prepareToDestroy();
        this.items = null;
    }

    public final CommanderAdapter.Item[] bitsToItems(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i) || cis.keyAt(i) <= 0) continue;
                ++counter;
            }
            CommanderAdapter.Item[] res = new CommanderAdapter.Item[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                int k;
                if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
                res[j++] = this.items[k - 1];
            }
            return res;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"bitsToFiles()", (Throwable)e);
            return null;
        }
    }

    protected int getPredictedAttributesLength() {
        return 10;
    }

    public int getCount() {
        if (this.items == null) {
            return 1;
        }
        return this.items.length + 1;
    }

    public Object getItem(int position) {
        CommanderAdapter.Item item = null;
        if (position == 0) {
            item = new CommanderAdapter.Item();
            item.name = this.parentLink;
            item.dir = true;
        } else {
            if (this.items != null && position <= this.items.length) {
                return this.items[position - 1];
            }
            item = new CommanderAdapter.Item();
            item.name = "???";
        }
        return item;
    }

    public Engines.IReciever getReceiver() {
        return this;
    }

    static {
        GENRES = Utils.mbAddSl(MediaStore.Audio.Genres.EXTERNAL_CONTENT_URI.getPath()).hashCode();
        ARTISTS = Utils.mbAddSl(MediaStore.Audio.Artists.EXTERNAL_CONTENT_URI.getPath()).hashCode();
        PLAYLISTS = Utils.mbAddSl(MediaStore.Audio.Playlists.EXTERNAL_CONTENT_URI.getPath()).hashCode();
        IMAGES = Utils.mbAddSl(MediaStore.Images.Media.EXTERNAL_CONTENT_URI.getPath()).hashCode();
        VIDEO = Utils.mbAddSl(MediaStore.Video.Media.EXTERNAL_CONTENT_URI.getPath()).hashCode();
        parent_types = new int[]{ALBUMS, ARTISTS, GENRES, PLAYLISTS};
    }

    class DeleteEngine
    extends Engine {
        private CommanderAdapter.Item[] mList;
        ContentResolver cr;

        DeleteEngine(CommanderAdapter.Item[] list) {
            this.setName(".DeleteEngine");
            this.mList = list;
        }

        public void run() {
            try {
                ContentAdapter.this.Init(null);
                this.cr = ContentAdapter.this.ctx.getContentResolver();
                String dirName = Utils.mbAddSl(ContentAdapter.this.content_uri.getPath());
                int cnt = this.deleteItems(dirName, this.mList);
                this.sendResult(Utils.getOpReport(ContentAdapter.this.ctx, cnt, 2131362006));
            }
            catch (Exception e) {
                this.sendProgress(e.getMessage(), -7);
            }
        }

        private final int deleteItems(String base_path, CommanderAdapter.Item[] l) throws Exception {
            if (l == null) {
                return 0;
            }
            int cnt = 0;
            int num = l.length;
            double conv = 100.0 / (double)num;
            for (int i = 0; i < num; ++i) {
                DeleteEngine.sleep(1L);
                if (this.isStopReq()) {
                    throw new Exception(ContentAdapter.this.s(2131361990));
                }
                CommanderAdapter.Item f = l[i];
                this.sendProgress(ContentAdapter.this.ctx.getString(2131361979, new Object[]{f.name}), (int)((double)cnt * conv));
                Uri c_uri = (Uri)f.origin;
                if (c_uri == null) continue;
                cnt += this.cr.delete(c_uri, null, null);
            }
            return cnt;
        }
    }
}

