/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.util.Log;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TargetApi(value=8)
public class MediaScanEngine
extends Engine
implements MediaScannerConnection.MediaScannerConnectionClient {
    private static final String TAG = "MediaScanEngine";
    private MediaScannerConnection msc;
    private Context ctx;
    private File folder;
    private boolean all = false;
    private FileItem[] to_scan_a;
    private int count = 0;
    private int num = 0;

    public MediaScanEngine(Context ctx, File folder, boolean all) {
        this.ctx = ctx;
        this.folder = folder;
        this.all = all;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.sendProgress("", 0, -1);
        ArrayList<FileItem> to_scan = new ArrayList<FileItem>();
        this.collectFiles(this.folder, to_scan);
        this.num = to_scan.size();
        if (this.num > 0) {
            this.to_scan_a = new FileItem[this.num];
            to_scan.toArray(this.to_scan_a);
            this.msc = new MediaScannerConnection(this.ctx, (MediaScannerConnection.MediaScannerConnectionClient)this);
            this.msc.connect();
            MediaScanEngine mediaScanEngine = this;
            synchronized (mediaScanEngine) {
                while (!this.stop) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        this.stop = true;
                    }
                }
            }
            this.sendReport(this.count + " files were scanned");
        }
    }

    private void collectFiles(File folder, List<FileItem> to_scan) {
        if (folder == null) {
            return;
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return;
        }
        for (File f : files) {
            if (f == null) continue;
            try {
                if (f.isDirectory()) {
                    this.collectFiles(f, to_scan);
                    continue;
                }
                String fn = f.getName();
                if (".nomedia".equals(fn)) continue;
                String ext = Utils.getFileExt(fn);
                String mime = Utils.getMimeByExt(ext);
                if (!this.all && (mime == null || !mime.startsWith("image/") && !mime.startsWith("audio/") && !mime.startsWith("video/"))) continue;
                to_scan.add(new FileItem(f.getAbsolutePath(), mime));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private final boolean scanNextFile() {
        if (this.count < this.num) {
            FileItem fi = this.to_scan_a[this.count++];
            this.msc.scanFile(fi.path, fi.mime);
            return true;
        }
        return false;
    }

    public void onMediaScannerConnected() {
        this.scanNextFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScanCompleted(String path, Uri uri) {
        String rep_path;
        int pl = path.length();
        if (pl < 256) {
            char[] chars = new char[256 - pl];
            Arrays.fill(chars, '\u00a0');
            rep_path = path + new String(chars);
        } else {
            rep_path = path;
        }
        Log.v((String)TAG, (String)("Scan completed: " + path + " " + uri.toString()));
        this.sendProgress(rep_path, this.count * 100 / this.num);
        File f = new File(path);
        if (f.isFile() && f.length() == 0L && this.ctx.getContentResolver().delete(uri, null, null) > 0) {
            Log.w((String)"scanMedia()", (String)("Deleteing " + path));
            f.delete();
        }
        if (this.stop || !this.scanNextFile()) {
            this.msc.disconnect();
            MediaScanEngine mediaScanEngine = this;
            synchronized (mediaScanEngine) {
                this.stop = true;
                this.notify();
            }
            return;
        }
    }

    class FileItem {
        public String path;
        public String mime;

        FileItem(String path, String mime) {
            this.path = path;
            this.mime = mime;
        }
    }
}

