/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.favorites;

import android.net.Uri;
import android.util.Log;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;
import java.util.regex.Pattern;
import org.apache.http.auth.UsernamePasswordCredentials;

public class Favorite {
    private static final String TAG = "Favorite";
    private static String sep = ",";
    private static Pattern sep_re = Pattern.compile(sep);
    private Uri uri;
    private String comment;
    private Credentials credentials;

    public Favorite(Uri u) {
        this.init(u);
    }

    public Favorite(Uri u, Credentials c) {
        if (c == null) {
            this.init(u);
        } else {
            this.uri = Utils.updateUserInfo(u, null);
            this.credentials = c;
        }
    }

    public Favorite(String uri_str, String comment_) {
        try {
            this.init(Uri.parse((String)uri_str));
            this.comment = comment_;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Favorite(String raw2) {
        this.fromString(raw2);
    }

    public void init(Uri u) {
        try {
            this.uri = u;
            String user_info = this.uri.getUserInfo();
            if (user_info != null && user_info.length() > 0) {
                this.credentials = new Credentials(user_info);
                String pw = this.credentials.getPassword();
                if (Credentials.pwScreen.equals(pw)) {
                    this.credentials = new Credentials(this.credentials.getUserName(), this.credentials.getPassword());
                }
                this.uri = Utils.updateUserInfo(this.uri, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean fromString(String raw2) {
        if (raw2 == null) {
            return false;
        }
        try {
            String[] flds = sep_re.split(raw2);
            if (flds == null) {
                return false;
            }
            this.comment = null;
            this.credentials = null;
            String username = null;
            String pass_enc = null;
            for (int i = 0; i < flds.length; ++i) {
                String s = flds[i];
                if (s == null || s.length() == 0) continue;
                if (s.startsWith("URI=")) {
                    this.uri = Uri.parse((String)this.unescape(s.substring(4)));
                    continue;
                }
                if (s.startsWith("CMT=")) {
                    this.comment = this.unescape(s.substring(4));
                    continue;
                }
                if (s.startsWith("CRD=")) {
                    this.credentials = Credentials.createFromEncriptedString(this.unescape(s.substring(4)));
                    continue;
                }
                if (s.startsWith("USER=")) {
                    username = this.unescape(s.substring(5));
                    continue;
                }
                if (!s.startsWith("PASS=")) continue;
                pass_enc = this.unescape(s.substring(5));
            }
            if (username != null && pass_enc != null) {
                this.credentials = new Credentials(username, Credentials.decrypt(pass_enc));
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("can't restore " + raw2), (Throwable)e);
        }
        return true;
    }

    public String toString() {
        try {
            if (this.uri == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer(128);
            buf.append("URI=");
            buf.append(this.escape(this.uri.toString()));
            if (this.comment != null) {
                buf.append(sep);
                buf.append("CMT=");
                buf.append(this.escape(this.comment));
            }
            if (this.credentials != null) {
                buf.append(sep);
                buf.append("CRD=");
                buf.append(this.escape(this.credentials.exportToEncriptedString()));
            }
            return buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String s) {
        this.comment = s;
    }

    public void setUri(Uri u) {
        this.uri = u;
    }

    public Uri getUri() {
        return this.uri;
    }

    public Uri getUriWithAuth() {
        if (this.credentials == null) {
            return this.uri;
        }
        return Utils.getUriWithAuth(this.uri, this.credentials.getUserName(), this.credentials.getPassword());
    }

    public String getUriString(boolean screen_pw) {
        try {
            if (this.uri == null) {
                return null;
            }
            if (this.credentials == null) {
                return this.uri.toString();
            }
            if (screen_pw) {
                return Utils.getUriWithAuth(this.uri, this.credentials.getUserName(), Credentials.pwScreen).toString();
            }
            return this.getUriWithAuth().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean equals(String test) {
        String item = this.getUriString(false);
        if (item != null) {
            String strip_item = item.trim();
            if (strip_item.length() == 0 || strip_item.charAt(strip_item.length() - 1) != '/') {
                strip_item = strip_item + "/";
            }
            if (strip_item.compareTo(test) == 0) {
                return true;
            }
        }
        return false;
    }

    public String getUserName() {
        return this.credentials == null ? null : this.credentials.getUserName();
    }

    public String getPassword() {
        return this.credentials == null ? "" : this.credentials.getPassword();
    }

    public void setCredentials(String un, String pw) {
        if (un == null || un.length() == 0) {
            this.credentials = null;
            return;
        }
        this.credentials = new Credentials(un, pw);
    }

    private String unescape(String s) {
        return s.replace("%2C", sep);
    }

    private String escape(String s) {
        return s.replace(sep, "%2C");
    }

    public static final String screenPwd(String uri_str) {
        if (uri_str == null) {
            return null;
        }
        return Favorite.screenPwd(Uri.parse((String)uri_str));
    }

    public static final String screenPwd(Uri u) {
        if (u == null) {
            return null;
        }
        String ui = u.getUserInfo();
        if (ui == null || ui.length() == 0) {
            return u.toString();
        }
        int pw_pos = ui.indexOf(58);
        if (pw_pos < 0) {
            return u.toString();
        }
        ui = Uri.encode((String)ui.substring(0, pw_pos)) + ":" + Credentials.pwScreen;
        return Utils.updateUserInfo(u, ui).toString();
    }

    public static final boolean isPwdScreened(Uri u) {
        UsernamePasswordCredentials crd;
        String user_info = u.getUserInfo();
        return user_info != null && user_info.length() > 0 && Credentials.pwScreen.equals((crd = new UsernamePasswordCredentials(user_info)).getPassword());
    }

    public final Credentials borrowPassword(Uri stranger_uri) {
        Credentials stranger_crd;
        String stranger_username;
        if (this.credentials == null) {
            return null;
        }
        String stranger_user_info = stranger_uri.getUserInfo();
        String username = this.credentials.getUserName();
        String password = this.credentials.getPassword();
        if (username != null && password != null && stranger_user_info != null && stranger_user_info.length() > 0 && username.equalsIgnoreCase(stranger_username = (stranger_crd = new Credentials(stranger_user_info)).getUserName())) {
            return new Credentials(stranger_username, password);
        }
        return null;
    }

    public static Uri borrowPassword(Uri us, Uri fu) {
        String host;
        String schm = us.getScheme();
        if (schm != null && schm.equals(fu.getScheme()) && (host = us.getHost()) != null && host.equalsIgnoreCase(fu.getHost())) {
            String uis = us.getUserInfo();
            String fui = fu.getUserInfo();
            if (fui != null && fui.length() > 0) {
                Credentials crds = new Credentials(uis);
                Credentials fcrd = new Credentials(fui);
                String un = crds.getUserName();
                if (un != null && un.equals(fcrd.getUserName())) {
                    return Utils.getUriWithAuth(us, un, fcrd.getPassword());
                }
            }
        }
        return null;
    }
}

