/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.favorites;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.ghostsq.commander.Panels;
import com.ghostsq.commander.favorites.Favorite;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.util.ArrayList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Favorites
extends ArrayList<Favorite> {
    private static final long serialVersionUID = 1L;
    private static final String old_sep = ",";
    private static final String sep = ";";
    private final String TAG = this.getClass().getSimpleName();
    private final Context c;

    public Favorites(Context c_) {
        this.c = c_;
    }

    public final void addToFavorites(Uri u, Credentials crd, String comment) {
        this.removeFromFavorites(u);
        if (crd == null && Favorite.isPwdScreened(u)) {
            crd = this.searchForPassword(u);
        }
        Favorite f = new Favorite(u, crd);
        this.add(f);
        if (comment != null) {
            f.setComment(comment);
        }
    }

    public final void removeFromFavorites(Uri u) {
        int pos = this.findIgnoreAuth(u);
        if (pos >= 0) {
            this.remove(pos);
        } else {
            Log.w((String)this.TAG, (String)("Can't find in the list of favs:" + u));
        }
    }

    public final int findIgnoreAuth(Uri u) {
        try {
            if (u != null) {
                u = Utils.addTrailngSlash(Utils.updateUserInfo(u, null));
                for (int i = 0; i < this.size(); ++i) {
                    Favorite f = (Favorite)this.get(i);
                    if (f == null) {
                        Log.e((String)this.TAG, (String)"A fave is null!");
                        continue;
                    }
                    Uri fu = f.getUri();
                    if (fu == null) {
                        Log.e((String)this.TAG, (String)"A fave URI is null!");
                        continue;
                    }
                    if (!(fu = Utils.addTrailngSlash(fu)).equals((Object)u)) continue;
                    return i;
                }
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("Uri: " + Favorite.screenPwd(u)), (Throwable)e);
        }
        return -1;
    }

    public final Credentials searchForPassword(Uri u) {
        try {
            String ui = u.getUserInfo();
            if (ui != null && ui.length() > 0) {
                String user = ui.substring(0, ui.indexOf(58));
                String host = u.getHost();
                String schm = u.getScheme();
                String path = u.getPath();
                if (path == null || path.length() == 0) {
                    path = "/";
                } else {
                    Utils.mbAddSl(path);
                }
                int best = -1;
                for (int i = 0; i < this.size(); ++i) {
                    try {
                        Uri fu;
                        Favorite f = (Favorite)this.get(i);
                        if (!user.equalsIgnoreCase(f.getUserName()) || !schm.equals((fu = f.getUri()).getScheme()) || !host.equalsIgnoreCase(fu.getHost())) continue;
                        best = i;
                        String fp = fu.getPath();
                        if (fp == null || path.length() == 0) {
                            fp = "/";
                        } else {
                            Utils.mbAddSl(fp);
                        }
                        if (!path.equalsIgnoreCase(fp)) continue;
                        break;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (best >= 0) {
                    Favorite f = (Favorite)this.get(best);
                    return f.borrowPassword(u);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.w((String)this.TAG, (String)"Faild to find a suitable Favorite with password!!!");
        return null;
    }

    public final String getAsString() {
        int sz = this.size();
        String[] a = new String[sz];
        for (int i = 0; i < sz; ++i) {
            String fav_str = ((Favorite)this.get(i)).toString();
            if (fav_str == null) continue;
            a[i] = this.escape(fav_str);
        }
        String s = Utils.join(a, sep);
        return s;
    }

    public final void setFromOldString(String stored) {
        try {
            if (stored != null && stored.length() != 0) {
                this.clear();
                String use_sep = old_sep;
                String[] favs = stored.split(use_sep);
                for (int i = 0; i < favs.length; ++i) {
                    if (favs[i] == null || favs[i].length() <= 0) continue;
                    this.add(new Favorite(favs[i], null));
                }
            }
            if (this.isEmpty()) {
                this.add(new Favorite("home:", this.c.getString(2131361828)));
                this.add(new Favorite(Panels.DEFAULT_LOC, this.c.getString(2131361906)));
                if (Build.VERSION.SDK_INT >= 8) {
                    this.add(new Favorite(ForwardCompat.getPath(ForwardCompat.PubPathType.DOWNLOADS), "Downloads"));
                    this.add(new Favorite(ForwardCompat.getPath(ForwardCompat.PubPathType.DCIM), "Camera"));
                    this.add(new Favorite(ForwardCompat.getPath(ForwardCompat.PubPathType.PICTURES), "Pictures"));
                    this.add(new Favorite(ForwardCompat.getPath(ForwardCompat.PubPathType.MUSIC), "Music"));
                    this.add(new Favorite(ForwardCompat.getPath(ForwardCompat.PubPathType.MOVIES), "Movies"));
                }
            }
        }
        catch (Throwable e) {
            Log.e((String)this.TAG, null, (Throwable)e);
        }
    }

    public final void setFromString(String stored) {
        if (stored == null) {
            return;
        }
        this.clear();
        String use_sep = sep;
        String[] favs = stored.split(use_sep);
        try {
            for (int i = 0; i < favs.length; ++i) {
                String stored_fav = this.unescape(favs[i]);
                this.add(new Favorite(stored_fav));
            }
        }
        catch (NoSuchElementException e) {
            Log.e((String)this.TAG, null, (Throwable)e);
        }
        if (this.isEmpty()) {
            this.add(new Favorite("home:", this.c.getString(2131361828)));
        }
    }

    private final String unescape(String s) {
        return s.replace("%3B", sep);
    }

    private final String escape(String s) {
        return s.replace(sep, "%3B");
    }
}

