/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.root;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.ghostsq.commander.root.ExecEngine;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;

class MountsListEngine
extends ExecEngine {
    private MountItem[] items_tmp;
    private ArrayList<MountItem> array = new ArrayList();
    private String pass_back_on_done;
    private boolean system;
    private boolean remount;

    MountsListEngine(Context ctx, Handler h, String pass_back_on_done_) {
        super(ctx);
        this.setHandler(h);
        this.pass_back_on_done = pass_back_on_done_;
        this.system = false;
    }

    MountsListEngine(Context ctx, Handler h, boolean remount_) {
        super(ctx);
        this.setHandler(h);
        this.pass_back_on_done = null;
        this.system = true;
        this.remount = remount_;
    }

    public final boolean toRemount() {
        return this.remount;
    }

    public final MountItem[] getItems() {
        return this.items_tmp;
    }

    public void run() {
        String msg = null;
        if (!this.getList(true)) {
            Log.w((String)this.TAG, (String)"su failed. let's try just sh");
            this.errMsg = null;
            msg = this.context.getString(2131362185);
            this.getList(false);
        }
        this.doneReading(msg, this.pass_back_on_done);
    }

    private final boolean getList(boolean su) {
        if (!su) {
            this.sh = "sh";
        }
        if (!this.execute("mount", false, 1500)) {
            Log.d((String)this.TAG, (String)"Executing mount has failed!");
            return false;
        }
        int sz = this.array.size();
        this.items_tmp = new MountItem[sz];
        if (sz > 0) {
            this.array.toArray(this.items_tmp);
        }
        return true;
    }

    protected void procInput(BufferedReader br) throws IOException, Exception {
        while (br.ready()) {
            MountItem item;
            if (this.isStopReq()) {
                throw new Exception();
            }
            String ln = br.readLine();
            if (ln == null) break;
            if (ln.length() == 0 || this.system && ln.indexOf("/system ") < 0 || !(item = new MountItem(ln)).isValid()) continue;
            this.array.add(item);
        }
    }

    public class MountItem {
        private static final String TAG = "MountItem";
        private String dev = "";
        private String mntp = "";
        private String type = "";
        private String opts = "";
        private String r1 = "";
        private String r2 = "";

        public MountItem(String string2) {
            String[] flds = string2.split(" ");
            if (flds.length < 4) {
                this.dev = "???";
            }
            if (flds[1].equals("on") && flds[3].equals("type")) {
                this.dev = flds.length > 0 ? flds[0] : "";
                this.mntp = flds.length > 2 ? flds[2] : "";
                this.type = flds.length > 4 ? flds[4] : "";
                String string3 = this.opts = flds.length > 5 ? flds[5] : "";
                if (this.opts.length() > 1 && this.opts.charAt(0) == '(' && this.opts.charAt(this.opts.length() - 1) == ')') {
                    this.opts = this.opts.substring(1, this.opts.length() - 1);
                }
            } else {
                this.dev = flds.length > 0 ? flds[0] : "";
                this.mntp = flds.length > 1 ? flds[1] : "";
                this.type = flds.length > 2 ? flds[2] : "";
                this.opts = flds.length > 3 ? flds[3] : "";
                this.r1 = flds.length > 4 ? flds[4] : "";
                this.r2 = flds.length > 5 ? flds[5] : "";
            }
        }

        public boolean isValid() {
            return this.dev.length() > 0 && this.mntp.length() > 0;
        }

        public String getName() {
            return this.dev + " " + this.mntp;
        }

        public String getOptions() {
            return this.opts;
        }

        public String getMode() {
            if (this.opts != null) {
                try {
                    String[] flds;
                    for (String f : flds = this.opts.split(",")) {
                        if (!f.equals("rw") && !f.equals("ro")) continue;
                        return f;
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("opts=" + this.opts), (Throwable)e);
                }
            }
            return null;
        }

        public String getRest() {
            return this.type + " " + this.opts + " " + this.r1 + " " + this.r2;
        }

        public String getMountPoint() {
            return this.mntp;
        }
    }
}

