package com.ghostsq.commander.samba;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiManager.WifiLock;
import android.util.Log;

import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;

class CopyFromEngine extends Engine // From a SMB share to local
{
    public final static String TAG = "CopyFromEngine";
    protected static int BLOCK_SIZE = 8192;
    private Commander commander;
    private Context   ctx;
    private SmbFile[] mList;
    private File      dest_folder;
    private boolean   move;
    private WifiLock  wifiLock;
    // to access from the writing thread
    private WritingThread wt;
    public  byte bufs[][] = { new byte[BLOCK_SIZE], new byte[BLOCK_SIZE] };
    public  int  read_bi = 0, write_bi = 1;

    static {
        long free = Runtime.getRuntime().freeMemory();
        BLOCK_SIZE = free < 65536 ? 32768 : (int)free / 3;
        Log.d( TAG, "Buffer size: " + BLOCK_SIZE + " free=" + free );        
    }
    
      CopyFromEngine( Commander commander_, SmbFile[] list, File dest, boolean move_, Engines.IReciever recipient_ ) {
          commander = commander_;
          ctx = commander.getContext();
          mList = list;
          dest_folder = dest;
          move = move_;
          recipient = recipient_;
          WifiManager manager = (WifiManager)ctx.getSystemService( Context.WIFI_SERVICE );
          wifiLock = manager.createWifiLock( android.os.Build.VERSION.SDK_INT >= 12 ? 3 : WifiManager.WIFI_MODE_FULL, TAG );
          wifiLock.setReferenceCounted( false );
      }
      @Override
      public void run() {
          wifiLock.acquire();
          int total = copyFiles( mList, "" );
          wifiLock.release();
          if( recipient != null ) {
              sendReceiveReq( dest_folder );
              return;
          }
          sendResult( Utils.getOpReport( ctx, total, Utils.RR.copied.r() ) );
          super.run();
      }
      private final int copyFiles( SmbFile[] list, String path ) {
        int counter = 0;
        try {
            long dir_size = 0, byte_count = 0;
            for( int i = 0; i < list.length; i++ ) {
                SmbFile f = list[i];
                synchronized( f ) {
                    if( !f.isDirectory() )
                        dir_size += f.length();
                }
            }
            double conv = 100. / (double)dir_size;
            for( int i = 0; i < list.length; i++ ) {
                SmbFile f = list[i];
                if( f == null ) continue;
                String rel_name;
                synchronized( f ) {
                    if( !f.exists() )
                        continue;
                    String file_name = f.getName();
                    rel_name = path + file_name;
                    File dest_file = new File( dest_folder, rel_name );
                    if( f.isDirectory() ) {
                        if( !dest_file.mkdir() ) {
                            if( !dest_file.exists() || !dest_file.isDirectory() ) {
                                errMsg = "Can't create folder \"" + dest_file.getCanonicalPath() + "\"";
                            break;
                        }
                    }
                    SmbFile[] subItems = f.listFiles();
                    if( subItems == null ) {
                        errMsg = "Failed to get the file list of the subfolder '" + rel_name + "'.\n";
                        break;
                    }
                    counter += copyFiles( subItems, rel_name );
                    if( errMsg != null )
                        break;
                }
                else {
                    if( dest_file.exists() ) {
                        int res = askOnFileExist( ctx.getString( Utils.RR.file_exist.r(), dest_file.getAbsolutePath() ), commander );
                        if( res == Commander.ABORT )
                            break;
                        if( res == Commander.SKIP )
                            continue;
                        if( res == Commander.REPLACE ) {
                            if( !dest_file.delete() ) {
                                error( ctx.getString( Utils.RR.cant_del.r(), dest_file.getAbsoluteFile() ) );
                                break;
                            }
                        }
                    }
                    InputStream in = f.getInputStream();
                    OutputStream out = new FileOutputStream( dest_file );
                   
                    wt = new WritingThread( out );
                    wt.start();                    
                    
                    long done = 0, nn = 0, start_time = 0;
                    int  n = 0, speed = 0;
                    int so_far = (int)(byte_count * conv);
                    try {
                        int fnl = rel_name.length();
                        String retr_s = ctx.getString( Utils.RR.retrieving.r(), 
                                fnl > CUT_LEN ? "\u2026" + rel_name.substring( fnl - CUT_LEN ) : rel_name );
                            String   sz_s = Utils.getHumanSize( f.length() );
                            while( true ) {
                                if( isStopReq() ) {
                                    in.close();
                                    wt.interrupt();
                                    error( ctx.getString( Utils.RR.fail_del.r(), dest_file.getName() ) );
                                    dest_file.delete();
                                    return counter;
                                }
                                if( nn == 0 ) {
                                    start_time = System.currentTimeMillis();
                                    sendProgress( retr_s + sizeOfsize( done, sz_s ), so_far, (int)(byte_count * conv), speed );
                                }
                                n = in.read( bufs[read_bi] );
                                synchronized( wt ) {
                                    while( wt.to_write != 0 )
                                        wt.wait( 1000 );
                                    read_bi  = ++read_bi  % 2;  
                                    write_bi = ++write_bi % 2;
                                    wt.to_write = n;
                                    wt.notify();                                    
                                }
                                if( n < 0 ) break;
                                byte_count += n;
                                done       += n;
                                nn         += n;
                                long time_delta = System.currentTimeMillis() - start_time;
                                if( time_delta > DELAY ) {
                                    speed = (int)(MILLI * nn / time_delta);
                                    nn = 0;
                                }
                            }
                            sendProgress( retr_s + sizeOfsize( done, sz_s ), so_far, (int)(byte_count * conv), ++speed );
                            in.close();
                        }
                        catch( Exception e ) {
                            wt.interrupt();
                            in.close();
                            out.close();
                            error( e.getMessage() );
                            error( ctx.getString( Utils.RR.fail_del.r(), dest_file.getName() ) );
                            dest_file.delete();
                            break;
                        }
                    }
                    long time = f.lastModified();
                    if( time > 0 )
                        dest_file.setLastModified( time );
                    
                    final int GINGERBREAD = 9;
                    if( android.os.Build.VERSION.SDK_INT >= GINGERBREAD )
                        ForwardCompat.setFullPermissions( dest_file );
                    
                    counter++;
                    if( move )
                        f.delete();
                }
                if( stop || isInterrupted() ) {
                    if( wt != null ) wt.interrupt();
                    error( ctx.getString( Utils.RR.interrupted.r() ) );
                    break;
                }
            }
          }
          catch( SmbException e ) {
              if( wt != null ) wt.interrupt();
              error( e.getMessage() );
              e.printStackTrace();
              Throwable t = e.getCause();
              if( t != null )
                  error( t.getMessage() );
          }
          catch( Throwable e ) {
              if( wt != null ) wt.interrupt();
              error( e.getMessage() );
              e.printStackTrace();
          }
          return counter;
      }
      
      class WritingThread extends Thread {
        public  int  to_write = 0;
        private OutputStream os;
        WritingThread( OutputStream os_ ) {
            os = os_;
            setName( "GC_SMB_CF_WT" );
        }

        @Override
        public void run() {
            try {
                while( true ) {
                    synchronized( this ) {
                        while( to_write == 0 )
                            wait( 1000 );
                    }
                    if( to_write < 0 ) break;
                    os.write( CopyFromEngine.this.bufs[CopyFromEngine.this.write_bi], 0, to_write );
                    synchronized( this ) {
                        to_write = 0;
                        notify();
                    }
                }
            } catch( InterruptedException e ) {
                Log.w( getName(), "Interrupted" );
            } catch( IOException e ) {
                Log.e( getName(), "IO error", e );
            } finally {
                try {
                    os.close();
                } catch( IOException e ) {
                    e.printStackTrace();
                }
            }
        }
    }
}
