package com.ghostsq.commander.samba;

import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import android.content.Context;
import android.os.Handler;

import com.ghostsq.commander.R;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.utils.Utils;

class RenEngine extends Engine {
    private Context ctx;
    private SmbFile old_file;
    private String  full_url; 
    private NtlmPasswordAuthentication credentials;
    
    public RenEngine( Context ctx_, SmbFile old_file_, String full_url_, NtlmPasswordAuthentication credentials_ ) {
        ctx = ctx_;
        old_file = old_file_;
        full_url = full_url_;
        credentials = credentials_;
    }
    @Override
    public void run() {
        try {
            synchronized( old_file ) {
                old_file.renameTo( new SmbFile( full_url, credentials ) );
            }
            sendProgress( null, Commander.OPERATION_COMPLETED_REFRESH_REQUIRED );
            return;
        } catch( Exception e ) {
            String msg = ctx.getString( Utils.RR.cant_md.r(), full_url ) + "\n - " + e.getLocalizedMessage();
            sendProgress( msg, Commander.OPERATION_FAILED );
        }
    }
}
