/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Resources;
import com.ghostsq.commander.Prefs;
import com.ghostsq.commander.utils.Utils;
import java.util.ArrayList;

public final class ColorsKeeper {
    public static final String BGR_COLORS = "bgr_color_picker";
    public static final String FGR_COLORS = "fgr_color_picker";
    public static final String SEL_COLORS = "sel_color_picker";
    public static final String SFG_COLORS = "sfg_color_picker";
    public static final String CUR_COLORS = "cur_color_picker";
    public static final String TTL_COLORS = "ttl_color_picker";
    public static final String BTN_COLORS = "btn_color_picker";
    private Context ctx;
    private SharedPreferences colorPref = null;
    public int ttlColor;
    public int bgrColor;
    public int fgrColor;
    public int selColor;
    public int sfgColor;
    public int curColor;
    public int btnColor;
    public ArrayList<FileTypeColor> ftColors;

    public boolean isButtonsDefault() {
        return this.btnColor == 0;
    }

    public ColorsKeeper(Context ctx_) {
        this.ctx = ctx_;
        Resources r = this.ctx.getResources();
        this.ttlColor = r.getColor(2131165196);
        this.bgrColor = r.getColor(2131165186);
        this.fgrColor = r.getColor(2131165187);
        this.selColor = r.getColor(2131165194);
        this.sfgColor = r.getColor(2131165187);
        this.btnColor = Prefs.getDefaultColor(this.ctx, BTN_COLORS, false);
        this.curColor = 0;
    }

    public int getColor(String key) {
        if (BGR_COLORS.equals(key)) {
            return this.bgrColor;
        }
        if (FGR_COLORS.equals(key)) {
            return this.fgrColor;
        }
        if (SEL_COLORS.equals(key)) {
            return this.selColor;
        }
        if (SFG_COLORS.equals(key)) {
            return this.sfgColor;
        }
        if (CUR_COLORS.equals(key)) {
            return this.curColor;
        }
        if (TTL_COLORS.equals(key)) {
            return this.ttlColor;
        }
        if (BTN_COLORS.equals(key)) {
            return this.btnColor;
        }
        return 0;
    }

    public void setColor(String key, int c) {
        if (BGR_COLORS.equals(key)) {
            this.bgrColor = c;
        }
        if (FGR_COLORS.equals(key)) {
            this.fgrColor = c;
        }
        if (SEL_COLORS.equals(key)) {
            this.selColor = c;
        }
        if (SFG_COLORS.equals(key)) {
            this.sfgColor = c;
        }
        if (CUR_COLORS.equals(key)) {
            this.curColor = c;
        }
        if (TTL_COLORS.equals(key)) {
            this.ttlColor = c;
        }
        if (BTN_COLORS.equals(key)) {
            this.btnColor = c;
        }
    }

    public final void store() {
        this.colorPref = this.ctx.getSharedPreferences("colors", 0);
        SharedPreferences.Editor editor = this.colorPref.edit();
        editor.putInt(BGR_COLORS, this.bgrColor);
        editor.putInt(FGR_COLORS, this.fgrColor);
        editor.putInt(CUR_COLORS, this.curColor);
        editor.putInt(SEL_COLORS, this.selColor);
        editor.putInt(SFG_COLORS, this.sfgColor);
        editor.putInt(TTL_COLORS, this.ttlColor);
        editor.putInt(BTN_COLORS, this.btnColor);
        editor.commit();
    }

    public final void restore() {
        this.colorPref = this.ctx.getSharedPreferences("colors", 0);
        this.bgrColor = this.colorPref.getInt(BGR_COLORS, this.bgrColor);
        this.fgrColor = this.colorPref.getInt(FGR_COLORS, this.fgrColor);
        this.curColor = this.colorPref.getInt(CUR_COLORS, this.curColor);
        this.selColor = this.colorPref.getInt(SEL_COLORS, this.selColor);
        this.sfgColor = this.colorPref.getInt(SFG_COLORS, this.sfgColor);
        this.ttlColor = this.colorPref.getInt(TTL_COLORS, this.ttlColor);
        this.btnColor = this.colorPref.getInt(BTN_COLORS, this.btnColor);
    }

    public final void storeTypeColors() {
        this.colorPref = this.ctx.getSharedPreferences("colors", 0);
        SharedPreferences.Editor editor = this.colorPref.edit();
        for (int i = 1; i <= this.ftColors.size(); ++i) {
            FileTypeColor ftc = this.ftColors.get(i - 1);
            ftc.store(editor, i);
        }
        editor.commit();
    }

    public final int restoreTypeColors() {
        try {
            FileTypeColor ftc;
            this.colorPref = this.ctx.getSharedPreferences("colors", 0);
            if (this.ftColors == null) {
                this.ftColors = new ArrayList(5);
            } else {
                this.ftColors.clear();
            }
            for (int i = 1; i < 999 && (ftc = new FileTypeColor()).restore(this.ctx, this.colorPref, i); ++i) {
                this.ftColors.add(ftc);
            }
            return this.ftColors.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public final int addTypeColor() {
        this.ftColors.add(new FileTypeColor("", this.fgrColor));
        return this.ftColors.size();
    }

    public class FileTypeColor {
        private static final String TYPES_pref = "types";
        private static final String FGR_COL_pref = "fgr_color";
        public String masks;
        public int color;
        public boolean masksDirty = false;
        public boolean colorDirty = false;

        public FileTypeColor() {
            this.color = 0;
        }

        public FileTypeColor(String m, int c) {
            this.masks = m;
            this.color = c;
        }

        public final void setMasks(String m) {
            this.masks = m;
            this.masksDirty = true;
        }

        public final void setColor(int c) {
            this.color = c;
            this.colorDirty = true;
        }

        public final boolean restore(Context ctx, SharedPreferences pref, int i) {
            try {
                this.color = ColorsKeeper.this.colorPref.getInt(FGR_COL_pref + i, this.getDefColor(ctx, i));
                this.masks = ColorsKeeper.this.colorPref.getString(TYPES_pref + i, this.getDefMasks(i));
                return this.masks != null;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public final void store(SharedPreferences.Editor editor, int i) {
            String pref_key;
            if (this.colorDirty) {
                pref_key = FGR_COL_pref + i;
                editor.putInt(pref_key, this.color);
            }
            if (this.masksDirty) {
                pref_key = TYPES_pref + i;
                editor.putString(pref_key, this.masks);
            }
        }

        public final String getDefMasks(int i) {
            String[] exts;
            String cat = null;
            switch (i) {
                case 1: {
                    return "/*;*/";
                }
                case 2: {
                    cat = "i";
                    break;
                }
                case 3: {
                    cat = "v";
                    break;
                }
                case 4: {
                    cat = "a";
                    break;
                }
                case 5: {
                    return "*.htm*;*.xml;*.pdf;*.csv;*.doc*;*.xls*";
                }
                case 6: {
                    return "*.apk;*.zip;*.jar;*.rar";
                }
            }
            if (cat != null && (exts = Utils.getExtsByCategory(cat)) != null) {
                StringBuffer ret_buf = new StringBuffer();
                boolean fst = true;
                for (int k = 0; k < exts.length; ++k) {
                    if (!fst) {
                        ret_buf.append(";");
                    }
                    ret_buf.append("*");
                    ret_buf.append(exts[k]);
                    fst = false;
                }
                return ret_buf.toString();
            }
            return null;
        }

        public int getDefColor(Context ctx, int i) {
            Resources r = ctx.getResources();
            switch (i) {
                case 1: {
                    return r.getColor(2131165188);
                }
                case 2: {
                    return r.getColor(2131165189);
                }
                case 3: {
                    return r.getColor(2131165190);
                }
                case 4: {
                    return r.getColor(0x7F070007);
                }
                case 5: {
                    return r.getColor(2131165192);
                }
                case 6: {
                    return r.getColor(2131165193);
                }
            }
            return r.getColor(2131165187);
        }
    }
}

