/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.Dialog;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.text.Html;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Display;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.RemoteViews;
import android.widget.Toast;
import com.ghostsq.commander.BackgroundWork;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.Dialogs;
import com.ghostsq.commander.IBackgroundWork;
import com.ghostsq.commander.Panels;
import com.ghostsq.commander.Prefs;
import com.ghostsq.commander.ServerForm;
import com.ghostsq.commander.StreamServer;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.adapters.FindAdapter;
import com.ghostsq.commander.adapters.MediaScanEngine;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;

public class FileCommander
extends Activity
implements Commander,
ServiceConnection,
View.OnClickListener {
    private static final String TAG = "GhostCommanderActivity";
    public static final int REQUEST_CODE_PREFERENCES = 1;
    public static final int REQUEST_CODE_SRV_FORM = 2;
    public static final int REQUEST_CODE_OPEN = 3;
    public static final int FIND_ACT = 1017;
    public static final int SMB_ACT = 2751;
    public static final int FTP_ACT = 4501;
    public static final int SFTP_ACT = 2450;
    private ArrayList<Dialogs> dialogs;
    private ProgressDialog waitPopup;
    public Panels panels;
    private boolean on = false;
    private boolean exit = false;
    private boolean dont_restore = false;
    private boolean sxs_auto = true;
    private boolean show_confirm = true;
    private boolean back_exits = false;
    private boolean ab = false;
    private String lang = "";
    private int file_exist_resolution = 0;
    private IBackgroundWork background_work;
    private NotificationManager notMan = null;
    private ArrayList<NotificationId> bg_ids = new ArrayList();
    private static final String PARCEL = "parcel";
    private static final String TASK_ID = "task_id";

    public final void showMemory(String s) {
        ActivityManager sys = (ActivityManager)this.getSystemService("activity");
        ActivityManager.MemoryInfo mem = new ActivityManager.MemoryInfo();
        sys.getMemoryInfo(mem);
        this.showMessage(s + "\n Memory: " + mem.availMem + (mem.lowMemory ? " !!!" : ""));
    }

    public final void showMessage(String s) {
        boolean html = Utils.isHTML(s);
        Toast.makeText((Context)this, (CharSequence)(html ? Html.fromHtml((String)s) : s), (int)1).show();
    }

    public int getWidth() {
        return this.panels.getWidth();
    }

    public boolean isActionBar() {
        return this.ab;
    }

    protected final Dialogs getDialogsInstance(int id2) {
        for (int i = 0; i < this.dialogs.size(); ++i) {
            if (this.dialogs.get(i).getId() != id2) continue;
            return this.dialogs.get(i);
        }
        return null;
    }

    protected final Dialogs obtainDialogsInstance(int id2) {
        Dialogs dh = this.getDialogsInstance(id2);
        if (dh == null) {
            dh = new Dialogs(this, id2);
            this.dialogs.add(dh);
        }
        return dh;
    }

    protected final void addDialogsInstance(Dialogs dh) {
        this.dialogs.add(dh);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 11 && (this.getResources().getConfiguration().screenLayout & 0xF) >= 3) {
            this.ab = this.getWindow().requestFeature(8);
        }
        if (!this.ab) {
            this.requestWindowFeature(1);
        }
        this.dialogs = new ArrayList(5);
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
        this.back_exits = sharedPref.getBoolean("exit_on_back", false);
        this.lang = sharedPref.getString("language", "");
        Utils.changeLanguage((Context)this);
        String panels_mode = sharedPref.getString("panels_sxs_mode", "a");
        this.sxs_auto = panels_mode.equals("a");
        boolean sxs = this.sxs_auto ? this.getRotMode() : panels_mode.equals("y");
        this.panels = new Panels(this, sxs);
        this.setConfirmMode(sharedPref);
        this.notMan = (NotificationManager)this.getSystemService("notification");
        this.bindService(new Intent((Context)this, BackgroundWork.class), this, 1);
    }

    protected void onStart() {
        super.onStart();
        this.on = true;
        if (this.dont_restore) {
            this.dont_restore = false;
        } else {
            Utils.changeLanguage((Context)this);
            Intent intent = this.getIntent();
            SharedPreferences prefs = this.getPreferences(0);
            Panels.State s = new Panels.State(this.panels);
            s.restore(prefs);
            String action = intent.getAction();
            Log.i((String)TAG, (String)("Action: " + action));
            if ("android.intent.action.VIEW".equals(action)) {
                Log.d((String)TAG, (String)("Not restoring " + s.getCurrent()));
                this.panels.setState(s, s.getCurrent());
                Log.d((String)TAG, (String)("VIEW opens in " + this.panels.getCurrent()));
                this.onNewIntent(intent);
                return;
            }
            this.panels.setState(s, -1);
            String FT = "first_time";
            if (prefs.getBoolean("first_time", true)) {
                SharedPreferences.Editor editor = prefs.edit();
                editor.putBoolean("first_time", false);
                editor.commit();
                this.showInfo(this.getString(2131362206));
            }
            if ("android.intent.action.SEARCH_LONG_PRESS".equals(action)) {
                this.showSearchDialog();
                return;
            }
        }
    }

    protected void onPause() {
        Log.v((String)TAG, (String)"Pausing\n");
        super.onPause();
        this.on = false;
        SharedPreferences.Editor editor = this.getPreferences(0).edit();
        Panels.State s = this.panels.getState();
        s.store(editor);
        editor.commit();
    }

    protected void onResume() {
        Log.v((String)TAG, (String)"Resuming\n");
        super.onResume();
        this.on = true;
    }

    protected void onStop() {
        Log.v((String)TAG, (String)"Stopping\n");
        super.onStop();
        this.on = false;
    }

    protected void onDestroy() {
        Log.v((String)TAG, (String)"Destroying\n");
        this.on = false;
        super.onDestroy();
        if (this.notMan != null) {
            this.notMan.cancelAll();
        }
        this.panels.Destroy();
        this.unbindService(this);
        if (this.isFinishing() && this.exit) {
            Log.i((String)TAG, (String)"Good bye cruel world...");
            System.exit(0);
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        Log.i((String)TAG, (String)"Saving Instance State");
        Panels.State s = this.panels.getState();
        s.store(outState);
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        Log.i((String)TAG, (String)"Restoring Instance State");
        if (savedInstanceState != null) {
            Panels.State s = new Panels.State(this.panels);
            s.restore(savedInstanceState);
            this.panels.setState(s, -1);
        }
        super.onRestoreInstanceState(savedInstanceState);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Utils.changeLanguage((Context)this);
        super.onConfigurationChanged(newConfig);
        this.panels.setLayoutMode(this.sxs_auto ? newConfig.orientation == 2 : this.panels.getLayoutMode());
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        try {
            Utils.changeLanguage((Context)this);
            AdapterView.AdapterContextMenuInfo acmi = (AdapterView.AdapterContextMenuInfo)menuInfo;
            menu2.setHeaderTitle((CharSequence)this.getString(2131361938));
            CommanderAdapter ca = this.panels.getListAdapter(true);
            ca.populateContextMenu(menu2, acmi, Utils.getCount(this.panels.getMultiple(true)));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onCreateContextMenu()", (Throwable)e);
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        try {
            this.panels.resetQuickSearch();
            AdapterView.AdapterContextMenuInfo info = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
            if (info == null) {
                return false;
            }
            this.panels.setSelection(info.position);
            int item_id = item.getItemId();
            if (903 == item_id) {
                this.panels.openItem(info.position);
            } else {
                this.dispatchCommand(item_id);
            }
            return true;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"onContextItemSelected()", (Throwable)e);
            return false;
        }
    }

    protected Dialog onCreateDialog(int id2) {
        Dialogs dh;
        Dialog d;
        if (!this.on) {
            Log.e((String)TAG, (String)"onCreateDialog() is called when the activity is down");
        }
        return (d = (dh = this.obtainDialogsInstance(id2)).createDialog(id2)) != null ? d : super.onCreateDialog(id2);
    }

    protected void onPrepareDialog(int id2, Dialog dialog) {
        Dialogs dh = this.getDialogsInstance(id2);
        if (dh != null) {
            dh.prepareDialog(id2, dialog);
        }
        super.onPrepareDialog(id2, dialog);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        try {
            Utils.changeLanguage((Context)this);
            MenuInflater inflater = this.getMenuInflater();
            if (this.ab) {
                inflater.inflate(2131492864, menu2);
                inflater.inflate(2131492865, menu2);
                MenuItem list_menu = menu2.findItem(2131230904);
                if (list_menu != null) {
                    list_menu.setVisible(false);
                }
            } else {
                inflater.inflate(2131492865, menu2);
            }
            return true;
        }
        catch (Error e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        this.panels.resetQuickSearch();
        boolean processed = super.onMenuItemSelected(featureId, item);
        if (!processed) {
            this.dispatchCommand(item.getItemId());
        }
        return true;
    }

    public void issue(Intent in, int ret) {
        if (in == null) {
            return;
        }
        try {
            if (ret == 0) {
                this.startActivity(in);
            } else {
                this.startActivityForResult(in, ret);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)in.getDataString(), (Throwable)e);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Log.d((String)TAG, (String)("onActivityResult( " + requestCode + ", " + data + " )"));
        switch (requestCode) {
            case 1: {
                SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
                this.back_exits = sharedPref.getBoolean("exit_on_back", false);
                String lang_ = sharedPref.getString("language", "");
                if (!this.lang.equalsIgnoreCase(lang_)) {
                    this.lang = lang_;
                    Utils.changeLanguage((Context)this);
                    this.showMessage(this.getString(2131362153));
                    this.exit = true;
                }
                this.panels.applySettings(sharedPref, false);
                String panels_mode = sharedPref.getString("panels_sxs_mode", "a");
                this.sxs_auto = panels_mode.equals("a");
                boolean sxs = this.sxs_auto ? this.getRotMode() : panels_mode.equals("y");
                this.panels.setLayoutMode(sxs);
                this.panels.showToolbar(sharedPref.getBoolean("show_toolbar", true));
                this.setConfirmMode(sharedPref);
                break;
            }
            case 2: {
                if (resultCode != -1) break;
                this.dont_restore = true;
                Uri uri = data.getData();
                if (uri == null) break;
                Credentials crd = null;
                try {
                    crd = (Credentials)data.getParcelableExtra(Credentials.KEY);
                    boolean aff_fave = data.getBooleanExtra("ADD_FAVE", false);
                    String comment = data.getStringExtra("COMMENT");
                    if (aff_fave) {
                        this.panels.addToFavorites(uri, crd, comment);
                    }
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"on taking credentials from parcel", (Throwable)e);
                }
                this.panels.Navigate(this.panels.getCurrent(), uri, crd, null);
                break;
            }
            case 2131230755: {
                if (data == null) break;
                data.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
                this.sendBroadcast(data);
                break;
            }
            case 695: {
                if (data == null) break;
                this.on = true;
                Message msg = (Message)data.getParcelableExtra("com.ghostsq.commander.MESSAGE");
                if (msg != null) {
                    this.notifyMe(msg);
                    break;
                }
                this.panels.refreshLists(null);
                break;
            }
            case 3: {
                try {
                    File[] temp_files;
                    File temp_dir = new File(ForwardCompat.getExternalFilesDir((Context)this), "to_open");
                    for (File f : temp_files = temp_dir.listFiles()) {
                        f.deleteOnExit();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            default: {
                this.handleActivityResult(requestCode, resultCode, data);
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        char c = (char)event.getUnicodeChar();
        this.panels.resetQuickSearch();
        switch (c) {
            case '=': {
                this.panels.makeOtherAsCurrent();
                return true;
            }
            case '&': {
                this.openPrefs();
                return true;
            }
            case '/': {
                this.showSearchDialog();
                return true;
            }
            case '1': {
                this.showInfo(this.getString(2131362206));
                return true;
            }
            case '9': {
                this.openPrefs();
                return true;
            }
            case '0': {
                this.exit = true;
                this.finish();
                return true;
            }
        }
        switch (keyCode) {
            case 61: {
                this.panels.togglePanels(false);
                return true;
            }
            case 25: {
                if (!this.panels.volumeLegacy) break;
                this.panels.togglePanels(false);
                return true;
            }
            case 84: {
                this.showSearchDialog();
                return false;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 24 || keyCode == 25) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void onClick(View button) {
        this.panels.resetQuickSearch();
        if (button == null) {
            return;
        }
        this.dispatchCommand(button.getId());
    }

    public final boolean backExit() {
        if (this.back_exits) {
            this.finish();
            return true;
        }
        return false;
    }

    public void dispatchCommand(int id2) {
        try {
            Utils.changeLanguage((Context)this);
            switch (id2) {
                case 2131230720: 
                case 2131230917: {
                    this.showInfo(this.getString(2131362206));
                    break;
                }
                case 2131230723: 
                case 2131230724: {
                    this.panels.openForView(2131230724 == id2);
                    break;
                }
                case 2131230725: 
                case 2131230726: {
                    this.panels.openForEdit(null, 2131230726 == id2);
                    break;
                }
                case 2131230721: 
                case 2131230722: 
                case 2131230728: 
                case 2131230729: 
                case 2131230730: 
                case 2131230731: 
                case 2131230733: 
                case 2131230734: 
                case 2131230909: {
                    boolean touch;
                    boolean bl = touch = 2131230722 == id2 || 2131230729 == id2 || 2131230731 == id2 || 2131230734 == id2 || 2131230758 == id2;
                    if (Utils.getCount(this.panels.getMultiple(touch)) > 0) {
                        this.showDialog(id2);
                        break;
                    }
                    this.showMessage(this.getString(2131361958));
                    break;
                }
                case 2131230727: 
                case 2131230732: 
                case 2131230908: 
                case 2131230919: {
                    this.showDialog(id2);
                    break;
                }
                case 2131230920: {
                    this.startViewURIActivity(2131362211);
                    break;
                }
                case 2131230735: 
                case 2131230914: {
                    this.openPrefs();
                    break;
                }
                case 2131230736: 
                case 2131230915: {
                    this.exit = true;
                    this.finish();
                    break;
                }
                case 2131230754: {
                    this.openOptionsMenu();
                }
                case 2131230737: 
                case 2131230902: {
                    this.panels.makeOtherAsCurrent();
                    break;
                }
                case 2131230906: {
                    this.panels.swapPanels();
                    break;
                }
                case 2131230911: {
                    this.panels.togglePanelsMode();
                    break;
                }
                case 2131230738: {
                    this.panels.togglePanels(true);
                    break;
                }
                case 2131230739: 
                case 2131230740: {
                    this.panels.showSizes(2131230740 == id2);
                    break;
                }
                case 2131230894: {
                    this.panels.goUp();
                    break;
                }
                case 2131230895: {
                    this.panels.goTop();
                    break;
                }
                case 2131230896: {
                    this.panels.goBot();
                    break;
                }
                case 2131230897: {
                    this.Navigate(Uri.parse((String)"home:"), null, null);
                    break;
                }
                case 2131230901: {
                    this.Navigate(Uri.parse((String)"favs:"), null, null);
                    break;
                }
                case 2131230750: {
                    this.Navigate(Uri.parse((String)Panels.DEFAULT_LOC), null, null);
                    break;
                }
                case 2131230751: {
                    String shm;
                    Uri cu = this.panels.getFolderUriWithAuth(true);
                    String string2 = shm = cu != null ? cu.getScheme() : null;
                    String to_go = "root".equals(shm) ? cu.getPath() : "root:" + (cu == null || Utils.str(shm) ? "" : cu.getPath());
                    this.Navigate(Uri.parse((String)to_go), null, null);
                    break;
                }
                case 2131230752: {
                    this.Navigate(Uri.parse((String)"mount:"), null, null);
                    break;
                }
                case 4501: {
                    Intent i = new Intent((Context)this, ServerForm.class);
                    i.putExtra("schema", "ftp");
                    this.startActivityForResult(i, 2);
                    break;
                }
                case 2450: {
                    Intent i = new Intent((Context)this, ServerForm.class);
                    i.putExtra("schema", "sftp");
                    this.startActivityForResult(i, 2);
                    break;
                }
                case 2751: {
                    Intent i = new Intent((Context)this, ServerForm.class);
                    i.putExtra("schema", "smb");
                    this.startActivityForResult(i, 2);
                    break;
                }
                case 2131230903: {
                    this.showSearchDialog();
                    break;
                }
                case 2131230756: {
                    String path = this.panels.getSelectedItemName(true, true);
                    String ext = Utils.getFileExt(path);
                    if (".zip".equalsIgnoreCase(ext)) {
                        this.Navigate(Uri.parse((String)path).buildUpon().scheme("zip").build(), null, null);
                    }
                    break;
                }
                case 2131230757: {
                    this.panels.unpackZip();
                    break;
                }
                case 2131230747: {
                    this.panels.openGoPanel();
                    break;
                }
                case 2131230748: {
                    this.panels.addCurrentToFavorites();
                    break;
                }
                case 2131230741: {
                    this.panels.changeSorting(0);
                    break;
                }
                case 2131230742: {
                    this.panels.changeSorting(48);
                    break;
                }
                case 2131230743: {
                    this.panels.changeSorting(16);
                    break;
                }
                case 2131230744: {
                    this.panels.changeSorting(32);
                    break;
                }
                case 2131230905: {
                    this.panels.refreshLists(null);
                    break;
                }
                case 2131230745: {
                    this.showDialog(239);
                    break;
                }
                case 2131230746: {
                    this.showDialog(762);
                    break;
                }
                case 2131230918: {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)this.getString(2131362212)));
                    this.startActivity(intent);
                    break;
                }
                case 236: {
                    this.panels.tryToSend();
                    break;
                }
                case 902: {
                    this.panels.tryToOpen();
                    break;
                }
                case 390: {
                    this.panels.copyName();
                    break;
                }
                case 269: {
                    this.panels.createDesktopShortcut();
                    break;
                }
                case 414: {
                    this.panels.faveSelectedFolder();
                    break;
                }
                case 2131230912: {
                    InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
                    imm.toggleSoftInput(0, 0);
                    break;
                }
                case 2131230753: {
                    this.panels.toggleHidden();
                    break;
                }
                case 2131230913: {
                    if (Build.VERSION.SDK_INT >= 8) {
                        MediaScanEngine mse = new MediaScanEngine((Context)this, new File(Panels.DEFAULT_LOC), false);
                        mse.setHandler(new SimpleHandler());
                        this.startEngine(mse);
                        break;
                    }
                    this.sendBroadcast(new Intent("android.intent.action.MEDIA_MOUNTED", Uri.parse((String)("file://" + Panels.DEFAULT_LOC))));
                    break;
                }
                default: {
                    CommanderAdapter ca = this.panels.getListAdapter(true);
                    if (ca != null) {
                        ca.doIt(id2, this.panels.getMultiple(true));
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("Failed command: " + id2), (Throwable)e);
        }
    }

    private final void openPrefs() {
        try {
            Intent launchPreferencesIntent = new Intent().setClass((Context)this, Prefs.class);
            this.startActivityForResult(launchPreferencesIntent, 1);
        }
        catch (Error e) {
            Log.e((String)TAG, (String)"Preferences can't open", (Throwable)e);
        }
    }

    private final void showSearchDialog() {
        CommanderAdapter ca = this.panels.getListAdapter(true);
        if (ca instanceof FSAdapter || ca instanceof FindAdapter) {
            String cur_path;
            Uri cur_uri;
            String cur_s = ca.toString();
            if (cur_s != null && (cur_uri = Uri.parse((String)cur_s)) != null && (cur_path = cur_uri.getPath()) != null) {
                Dialogs dh = this.obtainDialogsInstance(1017);
                dh.setCookie(cur_path);
                this.showDialog(1017);
                return;
            }
            this.showMessage("Error");
        } else {
            this.showError(this.getString(2131361961));
        }
    }

    public void Navigate(Uri uri, Credentials crd, String posTo) {
        this.panels.Navigate(this.panels.getCurrent(), uri, crd, posTo);
    }

    public void Open(Uri uri, Credentials crd) {
        try {
            if (uri == null) {
                return;
            }
            String scheme = uri.getScheme();
            String path = uri.getPath();
            String ext = Utils.getFileExt("zip".equals(scheme) ? uri.getFragment() : path);
            if (!Utils.str(ext)) {
                ext = Utils.getFileExt(uri.getFragment());
            }
            String mime = Utils.getMimeByExt(ext);
            if (!Utils.str(scheme)) {
                Intent i = new Intent("android.intent.action.VIEW");
                Intent op_intent = this.getIntent();
                if (op_intent != null) {
                    String action = op_intent.getAction();
                    if ("android.intent.action.PICK".equals(action)) {
                        i.setData(uri);
                        this.setResult(-1, i);
                        this.finish();
                        return;
                    }
                    if ("android.intent.action.GET_CONTENT".equals(action)) {
                        i.setData(Uri.parse((String)("content://com.ghostsq.commander.FileProvider" + path)));
                        this.setResult(-1, i);
                        this.finish();
                        return;
                    }
                }
                if (ext != null && (ext.compareToIgnoreCase(".zip") == 0 || ext.compareToIgnoreCase(".jar") == 0)) {
                    this.Navigate(uri.buildUpon().scheme("zip").build(), null, null);
                    return;
                }
                i.setDataAndType(uri.buildUpon().scheme("file").authority("").build(), mime);
                i.setFlags(0x10080000);
                this.startActivityForResult(i, 3);
            } else {
                if (mime != null && (mime.startsWith("audio") || mime.startsWith("video"))) {
                    this.startService(new Intent((Context)this, StreamServer.class));
                    Intent i = new Intent("android.intent.action.VIEW");
                    if (crd != null) {
                        String username = crd.getUserName();
                        StreamServer.storeCredentials((Context)this, crd, uri);
                        uri = Utils.updateUserInfo(uri, username);
                    }
                    String http_url = "http://127.0.0.1:5322/" + Uri.encode((String)uri.toString());
                    i.setDataAndType(Uri.parse((String)http_url), mime);
                    i.setFlags(0x10080000);
                    this.startActivity(i);
                    return;
                }
                File temp_dir = new File(ForwardCompat.getExternalFilesDir((Context)this), "to_open");
                temp_dir.mkdir();
                final CommanderAdapter ca = CA.CreateAdapterInstance(scheme, (Context)this);
                if (ca == null) {
                    return;
                }
                ca.Init(this);
                ca.setCredentials(crd);
                final String _fn = path.substring(path.lastIndexOf(47) + 1);
                final Uri _uri = uri;
                final File _out_file = new File(temp_dir, _fn);
                final Handler _handler = new Handler();
                final ProgressDialog _pd = ProgressDialog.show((Context)this, (CharSequence)"", (CharSequence)this.getString(2131361988), (boolean)true, (boolean)true);
                new Thread(new Runnable(){

                    public void run() {
                        try {
                            CommanderAdapter.Item item = ca.getItem(_uri);
                            if (item == null) {
                                _pd.cancel();
                                Log.e((String)FileCommander.TAG, (String)("No item for: " + _uri.toString()));
                                return;
                            }
                            if (item.size > 5000000L) {
                                _handler.post(new Runnable(){

                                    public void run() {
                                        _pd.cancel();
                                        FileCommander.this.showError(FileCommander.this.getString(2131362175, new Object[]{_fn}));
                                    }
                                });
                                return;
                            }
                            FileOutputStream fos = new FileOutputStream(_out_file);
                            InputStream is = ca.getContent(_uri);
                            Utils.copyBytes(is, fos);
                            fos.close();
                            ca.closeStream(is);
                            ca.prepareToDestroy();
                            _handler.post(new Runnable(){

                                public void run() {
                                    _pd.cancel();
                                    FileCommander.this.Open(Uri.parse((String)_out_file.toString()), null);
                                }
                            });
                            return;
                        }
                        catch (Exception e) {
                            Log.e((String)FileCommander.TAG, (String)_uri.toString(), (Throwable)e);
                            _handler.post(new Runnable(){

                                public void run() {
                                    _pd.cancel();
                                    FileCommander.this.showError(FileCommander.this.getString(2131362040, new Object[]{_fn}));
                                }
                            });
                            return;
                        }
                    }
                }).start();
            }
        }
        catch (ActivityNotFoundException e) {
            this.showMessage("Application for open '" + uri.toString() + "' is not available, ");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)uri.toString(), (Throwable)e);
        }
    }

    public Context getContext() {
        return this;
    }

    protected void onNewIntent(Intent intent) {
        block23: {
            this.on = true;
            super.onNewIntent(intent);
            try {
                long task_id;
                Bundle extras = intent.getExtras();
                if (extras != null && (task_id = extras.getLong(TASK_ID)) > 0L) {
                    Dialogs dh = this.obtainDialogsInstance(493);
                    if (dh != null) {
                        long d_task_id = dh.getTaskId();
                        if (d_task_id != 0L) {
                            this.bg_ids.add(new NotificationId(d_task_id));
                        }
                        dh.cancelDialog();
                    }
                    this.remBgNotifId(task_id);
                    dh.setTaskId(task_id);
                    dh.showDialog();
                    Parcelable pe = intent.getParcelableExtra(PARCEL);
                    if (pe != null && pe instanceof Message) {
                        this.notifyMe((Message)pe);
                    }
                    return;
                }
                String action = intent.getAction();
                Uri uri = intent.getData();
                if (uri != null && "android.intent.action.VIEW".equals(action)) {
                    Log.v((String)TAG, (String)("Intent URI: " + uri));
                    Credentials crd = null;
                    try {
                        crd = (Credentials)intent.getParcelableExtra(Credentials.KEY);
                    }
                    catch (Throwable e) {
                        Log.e((String)TAG, (String)"on extracting credentials from an intent", (Throwable)e);
                    }
                    String file_name = null;
                    String type = intent.getType();
                    if ("application/x-zip-compressed".equals(type) || "application/zip".equals(type)) {
                        String scheme = uri.getScheme();
                        if (!Utils.str(scheme) || "file".equals(scheme)) {
                            uri = uri.buildUpon().scheme("zip").build();
                        } else if ("content".equals(scheme) && (uri = this.fileUriFromcontentUri(uri)) == null) {
                            return;
                        }
                    } else if ("content".equals(uri.getScheme())) {
                        try {
                            InputStream is = this.getContentResolver().openInputStream(uri);
                            if (is != null) {
                                File dwf = new File(Panels.DEFAULT_LOC, "download");
                                if (!dwf.exists()) {
                                    dwf.mkdirs();
                                }
                                String fn = uri.getLastPathSegment();
                                File f = null;
                                for (int i = 0; i < 99; ++i) {
                                    file_name = i == 0 ? fn : fn + "_" + i;
                                    f = new File(dwf, file_name);
                                    if (f.exists()) continue;
                                    if (f.createNewFile()) break;
                                    f = null;
                                }
                                if (f != null) {
                                    int n;
                                    BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f), 8192);
                                    byte[] buf = new byte[4096];
                                    while ((n = is.read(buf)) != -1) {
                                        bos.write(buf, 0, n);
                                    }
                                    bos.close();
                                    is.close();
                                    uri = Uri.fromFile((File)dwf);
                                    this.showMessage(this.getString(2131361978, new Object[]{f.toString()}));
                                } else {
                                    this.showError(this.getString(2131361997, new Object[]{fn}));
                                }
                            }
                        }
                        catch (Exception e) {
                            this.showError(this.getString(2131361997, new Object[]{""}));
                        }
                    }
                    this.panels.Navigate(this.panels.getCurrent(), uri, crd, file_name);
                    this.dont_restore = true;
                    break block23;
                }
                this.handleActivityResult(-1, -1, intent);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Can't extract a parcel from intent", (Throwable)e);
            }
        }
    }

    private final Uri fileUriFromcontentUri(Uri uri) {
        try {
            FileOutputStream fos;
            String dn_dir;
            File dn_file;
            ContentResolver cr = this.getContentResolver();
            String[] projection = new String[]{"_display_name", "_size"};
            Cursor c = cr.query(uri, projection, null, null, null);
            int nci = c.getColumnIndex("_display_name");
            int sci = c.getColumnIndex("_size");
            c.moveToFirst();
            String fn = c.getString(nci);
            Long fs = c.getLong(sci);
            if (!Utils.str(fn)) {
                fn = "temp.zip";
            }
            if (uri.toString().contains("downloads") && Build.VERSION.SDK_INT >= 8 && (dn_file = new File(dn_dir = ForwardCompat.getPath(ForwardCompat.PubPathType.DOWNLOADS), fn)).exists() && dn_file.length() == fs.longValue()) {
                return Uri.parse((String)("zip:" + dn_file.getAbsolutePath()));
            }
            InputStream is = cr.openInputStream(uri);
            if (is == null) {
                throw new Exception("No input stream");
            }
            File temp_dir = Utils.createTempDir((Context)this);
            File dest = new File(temp_dir, fn);
            if (dest.exists()) {
                dest.delete();
            }
            if (!Utils.copyBytes(is, fos = new FileOutputStream(dest))) {
                throw new Exception("Copy failed");
            }
            is.close();
            fos.close();
            return Uri.parse((String)("zip:" + dest.getAbsolutePath()));
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)uri.toString(), (Throwable)e);
            this.showError(this.getString(2131362179));
            return null;
        }
    }

    private final void handleActivityResult(int requestCode, int resultCode, Intent data) {
        CommanderAdapter ca = this.panels.getListAdapter(true);
        if (ca != null && ca.handleActivityResult(requestCode, resultCode, data)) {
            return;
        }
        ca = this.panels.getListAdapter(false);
        if (ca != null) {
            ca.handleActivityResult(requestCode, resultCode, data);
        }
    }

    public boolean startEngine(Engine e) {
        if (this.background_work != null) {
            this.background_work.start(e);
            return true;
        }
        Log.e((String)TAG, (String)"background work service is not available!");
        return false;
    }

    public boolean stopEngine(long task_id) {
        if (this.background_work == null) {
            return false;
        }
        return this.background_work.stopEngine(task_id);
    }

    public boolean notifyMe(Message progress) {
        boolean TERMINATE = true;
        boolean CONTINUE = false;
        String string2 = null;
        try {
            Bundle b;
            String cookie;
            if (progress.obj != null) {
                if (progress.obj instanceof Bundle) {
                    string2 = ((Bundle)progress.obj).getString("STRING");
                } else if (progress.obj instanceof String) {
                    string2 = (String)progress.obj;
                    Log.w((String)TAG, (String)"Old version message type!");
                }
            }
            String string3 = cookie = (b = progress.getData()) != null ? b.getString("cookie") : null;
            if (progress.what == -1) {
                this.setProgressBarIndeterminateVisibility(true);
                if (Utils.str(string2)) {
                    this.showMessage(string2);
                }
                return false;
            }
            long task_id = b.getLong("task");
            Dialogs dh = null;
            if (progress.what == 0) {
                if (progress.arg1 >= 0) {
                    boolean id_found = false;
                    if (this.on && (dh = this.obtainDialogsInstance(493)) != null) {
                        Dialog dlg;
                        if (task_id == dh.getTaskId()) {
                            dh.showDialog();
                            dh.setProgress(string2, progress.arg1, progress.arg2, b != null ? b.getInt("speed", -1) : 0);
                            this.remBgNotifId(task_id);
                            return false;
                        }
                        for (NotificationId bg_id : this.bg_ids) {
                            if (!bg_id.is(task_id)) continue;
                            id_found = true;
                            break;
                        }
                        if (!(id_found || (dlg = dh.getDialog()) != null && dlg.isShowing())) {
                            dh.setTaskId(task_id);
                            dh.showDialog();
                            dh.setProgress(string2, progress.arg1, progress.arg2, b != null ? b.getInt("speed", -1) : 0);
                            return false;
                        }
                    }
                    if (!id_found) {
                        this.addBgNotifId(task_id);
                    }
                    this.setSystemOngoingNotification((int)task_id, string2, progress.arg2 > 0 ? progress.arg2 : progress.arg1);
                    return false;
                }
                if (this.waitPopup == null) {
                    this.waitPopup = ProgressDialog.show((Context)this, (CharSequence)"", (CharSequence)this.getString(2131361903), (boolean)true, (boolean)true);
                }
                return false;
            }
            dh = this.getDialogsInstance(493);
            if (dh != null && task_id == dh.getTaskId()) {
                Log.d((String)TAG, (String)("Cancelling dialog " + task_id));
                dh.cancelDialog();
            } else {
                this.remBgNotifId(task_id);
            }
            if (this.notMan != null) {
                this.notMan.cancel((int)task_id);
            }
            if (!this.on) {
                this.setSystemNotification((int)task_id, progress);
                return progress.what != -6;
            }
            if (this.waitPopup != null) {
                this.waitPopup.cancel();
                this.waitPopup = null;
            }
            this.setProgressBarIndeterminateVisibility(false);
            this.panels.operationFinished();
            switch (progress.what) {
                case -6: {
                    dh = this.obtainDialogsInstance(328);
                    dh.setMessageToBeShown(string2, null);
                    dh.showDialog();
                    return false;
                }
                case -7: 
                case -2: {
                    if (Utils.str(cookie)) {
                        int which_panel = cookie.charAt(0) == '1' ? 1 : 0;
                        this.panels.setPanelTitle(this.getString(2131361904), which_panel);
                    }
                    if (Utils.str(string2)) {
                        this.showError(string2);
                    }
                    if (progress.what == -7) {
                        String posto = b != null ? b.getString("posto") : null;
                        this.panels.refreshLists(posto);
                    } else {
                        this.panels.redrawLists();
                    }
                    return true;
                }
                case -5: {
                    if (string2 != null) {
                        Parcelable crd_p;
                        dh = this.obtainDialogsInstance(995);
                        if (b != null && (crd_p = b.getParcelable("crd")) != null && crd_p instanceof Credentials) {
                            dh.setCredentials((Credentials)crd_p, Utils.str(cookie) ? (cookie.charAt(0) == '1' ? 1 : 0) : -1);
                        }
                        dh.setMessageToBeShown(string2, cookie);
                        this.showDialog(995);
                    }
                    return true;
                }
                case -4: {
                    Uri uri;
                    String posto = b != null ? b.getString("posto") : null;
                    Uri uri2 = uri = b != null ? (Uri)b.getParcelable("uri") : null;
                    if (uri != null) {
                        this.Navigate(uri, null, posto);
                        break;
                    }
                    this.panels.refreshLists(posto);
                    break;
                }
                case -3: {
                    if (Utils.str(cookie)) {
                        int which_panel = cookie.charAt(0) == '1' ? 1 : 0;
                        String item_name = cookie.substring(1);
                        this.panels.recoverAfterRefresh(item_name, which_panel);
                        break;
                    }
                    this.panels.recoverAfterRefresh(null, -1);
                }
            }
            if ((this.show_confirm || progress.arg1 == 870) && Utils.str(string2)) {
                this.showInfo(string2);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, string2, (Throwable)e);
        }
        return true;
    }

    public final void addBgNotifId(long id2) {
        for (NotificationId bg_id : this.bg_ids) {
            if (!bg_id.is(id2)) continue;
            return;
        }
        this.bg_ids.add(new NotificationId(id2));
    }

    private final boolean remBgNotifId(long id2) {
        for (NotificationId bg_id : this.bg_ids) {
            if (!bg_id.is(id2)) continue;
            this.bg_ids.remove(bg_id);
            this.notMan.cancel((int)id2);
            return true;
        }
        return false;
    }

    private PendingIntent getPendingIntent(long task_id, Parcelable parcel) {
        Intent intent = new Intent((Context)this, FileCommander.class);
        intent.setFlags(0x24000000);
        intent.setAction("android.intent.action.MAIN");
        intent.putExtra(TASK_ID, task_id);
        if (parcel != null) {
            intent.putExtra(PARCEL, parcel);
        }
        return PendingIntent.getActivity((Context)this, (int)0, (Intent)intent, (int)0x8000000);
    }

    private void setSystemOngoingNotification(int id2, String str, int p) {
        if (this.notMan == null || str == null) {
            return;
        }
        NotificationId n_id = null;
        for (NotificationId bg_id : this.bg_ids) {
            if (!bg_id.is(id2)) continue;
            n_id = bg_id;
        }
        if (n_id == null) {
            return;
        }
        long cur_time = System.currentTimeMillis();
        if (n_id.last + 1000L > cur_time) {
            return;
        }
        n_id.last = cur_time;
        Notification notification = new Notification(2130837524, (CharSequence)this.getString(2131362045), n_id.started);
        notification.contentIntent = this.getPendingIntent(id2, null);
        notification.flags |= 2;
        RemoteViews not_view = new RemoteViews(this.getPackageName(), 2130903050);
        not_view.setTextViewText(2131230829, (CharSequence)str.replace("\n", " "));
        not_view.setProgressBar(2131230830, 100, p, false);
        not_view.setTextViewText(2131230831, (CharSequence)("" + p + "%"));
        notification.contentView = not_view;
        this.notMan.notify(id2, notification);
    }

    private void setSystemNotification(int id2, Message msg) {
        if (this.notMan == null || msg == null) {
            return;
        }
        String str = "";
        try {
            if (msg.obj instanceof Bundle) {
                str = ((Bundle)msg.obj).getString("STRING");
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
        Notification notification = new Notification(2130837524, (CharSequence)str, System.currentTimeMillis());
        notification.setLatestEventInfo((Context)this, (CharSequence)this.getString(2131361803), (CharSequence)str, this.getPendingIntent(id2, (Parcelable)msg));
        notification.flags |= 0x18;
        if (msg.what == -6) {
            notification.flags |= 1;
            notification.defaults |= 2;
            notification.ledARGB = -65536;
            notification.ledOnMS = 300;
            notification.ledOffMS = 1000;
        }
        this.notMan.notify(id2, notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResolution(int r) {
        FileCommander fileCommander = this;
        synchronized (fileCommander) {
            this.file_exist_resolution = r;
            this.notify();
        }
    }

    public int getResolution() {
        int r = this.file_exist_resolution;
        this.file_exist_resolution = 0;
        return r;
    }

    public void showError(String errMsg) {
        try {
            if (!this.on) {
                return;
            }
            Dialogs dh = this.obtainDialogsInstance(193);
            dh.setMessageToBeShown(errMsg, null);
            dh.showDialog();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.showMessage(errMsg);
            return;
        }
    }

    public void showInfo(String msg) {
        if (!this.on) {
            return;
        }
        if (msg.length() < 32) {
            this.showMessage(msg);
        } else {
            Dialogs dh = this.obtainDialogsInstance(864);
            dh.setMessageToBeShown(msg, null);
            dh.showDialog();
        }
    }

    public final void startViewURIActivity(int res_id) {
        Intent i = new Intent("android.intent.action.VIEW");
        i.setData(Uri.parse((String)this.getString(res_id)));
        this.startActivity(i);
    }

    private final boolean getRotMode() {
        boolean sideXside = false;
        try {
            Display disp = this.getWindowManager().getDefaultDisplay();
            sideXside = disp.getWidth() > disp.getHeight();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
        return sideXside;
    }

    private final void setConfirmMode(SharedPreferences sharedPref) {
        this.show_confirm = sharedPref.getBoolean("show_confirm", true);
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        this.background_work = ((IBackgroundWork.IBackgroundWorkBinder)service).init(this);
    }

    public void onServiceDisconnected(ComponentName name) {
        this.background_work = null;
    }

    public class SimpleHandler
    extends Handler {
        public void handleMessage(Message msg) {
            FileCommander.this.notifyMe(msg);
        }
    }

    private class NotificationId {
        public long id;
        public long started;
        public long last;

        public NotificationId(long id_) {
            this.id = id_;
            this.last = this.started = System.currentTimeMillis();
        }

        public final boolean is(long fid) {
            return this.id == fid;
        }
    }
}

