/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;

public class PanelsView
extends ViewGroup {
    private static final String TAG = "PanelsView";
    private boolean sxs = false;
    private WindowManager wm;
    private int panel_width;
    private View lv;
    private View rv;
    private View dv;
    private View ls;
    private View rs;

    public PanelsView(Context context) {
        super(context);
    }

    public PanelsView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void init(WindowManager wm_) {
        this.wm = wm_;
        this.lv = this.findViewById(2131230776);
        this.rv = this.findViewById(2131230779);
        this.dv = this.findViewById(2131230777);
        this.ls = this.findViewById(2131230775);
        this.rs = this.findViewById(2131230778);
        DisplayMetrics dm = new DisplayMetrics();
        this.wm.getDefaultDisplay().getMetrics(dm);
        if (dm.density <= 1.0f) {
            this.ls.setVisibility(8);
            this.rs.setVisibility(8);
            this.ls = null;
            this.rs = null;
        }
    }

    public void setMode(boolean sxs_) {
        this.sxs = sxs_;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int av_h = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.panel_width = this.wm.getDefaultDisplay().getWidth();
        if (this.sxs) {
            this.panel_width /= 2;
            --this.panel_width;
        } else {
            this.panel_width -= 4;
        }
        int w_spec = View.MeasureSpec.makeMeasureSpec((int)this.panel_width, (int)0x40000000);
        int h_spec = View.MeasureSpec.makeMeasureSpec((int)(av_h - 10), (int)0x40000000);
        if (this.ls != null && this.rs != null) {
            this.ls.measure(w_spec, View.MeasureSpec.makeMeasureSpec((int)(av_h / 10), (int)Integer.MIN_VALUE));
            this.rs.measure(w_spec, View.MeasureSpec.makeMeasureSpec((int)(av_h / 10), (int)Integer.MIN_VALUE));
        }
        this.lv.measure(w_spec, h_spec);
        this.dv.measure(View.MeasureSpec.makeMeasureSpec((int)1, (int)0x40000000), heightMeasureSpec);
        this.rv.measure(w_spec, h_spec);
        this.setMeasuredDimension(PanelsView.resolveSize((int)(this.panel_width * 2 + 1), (int)widthMeasureSpec), PanelsView.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        try {
            int stat_h = this.ls != null && this.rs != null ? this.ls.getMeasuredHeight() : 0;
            this.lv.layout(l, t, this.panel_width, b - stat_h);
            if (this.ls != null) {
                this.ls.layout(l, b - stat_h, this.panel_width, b);
            }
            this.dv.layout(l + this.panel_width, t, l + this.panel_width + 1, b);
            this.rv.layout(l + this.panel_width + 1, t, r, b - stat_h);
            if (this.rs != null) {
                this.rs.layout(l + this.panel_width + 1, b - stat_h, r, b);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
    }
}

