/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.example.touch.TouchImageView;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.util.List;

public class PictureViewer
extends Activity
implements View.OnTouchListener {
    private static final String TAG = "PictureViewerActivity";
    public ImageView image_view;
    public TextView name_view;
    public boolean touch = false;
    public CommanderAdapter ca;
    public int ca_pos = -1;
    public Handler h = new Handler();
    public ProgressDialog pd;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.requestWindowFeature(1);
            this.touch = Build.VERSION.SDK_INT >= 8;
            FrameLayout fl = new FrameLayout((Context)this);
            this.image_view = this.touch ? new TouchImageView((Context)this) : new ImageView((Context)this);
            fl.addView((View)this.image_view);
            SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this);
            String fnt_sz_s = sharedPref.getString("font_size", "12");
            int fnt_sz = 12;
            try {
                fnt_sz = Integer.parseInt(fnt_sz_s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.name_view = new TextView((Context)this);
            this.name_view.setTextColor(-1);
            this.name_view.setTextSize((float)fnt_sz);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-2, -2, 1);
            this.name_view.setLayoutParams((ViewGroup.LayoutParams)lp);
            fl.addView((View)this.name_view);
            this.setContentView((View)fl);
            this.image_view.setOnTouchListener((View.OnTouchListener)this);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void onLowMemory() {
        Log.w((String)TAG, (String)"Low Memory!");
        super.onLowMemory();
    }

    protected void onStart() {
        super.onStart();
        Intent intent = this.getIntent();
        Uri uri = intent.getData();
        if (uri == null) {
            return;
        }
        Log.d((String)TAG, (String)("uri=" + uri));
        this.ca_pos = intent.getIntExtra("position", -1);
        Log.d((String)TAG, (String)("orig pos=" + this.ca_pos));
        String name_to_show = null;
        String scheme = uri.getScheme();
        if (!"content".equals(scheme)) {
            this.ca = CA.CreateAdapterInstance(scheme, (Context)this);
            if (this.ca == null) {
                return;
            }
            this.ca.Init(new CommanderStub());
            Credentials crd = null;
            try {
                crd = (Credentials)intent.getParcelableExtra(Credentials.KEY);
                this.ca.setCredentials(crd);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"on taking credentials from parcel", (Throwable)e);
            }
            Uri.Builder ub = uri.buildUpon();
            Uri p_uri = null;
            if ("zip".equals(scheme)) {
                String cur = uri.getFragment();
                File cur_f = new File(cur);
                name_to_show = cur_f.getName();
                String parent_dir = cur_f.getParent();
                p_uri = uri.buildUpon().fragment(parent_dir != null ? parent_dir : "").build();
            } else {
                ub.path("/");
                List ps = uri.getPathSegments();
                int n = ps.size();
                if (n > 0) {
                    --n;
                }
                for (int i = 0; i < n; ++i) {
                    ub.appendPath((String)ps.get(i));
                }
                p_uri = ub.build();
                name_to_show = (String)ps.get(ps.size() - 1);
            }
            if (p_uri != null) {
                Log.d((String)TAG, (String)"do read list");
                this.ca.readSource(p_uri, null);
                Log.d((String)TAG, (String)"end reading");
            }
        }
        new LoaderThread(uri, name_to_show).start();
    }

    protected void onStop() {
        super.onStop();
        if (this.ca != null) {
            this.ca.prepareToDestroy();
            this.ca = null;
        }
    }

    public void setBitmapToView(Bitmap bmp, String name) {
        try {
            Log.v((String)TAG, (String)"Bitmap is ready");
            this.hideWait();
            if (bmp != null) {
                if (this.touch) {
                    ((TouchImageView)this.image_view).init();
                }
                this.image_view.setImageBitmap(bmp);
                this.image_view.requestLayout();
                this.image_view.invalidate();
                if (this.touch) {
                    ((TouchImageView)this.image_view).setMaxZoom(4.0f);
                }
                this.name_view.setTextColor(-1);
                this.name_view.setText((CharSequence)name);
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public final void showWait() {
        if (this.pd == null) {
            this.pd = ProgressDialog.show((Context)this, (CharSequence)"", (CharSequence)this.getString(2131361988), (boolean)true, (boolean)true);
        }
    }

    public final void hideWait() {
        if (this.pd != null) {
            this.pd.cancel();
        }
        this.pd = null;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.touch && ((TouchImageView)this.image_view).onTouch(v, event)) {
            return true;
        }
        if (event.getAction() == 1) {
            boolean to_next = event.getX() > (float)(this.image_view.getWidth() / 2);
            this.LoadNext(to_next);
            return true;
        }
        this.image_view.performClick();
        return false;
    }

    private void LoadNext(boolean forward) {
        String name;
        Uri pos_uri;
        String mime;
        if (this.ca_pos < 0 || this.ca == null) {
            Log.e((String)TAG, (String)("ca=" + this.ca + ", pos=" + this.ca_pos));
            return;
        }
        int orig_pos = this.ca_pos;
        do {
            this.ca_pos = forward ? ++this.ca_pos : --this.ca_pos;
            if (this.ca_pos <= 0) {
                this.ca_pos = orig_pos;
                return;
            }
            pos_uri = this.ca.getItemUri(this.ca_pos);
            if (pos_uri == null) {
                this.ca_pos = orig_pos;
                return;
            }
            name = this.ca.getItemName(this.ca_pos, false);
            mime = Utils.getMimeByExt(Utils.getFileExt(name));
            Log.d((String)TAG, (String)("Next name: " + name + " mime: " + mime));
        } while (!mime.startsWith("image/"));
        Log.d((String)TAG, (String)("new pos=" + this.ca_pos));
        this.name_view.setTextColor(-7829368);
        this.name_view.setText((CharSequence)this.getString(2131361903));
        new LoaderThread(pos_uri, name).start();
    }

    private class CommanderStub
    implements Commander {
        private CommanderStub() {
        }

        public Context getContext() {
            return PictureViewer.this;
        }

        public void issue(Intent in, int ret) {
        }

        public void showError(String msg) {
        }

        public void showInfo(String msg) {
        }

        public void showDialog(int dialog_id) {
        }

        public void Navigate(Uri uri, Credentials crd, String positionTo) {
        }

        public void dispatchCommand(int id2) {
        }

        public void Open(Uri uri, Credentials crd) {
        }

        public int getResolution() {
            return 0;
        }

        public boolean notifyMe(Message m) {
            return false;
        }

        public boolean startEngine(Engine e) {
            return false;
        }
    }

    private class LoaderThread
    extends Thread {
        private Context ctx;
        private byte[] buf;
        private Uri u;
        private Bitmap bmp;
        private String name_to_show = null;

        LoaderThread(Uri u_, String name_) {
            this.ctx = PictureViewer.this;
            this.u = u_;
            this.name_to_show = name_;
            this.setName("PictureLoader");
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 22[FORLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

