/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.widget.AdapterView;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.utils.Credentials;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public interface CommanderAdapter {
    public static final int MODE_WIDTH = 1;
    public static final int NARROW_MODE = 0;
    public static final int WIDE_MODE = 1;
    public static final int MODE_DETAILS = 2;
    public static final int SIMPLE_MODE = 0;
    public static final int DETAILED_MODE = 2;
    public static final int MODE_FINGERF = 4;
    public static final int SLIM_MODE = 0;
    public static final int FAT_MODE = 4;
    public static final int MODE_HIDDEN = 8;
    public static final int SHOW_MODE = 0;
    public static final int HIDE_MODE = 8;
    public static final int MODE_SORTING = 48;
    public static final int SORT_NAME = 0;
    public static final int SORT_SIZE = 16;
    public static final int SORT_DATE = 32;
    public static final int SORT_EXT = 48;
    public static final int MODE_SORT_DIR = 64;
    public static final int SORT_ASC = 0;
    public static final int SORT_DSC = 64;
    public static final int MODE_CASE = 128;
    public static final int CASE_SENS = 0;
    public static final int CASE_IGNORE = 128;
    public static final int MODE_ATTR = 768;
    public static final int NO_ATTR = 0;
    public static final int SHOW_ATTR = 256;
    public static final int ATTR_ONLY = 512;
    public static final int MODE_ROOT = 1024;
    public static final int BASIC_MODE = 0;
    public static final int ROOT_MODE = 1024;
    public static final int MODE_ICONS = 12288;
    public static final int TEXT_MODE = 0;
    public static final int ICON_MODE = 4096;
    public static final int ICON_TINY = 8192;
    public static final int LIST_STATE = 65536;
    public static final int STATE_IDLE = 0;
    public static final int STATE_BUSY = 65536;
    public static final int MODE_CLONE = 131072;
    public static final int NORMAL_MODE = 0;
    public static final int CLONE_MODE = 131072;
    public static final int SET_TBN_SIZE = 0x1000000;
    public static final int SET_FONT_SIZE = 0x2000000;
    public static final int MODE_COPY = 0;
    public static final int MODE_MOVE = 1;
    public static final int MODE_DEL_SRC_DIR = 2;
    public static final int MODE_MOVE_DEL_SRC_DIR = 3;

    public void Init(Commander var1);

    public String getScheme();

    public void setUri(Uri var1);

    public Uri getUri();

    public int setMode(int var1, int var2);

    public void populateContextMenu(ContextMenu var1, AdapterView.AdapterContextMenuInfo var2, int var3);

    public boolean hasFeature(Feature var1);

    public void setCredentials(Credentials var1);

    public Credentials getCredentials();

    public boolean readSource(Uri var1, String var2);

    public void openItem(int var1);

    public String getItemName(int var1, boolean var2);

    public Uri getItemUri(int var1);

    public void reqItemsSize(SparseBooleanArray var1);

    public boolean renameItem(int var1, String var2, boolean var3);

    public boolean copyItems(SparseBooleanArray var1, CommanderAdapter var2, boolean var3);

    public boolean receiveItems(String[] var1, int var2);

    public Engines.IReciever getReceiver();

    public Item getItem(Uri var1);

    public InputStream getContent(Uri var1, long var2);

    public InputStream getContent(Uri var1);

    public OutputStream saveContent(Uri var1);

    public void closeStream(Closeable var1);

    public boolean createFile(String var1);

    public void createFolder(String var1);

    public boolean deleteItems(SparseBooleanArray var1);

    public void doIt(int var1, SparseBooleanArray var2);

    public boolean handleActivityResult(int var1, int var2, Intent var3);

    public void terminateOperation();

    public void prepareToDestroy();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        FS,
        LOCAL,
        REAL,
        F1,
        F2,
        F3,
        F4,
        SF4,
        F5,
        F6,
        F7,
        F8,
        F9,
        F10,
        EQ,
        TGL,
        SZ,
        SORTING,
        BY_NAME,
        BY_EXT,
        BY_SIZE,
        BY_DATE,
        SEL_UNS,
        ENTER,
        ADD_FAV,
        REMOUNT,
        HOME,
        FAVS,
        SDCARD,
        ROOT,
        MOUNT,
        HIDDEN,
        REFRESH,
        SOFTKBD,
        SEARCH,
        MENU,
        SEND,
        CHKBL,
        SCROLL;

    }

    public static class Item {
        public String name = "";
        public Date date = null;
        public long size = -1L;
        public boolean dir = false;
        public boolean sel = false;
        public String attr = "";
        public Object origin = null;
        public int icon_id = -1;
        private Drawable thumbnail;
        private long thumbnailUsed;
        public int colorCache = 0;
        public boolean need_thumb = false;
        public boolean no_thumb = false;
        public boolean thumb_is_icon = false;
        public boolean thumb_pending = false;

        public Item() {
        }

        public Item(String name_) {
            this.name = name_;
        }

        public final boolean isThumbNail() {
            return this.thumbnail != null;
        }

        public final Drawable getThumbNail() {
            this.thumbnailUsed = System.currentTimeMillis();
            return this.thumbnail;
        }

        public final void setThumbNail(Drawable t) {
            this.thumbnailUsed = System.currentTimeMillis();
            this.thumbnail = t;
            this.thumb_pending = false;
        }

        public final void setIcon(Drawable t) {
            this.setThumbNail(t);
            this.thumb_is_icon = true;
        }

        public final boolean remThumbnailIfOld(int ttl) {
            if (this.thumbnail != null && !this.need_thumb && System.currentTimeMillis() - this.thumbnailUsed > (long)ttl) {
                this.thumbnail = null;
                return true;
            }
            return false;
        }
    }
}

