/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.widget.AdapterView;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.EditFTPPermissions;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.adapters.FTPEngines;
import com.ghostsq.commander.favorites.Favorite;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.FTP;
import com.ghostsq.commander.utils.LsItem;
import com.ghostsq.commander.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class FTPAdapter
extends CommanderAdapterBase
implements Engines.IReciever {
    private static final String TAG = "FTPAdapter";
    public FTP ftp = new FTP();
    public Uri uri = null;
    public LsItem[] items = null;
    private Timer heartBeat;
    public boolean noHeartBeats = false;
    public FTPCredentials theUserPass = null;
    private static final int CHMOD_CMD = 36793;

    public FTPAdapter(Context ctx_) {
        super(ctx_);
    }

    public void Init(Commander c) {
        super.Init(c);
    }

    public String getScheme() {
        return "ftp";
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case REAL: {
                return true;
            }
        }
        return super.hasFeature(feature);
    }

    protected int getPredictedAttributesLength() {
        return 25;
    }

    public void setCredentials(Credentials crd) {
        this.theUserPass = crd != null ? new FTPCredentials(crd) : null;
    }

    public Credentials getCredentials() {
        if (this.theUserPass == null || this.theUserPass.isNotSet()) {
            return null;
        }
        return this.theUserPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readSource(Uri tmp_uri, String pass_back_on_done) {
        try {
            boolean need_reconnect = false;
            if (tmp_uri != null) {
                String new_user_info = tmp_uri.getUserInfo();
                if (this.uri == null) {
                    need_reconnect = true;
                } else if (!tmp_uri.getHost().equalsIgnoreCase(this.uri.getHost())) {
                    need_reconnect = true;
                    if (this.theUserPass != null && !this.theUserPass.dirty) {
                        this.theUserPass = null;
                    }
                } else if (new_user_info != null) {
                    if (this.theUserPass == null) {
                        need_reconnect = true;
                    } else if (this.theUserPass != null && !this.theUserPass.equals((Object)new FTPCredentials(new_user_info))) {
                        need_reconnect = true;
                    }
                } else if (this.theUserPass != null) {
                    need_reconnect = this.theUserPass.dirty;
                }
                if (this.uri != null) {
                    Uri uri = this.uri;
                    synchronized (uri) {
                        this.setUri(tmp_uri);
                    }
                } else {
                    this.setUri(tmp_uri);
                }
            } else if (this.uri == null) {
                return false;
            }
            if (this.reader != null) {
                Log.w((String)TAG, (String)"reader's existed!");
                if (this.reader.isAlive()) {
                    Log.e((String)TAG, (String)"reader's busy!");
                    return false;
                }
            }
            if (this.items == null) {
                this.numItems = 1;
            }
            this.notify(-1);
            Log.v((String)TAG, (String)"Creating and starting the reader...");
            this.reader = new ListEngine(this.readerHandler, need_reconnect, pass_back_on_done);
            this.reader.start();
            if (this.heartBeat == null) {
                this.heartBeat = new Timer("FTP Heartbeat", true);
                this.heartBeat.schedule((TimerTask)new Noop(), 120000L, 40000L);
            }
            return true;
        }
        catch (Exception e) {
            this.commander.showError(e.getLocalizedMessage());
            e.printStackTrace();
            this.notify(this.ftp.getLog(), -2);
            return false;
        }
    }

    protected void onReadComplete() {
        Log.v((String)TAG, (String)("UI thread finishes the items obtaining. reader=" + this.reader));
        if (this.reader instanceof ListEngine) {
            ListEngine list_engine = (ListEngine)this.reader;
            this.items = null;
            if ((this.mode & 8) == 8) {
                LsItem[] tmp_items = list_engine.getItems();
                if (tmp_items != null) {
                    int cnt = 0;
                    for (int i = 0; i < tmp_items.length; ++i) {
                        if (tmp_items[i].getName().charAt(0) == '.') continue;
                        ++cnt;
                    }
                    this.items = new LsItem[cnt];
                    int j = 0;
                    for (int i = 0; i < tmp_items.length; ++i) {
                        if (tmp_items[i].getName().charAt(0) == '.') continue;
                        this.items[j++] = tmp_items[i];
                    }
                }
            } else {
                this.items = list_engine.getItems();
            }
            this.numItems = this.items != null ? this.items.length + 1 : 1;
            this.notifyDataSetChanged();
            if (this.theUserPass != null) {
                this.theUserPass.dirty = false;
            }
        }
    }

    public String toString() {
        if (this.uri == null) {
            return "";
        }
        String ui = this.uri.getUserInfo();
        if (ui != null && this.theUserPass == null) {
            return Favorite.screenPwd(this.uri);
        }
        if (this.theUserPass == null || this.theUserPass.isNotSet()) {
            return this.uri.toString();
        }
        return Favorite.screenPwd(Utils.getUriWithAuth(this.uri, this.theUserPass));
    }

    public Uri getUri() {
        return Utils.updateUserInfo(this.uri, null);
    }

    private final void setFTPMode(Uri uri_) {
        String active_s = uri_.getQueryParameter("a");
        boolean a_set = Utils.str(active_s);
        if ((this.mode & 0x20000) == 0 || a_set) {
            this.ftp.setActiveMode(a_set && ("1".equals(active_s) || "true".equals(active_s) || "yes".equals(active_s)));
        }
        String charset_s = uri_.getQueryParameter("e");
        boolean e_set = Utils.str(charset_s);
        if ((this.mode & 0x20000) == 0 || e_set) {
            Charset charset = null;
            try {
                charset = Charset.forName(charset_s);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ftp.setCharset(charset);
        }
    }

    public void setUri(Uri uri_) {
        this.uri = uri_;
        try {
            this.setFTPMode(this.uri);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Uri: " + uri_), (Throwable)e);
        }
    }

    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        try {
            super.populateContextMenu(menu2, acmi, num);
            if (acmi.position > 0) {
                menu2.add(0, 36793, 0, 2131362197);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, null, (Throwable)e);
        }
    }

    public void doIt(int command_id, SparseBooleanArray cis) {
        try {
            if (36793 == command_id) {
                boolean selected_one;
                LsItem[] items_todo = this.bitsToItems(cis);
                boolean bl = selected_one = items_todo != null && items_todo.length > 0 && items_todo[0] != null;
                if (selected_one) {
                    Intent i = new Intent(this.ctx, EditFTPPermissions.class);
                    i.putExtra("perm", items_todo[0].getAttr());
                    i.putExtra("path", Utils.mbAddSl(this.uri.getPath()) + items_todo[0].getName());
                    i.putExtra("uri", (Parcelable)Utils.getUriWithAuth(this.uri, this.theUserPass));
                    this.commander.issue(i, 695);
                } else {
                    this.commander.showError(this.commander.getContext().getString(2131362038));
                }
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Can't do the command " + command_id), (Throwable)e);
        }
    }

    public void reqItemsSize(SparseBooleanArray cis) {
        try {
            LsItem[] subItems = this.bitsToItems(cis);
            this.notify(-1);
            FTPEngines.CalcSizesEngine cse = new FTPEngines.CalcSizesEngine(this.commander, this.theUserPass, this.uri, subItems, this.ftp.getActiveMode(), this.ftp.getCharset());
            this.commander.startEngine(cse);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        String err_msg = null;
        try {
            Uri to_uri;
            LsItem[] subItems = this.bitsToItems(cis);
            if (subItems == null) {
                this.notify(this.s(2131361955), -2);
                return false;
            }
            if (!this.checkReadyness()) {
                return false;
            }
            Engines.IReciever recipient = null;
            File dest = null;
            if (move && to instanceof FTPAdapter && subItems.length == 1 && !subItems[0].isDirectory() && (to_uri = to.getUri()).getHost().equalsIgnoreCase(this.uri.getHost())) {
                this.notify(-1);
                String loc_name = subItems[0].getName();
                String old_name = Utils.mbAddSl(this.uri.getPath()) + loc_name;
                String new_name = Utils.mbAddSl(to_uri.getPath()) + loc_name;
                FTPEngines.RenEngine re = new FTPEngines.RenEngine(this.ctx, this.theUserPass, this.uri, old_name, new_name, this.ftp.getActiveMode(), this.ftp.getCharset());
                this.commander.startEngine(re);
                return true;
            }
            if (to instanceof FSAdapter) {
                dest = new File(to.toString());
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (!dest.isDirectory()) {
                    throw new RuntimeException(this.s(2131361959));
                }
            } else {
                dest = new File(this.createTempDir());
                recipient = to.getReceiver();
            }
            this.notify(-1);
            FTPEngines.CopyFromEngine cfe = new FTPEngines.CopyFromEngine(this.commander, this.theUserPass, this.uri, subItems, dest, move, recipient, this.ftp.getActiveMode(), this.ftp.getCharset());
            this.commander.startEngine(cfe);
            return true;
        }
        catch (Exception e) {
            err_msg = e.getLocalizedMessage();
            this.notify(err_msg, -2);
            return false;
        }
    }

    public boolean createFile(String fileURI) {
        this.notify("Operation not supported on a FTP folder.", -2);
        return false;
    }

    public void createFolder(String name) {
        this.notify(-1);
        this.commander.startEngine(new MkDirEngine(name));
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        try {
            if (!this.checkReadyness()) {
                return false;
            }
            LsItem[] subItems = this.bitsToItems(cis);
            if (subItems != null) {
                this.notify(-1);
                this.commander.startEngine(new FTPEngines.DelEngine(this.ctx, this.theUserPass, this.uri, subItems, this.ftp.getActiveMode(), this.ftp.getCharset()));
                return true;
            }
        }
        catch (Exception e) {
            this.commander.showError(e.getLocalizedMessage());
        }
        return false;
    }

    public Uri getItemUri(int position) {
        Uri u = this.getUri();
        if (u == null) {
            return null;
        }
        return u.buildUpon().appendEncodedPath(this.getItemName(position, false)).build();
    }

    public String getItemName(int position, boolean full) {
        if (this.items != null && position > 0 && position <= this.items.length) {
            String path;
            if (full && (path = this.toString()) != null && path.length() > 0) {
                if (path.charAt(path.length() - 1) != SLC) {
                    path = path + SLS;
                }
                return path + this.items[position - 1].getName();
            }
            return this.items[position - 1].getName();
        }
        return null;
    }

    public void openItem(int position) {
        if (position == 0) {
            String path;
            int len_;
            if (this.uri != null && this.parentLink != SLS && (len_ = (path = this.uri.getPath()).length() - 1) > 0) {
                if (path.charAt(len_) == SLC) {
                    path = path.substring(0, len_);
                }
                if ((path = path.substring(0, path.lastIndexOf(SLC))).length() == 0) {
                    path = SLS;
                }
                this.commander.Navigate(this.uri.buildUpon().path(path).build(), null, this.uri.getLastPathSegment());
            }
            return;
        }
        if (this.items == null || position < 0 || position > this.items.length) {
            return;
        }
        LsItem item = this.items[position - 1];
        if (item.isDirectory()) {
            String cur = this.uri.getPath();
            if (cur == null || cur.length() == 0) {
                cur = SLS;
            } else if (cur.charAt(cur.length() - 1) != SLC) {
                cur = cur + SLS;
            }
            Uri item_uri = this.uri.buildUpon().appendEncodedPath(item.getName()).build();
            this.commander.Navigate(item_uri, null, null);
        } else {
            Uri auth_item_uri = this.getUri().buildUpon().appendEncodedPath(item.getName()).build();
            this.commander.Open(auth_item_uri, this.theUserPass);
        }
    }

    public boolean receiveItems(String[] uris, int move_mode) {
        try {
            if (uris == null || uris.length == 0) {
                this.notify(this.s(2131361955), -2);
                return false;
            }
            File[] list = Utils.getListOfFiles(uris);
            if (list == null) {
                this.notify("Something wrong with the files", -2);
                return false;
            }
            this.notify(-1);
            boolean move = (move_mode & 1) != 0;
            boolean del_src_dir = (move_mode & 2) != 0;
            this.commander.startEngine(new FTPEngines.CopyToEngine(this.ctx, this.theUserPass, this.uri, list, move, del_src_dir, this.ftp.getActiveMode(), this.ftp.getCharset()));
            return true;
        }
        catch (Exception e) {
            this.notify(e.getLocalizedMessage(), -2);
            return false;
        }
    }

    public boolean renameItem(int position, String new_name, boolean copy) {
        try {
            if (copy) {
                this.notify(this.s(2131362037), -2);
            }
            if (this.items == null || position <= 0 || position > this.items.length) {
                return false;
            }
            String old_name = this.getItemName(position, false);
            if (old_name != null) {
                this.notify(-1);
                FTPEngines.RenEngine re = new FTPEngines.RenEngine(this.ctx, this.theUserPass, this.uri, old_name, new_name, this.ftp.getActiveMode(), this.ftp.getCharset());
                this.commander.startEngine(re);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void prepareToDestroy() {
        if (this.heartBeat != null) {
            this.heartBeat.cancel();
            this.heartBeat.purge();
            this.heartBeat = null;
        }
        super.prepareToDestroy();
        new Thread(new Runnable(){

            public void run() {
                FTPAdapter.this.ftp.disconnect(false);
            }
        }, "FTP disconnect").start();
        this.items = null;
    }

    public Object getItem(int position) {
        CommanderAdapter.Item item = new CommanderAdapter.Item();
        item.name = "???";
        if (position == 0) {
            item.name = this.parentLink;
        } else if (this.items != null && position > 0 && position <= this.items.length) {
            LsItem ls_item = this.items[position - 1];
            item.dir = ls_item.isDirectory();
            item.name = item.dir ? SLS + ls_item.getName() : ls_item.getName();
            String lnk = ls_item.getLinkTarget();
            if (lnk != null) {
                item.name = item.name + " -> " + lnk;
                if (!item.dir) {
                    item.icon_id = 2130837527;
                }
            }
            item.size = !item.dir || ls_item.length() > 0L ? ls_item.length() : -1L;
            item.date = ls_item.getDate();
            item.attr = ls_item.getAttr();
        }
        return item;
    }

    private final LsItem[] bitsToItems(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                ++counter;
            }
            LsItem[] subItems = new LsItem[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                subItems[j++] = this.items[cis.keyAt(i) - 1];
            }
            return subItems;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            return null;
        }
    }

    private final boolean checkReadyness() {
        if (!this.ftp.isLoggedIn()) {
            this.notify(this.s(2131362062), -2);
            return false;
        }
        return true;
    }

    protected void reSort() {
        if (this.items == null || this.items.length < 1) {
            return;
        }
        LsItem lsItem = this.items[0];
        lsItem.getClass();
        LsItem.LsItemPropComparator comp = lsItem.new LsItem.LsItemPropComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Arrays.sort(this.items, comp);
    }

    public CommanderAdapter.Item getItem(Uri u) {
        try {
            this.setFTPMode(u);
            if (this.theUserPass == null || this.theUserPass.isNotSet()) {
                this.theUserPass = new FTPCredentials(u.getUserInfo());
            }
            if (this.ftp.connectAndLogin(u, this.theUserPass.getUserName(), this.theUserPass.getPassword(), false) > 0) {
                List segs = u.getPathSegments();
                if (segs.size() == 0) {
                    CommanderAdapter.Item item = new CommanderAdapter.Item("/");
                    item.dir = true;
                    return item;
                }
                String prt_path = "";
                for (int i = 0; i < segs.size() - 1; ++i) {
                    prt_path = prt_path + "/" + (String)segs.get(i);
                }
                LsItem[] subItems = this.ftp.getDirList(prt_path, true);
                if (subItems != null) {
                    String fn = (String)segs.get(segs.size() - 1);
                    for (int i = 0; i < subItems.length; ++i) {
                        LsItem ls_item = subItems[i];
                        String ifn = ls_item.getName();
                        if (!fn.equals(ifn)) continue;
                        CommanderAdapter.Item item = new CommanderAdapter.Item(ifn);
                        item.size = ls_item.length();
                        item.date = ls_item.getDate();
                        item.dir = ls_item.isDirectory();
                        return item;
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream getContent(Uri u, long skip) {
        try {
            if (this.uri != null && !this.uri.getHost().equals(u.getHost())) {
                return null;
            }
            if (this.theUserPass == null || this.theUserPass.isNotSet()) {
                this.theUserPass = new FTPCredentials(u.getUserInfo());
            }
            this.setFTPMode(u);
            if (this.ftp.connectAndLogin(u, this.theUserPass.getUserName(), this.theUserPass.getPassword(), false) > 0) {
                this.noHeartBeats = true;
                return this.ftp.prepRetr(u.getPath(), skip);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)u.getPath(), (Throwable)e);
        }
        return null;
    }

    public OutputStream saveContent(Uri u) {
        try {
            if (this.uri != null && !this.uri.getHost().equals(u.getHost())) {
                return null;
            }
            if (this.theUserPass == null || this.theUserPass.isNotSet()) {
                this.theUserPass = new FTPCredentials(u.getUserInfo());
            }
            this.setFTPMode(u);
            if (this.ftp.connectAndLogin(u, this.theUserPass.getUserName(), this.theUserPass.getPassword(), false) > 0) {
                this.noHeartBeats = true;
                return this.ftp.prepStore(u.getPath());
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)u.getPath(), (Throwable)e);
        }
        return null;
    }

    public void closeStream(Closeable s) {
        try {
            this.noHeartBeats = false;
            if (s != null) {
                s.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Engines.IReciever getReceiver() {
        return this;
    }

    public static class FTPCredentials
    extends Credentials {
        public boolean dirty = true;

        public FTPCredentials(String userName, String password) {
            super(userName, password);
        }

        public FTPCredentials(String newUserInfo) {
            super(newUserInfo == null ? ":" : newUserInfo);
        }

        public FTPCredentials(Credentials c) {
            super(c);
        }

        public String getUserName() {
            String u = super.getUserName();
            return u == null || u.length() == 0 ? "anonymous" : u;
        }

        public String getPassword() {
            String u = super.getUserName();
            String p = u == null || u.length() == 0 ? "user@host.com" : super.getPassword();
            return p != null ? p : "";
        }

        public final boolean isNotSet() {
            String u = super.getUserName();
            if (u == null || u.length() == 0) {
                return true;
            }
            String p = super.getPassword();
            return p == null;
        }
    }

    class MkDirEngine
    extends Engine {
        private String name;

        MkDirEngine(String name_) {
            this.name = name_;
        }

        public void run() {
            FTPAdapter.this.ftp.clearLog();
            try {
                FTPAdapter.this.ftp.makeDir(this.name);
                this.sendResult("");
                return;
            }
            catch (Exception exception) {
                this.error(FTPAdapter.this.ctx.getString(2131362061, new Object[]{this.name, FTPAdapter.this.ftp.getLog()}));
                if (!this.noErrors()) {
                    this.sendResult("");
                } else {
                    this.sendRefrReq(this.name);
                }
                return;
            }
        }
    }

    class ListEngine
    extends Engine {
        private boolean needReconnect;
        private LsItem[] items_tmp;
        public String pass_back_on_done;

        ListEngine(Handler h, boolean need_reconnect_, String pass_back_on_done_) {
            this.setHandler(h);
            this.needReconnect = need_reconnect_;
            this.pass_back_on_done = pass_back_on_done_;
        }

        public LsItem[] getItems() {
            return this.items_tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            block22: {
                block21: {
                    Uri uri;
                    String path;
                    block19: {
                        int n;
                        block20: {
                            try {
                                try {
                                    int cl_res;
                                    if (FTPAdapter.this.uri == null) {
                                        this.sendProgress("Wrong URI", -2);
                                        Object var11_1 = null;
                                        super.run();
                                        return;
                                    }
                                    Log.i((String)this.TAG, (String)"ListEngine started");
                                    this.threadStartedAt = System.currentTimeMillis();
                                    FTPAdapter.this.ftp.clearLog();
                                    if (this.needReconnect && FTPAdapter.this.ftp.isLoggedIn()) {
                                        FTPAdapter.this.ftp.disconnect(false);
                                    }
                                    if (FTPAdapter.this.theUserPass == null || FTPAdapter.this.theUserPass.isNotSet()) {
                                        FTPAdapter.this.theUserPass = new FTPCredentials(FTPAdapter.this.uri.getUserInfo());
                                    }
                                    if ((cl_res = FTPAdapter.this.ftp.connectAndLogin(FTPAdapter.this.uri, FTPAdapter.this.theUserPass.getUserName(), FTPAdapter.this.theUserPass.getPassword(), true)) < 0) {
                                        if (cl_res == -2) {
                                            this.sendLoginReq(FTPAdapter.this.uri.toString(), FTPAdapter.this.theUserPass, this.pass_back_on_done);
                                        }
                                        Object var11_2 = null;
                                        super.run();
                                        return;
                                    }
                                    if (cl_res == 2) {
                                        this.sendProgress(FTPAdapter.this.ctx.getString(2131362059, new Object[]{FTPAdapter.this.uri.getHost(), FTPAdapter.this.theUserPass.getUserName()}), -1);
                                    }
                                    if (FTPAdapter.this.ftp.isLoggedIn()) {
                                        this.items_tmp = FTPAdapter.this.ftp.getDirList(null, (FTPAdapter.this.mode & 8) == 0);
                                        path = FTPAdapter.this.ftp.getCurrentDir();
                                        if (path == null) break block19;
                                        uri = this.items_tmp;
                                        n = ((LsItem[])uri).length;
                                        break block20;
                                    }
                                    Log.e((String)this.TAG, (String)"Did not log in.");
                                }
                                catch (UnknownHostException e) {
                                    FTPAdapter.this.ftp.debugPrint("Unknown host:\n" + e.getLocalizedMessage());
                                    Object var11_5 = null;
                                    super.run();
                                    break block22;
                                }
                                catch (IOException e) {
                                    FTPAdapter.this.ftp.debugPrint("IO exception:\n" + e.getLocalizedMessage());
                                    Log.e((String)this.TAG, (String)"", (Throwable)e);
                                    Object var11_6 = null;
                                    super.run();
                                    break block22;
                                }
                                catch (Exception e) {
                                    FTPAdapter.this.ftp.debugPrint(e.getLocalizedMessage());
                                    Log.e((String)this.TAG, (String)"", (Throwable)e);
                                    Object var11_7 = null;
                                    super.run();
                                    break block22;
                                }
                                break block21;
                            }
                            catch (Throwable throwable) {
                                Object var11_8 = null;
                                super.run();
                                throw throwable;
                            }
                        }
                        for (int i = 0; i < n; ++i) {
                            String lt;
                            Uri lsi = uri[i];
                            String name = lsi.getName();
                            if (name == null || !Utils.str(lt = lsi.getLinkTarget())) continue;
                            if (lt.charAt(0) != '/') {
                                lt = Utils.mbAddSl(path) + lt;
                            }
                            if (!FTPAdapter.this.ftp.setCurrentDir(lt)) continue;
                            lsi.setDirectory();
                        }
                    }
                    FTPAdapter.this.ftp.setCurrentDir(path);
                    uri = FTPAdapter.this.uri;
                    // MONITORENTER : uri
                    FTPAdapter.this.uri = FTPAdapter.this.uri.buildUpon().encodedPath(path).build();
                    // MONITOREXIT : uri
                    if (this.items_tmp != null) {
                        if (this.items_tmp.length > 0) {
                            LsItem lsItem = this.items_tmp[0];
                            lsItem.getClass();
                            LsItem.LsItemPropComparator comp = lsItem.new LsItem.LsItemPropComparator(FTPAdapter.this.mode & 0x30, (FTPAdapter.this.mode & 0x80) != 0, FTPAdapter.this.ascending);
                            Arrays.sort(this.items_tmp, comp);
                        }
                        FTPAdapter.this.parentLink = path == null || path.length() == 0 || path.equals(CommanderAdapterBase.SLS) ? CommanderAdapterBase.SLS : "..";
                        this.sendProgress(this.tooLong(8) ? FTPAdapter.this.ftp.getLog() : null, -3, this.pass_back_on_done);
                        Object var11_3 = null;
                        super.run();
                        return;
                    }
                    Log.e((String)this.TAG, (String)"Can't get the items list");
                }
                Object var11_4 = null;
                super.run();
            }
            FTPAdapter.this.ftp.disconnect(true);
            this.sendProgress(FTPAdapter.this.ftp.getLog(), -2, this.pass_back_on_done);
        }
    }

    class Noop
    extends TimerTask {
        Noop() {
        }

        public void run() {
            if (!FTPAdapter.this.noHeartBeats && FTPAdapter.this.reader == null && FTPAdapter.this.ftp.isLoggedIn()) {
                try {
                    FTPAdapter.this.ftp.heartBeat();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

