/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.widget.AdapterView;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.favorites.FavDialog;
import com.ghostsq.commander.favorites.Favorite;
import com.ghostsq.commander.utils.Credentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavsAdapter
extends CommanderAdapterBase {
    private static final String TAG = "FavsAdapter";
    private static final int CREATE_FAVE_SHORTCUT = 3423;
    private ArrayList<Favorite> favs = null;

    public FavsAdapter(Context ctx_) {
        super(ctx_, 770);
        this.numItems = 1;
    }

    @Override
    public String getScheme() {
        return "favs";
    }

    public void setFavorites(ArrayList<Favorite> favs_) {
        this.favs = favs_;
        this.numItems = this.favs.size() + 1;
    }

    @Override
    public int setMode(int mask, int val) {
        if ((mask & 0x303) == 0) {
            super.setMode(mask, val);
        }
        return this.mode;
    }

    @Override
    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case F2: 
            case F4: 
            case F8: 
            case SORTING: 
            case MOUNT: 
            case REFRESH: 
            case CHKBL: {
                return true;
            }
            case BY_DATE: 
            case ADD_FAV: 
            case FAVS: {
                return false;
            }
        }
        return super.hasFeature(feature);
    }

    public String toString() {
        return "favs:";
    }

    @Override
    public Uri getUri() {
        return Uri.parse((String)this.toString());
    }

    @Override
    public void setUri(Uri uri) {
    }

    @Override
    public boolean readSource(Uri tmp_uri, String pbod) {
        this.numItems = this.favs.size() + 1;
        this.notifyDataSetChanged();
        this.notify(pbod);
        return true;
    }

    @Override
    public void populateContextMenu(ContextMenu menu2, AdapterView.AdapterContextMenuInfo acmi, int num) {
        if (num <= 1) {
            menu2.add(0, 903, 0, (CharSequence)this.s(2131361893));
            menu2.add(0, 2131230721, 0, (CharSequence)this.s(2131361947));
            menu2.add(0, 2131230725, 0, (CharSequence)this.s(2131361940));
            menu2.add(0, 2131230733, 0, (CharSequence)this.s(2131361966));
            menu2.add(0, 3423, 0, (CharSequence)this.s(2131361864));
        }
    }

    @Override
    public void reqItemsSize(SparseBooleanArray cis) {
        this.notErr();
    }

    @Override
    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        return this.notErr();
    }

    @Override
    public boolean createFile(String fileURI) {
        return this.notErr();
    }

    @Override
    public void createFolder(String new_name) {
        this.notErr();
    }

    @Override
    public boolean deleteItems(SparseBooleanArray cis) {
        int i;
        ArrayList<Favorite> favs_to_remove = new ArrayList<Favorite>(this.numItems - 1);
        for (i = 0; i < cis.size(); ++i) {
            int k;
            if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
            favs_to_remove.add(this.favs.get(k - 1));
        }
        for (i = 0; i < favs_to_remove.size(); ++i) {
            this.favs.remove(favs_to_remove.get(i));
        }
        this.numItems = this.favs.size() + 1;
        this.notifyDataSetChanged();
        this.notify(-3);
        return true;
    }

    @Override
    public void openItem(int position) {
        if (position == 0) {
            this.commander.Navigate(Uri.parse((String)"home:"), null, null);
            return;
        }
        if (this.favs == null || position < 0 || position > this.numItems) {
            return;
        }
        Favorite f = this.favs.get(position - 1);
        if (f != null) {
            this.commander.Navigate(f.getUri(), f.getCredentials(), null);
        }
    }

    @Override
    public boolean receiveItems(String[] full_names, int move_mode) {
        return this.notErr();
    }

    @Override
    public boolean renameItem(int p, String newName, boolean c) {
        if (this.favs != null && p > 0 && p <= this.favs.size()) {
            this.favs.get(p - 1).setComment(newName);
            this.notifyDataSetChanged();
            return true;
        }
        return false;
    }

    @Override
    public void doIt(int command_id, SparseBooleanArray cis) {
        if (3423 == command_id) {
            int k = 0;
            int n = this.favs.size();
            for (int i = 0; i < cis.size(); ++i) {
                k = cis.keyAt(i);
                if (cis.valueAt(i) && k > 0 && k <= n) break;
            }
            if (k > 0) {
                this.createDesktopShortcut(this.favs.get(k - 1));
            }
        }
    }

    public void editItem(int p) {
        if (this.favs != null && p > 0 && p <= this.favs.size()) {
            new FavDialog(this.ctx, this.favs.get(p - 1), this);
        }
    }

    public void invalidate() {
        this.notifyDataSetChanged();
        this.notify(-3);
    }

    private final void createDesktopShortcut(Favorite f) {
        if (f == null) {
            return;
        }
        Uri uri = f.getUri();
        Intent shortcutIntent = new Intent();
        shortcutIntent.setClassName(this.ctx, this.commander.getClass().getName());
        shortcutIntent.setAction("android.intent.action.VIEW");
        shortcutIntent.setData(uri);
        Credentials crd = f.getCredentials();
        if (crd != null) {
            shortcutIntent.putExtra(Credentials.KEY, (Parcelable)crd);
        }
        Intent intent = new Intent();
        intent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)shortcutIntent);
        String name = f.getComment();
        if (name == null || name.length() == 0) {
            name = f.getUriString(true);
        }
        intent.putExtra("android.intent.extra.shortcut.NAME", name);
        int ic_id = CA.getDrawableIconId(uri != null ? uri.getScheme() : "");
        Intent.ShortcutIconResource iconResource = Intent.ShortcutIconResource.fromContext((Context)this.ctx, (int)ic_id);
        intent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)iconResource);
        intent.setAction("com.android.launcher.action.INSTALL_SHORTCUT");
        this.ctx.sendBroadcast(intent);
    }

    @Override
    public String getItemName(int p, boolean full) {
        if (this.favs != null && p > 0 && p <= this.favs.size()) {
            Favorite f = this.favs.get(p - 1);
            String comm = f.getComment();
            return comm != null && comm.length() > 0 ? comm : (full ? f.getUriString(true) : "");
        }
        return null;
    }

    public Object getItem(int position) {
        Favorite f;
        CommanderAdapter.Item item = new CommanderAdapter.Item();
        if (position == 0) {
            item = new CommanderAdapter.Item();
            item.name = this.parentLink;
            item.dir = true;
        } else if (this.favs != null && position > 0 && position <= this.favs.size() && (f = this.favs.get(position - 1)) != null) {
            item.dir = false;
            item.name = f.getUriString(true);
            item.size = -1L;
            item.sel = false;
            item.date = null;
            item.attr = f.getComment();
            Uri uri = f.getUri();
            item.icon_id = CA.getDrawableIconId(uri != null ? uri.getScheme() : "");
        }
        return item;
    }

    @Override
    protected void reSort() {
        if (this.favs == null) {
            return;
        }
        FavoriteComparator comp = new FavoriteComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Collections.sort(this.favs, comp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class FavoriteComparator
    implements Comparator<Favorite> {
        int type;
        boolean case_ignore;
        boolean ascending;

        public FavoriteComparator(int type_, boolean case_ignore_, boolean ascending_) {
            this.type = type_;
            this.case_ignore = case_ignore_;
            this.ascending = ascending_;
        }

        @Override
        public int compare(Favorite f1, Favorite f2) {
            if (f1 == null || f2 == null) {
                Log.w((String)FavsAdapter.TAG, (String)"a Fav is null!");
                return 0;
            }
            int ext_cmp = 0;
            switch (this.type) {
                case 48: {
                    String c2;
                    String c1 = f1.getComment();
                    if (c1 == null) {
                        c1 = "";
                    }
                    if ((c2 = f2.getComment()) == null) {
                        c2 = "";
                    }
                    ext_cmp = c1.compareTo(c2);
                    break;
                }
                case 16: {
                    ext_cmp = this.getWeight(f1.getUri()) - this.getWeight(f2.getUri()) > 0 ? 1 : -1;
                    break;
                }
            }
            if (ext_cmp == 0) {
                Uri u1 = f1.getUri();
                Uri u2 = f2.getUri();
                if (u1 != null) {
                    ext_cmp = u1.compareTo(u2);
                }
            }
            return this.ascending ? ext_cmp : -ext_cmp;
        }

        private int getWeight(Uri u) {
            int w = 0;
            if (u != null) {
                ++w;
                String s = u.getScheme();
                if (s != null) {
                    ++w;
                    if ("ftp".equals(s)) {
                        ++w;
                    } else if ("smb".equals(s)) {
                        w += 2;
                    }
                }
            }
            return w;
        }
    }
}

