/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.util.SparseBooleanArray;
import com.ghostsq.commander.Panels;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.http.util.EncodingUtils;

public class ZipAdapter
extends CommanderAdapterBase {
    public static final String TAG = "ZipAdapter";
    protected static final int BLOCK_SIZE = 100000;
    public Uri uri = null;
    public ZipFile zip = null;
    public ZipEntry[] items = null;
    private ZipEntry cachedEntry = null;

    public ZipAdapter(Context ctx_) {
        super(ctx_);
        this.parentLink = "..";
    }

    public String getScheme() {
        return "zip";
    }

    public boolean hasFeature(CommanderAdapter.Feature feature) {
        switch (feature) {
            case REAL: {
                return true;
            }
            case F4: 
            case SZ: {
                return false;
            }
        }
        return super.hasFeature(feature);
    }

    public boolean readSource(Uri tmp_uri, String pass_back_on_done) {
        try {
            if (tmp_uri != null) {
                this.uri = tmp_uri;
            }
            if (this.uri == null) {
                return false;
            }
            if (this.reader != null && this.reader.isAlive()) {
                this.commander.showInfo(this.ctx.getString(2131362034));
                this.reader.interrupt();
                Thread.sleep(500L);
                if (this.reader.isAlive()) {
                    return false;
                }
            }
            Log.v((String)TAG, (String)("reading " + this.uri));
            this.notify(-1);
            this.reader = new ListEngine(this.readerHandler, pass_back_on_done);
            this.reader.start();
            return true;
        }
        catch (Exception e) {
            this.commander.showError("Exception: " + e);
            e.printStackTrace();
            this.notify("Fail", -2);
            return false;
        }
    }

    protected void onReadComplete() {
        if (this.reader instanceof ListEngine) {
            ListEngine list_engine = (ListEngine)this.reader;
            ZipEntry[] tmp_items = list_engine.getItems();
            if (tmp_items != null && (this.mode & 8) == 8) {
                int cnt = 0;
                for (int i = 0; i < tmp_items.length; ++i) {
                    if (tmp_items[i].getName().charAt(0) == '.') continue;
                    ++cnt;
                }
                this.items = new ZipEntry[cnt];
                int j = 0;
                for (int i = 0; i < tmp_items.length; ++i) {
                    if (tmp_items[i].getName().charAt(0) == '.') continue;
                    this.items[j++] = tmp_items[i];
                }
            } else {
                this.items = tmp_items;
            }
            this.numItems = this.items != null ? this.items.length + 1 : 1;
            this.notifyDataSetChanged();
        }
    }

    public String toString() {
        return this.uri != null ? Uri.decode((String)this.uri.toString()) : "";
    }

    public Uri getUri() {
        return this.uri;
    }

    public void setUri(Uri uri_) {
        this.uri = uri_;
    }

    public void reqItemsSize(SparseBooleanArray cis) {
        this.notify("Not supported.", -2);
    }

    public boolean unpackZip(File zip_file) {
        try {
            if (!this.checkReadyness()) {
                return false;
            }
            this.zip = new ZipFile(zip_file);
            this.notify(-1);
            this.commander.startEngine(new CopyFromEngine(zip_file.getParentFile()));
            return true;
        }
        catch (Exception e) {
            this.notify("Exception: " + e.getMessage(), -2);
            return false;
        }
    }

    public boolean copyItems(SparseBooleanArray cis, CommanderAdapter to, boolean move) {
        try {
            if (this.zip == null) {
                throw new RuntimeException("Invalid ZIP");
            }
            ZipEntry[] subItems = this.bitsToItems(cis);
            if (subItems == null) {
                throw new RuntimeException("Nothing to extract");
            }
            if (!this.checkReadyness()) {
                return false;
            }
            Engines.IReciever recipient = null;
            File dest = null;
            if (to instanceof FSAdapter) {
                dest = new File(to.toString());
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (!dest.isDirectory()) {
                    throw new RuntimeException(this.ctx.getString(2131361959));
                }
            } else {
                dest = new File(this.createTempDir());
                recipient = to.getReceiver();
            }
            this.notify(-1);
            this.commander.startEngine(new CopyFromEngine(subItems, dest, recipient));
            return true;
        }
        catch (Exception e) {
            this.commander.showError("Exception: " + e.getMessage());
            return false;
        }
    }

    public boolean createFile(String fileURI) {
        this.notify("Operation not supported", -2);
        return false;
    }

    public void createFolder(String string2) {
        this.notify("Not supported", -2);
    }

    public boolean deleteItems(SparseBooleanArray cis) {
        try {
            if (!this.checkReadyness()) {
                return false;
            }
            ZipEntry[] to_delete = this.bitsToItems(cis);
            if (to_delete != null && this.zip != null && this.uri != null) {
                this.notify(-1);
                this.commander.startEngine(new DelEngine(new File(this.uri.getPath()), to_delete));
                return true;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"deleteItems()", (Throwable)e);
        }
        this.notify(null, -2);
        return false;
    }

    public Uri getItemUri(int position) {
        if (this.uri == null) {
            return null;
        }
        if (this.items == null || position > this.items.length) {
            return null;
        }
        return this.uri.buildUpon().encodedFragment(this.fixName(this.items[position - 1])).build();
    }

    public String getItemName(int position, boolean full) {
        if (this.items != null && position > 0 && position <= this.items.length) {
            if (full) {
                Uri item_uri;
                if (this.uri != null && (item_uri = this.getItemUri(position)) != null) {
                    return item_uri.toString();
                }
            } else {
                return new File(this.fixName(this.items[position - 1])).getName();
            }
        }
        return null;
    }

    public void openItem(int position) {
        if (position == 0) {
            if (this.uri == null) {
                return;
            }
            String cur = null;
            try {
                cur = this.uri.getFragment();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cur == null || cur.length() == 0 || cur.length() == 1 && cur.charAt(0) == SLC) {
                File zip_file = new File(this.uri.getPath());
                String parent_dir = Utils.escapePath(zip_file.getParent());
                this.commander.Navigate(Uri.parse((String)(parent_dir != null ? parent_dir : Panels.DEFAULT_LOC)), null, zip_file.getName());
            } else {
                File cur_f = new File(cur);
                String parent_dir = cur_f.getParent();
                this.commander.Navigate(this.uri.buildUpon().fragment(parent_dir != null ? parent_dir : "").build(), null, cur_f.getName());
            }
            return;
        }
        if (this.items == null || position < 0 || position > this.items.length) {
            return;
        }
        ZipEntry item = this.items[position - 1];
        if (item.isDirectory()) {
            this.commander.Navigate(this.uri.buildUpon().fragment(this.fixName(item)).build(), null, null);
        } else {
            this.commander.Open(this.uri.buildUpon().fragment(this.fixName(item)).build(), null);
        }
    }

    public boolean receiveItems(String[] uris, int move_mode) {
        try {
            if (!this.checkReadyness()) {
                return false;
            }
            if (uris == null || uris.length == 0) {
                this.notify(this.s(2131361955), -2);
                return false;
            }
            File[] list = Utils.getListOfFiles(uris);
            if (list == null) {
                this.notify("Something wrong with the files", -2);
                return false;
            }
            this.notify(-1);
            this.zip = null;
            this.items = null;
            this.commander.startEngine(new CopyToEngine(list, new File(this.uri.getPath()), this.uri.getFragment(), move_mode));
            return true;
        }
        catch (Exception e) {
            this.notify("Exception: " + e.getMessage(), -2);
            return false;
        }
    }

    public boolean createZip(File[] list, String zip_fn) {
        try {
            if (!this.checkReadyness()) {
                return false;
            }
            this.notify(-1);
            this.commander.startEngine(new CopyToEngine(list, new File(zip_fn)));
            return true;
        }
        catch (Exception e) {
            this.notify("Exception: " + e.getMessage(), -2);
            return false;
        }
    }

    public boolean renameItem(int position, String new_name, boolean copy) {
        ZipEntry to_rename = this.items[position - 1];
        if (to_rename != null && this.zip != null && Utils.str(new_name)) {
            this.notify(-1);
            RenameEngine eng = new RenameEngine(new File(this.uri.getPath()), to_rename, new_name, copy);
            this.commander.startEngine(eng);
            return true;
        }
        return false;
    }

    public void prepareToDestroy() {
        super.prepareToDestroy();
        this.items = null;
    }

    public Object getItem(int position) {
        CommanderAdapter.Item item = new CommanderAdapter.Item();
        item.name = "";
        if (position == 0) {
            item.name = this.parentLink;
        } else if (this.items != null && position > 0 && position <= this.items.length) {
            ZipEntry zip_entry = this.items[position - 1];
            item.dir = zip_entry.isDirectory();
            String name = this.fixName(zip_entry);
            int lsp = name.lastIndexOf(SLC, item.dir ? name.length() - 2 : name.length());
            item.name = lsp > 0 ? name.substring(lsp + 1) : name;
            item.size = zip_entry.getSize();
            long item_time = zip_entry.getTime();
            item.date = item_time > 0L ? new Date(item_time) : null;
        }
        return item;
    }

    private final String fixName(ZipEntry entry) {
        try {
            String entry_name = entry.getName();
            if (Build.VERSION.SDK_INT >= 10) {
                return entry_name;
            }
            byte[] ex = entry.getExtra();
            if (ex != null && ex.length == 2 && ex[0] == 1 && ex[1] == 2) {
                return entry_name;
            }
            byte[] bytes = EncodingUtils.getBytes((String)entry_name, (String)"iso-8859-1");
            return new String(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final ZipEntry[] bitsToItems(SparseBooleanArray cis) {
        try {
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                ++counter;
            }
            ZipEntry[] subItems = new ZipEntry[counter];
            int j = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i)) continue;
                subItems[j++] = this.items[cis.keyAt(i) - 1];
            }
            return subItems;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            return null;
        }
    }

    private final boolean checkReadyness() {
        return true;
    }

    protected void reSort() {
        if (this.items == null) {
            return;
        }
        ZipItemPropComparator comp = new ZipItemPropComparator(this.mode & 0x30, (this.mode & 0x80) != 0, this.ascending);
        Arrays.sort(this.items, comp);
    }

    public CommanderAdapter.Item getItem(Uri u) {
        try {
            ZipEntry zip_entry;
            String opened_zip_path;
            String zip_path = u.getPath();
            if (zip_path == null) {
                return null;
            }
            String string2 = opened_zip_path = this.uri != null ? this.uri.getPath() : null;
            if (opened_zip_path == null) {
                this.zip = new ZipFile(zip_path);
            } else if (!zip_path.equalsIgnoreCase(opened_zip_path)) {
                return null;
            }
            String entry_name = u.getFragment();
            if (entry_name != null && (zip_entry = this.zip.getEntry(entry_name)) != null) {
                String name = this.fixName(zip_entry);
                CommanderAdapter.Item item = new CommanderAdapter.Item();
                item.dir = zip_entry.isDirectory();
                int lsp = name.lastIndexOf(SLC, item.dir ? name.length() - 2 : name.length());
                item.name = lsp > 0 ? name.substring(lsp + 1) : name;
                item.size = zip_entry.getSize();
                long item_time = zip_entry.getTime();
                item.date = item_time > 0L ? new Date(item_time) : null;
                return item;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public InputStream getContent(Uri u, long offset) {
        try {
            String opened_zip_path;
            String zip_path = u.getPath();
            if (zip_path == null) {
                return null;
            }
            String string2 = opened_zip_path = this.uri != null ? this.uri.getPath() : null;
            if (opened_zip_path == null || this.zip == null) {
                this.zip = new ZipFile(zip_path);
            } else if (!zip_path.equalsIgnoreCase(opened_zip_path)) {
                return null;
            }
            String entry_name = u.getFragment();
            if (entry_name != null) {
                this.cachedEntry = this.zip.getEntry(entry_name);
                if (this.cachedEntry != null) {
                    InputStream is = this.zip.getInputStream(this.cachedEntry);
                    if (offset > 0L) {
                        is.skip(offset);
                    }
                    return is;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public void closeStream(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ZipItemPropComparator
    implements Comparator<ZipEntry> {
        int type;
        boolean case_ignore;
        boolean ascending;

        public ZipItemPropComparator(int type_, boolean case_ignore_, boolean ascending_) {
            this.type = type_;
            this.case_ignore = case_ignore_;
            this.ascending = ascending_;
        }

        @Override
        public int compare(ZipEntry f1, ZipEntry f2) {
            boolean f2IsDir;
            boolean f1IsDir = f1.isDirectory();
            if (f1IsDir != (f2IsDir = f2.isDirectory())) {
                return f1IsDir ? -1 : 1;
            }
            int ext_cmp = 0;
            switch (this.type) {
                case 48: {
                    ext_cmp = this.case_ignore ? Utils.getFileExt(f1.getName()).compareToIgnoreCase(Utils.getFileExt(f2.getName())) : Utils.getFileExt(f1.getName()).compareTo(Utils.getFileExt(f2.getName()));
                    break;
                }
                case 16: {
                    ext_cmp = f1.getSize() - f2.getSize() < 0L ? -1 : 1;
                    break;
                }
                case 32: {
                    int n = ext_cmp = f1.getTime() - f2.getTime() < 0L ? -1 : 1;
                }
            }
            if (ext_cmp == 0) {
                ext_cmp = this.case_ignore ? f1.getName().compareToIgnoreCase(f2.getName()) : f1.getName().compareTo(f2.getName());
            }
            return this.ascending ? ext_cmp : -ext_cmp;
        }
    }

    class RenameEngine
    extends Engine {
        private File zipFile;
        private ZipEntry ren_entry;
        private String new_name;
        private boolean copy = false;

        RenameEngine(File zipFile, ZipEntry ren_entry, String new_name, boolean copy) {
            this.zipFile = zipFile;
            this.ren_entry = ren_entry;
            this.new_name = new_name;
            this.copy = copy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ZipAdapter.this.zip == null) {
                return;
            }
            this.sendProgress(ZipAdapter.this.ctx.getString(2131361903), 1, 1);
            ZipAdapter zipAdapter = ZipAdapter.this;
            synchronized (zipAdapter) {
                block14: {
                    ZipAdapter.this.Init(null);
                    File old_file = new File(this.zipFile.getAbsolutePath() + "_tmp_" + new Date().getSeconds() + ".zip");
                    try {
                        ZipFile zf = new ZipFile(this.zipFile);
                        int processed = 0;
                        int num_entries = zf.size();
                        String old_flat_name = this.ren_entry.getName().replace("/", "");
                        String report_str = ZipAdapter.this.ctx.getString(2131361984, new Object[]{zf.getName()});
                        if (!this.zipFile.renameTo(old_file)) {
                            this.error("could not rename the file " + this.zipFile.getAbsolutePath() + " to " + old_file.getAbsolutePath());
                            break block14;
                        }
                        ZipInputStream zin = new ZipInputStream(new FileInputStream(old_file));
                        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.zipFile));
                        byte[] buf = new byte[100000];
                        ZipEntry entry = zin.getNextEntry();
                        while (entry != null && !this.isStopReq()) {
                            int len;
                            String name = entry.getName();
                            String flat_name = name.replace("/", "");
                            if (old_flat_name.equals(flat_name)) {
                                int sl_pos = name.lastIndexOf(47);
                                name = sl_pos >= 0 ? name.substring(0, sl_pos + 1) + this.new_name : this.new_name;
                            }
                            int pp = ++processed * 100 / num_entries;
                            out.putNextEntry(new ZipEntry(name));
                            long total_size = entry.getSize();
                            long bytes_saved = 0L;
                            while ((len = zin.read(buf)) > 0 && !this.isStopReq()) {
                                out.write(buf, 0, len);
                                this.sendProgress(report_str, pp, (int)((bytes_saved += (long)len) * 100L / total_size));
                            }
                            entry = zin.getNextEntry();
                        }
                        zin.close();
                        try {
                            out.close();
                        }
                        catch (Exception e) {
                            Log.e((String)this.TAG, (String)"", (Throwable)e);
                        }
                        if (this.isStopReq()) {
                            this.zipFile.delete();
                            old_file.renameTo(this.zipFile);
                            processed = 0;
                            this.error(ZipAdapter.this.s(2131361972));
                        } else {
                            old_file.delete();
                            ZipAdapter.this.zip = null;
                        }
                    }
                    catch (Exception e) {
                        this.error(e.getMessage());
                    }
                }
                this.sendResult(ZipAdapter.this.ctx.getString(2131361971));
                super.run();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CopyToEngine
    extends Engine {
        private File[] topList;
        private int basePathLen;
        private File zipFile;
        private String destPath;
        private long totalSize = 0L;
        private boolean newZip = false;
        private boolean move = false;
        private boolean del_src_dir = false;
        private String prep;

        CopyToEngine(File[] list, File zip_file, String dest_sub, int move_mode_) {
            this.topList = list;
            this.zipFile = zip_file;
            this.destPath = dest_sub != null ? (dest_sub.endsWith(CommanderAdapterBase.SLS) ? dest_sub : dest_sub + CommanderAdapterBase.SLS) : "";
            this.basePathLen = list.length > 0 ? list[0].getParent().length() + 1 : 0;
            this.move = (move_mode_ & 1) != 0;
            this.del_src_dir = (move_mode_ & 2) != 0;
        }

        CopyToEngine(File[] list, File zip_file) {
            this.topList = list;
            this.zipFile = zip_file;
            this.destPath = "";
            this.basePathLen = list.length > 0 ? list[0].getParent().length() + 1 : 0;
            this.newZip = true;
            this.prep = ZipAdapter.this.ctx.getString(2131361976);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int num_files = 0;
            try {
                this.sendProgress(this.prep, 1, 1);
                ZipAdapter zipAdapter = ZipAdapter.this;
                synchronized (zipAdapter) {
                    File src_dir;
                    ZipAdapter.this.Init(null);
                    ArrayList<File> full_list = new ArrayList<File>(this.topList.length);
                    this.totalSize = this.addToList(this.topList, full_list);
                    this.sendProgress(this.prep, 2, 2);
                    num_files = this.addFilesToZip(full_list);
                    if (this.del_src_dir && (src_dir = this.topList[0].getParentFile()) != null) {
                        src_dir.delete();
                    }
                }
            }
            catch (Exception e) {
                this.error("Exception: " + e.getMessage());
            }
            this.sendResult(Utils.getOpReport(ZipAdapter.this.ctx, num_files, 2131362009));
            super.run();
        }

        private final long addToList(File[] sub_list, ArrayList<File> full_list) {
            long total_size = 0L;
            try {
                for (int i = 0; i < sub_list.length; ++i) {
                    if (this.stop || this.isInterrupted()) {
                        this.errMsg = "Canceled";
                    } else {
                        File f = sub_list[i];
                        if (f == null || !f.exists()) continue;
                        if (f.isFile()) {
                            total_size += f.length();
                            full_list.add(f);
                            continue;
                        }
                        if (!f.isDirectory()) continue;
                        long dir_sz = this.addToList(f.listFiles(), full_list);
                        if (this.errMsg == null) {
                            if (dir_sz == 0L) {
                                full_list.add(f);
                                continue;
                            }
                            total_size += dir_sz;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"addToList()", (Throwable)e);
                this.errMsg = "Exception: " + e.getMessage();
            }
            return total_size;
        }

        private final int addFilesToZip(ArrayList<File> files) throws IOException {
            File old_file = null;
            try {
                int i;
                ZipOutputStream out;
                byte[] buf = new byte[100000];
                if (this.newZip) {
                    out = new ZipOutputStream(new FileOutputStream(this.zipFile));
                } else {
                    ZipFile zf = new ZipFile(this.zipFile);
                    int num_entries = zf.size();
                    long total_size = this.zipFile.length();
                    long bytes_saved = 0L;
                    old_file = new File(this.zipFile.getAbsolutePath() + "_tmp_" + new Date().getSeconds() + ".zip");
                    if (!this.zipFile.renameTo(old_file)) {
                        throw new RuntimeException("could not rename the file " + this.zipFile.getAbsolutePath() + " to " + old_file.getAbsolutePath());
                    }
                    ZipInputStream zin = new ZipInputStream(new FileInputStream(old_file));
                    out = new ZipOutputStream(new FileOutputStream(this.zipFile));
                    int e_i = 0;
                    ZipEntry entry = zin.getNextEntry();
                    while (entry != null && !this.isStopReq()) {
                        int pp = e_i++ * 100 / num_entries;
                        this.sendProgress(this.prep, pp, 0);
                        String name = entry.getName();
                        boolean notInFiles = true;
                        for (File f : files) {
                            if (this.isStopReq()) break;
                            String f_path = f.getAbsolutePath();
                            if (!f_path.regionMatches(true, this.basePathLen, name, 0, name.length())) continue;
                            notInFiles = false;
                            break;
                        }
                        if (notInFiles) {
                            int len;
                            out.putNextEntry(new ZipEntry(name));
                            while ((len = zin.read(buf)) > 0 && !this.isStopReq()) {
                                out.write(buf, 0, len);
                                this.sendProgress(this.prep, pp, (int)((bytes_saved += (long)len) * 100L / total_size));
                            }
                        }
                        entry = zin.getNextEntry();
                    }
                    zin.close();
                    if (this.isStopReq()) {
                        out.close();
                        this.zipFile.delete();
                        old_file.renameTo(this.zipFile);
                        return 0;
                    }
                }
                double conv = 100.0 / (double)this.totalSize;
                long byte_count = 0L;
                for (i = 0; i < files.size() && !this.isStopReq(); ++i) {
                    File f = files.get(i);
                    String fn = f.getAbsolutePath();
                    String rfn = this.destPath + fn.substring(this.basePathLen);
                    if (f.isDirectory()) {
                        out.putNextEntry(new ZipEntry(rfn + CommanderAdapterBase.SLS));
                    } else {
                        int len;
                        ZipEntry ze = new ZipEntry(rfn);
                        ze.setTime(f.lastModified());
                        out.putNextEntry(ze);
                        int fnl = fn.length();
                        String pack_s = ZipAdapter.this.ctx.getString(2131361984, new Object[]{fnl > 36 ? "\u2026" + fn.substring(fnl - 36) : fn});
                        FileInputStream in = new FileInputStream(f);
                        int so_far = (int)((double)byte_count * conv);
                        while ((len = ((InputStream)in).read(buf)) > 0 && !this.isStopReq()) {
                            out.write(buf, 0, len);
                            this.sendProgress(pack_s, so_far, (int)((double)(byte_count += (long)len) * conv));
                        }
                        ((InputStream)in).close();
                    }
                    out.closeEntry();
                    if (!this.move) continue;
                    f.delete();
                }
                out.close();
                if (this.isStopReq()) {
                    this.zipFile.delete();
                    if (!this.newZip) {
                        old_file.renameTo(this.zipFile);
                    }
                    return 0;
                }
                if (!this.newZip) {
                    old_file.delete();
                }
                return i;
            }
            catch (Exception e) {
                this.error(e.getMessage());
                e.printStackTrace();
                if (!this.newZip) {
                    this.zipFile.delete();
                    if (!this.newZip && old_file != null) {
                        old_file.renameTo(this.zipFile);
                    }
                }
                return 0;
            }
        }
    }

    class DelEngine
    extends Engine {
        private String[] flat_names_to_delete = null;
        private File zipFile;

        DelEngine(File zipFile_, ZipEntry[] list) {
            this.zipFile = zipFile_;
            this.flat_names_to_delete = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                ZipEntry z = list[i];
                this.flat_names_to_delete[i] = z.getName().replace("/", "");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (ZipAdapter.this.zip == null) {
                return;
            }
            this.sendProgress(ZipAdapter.this.ctx.getString(2131361903), 1, 1);
            ZipAdapter zipAdapter = ZipAdapter.this;
            synchronized (zipAdapter) {
                block14: {
                    ZipAdapter.this.Init(null);
                    File old_file = new File(this.zipFile.getAbsolutePath() + "_tmp_" + new Date().getSeconds() + ".zip");
                    try {
                        ZipFile zf = new ZipFile(this.zipFile);
                        int removed = 0;
                        int processed = 0;
                        int num_entries = zf.size();
                        String del = ZipAdapter.this.ctx.getString(2131361980);
                        if (!this.zipFile.renameTo(old_file)) {
                            this.error("could not rename the file " + this.zipFile.getAbsolutePath() + " to " + old_file.getAbsolutePath());
                            break block14;
                        }
                        ZipInputStream zin = new ZipInputStream(new FileInputStream(old_file));
                        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(this.zipFile));
                        byte[] buf = new byte[100000];
                        ZipEntry entry = zin.getNextEntry();
                        while (entry != null && !this.isStopReq()) {
                            String name = entry.getName();
                            String flat_name = name.replace("/", "");
                            boolean spare_this = true;
                            for (int i = 0; i < this.flat_names_to_delete.length && !this.isStopReq(); ++i) {
                                if (!flat_name.equals(this.flat_names_to_delete[i])) continue;
                                spare_this = false;
                                ++removed;
                                break;
                            }
                            if (spare_this) {
                                int len;
                                int pp = ++processed * 100 / num_entries;
                                long total_size = entry.getSize();
                                long bytes_saved = 0L;
                                out.putNextEntry(new ZipEntry(name));
                                while ((len = zin.read(buf)) > 0 && !this.isStopReq()) {
                                    out.write(buf, 0, len);
                                    this.sendProgress(del, pp, (int)((bytes_saved += (long)len) * 100L / total_size));
                                }
                            }
                            entry = zin.getNextEntry();
                        }
                        zin.close();
                        try {
                            out.close();
                        }
                        catch (Exception e) {
                            Log.e((String)this.TAG, (String)"DelEngine.run()->out.close()", (Throwable)e);
                        }
                        if (this.isStopReq()) {
                            this.zipFile.delete();
                            old_file.renameTo(this.zipFile);
                            processed = 0;
                            this.error(ZipAdapter.this.s(2131361972));
                            break block14;
                        }
                        old_file.delete();
                        ZipAdapter.this.zip = null;
                        this.sendResult(Utils.getOpReport(ZipAdapter.this.ctx, removed, 2131362006));
                        return;
                    }
                    catch (Exception e) {
                        this.error(e.getMessage());
                    }
                }
                this.sendResult(Utils.getOpReport(ZipAdapter.this.ctx, 0, 2131362006));
                super.run();
            }
        }
    }

    class CopyFromEngine
    extends EnumEngine {
        private File dest_folder;
        private ZipEntry[] mList;
        private String base_pfx;
        private int base_len;

        CopyFromEngine(ZipEntry[] list, File dest, Engines.IReciever recipient_) {
            this.mList = null;
            this.recipient = recipient_;
            this.mList = list;
            this.dest_folder = dest;
            try {
                this.base_pfx = ZipAdapter.this.uri.getFragment();
                if (this.base_pfx == null) {
                    this.base_pfx = "";
                }
                this.base_len = this.base_pfx.length();
            }
            catch (NullPointerException e) {
                Log.e((String)this.TAG, (String)"", (Throwable)e);
            }
        }

        CopyFromEngine(File dest) {
            this.mList = null;
            this.dest_folder = dest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.sendProgress(ZipAdapter.this.ctx.getString(2131361903), 1, 1);
            ZipAdapter zipAdapter = ZipAdapter.this;
            synchronized (zipAdapter) {
                if (this.mList == null) {
                    this.mList = this.GetFolderList("");
                    if (this.mList == null) {
                        this.sendProgress(ZipAdapter.this.ctx.getString(2131362179), -2);
                        return;
                    }
                }
                int total = this.copyFiles(this.mList, "");
                if (this.recipient != null) {
                    this.sendReceiveReq(this.dest_folder);
                    return;
                }
                this.sendResult(Utils.getOpReport(ZipAdapter.this.ctx, total, 2131362010));
            }
            super.run();
        }

        private final int copyFiles(ZipEntry[] list, String path) {
            int counter = 0;
            try {
                long dir_size = 0L;
                long byte_count = 0L;
                for (int i = 0; i < list.length; ++i) {
                    ZipEntry f = list[i];
                    if (f.isDirectory()) continue;
                    dir_size += f.getSize();
                }
                double conv = 100.0 / (double)dir_size;
                for (int i = 0; i < list.length; ++i) {
                    long entry_time;
                    String entry_name_fixed;
                    ZipEntry entry = list[i];
                    if (entry == null || (entry_name_fixed = ZipAdapter.this.fixName(entry)) == null) continue;
                    String file_name = new File(entry_name_fixed).getName();
                    File dest_file = new File(this.dest_folder, path + file_name);
                    String rel_name = entry_name_fixed.substring(this.base_len);
                    if (entry.isDirectory()) {
                        if (!(dest_file.mkdir() || dest_file.exists() && dest_file.isDirectory())) {
                            this.errMsg = "Can't create folder \"" + dest_file.getAbsolutePath() + "\"";
                            break;
                        }
                        ZipEntry[] subItems = this.GetFolderList(entry_name_fixed);
                        if (subItems == null) {
                            this.errMsg = "Failed to get the file list of the subfolder '" + rel_name + "'.\n";
                            break;
                        }
                        counter += this.copyFiles(subItems, rel_name);
                        if (this.errMsg != null) {
                            break;
                        }
                    } else {
                        if (dest_file.exists()) {
                            int res = this.askOnFileExist(ZipAdapter.this.ctx.getString(2131361995, new Object[]{dest_file.getAbsolutePath()}), ZipAdapter.this.commander);
                            if (res == 1) break;
                            if (res == 4) continue;
                            if (res == 2 && !dest_file.delete()) {
                                this.error(ZipAdapter.this.ctx.getString(2131362002, new Object[]{dest_file.getAbsoluteFile()}));
                                break;
                            }
                        }
                        InputStream in = ZipAdapter.this.zip.getInputStream(entry);
                        FileOutputStream out = new FileOutputStream(dest_file);
                        byte[] buf = new byte[100000];
                        int n = 0;
                        int so_far = (int)((double)byte_count * conv);
                        int fnl = rel_name.length();
                        String unp_msg = ZipAdapter.this.ctx.getString(2131361982, new Object[]{fnl > 36 ? "\u2026" + rel_name.substring(fnl - 36) : rel_name});
                        while ((n = in.read(buf)) >= 0) {
                            out.write(buf, 0, n);
                            this.sendProgress(unp_msg, so_far, (int)((double)(byte_count += (long)n) * conv));
                            if (!this.stop && !this.isInterrupted()) continue;
                            in.close();
                            out.close();
                            dest_file.delete();
                            this.errMsg = "File '" + dest_file.getName() + "' was not completed, delete.";
                            break;
                        }
                        in.close();
                        out.close();
                    }
                    int GINGERBREAD = 9;
                    if (Build.VERSION.SDK_INT >= 9) {
                        ForwardCompat.setFullPermissions(dest_file);
                    }
                    if ((entry_time = entry.getTime()) > 0L) {
                        dest_file.setLastModified(entry_time);
                    }
                    if (this.stop || this.isInterrupted()) {
                        this.error(ZipAdapter.this.ctx.getString(2131361990));
                        break;
                    }
                    if (i >= list.length - 1) {
                        this.sendProgress(ZipAdapter.this.ctx.getString(2131361983, new Object[]{rel_name}), (int)((double)byte_count * conv));
                    }
                    ++counter;
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"copyFiles()", (Throwable)e);
                this.error("Exception: " + e.getMessage());
            }
            return counter;
        }
    }

    class ListEngine
    extends EnumEngine {
        private ZipEntry[] items_tmp;
        public String pass_back_on_done;

        ListEngine(Handler h, String pass_back_on_done_) {
            super(h);
            this.items_tmp = null;
            this.pass_back_on_done = pass_back_on_done_;
        }

        public ZipEntry[] getItems() {
            return this.items_tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block7: {
                String zip_path = null;
                try {
                    try {
                        if (ZipAdapter.this.uri == null || (zip_path = ZipAdapter.this.uri.getPath()) == null) break block7;
                        ZipAdapter.this.zip = new ZipFile(zip_path);
                        String cur_path = null;
                        try {
                            cur_path = ZipAdapter.this.uri.getFragment();
                        }
                        catch (NullPointerException e) {
                            Log.e((String)this.TAG, (String)"uri.getFragment()", (Throwable)e);
                        }
                        this.items_tmp = this.GetFolderList(cur_path);
                        if (this.items_tmp == null) break block7;
                        ZipItemPropComparator comp = new ZipItemPropComparator(ZipAdapter.this.mode & 0x30, (ZipAdapter.this.mode & 0x80) != 0, ZipAdapter.this.ascending);
                        Arrays.sort(this.items_tmp, comp);
                        this.sendProgress(null, -3, this.pass_back_on_done);
                        Object var5_7 = null;
                    }
                    catch (ZipException e) {
                        Log.e((String)this.TAG, zip_path, (Throwable)e);
                        this.sendProgress(ZipAdapter.this.ctx.getString(2131362179), -2, this.pass_back_on_done);
                        Object var5_9 = null;
                        super.run();
                        return;
                    }
                    catch (Exception e) {
                        Log.e((String)this.TAG, zip_path, (Throwable)e);
                        this.sendProgress(e.getLocalizedMessage(), -2, this.pass_back_on_done);
                        Object var5_10 = null;
                        super.run();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_11 = null;
                    super.run();
                    throw throwable;
                }
                super.run();
                return;
            }
            Object var5_8 = null;
            super.run();
            this.sendProgress(ZipAdapter.this.ctx.getString(2131362179), -2, this.pass_back_on_done);
        }
    }

    class EnumEngine
    extends Engine {
        protected EnumEngine() {
        }

        protected EnumEngine(Handler h) {
            super.setHandler(h);
        }

        protected final ZipEntry[] GetFolderList(String fld_path) {
            Enumeration<? extends ZipEntry> entries;
            if (ZipAdapter.this.zip == null) {
                return null;
            }
            if (fld_path == null) {
                fld_path = "";
            } else if (fld_path.length() > 0 && fld_path.charAt(0) == CommanderAdapterBase.SLC) {
                fld_path = fld_path.substring(1);
            }
            int fld_path_len = fld_path.length();
            if (fld_path_len > 0 && fld_path.charAt(fld_path_len - 1) != CommanderAdapterBase.SLC) {
                fld_path = fld_path + CommanderAdapterBase.SLC;
                ++fld_path_len;
            }
            if ((entries = ZipAdapter.this.zip.entries()) == null) {
                return null;
            }
            ArrayList<ZipEntry> array2 = new ArrayList<ZipEntry>();
            while (entries.hasMoreElements()) {
                String entry_name;
                if (this.isStopReq()) {
                    return null;
                }
                ZipEntry e = entries.nextElement();
                if (e == null || (entry_name = ZipAdapter.this.fixName(e)) == null || fld_path.compareToIgnoreCase(entry_name) == 0 || !fld_path.regionMatches(true, 0, entry_name, 0, fld_path_len)) continue;
                int sl_pos = entry_name.indexOf(CommanderAdapterBase.SLC, fld_path_len);
                if (sl_pos > 0) {
                    String sub_dir = entry_name.substring(fld_path_len, sl_pos + 1);
                    int sub_dir_len = sub_dir.length();
                    boolean not_yet = true;
                    for (int i = 0; i < array2.size(); ++i) {
                        String a_name = ZipAdapter.this.fixName((ZipEntry)array2.get(i));
                        if (!a_name.regionMatches(fld_path_len, sub_dir, 0, sub_dir_len)) continue;
                        not_yet = false;
                        break;
                    }
                    if (!not_yet) continue;
                    ZipEntry sur_fld = new ZipEntry(entry_name.substring(0, sl_pos + 1));
                    byte[] eb = new byte[]{1, 2};
                    sur_fld.setExtra(eb);
                    array2.add(sur_fld);
                    continue;
                }
                array2.add(e);
            }
            return array2.toArray(new ZipEntry[array2.size()]);
        }
    }
}

