/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.favorites;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AutoCompleteTextView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.ghostsq.commander.FileCommander;
import com.ghostsq.commander.Panels;
import com.ghostsq.commander.favorites.Favorite;
import com.ghostsq.commander.favorites.Favorites;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;

public class LocationBar
extends BaseAdapter
implements Filterable,
View.OnKeyListener,
View.OnClickListener,
TextWatcher {
    private final String TAG = ((Object)((Object)this)).getClass().getName();
    private FileCommander c;
    private Panels p;
    private int toChange = -1;
    private View goPanel;
    private Favorites favorites;
    private float density = 1.0f;

    public LocationBar(FileCommander c_, Panels p_, Favorites shortcuts_list) {
        this.c = c_;
        this.p = p_;
        this.favorites = shortcuts_list;
        this.goPanel = this.c.findViewById(2131230769);
        try {
            View star;
            Button go;
            AutoCompleteTextView textView = (AutoCompleteTextView)this.goPanel.findViewById(2131230771);
            if (textView != null) {
                textView.setAdapter((ListAdapter)this);
                textView.setOnKeyListener((View.OnKeyListener)this);
                textView.addTextChangedListener((TextWatcher)this);
                if (Build.VERSION.SDK_INT < 11) {
                    textView.setBackgroundResource(0x1080018);
                }
            }
            if ((go = (Button)this.goPanel.findViewById(2131230772)) != null) {
                go.setOnClickListener((View.OnClickListener)this);
            }
            if ((star = this.goPanel.findViewById(2131230770)) != null) {
                star.setOnClickListener((View.OnClickListener)this);
            }
            this.density = this.c.getContext().getResources().getDisplayMetrics().density;
        }
        catch (Exception e) {
            this.c.showMessage("Exception on setup history dropdown: " + e);
        }
    }

    public void setFingerFriendly(boolean finger_friendly, int font_size, float density) {
        Button go = (Button)this.goPanel.findViewById(2131230772);
        if (go != null) {
            int pv = 0;
            int ph = (int)(finger_friendly ? 20.0f * density : 8.0f * density);
            go.setPadding(ph, pv, ph, pv);
        }
    }

    public Filter getFilter() {
        Filter nameFilter = new Filter(){

            public String convertResultToString(Object resultValue) {
                return resultValue != null ? resultValue.toString() : "?";
            }

            protected Filter.FilterResults performFiltering(CharSequence constraint) {
                Filter.FilterResults filterResults = new Filter.FilterResults();
                if (constraint != null) {
                    filterResults.values = new Object();
                    filterResults.count = 1;
                }
                return filterResults;
            }

            protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
                if (results != null && results.count > 0) {
                    LocationBar.this.notifyDataSetChanged();
                }
            }
        };
        return nameFilter;
    }

    public int getCount() {
        return this.favorites.size();
    }

    public Object getItem(int position) {
        return ((Favorite)this.favorites.get(position)).getUriString(true);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        try {
            TextView tv = convertView != null ? (TextView)convertView : new TextView((Context)this.c);
            int vp = this.p.fingerFriendly ? (int)(12.0f * this.density) : 4;
            tv.setPadding(6, vp, 6, vp);
            String screened = ((Favorite)this.favorites.get(position)).getUriString(true);
            tv.setText((CharSequence)(screened == null ? "" : screened));
            if (Build.VERSION.SDK_INT >= 11) {
                tv.setTextAppearance((Context)this.c, 16842805);
            } else {
                tv.setTextColor(this.c.getResources().getColor(17170436));
            }
            return tv;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"", (Throwable)e);
            return null;
        }
    }

    public static int getThemeResourceId(Context context, int attr2) {
        TypedValue typedvalueattr = new TypedValue();
        context.getTheme().resolveAttribute(attr2, typedvalueattr, true);
        return typedvalueattr.resourceId;
    }

    public final void openGoPanel(int which, Uri uri) {
        try {
            CheckBox star;
            this.goPanel.setVisibility(0);
            this.toChange = which;
            AutoCompleteTextView edit = (AutoCompleteTextView)this.c.findViewById(2131230771);
            if (edit != null) {
                edit.setText((CharSequence)Favorite.screenPwd(uri));
                edit.showDropDown();
                edit.requestFocus();
            }
            if ((star = (CheckBox)this.c.findViewById(2131230770)) != null) {
                star.setChecked(this.favorites.findIgnoreAuth(uri) >= 0);
            }
        }
        catch (Exception e) {
            this.c.showMessage("Error: " + e);
        }
    }

    public final void closeGoPanel() {
        View go_panel = this.c.findViewById(2131230769);
        if (go_panel != null) {
            go_panel.setVisibility(8);
        }
    }

    public final void applyGoPanel() {
        this.closeGoPanel();
        TextView edit = (TextView)this.goPanel.findViewById(2131230771);
        String new_dir = edit.getText().toString().trim();
        if (this.toChange >= 0 && new_dir.length() > 0) {
            Uri u = Uri.parse((String)new_dir);
            Credentials crd = null;
            if (Favorite.isPwdScreened(u)) {
                crd = this.favorites.searchForPassword(u);
            } else {
                String user_info = u.getUserInfo();
                if (Utils.str(user_info)) {
                    crd = new Credentials(user_info);
                }
            }
            u = Utils.updateUserInfo(u, null);
            if (this.toChange != this.p.getCurrent()) {
                this.p.togglePanels(false);
            }
            this.p.Navigate(this.toChange, u, crd, null);
        }
        this.toChange = -1;
        this.p.focus();
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        int v_id = v.getId();
        if (v_id == 2131230771) {
            switch (keyCode) {
                case 4: {
                    this.closeGoPanel();
                    return true;
                }
                case 23: 
                case 66: {
                    try {
                        AutoCompleteTextView actv = (AutoCompleteTextView)v;
                        if (actv.getListSelection() == -1) {
                            this.applyGoPanel();
                            return true;
                        }
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                    return false;
                }
                case 61: {
                    return true;
                }
            }
        }
        return false;
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 2131230770: {
                try {
                    if (this.toChange < 0) break;
                    TextView edit = (TextView)this.goPanel.findViewById(2131230771);
                    String uri_s = edit.getText().toString().trim();
                    CheckBox star_cb = (CheckBox)v;
                    Uri u = Uri.parse((String)uri_s);
                    this.favorites.removeFromFavorites(u);
                    if (star_cb.isChecked()) {
                        if (Favorite.isPwdScreened(u)) {
                            Credentials crd = this.favorites.searchForPassword(u);
                            if (crd == null) {
                                Uri au = Favorite.borrowPassword(u, this.p.getFolderUriWithAuth(true));
                                if (au == null) {
                                    Log.e((String)this.TAG, (String)"Can't find the replacement for screened password!");
                                } else {
                                    u = au;
                                }
                            }
                            this.favorites.add(new Favorite(u, crd));
                        } else {
                            this.favorites.add(new Favorite(u));
                        }
                    }
                    this.notifyDataSetChanged();
                    star_cb.setChecked(this.favorites.findIgnoreAuth(u) >= 0);
                    AutoCompleteTextView actv = (AutoCompleteTextView)this.goPanel.findViewById(2131230771);
                    actv.showDropDown();
                    actv.requestFocus();
                }
                catch (Exception exception) {}
                break;
            }
            case 2131230772: {
                this.applyGoPanel();
            }
        }
    }

    public void afterTextChanged(Editable s) {
        try {
            TextView edit = (TextView)this.goPanel.findViewById(2131230771);
            CheckBox star = (CheckBox)this.goPanel.findViewById(2131230770);
            String addr = edit.getText().toString().trim();
            Uri uri = Uri.parse((String)addr);
            star.setChecked(this.favorites.findIgnoreAuth(uri) >= 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }
}

