/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.annotation.SuppressLint;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"NewApi"})
public class StorageUtils {
    private static final String TAG = "StorageUtils";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<StorageInfo> getStorageList() {
        BufferedReader buf_reader;
        ArrayList<StorageInfo> list;
        block13: {
            String line;
            list = new ArrayList<StorageInfo>();
            String def_path = Environment.getExternalStorageDirectory().getPath();
            boolean def_path_internal = !Environment.isExternalStorageRemovable();
            String def_path_state = Environment.getExternalStorageState();
            boolean def_path_available = def_path_state.equals("mounted") || def_path_state.equals("mounted_ro");
            boolean def_path_readonly = Environment.getExternalStorageState().equals("mounted_ro");
            buf_reader = null;
            HashSet<String> paths = new HashSet<String>();
            buf_reader = new BufferedReader(new FileReader("/proc/mounts"));
            int cur_display_number = 1;
            while ((line = buf_reader.readLine()) != null) {
                Log.d((String)TAG, (String)line);
                if (line.contains("/mnt/asec") || !line.contains("vfat") && !line.contains("/mnt")) continue;
                StringTokenizer tokens = new StringTokenizer(line, " ");
                String unused = tokens.nextToken();
                String mount_point = tokens.nextToken();
                if (paths.contains(mount_point)) continue;
                unused = tokens.nextToken();
                List<String> flags = Arrays.asList(tokens.nextToken().split(","));
                boolean readonly = flags.contains("ro");
                if (mount_point.equals(def_path)) {
                    paths.add(def_path);
                    list.add(0, new StorageInfo(def_path, def_path_internal, readonly, -1));
                    continue;
                }
                if (line.contains("/dev/block/vold")) {
                    if (line.contains("/mnt/secure") || line.contains("/mnt/asec") || line.contains("/mnt/obb") || line.contains("/mnt/media_rw") || line.contains("/dev/mapper") || line.contains("tmpfs")) continue;
                    paths.add(mount_point);
                    list.add(new StorageInfo(mount_point, false, readonly, cur_display_number++));
                    continue;
                }
                if (!line.contains("extSdCard") && !line.contains("external_sd")) continue;
                list.add(new StorageInfo(mount_point, false, readonly, cur_display_number++));
            }
            if (paths.contains(def_path) || !def_path_available) break block13;
            list.add(0, new StorageInfo(def_path, def_path_internal, def_path_readonly, -1));
        }
        Object var16_17 = null;
        if (buf_reader == null) return list;
        try {
            buf_reader.close();
            return list;
        }
        catch (IOException iOException) {}
        return list;
        {
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                Object var16_18 = null;
                if (buf_reader == null) return list;
                try {
                    buf_reader.close();
                    return list;
                }
                catch (IOException iOException) {}
                return list;
            }
            catch (IOException ex) {
                ex.printStackTrace();
                Object var16_19 = null;
                if (buf_reader == null) return list;
                try {
                    buf_reader.close();
                    return list;
                }
                catch (IOException iOException) {}
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            if (buf_reader == null) throw throwable;
            try {
                buf_reader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static class StorageInfo {
        public final String path;
        public final boolean internal;
        public final boolean readonly;
        public final int display_number;

        StorageInfo(String path, boolean internal, boolean readonly, int display_number) {
            this.path = path;
            this.internal = internal;
            this.readonly = readonly;
            this.display_number = display_number;
        }

        public String getDisplayName() {
            StringBuilder res = new StringBuilder();
            if (this.internal) {
                res.append("Internal SD card");
            } else if (this.display_number > 1) {
                res.append("SD card " + this.display_number);
            } else {
                res.append("SD card");
            }
            if (this.readonly) {
                res.append(" (Read only)");
            }
            return res.toString();
        }
    }
}

