package com.ghostsq.commander.samba;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;

import jcifs.smb.SmbFile;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiManager.WifiLock;
import android.util.Log;

import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.adapters.FSEngines.DeleteEngine;
import com.ghostsq.commander.utils.Utils;

class CopyToEngine extends Engine // From a local fs to SMB share  
{
    public final static String TAG = "CopyToEngine";
    protected static int BLOCK_SIZE = 262144;
    private   Commander commander;
    private   Context ctx;
    private   File[]  mList;
    private   SmbFile to;
    private   boolean move = false;
    private   boolean del_src_dir = false;
    private   WifiLock  wifiLock;
    public    byte buf[] = new byte[BLOCK_SIZE];
    public    int  read_bi = 0, write_bi = 1;

    static {
        long free = Runtime.getRuntime().freeMemory();
        BLOCK_SIZE = free < 65536 ? 32768 : (int)free / 2;
        Log.d( TAG, "Buffer size: " + BLOCK_SIZE + " free=" + free );        
    }
    
    CopyToEngine( Commander commander_, File[] list, SmbFile to_, int move_mode_ ) {
        commander = commander_;
        ctx = commander.getContext();
        mList = list;
        to = to_;
        move = ( move_mode_ & CommanderAdapter.MODE_MOVE ) != 0;
        del_src_dir = ( move_mode_ & CommanderAdapter.MODE_DEL_SRC_DIR ) != 0;
        WifiManager manager = (WifiManager)ctx.getSystemService( Context.WIFI_SERVICE );
        wifiLock = manager.createWifiLock( android.os.Build.VERSION.SDK_INT >= 12 ? 3 : WifiManager.WIFI_MODE_FULL, TAG );
        wifiLock.setReferenceCounted( false );
    }

    @Override
    public void run() {
        if( to == null || mList == null || mList.length == 0 ) return;
        wifiLock.acquire();
        int cnt = copyFiles( mList, to );
        wifiLock.release();
        if( del_src_dir ) {
            try {
                File src_dir = mList[0].getParentFile();
                if( src_dir != null ) {
                    File[] content = src_dir.listFiles();
                    for( File file : content ) {
                        file.delete();
                    }
                    src_dir.delete();
                }
            } catch( Exception e ) {
                Log.e( TAG, "", e );
            }
        }
        sendResult( Utils.getOpReport( ctx, cnt, move && !del_src_dir ? Utils.RR.moved.r() : Utils.RR.copied.r() ) );
        super.run();
    }

    private final int copyFiles( File[] list, SmbFile dest ) {
        int counter = 0;
        try {
            long num = list.length;
            long dir_size = 0, byte_count = 0;
            for( int i = 0; i < num; i++ ) {
                File f = list[i];               
                if( !f.isDirectory() )
                    dir_size += f.length();
            }
            double conv = 100./(double)dir_size;
            for( int i = 0; i < num; i++ ) {
                if( stop || isInterrupted() ) {
                    error( ctx.getString( Utils.RR.interrupted.r() ) );
                    break;
                }
                File f = list[i];
                if( f != null && f.exists() ) {
                    boolean dir = f.isDirectory(); 
                    String fn = f.getName();
                    if( dir ) fn += "/";
                    SmbFile new_file = new SmbFile( dest, fn );
                    if( new_file.exists() ) {
                        int res = askOnFileExist( ctx.getString( Utils.RR.file_exist.r(), new_file.getPath() ), commander );
                        if( res == Commander.ABORT ) break;
                        if( res == Commander.SKIP )  continue;
                        if( res == Commander.REPLACE ) new_file.delete();
                    }
                    if( dir ) {
                        new_file.mkdir();
                        counter += copyFiles( f.listFiles(), new_file );
                        if( errMsg != null ) break;
                    } else if( f.isFile() ) {
                        new_file.createNewFile();
                        OutputStream out = new_file.getOutputStream();
                        InputStream in = new FileInputStream( f );
                        
                        long done = 0, nn = 0, start_time = 0;
                        int  n = 0;
                        int  so_far = (int)(byte_count * conv);
                        try {
                            String path_name = f.getAbsolutePath();
                            int pnl = path_name.length();
                            String cur_op_s = ctx.getString( Utils.RR.uploading.r(), 
                                    pnl > CUT_LEN ? "\u2026" + path_name.substring( pnl - CUT_LEN ) : path_name );
                            String     sz_s = Utils.getHumanSize( f.length() );
                            int speed = 0;
                            while( true ) {
                                if( isStopReq() ) {
                                    in.close();
                                    out.close();
                                    error( ctx.getString( Utils.RR.fail_del.r(), new_file.getName() ) );
                                    new_file.delete();
                                    return counter;
                                }                                
                                if( nn == 0 ) {
                                    start_time = System.currentTimeMillis();
                                    sendProgress( cur_op_s + sizeOfsize( done, sz_s ), so_far, (int)(byte_count * conv), speed );
                                }
                                n = in.read( buf );
                                if( n < 0 ) break;
                                out.write( buf, 0, n );
                                byte_count += n;
                                done       += n;
                                nn         += n;
                                long time_delta = System.currentTimeMillis() - start_time;
                                if( time_delta > DELAY ) {
                                    speed = (int)(MILLI * nn / time_delta);
                                    nn = 0;
                                }
                            }
                            sendProgress( cur_op_s + sizeOfsize( done, sz_s ), so_far, (int)(byte_count * conv), speed );
                            in.close();
                        } catch( Exception e ) {
                            error( ctx.getString( Utils.RR.fail_del.r(), new_file.getName() ) );
                            new_file.delete();
                            break;
                        }
                        finally {
                            if( in  != null ) in.close();
                            if( out != null ) out.close();
                        }
                    }
                    try {
                        new_file.setLastModified( f.lastModified() );
                    } catch( Exception e ) {
                        Log.e( TAG, "can't change date for the file " + new_file.getName() );
                    }
                    counter++;
                    if( move && !f.delete() ) {
                        error( ctx.getString( Utils.RR.cant_del.r(), f.getCanonicalPath() ) );
                        break;
                    }
                }
            }
        }
        catch( Exception e ) {
            e.printStackTrace();
            error( e.getLocalizedMessage() );
        }
        return counter;
    }
}
