package com.ghostsq.commander.samba;

import java.net.MalformedURLException;
import java.net.UnknownHostException;

import jcifs.UniAddress;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.NtStatus;
import jcifs.netbios.NbtAddress;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;

import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.CommanderAdapterBase;
import com.ghostsq.commander.adapters.Engine;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;

class ListEngine extends Engine {
    private static final String TAG = "smb.ListEngine"; 
    private String    smb_url = null; 
    private String    pass_back_on_done;
    private SmbItem[] items_tmp = null;
    private NtlmPasswordAuthentication credentials;
    private int       sort_mode;
    private Context   context;
    private SMBAdapter owner;
    
    ListEngine( String url, NtlmPasswordAuthentication credentials_, int sort_mode_, SMBAdapter owner_, Context context_, String pass_back_on_done_ ) {
        owner = owner_;
        smb_url = url;
        credentials = credentials_;
        sort_mode = sort_mode_;
        context = context_;
        pass_back_on_done = pass_back_on_done_;
    }
    public SmbItem[] getItems() {
        return items_tmp;
    }       
    @Override
    public void run() {
        Resources smb_res = null;
        try {
            PackageManager pm = context.getPackageManager();
            smb_res = pm.getResourcesForApplication( "com.ghostsq.commander.samba" );

            if( smb_url == null || smb_url.length() < 4 ) {
                sendProgress( smb_res.getString( R.string.nothing_read ), Commander.OPERATION_FAILED, pass_back_on_done );
                return;
            }
            if( smb_url.charAt( smb_url.length() - 1 ) != CommanderAdapterBase.SLC )
                smb_url += CommanderAdapterBase.SLS;
            
            SmbFile[] list = null;
            SmbFile f;
            if( "smb://".equals( smb_url ) )
                f = new SmbFile( smb_url, NtlmPasswordAuthentication.ANONYMOUS );
            else {
                if( credentials != null ) 
                    f = new SmbFile( smb_url, credentials );
                else
                    f = new SmbFile( smb_url );
            }
            try {
                Log.d( TAG, "Going to obtaib the items list" );
                list = f.listFiles();
                Log.d( TAG, "The items list was obtained" );
            } catch( SmbException e ) {
                Log.e( TAG, "List failed. " + e.getLocalizedMessage() + " Trying anonymous access" );
                String host = Uri.parse( smb_url ).getHost();
                boolean sfs = false;
                if( !Utils.str( host ) || "WORKGROUP".equalsIgnoreCase( host ) )
                    f = new SmbFile( smb_url, NtlmPasswordAuthentication.ANONYMOUS );
                else {
                    f = new SmbFile( smb_url ); // "simple file sharing"
                    sfs = true;
                }
                list = f.listFiles();
                if( sfs )
                    owner.setCredentials( null );   // works better in guest mode
            }
            if( list != null ) {
                int cnt = 0;
                for( int i = 0; i < list.length; i++ )
                    if( toShow( list[i], sort_mode ) )
                        cnt++;
                items_tmp = new SmbItem[cnt];
                int j = 0;
                for( int i = 0; i < list.length; i++ )
                    if( toShow( list[i], sort_mode ) )
                        items_tmp[j++] = new SmbItem( list[i], sort_mode, smb_res ); 
                sendProgress( null, Commander.OPERATION_COMPLETED, pass_back_on_done );
                return;
            }
            error( smb_res.getString( R.string.nothing_returned, smb_url ) );
        } catch( SmbAuthException e ) {
            String title = null;
            if( "smb://".equals( smb_url ) )
                title = getMasterBrowserName();
            else {
                Uri u = Uri.parse( smb_url );
                if( u != null )
                    title = u.getHost(); 
            }
            Credentials crd = credentials != null ?
                new Credentials( credentials.getName(), credentials.getPassword() ) : null;
            sendLoginReq( title, crd, pass_back_on_done );
            return;
        } catch( MalformedURLException e ) {
            error( smb_res.getString( R.string.malformed_url, e.getMessage() ) );
        } catch( SmbException e ) {
            try {
                Throwable cause = e.getRootCause();
                if( cause instanceof UnknownHostException ) {
                    String src = cause.getMessage();
                    if( src.indexOf( "__MSBROWSE__" ) >= 0 )
                        error( smb_res.getString( R.string.msbrowse_err ) );
                    else
                        error( smb_res.getString( R.string.connect_err, src ) );
                }
                else {
                    if( "Broken pipe".equals( e.getMessage() ) )
                        error( smb_res.getString( R.string.broken_pipe ) );
                    else {
                        if( e.getNtStatus() == NtStatus.NT_STATUS_LOGON_TYPE_NOT_GRANTED ) {
                            String title = null;
                            if( "smb://".equals( smb_url ) )
                                title = getMasterBrowserName();
                            else {
                                Uri u = Uri.parse( smb_url );
                                if( u != null ) {
                                    title = u.getHost();
                                    title += "\n";
                                }
                                title += e.getLocalizedMessage();
                            }
                            Credentials crd = credentials != null ?
                                new Credentials( credentials.getUsername(), credentials.getPassword() ) : null;
                            sendLoginReq( title, crd, pass_back_on_done );
                            Log.e( TAG, smb_res.getString( R.string.smb_exception, Integer.toHexString( e.getNtStatus() ), e.getMessage() ), e );
                            return;
                        }
                        String msg = e.getMessage();
                        error( smb_res.getString( R.string.smb_exception, Integer.toHexString( e.getNtStatus() ), msg != null ? msg : "" ) );
                    }
                }
            } catch ( Exception ee ) {
                Log.e( TAG, "Double exception", ee );
            }
        } catch( OutOfMemoryError err ) {
            error( "Out Of Memory" );
        } catch( Exception e ) {
            Log.e( TAG, "Exception :((", e );
            error( "Exception: " + e.getMessage() );
            
        } finally {
            super.run();
        }
        sendProgress( errMsg, Commander.OPERATION_FAILED, pass_back_on_done );
    }
    
    protected final String getMasterBrowserName() {
        try {
            NbtAddress[] nbt = NbtAddress.getAllByAddress( NbtAddress.getByName( NbtAddress.MASTER_BROWSER_NAME, 1, null ) );
            if( nbt != null ) {
                for( int i = 0; i < nbt.length; i++ )
                    if( nbt[i].getNameType() == 0x20 )
                        return nbt[i].getHostName();
            }
        } catch( Exception e ) {
            Log.e( TAG, "Exception", e );
        }
        return null;
    }
    
    protected final boolean toShow( SmbFile f, int mode ) {
        try {
            if( ( mode & CommanderAdapter.MODE_HIDDEN ) == CommanderAdapter.HIDE_MODE ) { 
                if( f.getName().charAt( 0 ) == '.' ) return false;
                if( ( f.getAttributes() & SmbFile.ATTR_HIDDEN ) != 0 ) return false;
            }
            int type = f.getType();
            if( type == SmbFile.TYPE_PRINTER || type == SmbFile.TYPE_NAMED_PIPE ) return false;
        } catch( SmbException e ) {
            Log.e( TAG, "Exception", e );
        }
        return true;
    }
}
