/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.annotation.SuppressLint;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Base64;
import android.util.Log;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileProvider
extends ContentProvider {
    private static final String TAG = "FileProvider";
    public static final String AUTHORITY = "com.ghostsq.commander";
    private static final String CA_MODE_SIG = "CA";
    private static final int MODE_SEG = 0;
    private static final int MIME_SEG = 1;
    private static final int URI_SEG = 2;
    private static final int SEG_NUM = 3;

    public static final Uri makeURI(String path) {
        Uri.Builder ub = new Uri.Builder();
        ub.scheme("content").authority(AUTHORITY).path(path);
        return ub.build();
    }

    public static final Uri makeURI(Uri u, String mime) {
        Uri.Builder ub = new Uri.Builder();
        String us = u.toString();
        ub.scheme("content").authority(AUTHORITY).appendPath(CA_MODE_SIG).appendPath(mime).appendPath(Base64.encodeToString((byte[])us.getBytes(), (int)8));
        return ub.build();
    }

    private static final List<String> isCAmode(Uri uri) {
        List ps = uri.getPathSegments();
        if (ps != null && ps.size() >= 3 && CA_MODE_SIG.equalsIgnoreCase((String)ps.get(0))) {
            return ps;
        }
        return null;
    }

    private static final Uri getEnclosedUri(Uri uri) {
        List ps = uri.getPathSegments();
        if (ps == null || ps.size() < 3) {
            return null;
        }
        byte[] ub = Base64.decode((String)((String)ps.get(2)), (int)8);
        String us = new String(ub);
        Log.d((String)TAG, (String)("Got enclosed URI: " + us));
        return Uri.parse((String)us);
    }

    public static void storeCredentials(Context ctx, Credentials crd, Uri uri) {
        crd.storeCredentials(ctx, FileProvider.class.getSimpleName(), uri);
    }

    public static Credentials restoreCredentials(Context ctx, Uri uri) {
        return Credentials.restoreCredentials(ctx, FileProvider.class.getSimpleName(), uri);
    }

    public boolean onCreate() {
        return true;
    }

    public String getType(Uri uri) {
        List<String> ps = FileProvider.isCAmode(uri);
        if (ps != null) {
            return ps.get(1);
        }
        String ext = Utils.getFileExt(uri.getPath());
        return Utils.getMimeByExt(ext);
    }

    public Cursor query(Uri uri, String[] fields, String sel, String[] sel_args, String sort) {
        try {
            Log.v((String)TAG, (String)("query( " + uri + " )"));
            if (!AUTHORITY.equals(uri.getAuthority())) {
                throw new RuntimeException("Unsupported URI");
            }
            List<String> ps = FileProvider.isCAmode(uri);
            if (ps != null) {
                Uri enclosed_uri = FileProvider.getEnclosedUri(uri);
                CommanderAdapter ca = null;
                MatrixCursor c = new MatrixCursor(fields);
                MatrixCursor.RowBuilder row = c.newRow();
                for (String col : fields) {
                    if ("_data".equals(col)) {
                        row.add((Object)enclosed_uri);
                        continue;
                    }
                    if ("mime_type".equals(col)) {
                        row.add((Object)this.getType(uri));
                        continue;
                    }
                    if ("_display_name".equals(col)) {
                        row.add((Object)enclosed_uri.getLastPathSegment());
                        continue;
                    }
                    if ("title".equals(col)) {
                        row.add((Object)enclosed_uri.getLastPathSegment());
                        continue;
                    }
                    if ("width".equals(col)) {
                        row.add((Object)100);
                        continue;
                    }
                    if ("height".equals(col)) {
                        row.add((Object)100);
                        continue;
                    }
                    if ("_size".equals(col)) {
                        CommanderAdapter.Item item;
                        if (ca == null) {
                            ca = this.CreateCA(enclosed_uri);
                        }
                        row.add((Object)((item = ca.getItem(enclosed_uri)) == null ? 0L : item.size));
                        continue;
                    }
                    row.add(null);
                }
                return c;
            }
            if (fields == null || fields.length == 0) {
                fields = new String[]{"_data", "mime_type", "_display_name", "_size"};
            }
            MatrixCursor c = new MatrixCursor(fields);
            MatrixCursor.RowBuilder row = c.newRow();
            File f = new File(uri.getPath());
            if (!f.exists() || !f.isFile()) {
                throw new RuntimeException("No file name specified: " + uri);
            }
            for (String col : fields) {
                if ("_data".equals(col)) {
                    row.add((Object)f.getAbsolutePath());
                    continue;
                }
                if ("mime_type".equals(col)) {
                    row.add((Object)this.getType(uri));
                    continue;
                }
                if ("_display_name".equals(col)) {
                    row.add((Object)f.getName());
                    continue;
                }
                if ("_size".equals(col)) {
                    row.add((Object)f.length());
                    continue;
                }
                row.add(null);
            }
            return c;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Can't provide for query " + uri), (Throwable)e);
            return null;
        }
    }

    private CommanderAdapter CreateCA(Uri u) {
        Credentials credentials;
        CommanderAdapter ca = CA.CreateAdapterInstance(u, this.getContext());
        if (ca == null) {
            return null;
        }
        ca.Init(null);
        String ui = u.getUserInfo();
        if (ui != null && (credentials = FileProvider.restoreCredentials(this.getContext(), u)) != null) {
            ca.setCredentials(credentials);
            u = Utils.updateUserInfo(u, null);
        }
        ca.setUri(u);
        return ca;
    }

    @SuppressLint(value={"NewApi"})
    public ParcelFileDescriptor openFile(Uri uri, String access_mode) throws FileNotFoundException {
        Log.v((String)TAG, (String)("openFile( " + uri + " ) " + access_mode));
        List<String> ps = FileProvider.isCAmode(uri);
        if (ps == null) {
            File file = new File(uri.getPath());
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
            int pfd_mode = 0;
            if (Build.VERSION.SDK_INT >= 19) {
                pfd_mode = ForwardCompat.parseFileDescriptorMode(access_mode);
            }
            ParcelFileDescriptor parcel = ParcelFileDescriptor.open((File)file, (int)pfd_mode);
            return parcel;
        }
        Uri enclosed_uri = FileProvider.getEnclosedUri(uri);
        try {
            CommanderAdapter ca = this.CreateCA(enclosed_uri);
            if (ca == null) {
                throw new FileNotFoundException();
            }
            InputStream is = ca.getContent(ca.getUri());
            if (is == null) {
                return null;
            }
            ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createReliablePipe();
            ParcelFileDescriptor.AutoCloseOutputStream os = new ParcelFileDescriptor.AutoCloseOutputStream(pipe[1]);
            new TransferThread(is, (OutputStream)os).start();
            return pipe[0];
        }
        catch (IOException e) {
            Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("Exception opening pipe to " + enclosed_uri.toString()), (Throwable)e);
            return null;
        }
    }

    public int update(Uri uri, ContentValues contentvalues, String s, String[] as) {
        return 0;
    }

    public int delete(Uri uri, String s, String[] as) {
        return 0;
    }

    public Uri insert(Uri uri, ContentValues contentvalues) {
        return null;
    }

    static class TransferThread
    extends Thread {
        InputStream in;
        OutputStream out;

        TransferThread(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        public void run() {
            byte[] buf = new byte[0x100000];
            int len = 0;
            try {
                int has_read;
                while ((has_read = this.in.read(buf)) > 0) {
                    this.out.write(buf, 0, has_read);
                    len += has_read;
                }
                Log.d((String)FileProvider.TAG, (String)("Bytes read: " + len));
                this.in.close();
                this.out.flush();
                this.out.close();
            }
            catch (IOException e) {
                Log.e((String)FileProvider.TAG, (String)("Exception transferring file. Were able to read bytes " + len), (Throwable)e);
            }
        }
    }
}

