/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceGroup;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.Toast;
import com.ghostsq.commander.ColorsKeeper;
import com.ghostsq.commander.FileTypes;
import com.ghostsq.commander.Panels;
import com.ghostsq.commander.RGBPickerDialog;
import com.ghostsq.commander.SelZoneDialog;
import com.ghostsq.commander.toolbuttons.ToolButtonsProps;
import com.ghostsq.commander.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class Prefs
extends PreferenceActivity
implements Preference.OnPreferenceClickListener,
RGBPickerDialog.ResultSink,
SelZoneDialog.ResultSink,
Preference.OnPreferenceChangeListener {
    private static final String TAG = "GhostCommander.Prefs";
    public static final String COLORS_PREFS = "colors";
    public static final String TOOLBUTTONS = "toolbar_preference";
    public static final String SEL_ZONE = "selection_zone";
    private ColorsKeeper ck;
    private String pref_key = null;
    static final String[] prefFileNames = new String[]{"FileCommander.xml", "com.ghostsq.commander_preferences.xml", "colors.xml", "ServerForm.xml", "Favorites.xml", "Editor.xml", "TextViewer.xml"};

    protected void onCreate(Bundle savedInstanceState) {
        try {
            Preference show_actionbar;
            Preference sel_zone_pref;
            Preference tool_buttons_pref;
            ListPreference l;
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this);
            Utils.setTheme((Context)this, sp.getString("color_themes", "d"));
            Utils.changeLanguage((Context)this);
            boolean ab = Utils.setActionBar((Activity)this);
            super.onCreate(savedInstanceState);
            this.ck = new ColorsKeeper((Context)this);
            if (!sp.getBoolean("_has_set_default_values", false)) {
                SharedPreferences.Editor ed = sp.edit();
                ed.putBoolean("open_content", Build.VERSION.SDK_INT > 23);
                ed.putBoolean("_has_set_default_values", true);
                try {
                    ed.apply();
                }
                catch (AbstractMethodError unused) {
                    ed.commit();
                }
            }
            this.addPreferencesFromResource(2131034112);
            Preference color_picker_pref = this.findPreference("bgr_color_picker");
            if (color_picker_pref != null) {
                color_picker_pref.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if ((color_picker_pref = this.findPreference("fgr_color_picker")) != null) {
                color_picker_pref.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if ((color_picker_pref = this.findPreference("sel_color_picker")) != null) {
                color_picker_pref.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if ((color_picker_pref = this.findPreference("sfg_color_picker")) != null) {
                color_picker_pref.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if ((color_picker_pref = this.findPreference("cur_color_picker")) != null) {
                color_picker_pref.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if ((color_picker_pref = this.findPreference("ttl_color_picker")) != null) {
                color_picker_pref.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if ((color_picker_pref = this.findPreference("btn_color_picker")) != null) {
                color_picker_pref.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if ((l = (ListPreference)this.findPreference("color_themes")) != null) {
                if (Build.VERSION.SDK_INT < 11) {
                    Preference color_pref = this.findPreference(COLORS_PREFS);
                    if (color_pref instanceof PreferenceGroup) {
                        PreferenceGroup colors_grp = (PreferenceGroup)color_pref;
                        colors_grp.removePreference((Preference)l);
                    }
                } else {
                    l.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
                }
            }
            if ((tool_buttons_pref = this.findPreference(TOOLBUTTONS)) != null) {
                tool_buttons_pref.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if ((sel_zone_pref = this.findPreference(SEL_ZONE)) != null) {
                sel_zone_pref.setOnPreferenceClickListener((Preference.OnPreferenceClickListener)this);
            }
            if ((show_actionbar = this.findPreference("show_actionbar")) != null && Build.VERSION.SDK_INT < 11) {
                PreferenceCategory cat_inps = (PreferenceCategory)this.findPreference("input_settings");
                cat_inps.removePreference(show_actionbar);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, null, (Throwable)e);
        }
    }

    protected void onStart() {
        super.onStart();
        this.ck.restore();
    }

    protected void onPause() {
        try {
            super.onPause();
            this.ck.store();
        }
        catch (Exception e) {
            Log.e((String)TAG, null, (Throwable)e);
        }
    }

    public boolean onPreferenceChange(Preference p, Object v) {
        if (!"color_themes".equals(p.getKey())) {
            return true;
        }
        if (!(v instanceof String)) {
            return false;
        }
        this.ck.setTheme((String)v);
        Utils.setTheme((Context)this, (String)v);
        return true;
    }

    public boolean onPreferenceClick(Preference preference) {
        try {
            this.pref_key = preference.getKey();
            if (TOOLBUTTONS.equals(this.pref_key)) {
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.setClass((Context)this, ToolButtonsProps.class);
                this.startActivity(intent);
            } else if (SEL_ZONE.equals(this.pref_key)) {
                SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences((Context)this);
                new SelZoneDialog((Context)this, this, sp.getBoolean("selection_zone_right", true), sp.getInt("selection_zone_width", 50), this.ck.selColor, this.ck.bgrColor).show();
            } else if ("fgr_color_picker".equals(this.pref_key)) {
                Intent intent = new Intent("android.intent.action.MAIN");
                intent.setClass((Context)this, FileTypes.class);
                this.startActivity(intent);
            } else {
                String title = preference.getTitle().toString();
                new RGBPickerDialog((Context)this, this, this.ck.getColor(this.pref_key), this.getDefaultColor(this.pref_key, true), title).show();
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void selZoneChanged(boolean atRight, int width) {
        SharedPreferences.Editor sp_edit = PreferenceManager.getDefaultSharedPreferences((Context)this).edit();
        sp_edit.putBoolean("selection_zone_right", atRight);
        sp_edit.putInt("selection_zone_width", width);
        sp_edit.commit();
    }

    public void colorChanged(int color2) {
        if (this.pref_key != null) {
            this.ck.setColor(this.pref_key, color2);
            this.pref_key = null;
        }
    }

    public int getDefaultColor(String key, boolean alt) {
        return ColorsKeeper.getDefaultColor((Context)this, key, alt);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        try {
            Utils.changeLanguage((Context)this);
            MenuInflater inflater = this.getMenuInflater();
            inflater.inflate(2131492867, menu2);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        super.onMenuItemSelected(featureId, item);
        try {
            File save_dir = new File(Panels.DEFAULT_LOC, ".GhostCommander");
            PackageManager pm = this.getPackageManager();
            ApplicationInfo ai = pm.getApplicationInfo(this.getPackageName(), 0);
            File sp_dir = new File(ai.dataDir, "shared_prefs");
            File f = new File(save_dir, "gc_prefs.zip");
            switch (item.getItemId()) {
                case 2131230943: {
                    if (!save_dir.exists()) {
                        save_dir.mkdirs();
                    }
                    this.savePrefs(sp_dir, f);
                    break;
                }
                case 2131230944: {
                    this.restPrefs(f, sp_dir);
                    this.ck.restore();
                    this.setResult(-1, new Intent("com.ghostsq.commander.PREF_RESTORE"));
                    this.finish();
                    break;
                }
                case 2131230945: {
                    if (!save_dir.exists()) {
                        save_dir.mkdirs();
                    }
                    final String f_save_dir = save_dir.getAbsolutePath();
                    Prefs ctx = this;
                    new Thread(new Runnable((Context)ctx){
                        final /* synthetic */ Context val$ctx;
                        {
                            this.val$ctx = context;
                        }

                        public void run() {
                            String fn = f_save_dir + "/logcat.txt";
                            try {
                                Process prc;
                                File f = new File(fn);
                                if (f.exists()) {
                                    f.delete();
                                }
                                Toast.makeText((Context)this.val$ctx, (CharSequence)((prc = Runtime.getRuntime().exec("logcat -d -v time -f " + fn + " *:v\n")).waitFor() == 0 ? this.val$ctx.getString(2131362198, new Object[]{fn}) : this.val$ctx.getString(2131361917)), (int)1).show();
                            }
                            catch (Exception e) {
                                Log.e((String)Prefs.TAG, (String)fn, (Throwable)e);
                            }
                        }
                    }).run();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public final void showMessage(String s) {
        Toast.makeText((Context)this, (CharSequence)s, (int)1).show();
    }

    private final void savePrefs(File sp_dir, File f) {
        try {
            if (f.exists()) {
                f.delete();
            }
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(f));
            for (int i = 0; i < prefFileNames.length; ++i) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(new File(sp_dir, prefFileNames[i]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (is == null) continue;
                zos.putNextEntry(new ZipEntry(prefFileNames[i]));
                Utils.copyBytes(is, zos);
                ((InputStream)is).close();
                zos.closeEntry();
            }
            zos.close();
            this.showMessage(this.getString(2131361897));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private final void restPrefs(File f, File sp_dir) {
        try {
            File[] ff;
            for (File of : ff = sp_dir.listFiles()) {
                of.delete();
            }
            ZipFile zf = new ZipFile(f);
            for (int i = 0; i < prefFileNames.length; ++i) {
                ZipEntry ze = zf.getEntry(prefFileNames[i]);
                if (ze == null) continue;
                InputStream is = zf.getInputStream(ze);
                FileOutputStream os = new FileOutputStream(new File(sp_dir, prefFileNames[i]));
                Utils.copyBytes(is, os);
                is.close();
                ((OutputStream)os).close();
            }
            this.showMessage(this.getString(2131361898));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

