/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewParent;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.ghostsq.commander.ColorsKeeper;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.ForwardCompat;
import com.ghostsq.commander.utils.Utils;
import java.io.InputStream;

public class TextViewer
extends Activity {
    public static final String TAG = "TextViewerActivity";
    private static final String SP_ENC = "encoding";
    public static final String STRURI = "string:";
    public static final String STRKEY = "string";
    private static final int VIEW_BOT = 595;
    private static final int VIEW_TOP = 590;
    private static final int VIEW_ENC = 363;
    private ScrollView scrollView;
    public TextView text_view;
    public Uri uri;
    public String encoding;

    public void onCreate(Bundle savedInstanceState) {
        try {
            ImageButton mb;
            boolean ct_enabled = false;
            boolean ab = Utils.needActionBar(this);
            SharedPreferences shared_pref = PreferenceManager.getDefaultSharedPreferences((Context)this);
            Utils.setTheme((Context)this, shared_pref.getString("color_themes", "d"));
            if (ab) {
                Utils.setActionBar(this);
            } else {
                ct_enabled = this.requestWindowFeature(7);
            }
            this.setContentView(2130903064);
            if (!ab && Build.VERSION.SDK_INT >= 17 && !ForwardCompat.hasPermanentMenuKey((Context)this) && (mb = (ImageButton)this.findViewById(2131230755)) != null) {
                mb.setVisibility(0);
                mb.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        TextViewer.this.openOptionsMenu();
                    }
                });
            }
            int fs = Integer.parseInt(shared_pref != null ? shared_pref.getString("font_size", "12") : "12");
            this.text_view = (TextView)this.findViewById(2131230898);
            if (this.text_view == null) {
                Log.e((String)TAG, (String)"No text view to show the content!");
                this.finish();
                return;
            }
            this.text_view.setTextSize((float)fs);
            this.text_view.setTypeface(Typeface.create((String)"monospace", (int)0));
            ColorsKeeper ck = new ColorsKeeper((Context)this);
            ck.restore();
            this.text_view.setBackgroundColor(ck.bgrColor);
            this.text_view.setTextColor(ck.fgrColor);
            if (ct_enabled) {
                TextView act_name_tv;
                Window w = this.getWindow();
                w.setFeatureInt(7, 2130903041);
                View at = this.findViewById(2131230786);
                if (at != null) {
                    ViewParent vp = at.getParent();
                    if (vp instanceof FrameLayout) {
                        FrameLayout flp = (FrameLayout)vp;
                        flp.setBackgroundColor(ck.ttlColor);
                        flp.setPadding(0, 0, 0, 0);
                    }
                    at.setBackgroundColor(ck.ttlColor);
                }
                if ((act_name_tv = (TextView)this.findViewById(2131230787)) != null) {
                    act_name_tv.setText(2131362096);
                }
            }
            this.scrollView = (ScrollView)this.findViewById(2131230798);
            super.onCreate(savedInstanceState);
        }
        catch (Exception e) {
            Toast.makeText((Context)this, (CharSequence)this.getString(2131362012), (int)1).show();
            Log.e((String)TAG, (String)"", (Throwable)e);
        }
    }

    protected void onStart() {
        super.onStart();
        SharedPreferences prefs = this.getPreferences(0);
        if (prefs != null) {
            this.encoding = prefs.getString(SP_ENC, "");
        }
        this.uri = this.getIntent().getData();
        if (!this.loadData()) {
            this.finish();
        }
        TextView file_name_tv = (TextView)this.findViewById(2131230788);
        if (this.uri != null) {
            String path = this.uri.getPath();
            if (file_name_tv != null && path != null && path.length() > 0) {
                String label_text = " - " + this.uri.getPath();
                String frgm = this.uri.getFragment();
                if (frgm != null) {
                    label_text = label_text + " (" + frgm + ")";
                }
                file_name_tv.setText((CharSequence)label_text);
            }
        }
    }

    protected void onPause() {
        super.onPause();
        SharedPreferences.Editor editor = this.getPreferences(0).edit();
        editor.putString(SP_ENC, this.encoding == null ? "" : this.encoding);
        editor.commit();
    }

    protected void onSaveInstanceState(Bundle toSaveState) {
        Log.i((String)TAG, (String)("Saving State: " + this.encoding));
        toSaveState.putString(SP_ENC, this.encoding == null ? "" : this.encoding);
        super.onSaveInstanceState(toSaveState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.encoding = savedInstanceState.getString(SP_ENC);
        }
        Log.i((String)TAG, (String)("Restored State " + this.encoding));
        super.onRestoreInstanceState(savedInstanceState);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        char c = (char)event.getUnicodeChar();
        switch (c) {
            case 'q': {
                this.finish();
                return true;
            }
            case 'g': {
                return this.dispatchCommand(590);
            }
            case 'G': {
                return this.dispatchCommand(595);
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        menu2.clear();
        menu2.add(0, 590, 0, (CharSequence)this.getString(2131362205)).setIcon(17301541);
        menu2.add(0, 595, 0, (CharSequence)this.getString(2131362206)).setIcon(17301538);
        menu2.add(0, 363, 0, (CharSequence)(this.getString(2131362211) + " '" + Utils.getEncodingDescr((Context)this, this.encoding, 1) + "'")).setIcon(17301660);
        menu2.add(0, 2131230930, 0, (CharSequence)this.getString(2131361860)).setIcon(17301594);
        return true;
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        if (this.dispatchCommand(item.getItemId())) {
            return true;
        }
        return super.onMenuItemSelected(featureId, item);
    }

    public boolean dispatchCommand(int id2) {
        switch (id2) {
            case 595: {
                this.scrollView.fullScroll(130);
                return true;
            }
            case 590: {
                this.scrollView.fullScroll(33);
                return true;
            }
            case 363: {
                int cen = Integer.parseInt(Utils.getEncodingDescr((Context)this, this.encoding, 0));
                new AlertDialog.Builder((Context)this).setTitle(2131362211).setSingleChoiceItems(2131296263, cen, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int i) {
                        TextViewer.this.encoding = TextViewer.this.getResources().getStringArray(2131296264)[i];
                        Log.i((String)TextViewer.TAG, (String)("Chosen encoding: " + TextViewer.this.encoding));
                        dialog.dismiss();
                        TextViewer.this.loadData();
                    }
                }).show();
                return true;
            }
            case 2131230930: {
                this.finish();
            }
        }
        return false;
    }

    private final boolean loadData() {
        if (this.uri != null) {
            try {
                String scheme = this.uri.getScheme();
                if (STRKEY.equals(scheme)) {
                    Intent i = this.getIntent();
                    String str = i.getStringExtra(STRKEY);
                    if (str != null) {
                        this.text_view.setText((CharSequence)str);
                        return true;
                    }
                    return false;
                }
                new DataLoadTask().execute(new Void[0]);
                return true;
            }
            catch (OutOfMemoryError e) {
                Log.e((String)TAG, (String)this.uri.toString(), (Throwable)e);
                Toast.makeText((Context)this, (CharSequence)this.getString(2131362214, new Object[]{this.uri.getPath()}), (int)1).show();
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)this.uri.toString(), (Throwable)e);
                Toast.makeText((Context)this, (CharSequence)(this.getString(2131361918) + e.getLocalizedMessage()), (int)1).show();
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DataLoadTask
    extends AsyncTask<Void, String, CharSequence> {
        private DataLoadTask() {
        }

        protected CharSequence doInBackground(Void ... v) {
            Uri uri = TextViewer.this.uri;
            try {
                String scheme = uri.getScheme();
                CommanderAdapter ca = null;
                InputStream is = null;
                if ("content".equals(scheme)) {
                    is = TextViewer.this.getContentResolver().openInputStream(uri);
                } else {
                    ca = CA.CreateAdapterInstance(uri, (Context)TextViewer.this);
                    if (ca != null) {
                        Credentials crd = null;
                        try {
                            crd = (Credentials)TextViewer.this.getIntent().getParcelableExtra(Credentials.KEY);
                        }
                        catch (Exception e) {
                            Log.e((String)TextViewer.TAG, (String)"on taking credentials from parcel", (Throwable)e);
                        }
                        ca.setCredentials(crd);
                        is = ca.getContent(uri);
                    }
                }
                if (is != null) {
                    CharSequence cs = Utils.readStreamToBuffer(is, TextViewer.this.encoding);
                    if (ca != null) {
                        ca.closeStream(is);
                        ca.prepareToDestroy();
                    } else {
                        is.close();
                    }
                    return cs;
                }
                this.publishProgress(new String[]{TextViewer.this.getString(2131362218)});
            }
            catch (OutOfMemoryError e) {
                Log.e((String)TextViewer.TAG, (String)uri.toString(), (Throwable)e);
                this.publishProgress(new String[]{TextViewer.this.getString(2131362214, new Object[]{uri.getPath()})});
            }
            catch (Throwable e) {
                Log.e((String)TextViewer.TAG, (String)uri.toString(), (Throwable)e);
                this.publishProgress(new String[]{TextViewer.this.getString(2131361918) + e.getLocalizedMessage()});
            }
            return null;
        }

        protected void onProgressUpdate(String ... err) {
            Toast.makeText((Context)TextViewer.this, (CharSequence)err[0], (int)1).show();
        }

        protected void onPostExecute(CharSequence cs) {
            try {
                if (cs == null) {
                    Log.e((String)TextViewer.TAG, (String)"Nothing loaded!");
                    return;
                }
                Log.d((String)TextViewer.TAG, (String)("Loaded charactes: " + cs.length()));
                if (TextViewer.this.text_view != null) {
                    TextViewer.this.text_view.setText(cs);
                }
            }
            catch (Throwable e) {
                this.onProgressUpdate(TextViewer.this.getString(2131361918) + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
    }
}

