/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.adapters;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.util.Log;
import com.ghostsq.commander.Commander;
import com.ghostsq.commander.adapters.Engines;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;
import java.io.File;

public class Engine
extends Thread {
    protected final String TAG = this.getClass().getSimpleName();
    protected static final int CUT_LEN = 36;
    protected static final int DELAY = 1000;
    protected static final int MILLI = 1000;
    protected static final double PERC = 100.0;
    protected Handler thread_handler = null;
    protected boolean stop = false;
    protected String errMsg = null;
    protected long threadStartedAt = 0L;
    protected int file_exist_behaviour = 0;
    protected Engines.IReciever recipient = null;

    protected Engine() {
    }

    protected Engine(Engines.IReciever recipient_) {
        this.recipient = recipient_;
    }

    protected void setEngineName(String name) {
        this.setName(name == null ? this.getClass().getName() : name);
    }

    public void setHandler(Handler h) {
        this.thread_handler = h;
    }

    public boolean reqStop() {
        if (this.isAlive()) {
            Log.i((String)this.getClass().getName(), (String)"reqStop()");
            if (this.stop) {
                this.interrupt();
            } else {
                this.stop = true;
            }
            return true;
        }
        Log.i((String)this.getClass().getName(), (String)"Engine thread is not alive");
        return false;
    }

    protected boolean isStopReq() {
        return this.stop || this.isInterrupted();
    }

    protected Bundle wrap(String str) {
        Bundle b = new Bundle(1);
        b.putString("STRING", str);
        return b;
    }

    protected final void sendProgress(String s, int p) {
        this.sendProgress(s, p, -1, -1);
    }

    protected final void sendProgress(String s, int p1, int p2) {
        this.sendProgress(s, p1, p2, -1);
    }

    protected final void sendProgress() {
        if (this.thread_handler == null) {
            return;
        }
        Message msg = this.thread_handler.obtainMessage(0, -1, -1, null);
        Bundle b = msg.getData();
        b.putLong("task", this.getId());
        this.thread_handler.sendMessage(msg);
    }

    protected final void sendProgress(String s, int p1, int p2, int speed) {
        if (this.thread_handler == null) {
            return;
        }
        Message msg = null;
        msg = p1 < 0 ? this.thread_handler.obtainMessage(p1, -1, -1, (Object)this.wrap(s)) : this.thread_handler.obtainMessage(0, p1, p2, (Object)this.wrap(s));
        Bundle b = msg.getData();
        b.putLong("task", this.getId());
        if (speed >= 0) {
            b.putInt("speed", speed);
        }
        this.thread_handler.sendMessage(msg);
    }

    protected final void sendProgress(String s, int p, String cookie) {
        if (this.thread_handler == null) {
            return;
        }
        Message msg = null;
        msg = p < 0 ? this.thread_handler.obtainMessage(p, -1, -1, (Object)this.wrap(s)) : this.thread_handler.obtainMessage(0, p, -1, (Object)this.wrap(s));
        Bundle b = msg.getData();
        b.putLong("task", this.getId());
        b.putString("cookie", cookie);
        this.thread_handler.sendMessage(msg);
    }

    protected final void sendLoginReq(String s, Credentials crd) {
        this.sendLoginReq(s, crd, null);
    }

    protected final void sendLoginReq(String s, Credentials crd, String cookie) {
        this.sendLoginReq(s, crd, cookie, false);
    }

    protected final void sendLoginReq(String s, Credentials crd, String cookie, boolean pw_only) {
        if (this.thread_handler == null) {
            return;
        }
        Message msg = this.thread_handler.obtainMessage(-5, -1, -1, (Object)this.wrap(s));
        Bundle b = msg.getData();
        b.putLong("task", this.getId());
        b.putParcelable("crd", (Parcelable)crd);
        if (cookie != null) {
            b.putString("cookie", cookie);
        }
        if (pw_only) {
            b.putBoolean("PW_ONLY", true);
        }
        this.thread_handler.sendMessage(msg);
    }

    protected final void sendReceiveReq(String[] items) {
        this.sendReceiveReq(items, false);
    }

    protected final void sendReceiveReq(String[] items, boolean move) {
        if (this.thread_handler == null) {
            return;
        }
        if (items == null || items.length == 0) {
            this.sendProgress("???", -2);
            return;
        }
        Message msg = this.thread_handler.obtainMessage(-3);
        Bundle b = msg.getData();
        b.putLong("task", this.getId());
        b.putBoolean("move", move);
        b.putStringArray("itms", items);
        this.thread_handler.sendMessage(msg);
    }

    protected final void sendReceiveReq(File dest_folder) {
        this.sendReceiveReq(dest_folder, false);
    }

    protected final void sendReceiveReq(File dest_folder, boolean move) {
        File[] temp_content = dest_folder.listFiles();
        String[] paths = new String[temp_content.length];
        for (int i = 0; i < temp_content.length; ++i) {
            paths[i] = temp_content[i].getAbsolutePath();
        }
        this.sendReceiveReq(paths, move);
    }

    protected final void error(String err) {
        Log.e((String)this.getClass().getSimpleName(), (String)(err == null ? "Unknown error" : err));
        this.errMsg = this.errMsg == null ? err : this.errMsg + "\n" + err;
    }

    protected final boolean noErrors() {
        return this.errMsg == null;
    }

    protected final void sendResult(String report) {
        if (this.errMsg != null) {
            this.sendProgress(report + "\n - " + this.errMsg, -7);
        } else {
            this.sendProgress(report, -4);
        }
    }

    protected final void sendRefrReq(String posto) {
        if (this.thread_handler == null) {
            return;
        }
        Message msg = this.thread_handler.obtainMessage(-4);
        if (posto != null) {
            Bundle b = msg.getData();
            b.putLong("task", this.getId());
            b.putString("posto", posto);
        }
        this.thread_handler.sendMessage(msg);
    }

    protected final void sendReport(String s) {
        if (this.thread_handler == null) {
            return;
        }
        Message msg = this.thread_handler.obtainMessage(-3, 870, -1, (Object)this.wrap(s));
        Bundle b = msg.getData();
        b.putLong("task", this.getId());
        this.thread_handler.sendMessage(msg);
    }

    protected final void doneReading(String msg, String cookie) {
        if (this.errMsg != null) {
            this.sendProgress(this.errMsg, -2, cookie);
        } else {
            this.sendProgress(msg, -3, cookie);
        }
    }

    protected final boolean tooLong(int sec) {
        if (this.threadStartedAt == 0L) {
            return false;
        }
        boolean yes = System.currentTimeMillis() - this.threadStartedAt > (long)(sec * 1000);
        this.threadStartedAt = 0L;
        return yes;
    }

    protected String sizeOfsize(long n, String sz_s) {
        return "\n" + Utils.getHumanSize(n) + "/" + sz_s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int askOnFileExist(String msg, Commander commander) throws InterruptedException {
        int res;
        if ((this.file_exist_behaviour & 8) != 0) {
            return this.file_exist_behaviour & 0xFFFFFFF7;
        }
        Commander commander2 = commander;
        synchronized (commander2) {
            this.sendProgress(msg, -6);
            while ((res = commander.getResolution()) == 0) {
                commander.wait();
            }
        }
        if (res == 1) {
            this.error(commander.getContext().getString(2131361992));
            return res;
        }
        if ((res & 8) != 0) {
            this.file_exist_behaviour = res;
        }
        return res & 0xFFFFFFF7;
    }

    public final Engines.IReciever getReciever() {
        return this.recipient;
    }

    protected final void deleteDir(File dir) {
        File[] children;
        if (dir == null) {
            return;
        }
        for (File f : children = dir.listFiles()) {
            if (f.isDirectory()) {
                this.deleteDir(f);
            }
            try {
                f.delete();
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)f.getAbsolutePath(), (Throwable)e);
            }
        }
        try {
            dir.delete();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)dir.getAbsolutePath(), (Throwable)e);
        }
    }
}

