/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.root;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import com.ghostsq.commander.adapters.Engine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.regex.Matcher;

public class ExecEngine
extends Engine {
    protected String sh;
    protected Context context;
    private String bb = "";
    private String where;
    private String command;
    private boolean use_busybox = false;
    private int wait_timeout = 500;
    private StringBuilder result;
    private boolean done = false;
    private OutputStreamWriter os = null;
    private BufferedReader is = null;
    private BufferedReader es = null;

    protected ExecEngine(Context context_) {
        this.context = context_;
        this.where = null;
        this.command = null;
        this.result = null;
        this.sh = this.getSuPath();
    }

    public ExecEngine(Context context_, String where_, String command_, boolean use_bb, int timeout) {
        this.context = context_;
        this.where = where_;
        this.command = command_;
        this.sh = this.getSuPath();
        this.use_busybox = use_bb;
        this.wait_timeout = timeout;
        this.result = new StringBuilder(1024);
    }

    protected final String getSuPath() {
        SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        return sharedPref.getString("su_path", "su");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.command == null) {
                return;
            }
            this.execute();
        }
        catch (Exception e) {
            this.error("Exception: " + e);
        }
        ExecEngine execEngine = this;
        synchronized (execEngine) {
            this.done = true;
            this.notify();
        }
        if (this.thread_handler != null) {
            this.sendResult(this.result != null && this.result.length() > 0 ? this.result.toString() : (this.errMsg != null ? "\nFailed to execute \"" + this.command + "\"" : null));
        }
    }

    protected boolean execute(String cmd, boolean use_bb) {
        this.command = cmd;
        this.use_busybox = use_bb;
        return this.execute();
    }

    protected boolean execute(String cmd, boolean use_bb, int timeout) {
        this.command = cmd;
        this.use_busybox = use_bb;
        this.wait_timeout = timeout;
        return this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean execute() {
        boolean ok;
        block26: {
            this.os = null;
            this.is = null;
            this.es = null;
            this.setEngineName(null);
            if (this.context != null) {
                SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
                this.bb = sharedPref.getString("busybox_path", "busybox") + " ";
            } else {
                this.bb = "busybox ";
            }
            Process p = Runtime.getRuntime().exec(this.sh);
            this.os = new OutputStreamWriter(p.getOutputStream());
            this.is = new BufferedReader(new InputStreamReader(p.getInputStream()));
            this.es = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            if (this.where != null) {
                this.outCmd(false, "cd '" + this.where + "'", this.os);
            }
            ok = this.cmdDialog(this.os, this.is, this.es);
            this.os.write("exit\n");
            this.os.flush();
            p.waitFor();
            int ev = p.exitValue();
            if (ev == 0) break block26;
            Log.e((String)this.TAG, (String)("Exit code " + ev));
            this.procError(this.es);
            if (this.errMsg == null || this.errMsg.length() == 0) {
                this.error("Exit code " + ev);
            }
            boolean bl = false;
            Object var6_7 = null;
            try {
                if (this.os != null) {
                    this.os.close();
                }
                if (this.is != null) {
                    this.is.close();
                }
                if (this.es != null) {
                    this.es.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return bl;
        }
        boolean bl = ok;
        Object var6_8 = null;
        try {
            if (this.os != null) {
                this.os.close();
            }
            if (this.is != null) {
                this.is.close();
            }
            if (this.es != null) {
                this.es.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return bl;
        catch (Exception e) {
            try {
                this.error("Exception: " + e);
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (this.os != null) {
                        this.os.close();
                    }
                    if (this.is != null) {
                        this.is.close();
                    }
                    if (this.es != null) {
                        this.es.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (this.os != null) {
                    this.os.close();
                }
                if (this.is != null) {
                    this.is.close();
                }
                if (this.es != null) {
                    this.es.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return false;
    }

    protected void outCmd(boolean use_bb, String cmd, OutputStreamWriter os) throws IOException, InterruptedException {
        String to_exec = (use_bb ? this.bb : "") + cmd + "\n";
        Log.v((String)this.TAG, (String)("executing: " + to_exec));
        os.write(to_exec);
        os.flush();
        boolean ready = false;
        int swait = 10;
        int tries = this.wait_timeout / 10;
        for (int i = 0; i < tries; ++i) {
            if (this.is.ready()) {
                ready = true;
                break;
            }
            Thread.sleep(10L);
        }
        if (ready) {
            Log.d((String)this.TAG, (String)"After cmd execution the input stream is ready");
        } else {
            Log.w((String)this.TAG, (String)("After " + this.wait_timeout + "ms the input stream is NOT yet ready!"));
        }
    }

    protected boolean cmdDialog(OutputStreamWriter os, BufferedReader is, BufferedReader es) {
        try {
            if (this.command != null) {
                this.outCmd(this.use_busybox, this.command, os);
            }
            boolean err = this.procError(es);
            if (!is.ready()) {
                Log.w((String)this.TAG, (String)("No output from the executed command " + this.command));
            }
            return this.procInput(is) || !err;
        }
        catch (Exception e) {
            this.error(e.getMessage());
            if (this.command != null) {
                Log.e((String)this.TAG, (String)("Exception '" + e.getMessage() + "' nn execution '" + this.command + "'"));
            }
            return false;
        }
    }

    protected boolean procInput(BufferedReader br) throws IOException, Exception {
        if (br != null && this.result != null) {
            while (br.ready()) {
                Thread.sleep(10L);
                if (this.isStopReq()) {
                    throw new Exception();
                }
                String ln = br.readLine();
                if (ln == null) break;
                this.result.append(ln).append("\n");
            }
        }
        return this.result != null && this.result.length() > 0;
    }

    protected boolean procError(BufferedReader es) throws IOException {
        return this.procError(es, false, false);
    }

    protected boolean procError(BufferedReader es, boolean ignore_all, boolean ignore_chown) throws IOException {
        boolean err = false;
        while (es.ready()) {
            String err_str = es.readLine();
            if (err_str == null || (err_str = err_str.trim()).length() <= 0) continue;
            if (ignore_all) {
                Log.w((String)this.TAG, (String)("Ignoring error: " + err_str));
                continue;
            }
            if (ignore_chown && err_str.indexOf("chown") >= 0) {
                Log.w((String)this.TAG, (String)("Ignoring chown error: " + err_str));
                continue;
            }
            this.error(err_str);
            err = true;
        }
        if (this.isStopReq()) {
            this.error("Canceled");
            return true;
        }
        return err;
    }

    public synchronized StringBuilder getResult() {
        try {
            this.wait(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.done ? this.result : null;
    }

    static String prepFileName(String fn) {
        return "'" + fn.replaceAll("'", Matcher.quoteReplacement("'\\''")) + "'";
    }
}

