/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.ghostsq.commander.utils.Crypt;

public class Credentials
implements Parcelable {
    private static String TAG = "GC.Credentials";
    public static String pwScreen = "***";
    public static String KEY = "CRD";
    private String username;
    private String password;
    public static final Parcelable.Creator<Credentials> CREATOR = new Parcelable.Creator<Credentials>(){

        public Credentials createFromParcel(Parcel in) {
            String un = in.readString();
            String pw = "";
            try {
                pw = new String(Crypt.decrypt(Crypt.getRawKey(), in.createByteArray()));
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"on password decryption", (Throwable)e);
            }
            return new Credentials(un, pw);
        }

        public Credentials[] newArray(int size) {
            return new Credentials[size];
        }
    };

    public Credentials(String usernamePassword) {
        int cp = usernamePassword.indexOf(58);
        if (cp < 0) {
            this.username = usernamePassword;
            return;
        }
        this.username = usernamePassword.substring(0, cp);
        this.password = usernamePassword.substring(cp + 1);
    }

    public Credentials(String userName, String password) {
        this.username = userName;
        this.password = password;
    }

    public Credentials(Credentials c) {
        this(c.getUserName(), c.getPassword());
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int f) {
        byte[] enc_pw = null;
        if (this.password != null) {
            try {
                enc_pw = Crypt.encrypt(Crypt.getRawKey(), this.getPassword().getBytes());
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"on password encryption", (Throwable)e);
            }
        }
        dest.writeString(this.getUserName());
        dest.writeByteArray(enc_pw);
    }

    public String toOldEncriptedString() {
        try {
            return Crypt.encrypt(this.getUserName() + ":" + this.getPassword(), false);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            return null;
        }
    }

    public static Credentials fromOldEncriptedString(String s) {
        try {
            return new Credentials(Crypt.decrypt(s, false));
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            return null;
        }
    }

    public String toEncriptedString(Context ctx) {
        try {
            String toc = this.getUserName() + ":" + this.getPassword();
            if (Build.VERSION.SDK_INT >= 18) {
                return Crypt.encrypt(ctx, toc, false);
            }
            return Crypt.encrypt(toc, false);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            return null;
        }
    }

    public static Credentials fromEncriptedString(String s, Context ctx) {
        try {
            String up = null;
            up = Build.VERSION.SDK_INT >= 18 ? Crypt.decrypt(ctx, s, false) : Crypt.decrypt(s, false);
            return new Credentials(up);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"", (Throwable)e);
            return null;
        }
    }

    public void storeCredentials(Context ctx, String storage, Uri uri) {
        int hash = (this.getUserName() + uri.getHost()).hashCode();
        SharedPreferences ssp = ctx.getSharedPreferences(storage, 0);
        SharedPreferences.Editor edt = ssp.edit();
        edt.putString("" + hash, this.toEncriptedString(ctx));
        edt.commit();
    }

    public static Credentials restoreCredentials(Context ctx, String storage, Uri uri) {
        int hash = (uri.getUserInfo() + uri.getHost()).hashCode();
        SharedPreferences ssp = ctx.getSharedPreferences(storage, 0);
        String crd_enc_s = ssp.getString("" + hash, null);
        if (crd_enc_s == null) {
            return null;
        }
        return Credentials.fromEncriptedString(crd_enc_s, ctx);
    }
}

