/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander.utils;

import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.Activity;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.VectorDrawable;
import android.media.ExifInterface;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.Process;
import android.util.Log;
import android.view.ViewConfiguration;
import android.widget.Toast;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForwardCompat {
    public static void setFullPermissions(File file) {
        file.setWritable(true, false);
        file.setReadable(true, false);
    }

    @TargetApi(value=11)
    public static void putStringSet(SharedPreferences.Editor ed, String key, Set<String> vs) {
        ed.putStringSet(key, vs);
    }

    @TargetApi(value=11)
    public static Set<String> getStringSet(SharedPreferences sp, String key) {
        return sp.getStringSet(key, null);
    }

    @TargetApi(value=11)
    public static SharedPreferences getDefaultSharedPreferences(Context ctx) {
        return ctx.getSharedPreferences(ctx.getPackageName() + "_preferences", 4);
    }

    @TargetApi(value=11)
    public static void getImageFileExtraInfo(ExifInterface exif, StringBuilder sb) {
        String is;
        String fl;
        String ex;
        String ap = exif.getAttribute("FNumber");
        if (ap != null) {
            sb.append("<br/><b>Aperture:</b> f").append(ap);
        }
        if ((ex = exif.getAttribute("ExposureTime")) != null) {
            sb.append("<br/><b>Exposure:</b> ").append(ex).append("s");
        }
        if ((fl = exif.getAttribute("FocalLength")) != null) {
            sb.append("<br/><b>Focal length:</b> ").append(fl);
        }
        if ((is = exif.getAttribute("ISOSpeedRatings")) != null) {
            sb.append("<br/><b>ISO level:</b> ").append(is);
        }
    }

    @TargetApi(value=24)
    public static ExifInterface getExifInterfaceFromStream(InputStream is) {
        try {
            return new ExifInterface(is);
        }
        catch (IOException e) {
            Log.e((String)"getExifInterfaceFromStream()", (String)"", (Throwable)e);
            return null;
        }
    }

    @TargetApi(value=11)
    public static void setupActionBar(Activity a) {
        ActionBar ab = a.getActionBar();
        if (ab == null) {
            return;
        }
        int size_class = a.getResources().getConfiguration().screenLayout & 0xF;
        if (size_class <= 3) {
            ab.setDisplayShowTitleEnabled(false);
        }
    }

    @TargetApi(value=14)
    public static boolean hasPermanentMenuKey(Context ctx) {
        return ViewConfiguration.get((Context)ctx).hasPermanentMenuKey();
    }

    @TargetApi(value=16)
    public static Notification buildNotification(Context ctx, String str, PendingIntent pi) {
        return new Notification.Builder(ctx).setContentTitle((CharSequence)str).setContentText((CharSequence)str).setSmallIcon(2130837527).setContentIntent(pi).build();
    }

    @TargetApi(value=19)
    public static String[] getStorageDirs(Context ctx) {
        File[] ff = ctx.getExternalFilesDirs(null);
        if (ff == null) {
            return null;
        }
        String[] res = new String[ff.length];
        for (int i = 0; i < ff.length; ++i) {
            String path;
            if (ff[i] == null || (path = ff[i].getAbsolutePath()) == null) continue;
            Log.d((String)"getStorageDirs", (String)path);
            int pos = path.indexOf("Android");
            if (pos < 0) {
                Log.e((String)"getStorageDirs", (String)("Unknown path " + path));
                continue;
            }
            res[i] = path.substring(0, pos);
        }
        return res;
    }

    @TargetApi(value=19)
    public static int parseFileDescriptorMode(String mode) {
        return ParcelFileDescriptor.parseMode((String)mode);
    }

    @TargetApi(value=23)
    public static boolean requestPermission(Activity act, String[] perms, int rpc) {
        ArrayList<String> al = new ArrayList<String>(perms.length);
        for (int i = 0; i < perms.length; ++i) {
            int cp = act.checkPermission(perms[i], Process.myPid(), Process.myUid());
            if (cp == 0) continue;
            al.add(perms[i]);
        }
        if (al.size() > 0) {
            act.requestPermissions(al.toArray(perms), rpc);
            return false;
        }
        return true;
    }

    @TargetApi(value=23)
    public static Parcelable createIcon(Context ctx, int icon_res_id) {
        return Icon.createWithResource((Context)ctx, (int)icon_res_id);
    }

    @TargetApi(value=23)
    public static Parcelable createIcon(Bitmap bmp) {
        return Icon.createWithBitmap((Bitmap)bmp);
    }

    @TargetApi(value=26)
    public static Bitmap getBitmap(Drawable drawable2) {
        try {
            Drawable d2b = null;
            if (drawable2 instanceof BitmapDrawable) {
                return ((BitmapDrawable)drawable2).getBitmap();
            }
            if (drawable2 instanceof VectorDrawable) {
                d2b = drawable2;
            } else if (drawable2 instanceof AdaptiveIconDrawable) {
                Drawable backgroundDr = ((AdaptiveIconDrawable)drawable2).getBackground();
                Drawable foregroundDr = ((AdaptiveIconDrawable)drawable2).getForeground();
                Drawable[] drr = new Drawable[]{backgroundDr, foregroundDr};
                d2b = new LayerDrawable(drr);
            }
            int width = d2b.getIntrinsicWidth();
            int height = d2b.getIntrinsicHeight();
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            d2b.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            d2b.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            Log.e((String)"getAppIcon()", (String)"", (Throwable)e);
            return null;
        }
    }

    @TargetApi(value=26)
    public static boolean makeShortcut(Context ctx, Intent shortcut_intent, String label, Parcelable icon_p) {
        try {
            ShortcutManager sm = (ShortcutManager)ctx.getSystemService(ShortcutManager.class);
            if (!sm.isRequestPinShortcutSupported()) {
                Toast.makeText((Context)ctx, (CharSequence)"Your home screen application does not support the Pin Shortcut feature.", (int)1).show();
                Log.w((String)"makeShortcut()", (String)"ShortcutManager.isRequestPinShortcutSupported() returned false");
            }
            Icon icon = (Icon)icon_p;
            ShortcutInfo si = new ShortcutInfo.Builder(ctx, label).setIntent(shortcut_intent).setShortLabel((CharSequence)label).setIcon(icon).build();
            return sm.requestPinShortcut(si, null);
        }
        catch (Exception e) {
            Log.e((String)"GC.ForwardCompat", (String)shortcut_intent.getDataString(), (Throwable)e);
            return false;
        }
    }
}

