/*
 * Decompiled with CFR 0.152.
 */
package com.ghostsq.commander;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.Display;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.ghostsq.commander.ColorsKeeper;
import com.ghostsq.commander.FilterProps;
import com.ghostsq.commander.Panels;
import com.ghostsq.commander.adapters.CA;
import com.ghostsq.commander.adapters.CommanderAdapter;
import com.ghostsq.commander.adapters.FSAdapter;
import com.ghostsq.commander.adapters.FavsAdapter;
import com.ghostsq.commander.adapters.HomeAdapter;
import com.ghostsq.commander.utils.Credentials;
import com.ghostsq.commander.utils.Utils;

public class ListHelper {
    private final String TAG;
    public final int which;
    public final int id;
    public ListView flv = null;
    private TextView status = null;
    private int currentPosition = -1;
    public int adapterMode = 0;
    private String[] listOfItemsChecked = null;
    private Panels p;
    private boolean needRefresh = false;
    private boolean was_current = false;

    ListHelper(int which_, Panels p_) {
        this.which = which_;
        this.TAG = "ListHelper" + this.which;
        this.p = p_;
        this.id = this.which == 0 ? 2131230782 : 2131230785;
        this.flv = (ListView)this.p.c.findViewById(this.id);
        if (this.flv != null) {
            this.flv.setItemsCanFocus(false);
            this.flv.setFocusableInTouchMode(true);
            this.flv.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this.p);
            this.flv.setChoiceMode(2);
            this.flv.setOnItemClickListener((AdapterView.OnItemClickListener)this.p);
            this.flv.setOnFocusChangeListener((View.OnFocusChangeListener)this.p);
            this.flv.setOnTouchListener((View.OnTouchListener)this.p);
            this.flv.setOnKeyListener((View.OnKeyListener)this.p);
            this.flv.setOnScrollListener((AbsListView.OnScrollListener)this.p);
            this.p.c.registerForContextMenu((View)this.flv);
        }
        this.status = (TextView)this.p.c.findViewById(this.which == 0 ? 2131230781 : 2131230784);
    }

    public final CommanderAdapter getListAdapter() {
        return (CommanderAdapter)this.flv.getAdapter();
    }

    public final void mbNavigate(Uri uri, Credentials crd, String posTo, boolean was_current_) {
        if ("find".equals(uri.getScheme())) {
            final Uri _uri = uri;
            final Credentials _crd = crd;
            final String _posTo = posTo;
            final boolean _was_current_ = was_current_;
            Context c = this.p.c.getContext();
            new AlertDialog.Builder(c).setTitle(2131361826).setMessage(2131361989).setPositiveButton(2131361929, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    ListHelper.this.Navigate(_uri, _crd, _posTo, _was_current_);
                }
            }).setNegativeButton(2131361930, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                    ListHelper.this.Navigate(Uri.parse((String)"home:"), null, null, _was_current_);
                }
            }).show();
        } else {
            this.Navigate(uri, crd, posTo, was_current_);
        }
    }

    public final void Navigate(Uri uri, Credentials crd, String posTo, boolean was_current_) {
        try {
            this.was_current = was_current_;
            this.currentPosition = -1;
            this.flv.clearChoices();
            this.flv.invalidateViews();
            CommanderAdapter ca_new = null;
            CommanderAdapter ca = (CommanderAdapter)this.flv.getAdapter();
            String scheme = uri.getScheme();
            if (scheme == null) {
                scheme = "";
            }
            if (ca == null || !scheme.equals(ca.getScheme())) {
                ca_new = CA.CreateAdapter(uri, this.p.c);
                if (ca_new == null) {
                    Log.e((String)this.TAG, (String)("Can't create adapter of type '" + scheme + "'"));
                    if (ca != null) {
                        return;
                    }
                    ca_new = CA.CreateAdapter(null, this.p.c);
                }
                if (ca != null) {
                    ca.prepareToDestroy();
                }
                if (ca_new instanceof FavsAdapter) {
                    FavsAdapter fav_a = (FavsAdapter)ca_new;
                    fav_a.setFavorites(this.p.getFavorites());
                }
                this.flv.setAdapter((ListAdapter)ca_new);
                this.flv.setOnKeyListener((View.OnKeyListener)this.p);
                SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences((Context)this.p.c);
                this.applySettings(sharedPref);
                ca = ca_new;
            }
            this.p.setPanelTitle("home".equals(ca.getScheme()) ? "" : this.p.c.getString(2131361916), this.which);
            if (crd != null) {
                ca.setCredentials(crd);
            }
            ca.setMode(112, this.adapterMode);
            ca.readSource(uri, "" + this.which + (posTo == null ? "" : posTo));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"NavigateInternal()", (Throwable)e);
        }
    }

    public final void focus() {
        if (this.flv == null) {
            return;
        }
        this.flv.requestFocus();
        this.flv.requestFocusFromTouch();
    }

    public final void applyColors(ColorsKeeper ck) {
        float pb;
        if (this.flv == null) {
            return;
        }
        this.flv.setBackgroundColor(ck.bgrColor);
        this.flv.setCacheColorHint(ck.bgrColor);
        if (ck.curColor != 0) {
            GradientDrawable selector_drawable = Utils.getShadingEx(ck.curColor, 0.9f);
            if (selector_drawable == null) {
                selector_drawable = new ColorDrawable(ck.curColor);
            }
            StateListDrawable sld = new StateListDrawable();
            sld.addState(new int[]{-16842909}, (Drawable)new ColorDrawable(0));
            sld.addState(new int[]{16842908, -16842910, 16842919}, (Drawable)selector_drawable);
            sld.addState(new int[]{16842908, -16842910}, (Drawable)selector_drawable);
            sld.addState(new int[]{16842908, 16842919}, (Drawable)selector_drawable);
            sld.addState(new int[]{-16842908, 16842919}, (Drawable)selector_drawable);
            sld.addState(new int[]{16842908}, (Drawable)selector_drawable);
            this.flv.setSelector((Drawable)sld);
        }
        float sb = (double)(pb = Utils.getBrightness(ck.bgrColor)) < 0.2 ? pb + 0.05f : pb - 0.05f;
        this.status.setBackgroundColor(Utils.setBrightness(ck.bgrColor, sb));
        this.status.setTextColor(ck.fgrColor);
    }

    public final void applySettings(SharedPreferences sharedPref) {
        try {
            int icon_mode;
            boolean same_line;
            CommanderAdapter ca = (CommanderAdapter)this.flv.getAdapter();
            if (ca == null) {
                return;
            }
            DisplayMetrics dm = new DisplayMetrics();
            this.p.c.getWindowManager().getDefaultDisplay().getMetrics(dm);
            float density = dm.density;
            Display disp = this.p.c.getWindowManager().getDefaultDisplay();
            int w = (int)((float)disp.getWidth() / density);
            int h = (int)((float)disp.getHeight() / density);
            int WIDTH_THRESHOLD = 480;
            int m = ca.setMode(1, this.p.sxs && w / 2 < 480 || sharedPref.getBoolean("two_lines", false) ? 0 : 1);
            this.flv.getWidth();
            ca.setMode(0x2000000, this.p.fnt_sz);
            this.status.setTextSize((float)(this.p.fnt_sz - 1));
            String sfx = this.p.sxs ? "_SbS" : "_Ovr";
            boolean detail_mode = sharedPref.getBoolean(this.which == 0 ? "left_detailed" + sfx : "right_detailed" + sfx, true);
            boolean show_icons = sharedPref.getBoolean("show_icons", true);
            boolean bl = same_line = (m & 1) == 1;
            if (show_icons) {
                icon_mode = 4096;
                if (this.p.fnt_sz < 18 && !this.p.fingerFriendly && (this.p.fnt_sz <= 10 || h * w <= 409920 && (this.p.sxs || same_line))) {
                    icon_mode |= 0x2000;
                }
            } else {
                icon_mode = 0;
            }
            ca.setMode(12288, icon_mode);
            ca.setMode(128, sharedPref.getBoolean("case_ignore", true) ? 128 : 0);
            ca.setMode(2, detail_mode ? 2 : 0);
            String sort = sharedPref.getString(this.which == 0 ? "left_sorting" : "right_sorting", "n");
            ca.setMode(48, sort.compareTo("s") == 0 ? 16 : (sort.compareTo("e") == 0 ? 48 : (sort.compareTo("d") == 0 ? 32 : 0)));
            ca.setMode(4, this.p.fingerFriendly ? 4 : 0);
            boolean hidden_mode = sharedPref.getBoolean((this.which == 0 ? "left" : "right") + "_show_hidden", true);
            ca.setMode(8, hidden_mode ? 0 : 8);
            int thubnails_size = 0;
            if (show_icons && sharedPref.getBoolean("show_thumbnails", true)) {
                thubnails_size = Integer.parseInt(sharedPref.getString("thumbnails_size", "200"));
            }
            ca.setMode(0x1000000, thubnails_size);
            if (ca instanceof HomeAdapter) {
                ca.setMode(1024, sharedPref.getBoolean("show_root", false) ? 1024 : 0);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"applySettings() inner", (Throwable)e);
        }
    }

    public void setFingerFriendly(boolean fat) {
        try {
            CommanderAdapter ca = (CommanderAdapter)this.flv.getAdapter();
            if (ca != null) {
                int mode = fat ? 4 : 0;
                ca.setMode(4, mode);
                this.flv.invalidate();
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, null, (Throwable)e);
        }
    }

    public final void setNeedRefresh() {
        this.needRefresh = true;
    }

    public final boolean needRefresh() {
        return this.needRefresh;
    }

    public final void refreshList(boolean was_current_, String posto) {
        try {
            this.was_current = was_current_;
            CommanderAdapter ca = (CommanderAdapter)this.flv.getAdapter();
            if (ca == null) {
                return;
            }
            this.storeChoosedItems();
            this.flv.clearChoices();
            String cookie = "" + this.which;
            if (posto != null) {
                cookie = cookie + posto;
            }
            ca.readSource(null, cookie);
            this.flv.invalidateViews();
            this.needRefresh = false;
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"refreshList()", (Throwable)e);
        }
    }

    public final void askRedrawList() {
        this.flv.invalidateViews();
    }

    public int getCurPos() {
        return this.currentPosition;
    }

    public void setCurPos(int pos) {
        this.currentPosition = pos;
    }

    public final void checkItem(boolean next) {
        int pos = this.getSelected();
        if (pos > 0) {
            SparseBooleanArray cis = this.flv.getCheckedItemPositions();
            this.flv.setItemChecked(pos, !cis.get(pos));
            if (next) {
                this.flv.setSelectionFromTop(pos + 1, this.flv.getHeight() / 2);
            }
        }
    }

    public final void checkItems(boolean set, String mask, boolean dir, boolean file) {
        try {
            if (!dir && !file) {
                return;
            }
            String[] cards = Utils.prepareWildcard(mask);
            ListAdapter la = this.flv.getAdapter();
            CommanderAdapter ca = (CommanderAdapter)la;
            if (la != null && cards != null) {
                for (int i = 1; i < this.flv.getCount(); ++i) {
                    CommanderAdapter.Item cai;
                    if (dir != file && ((cai = (CommanderAdapter.Item)la.getItem(i)) == null || (!cai.dir ? !file : !dir)) || !Utils.match(ca.getItemName(i, false), cards)) continue;
                    this.flv.setItemChecked(i, set);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)mask, (Throwable)e);
        }
    }

    public final void setSelection(int i, int y_) {
        final ListView flv$ = this.flv;
        final int position$ = i;
        final int y$ = y_;
        flv$.post(new Runnable(){

            public void run() {
                flv$.setSelectionFromTop(position$, y$ > 0 ? y$ : flv$.getHeight() / 2);
            }
        });
        this.currentPosition = i;
    }

    public final void setSelection(String name) {
        CommanderAdapter ca = (CommanderAdapter)this.flv.getAdapter();
        if (ca != null) {
            int num = ((ListAdapter)ca).getCount();
            for (int i = 0; i < num; ++i) {
                String item_name = ca.getItemName(i, false);
                if (item_name == null || item_name.compareTo(name) != 0) continue;
                this.setSelection(i, this.flv.getHeight() / 2);
                break;
            }
        }
    }

    public final String getActiveItemsSummary(boolean touched) {
        CommanderAdapter adapter = (CommanderAdapter)this.flv.getAdapter();
        String filter_info = null;
        FilterProps filter = adapter.getFilter();
        if (filter != null) {
            filter_info = filter.getString((Context)this.p.c);
        }
        filter_info = filter_info == null ? "" : filter_info + "  /  ";
        SparseBooleanArray cis = this.getMultiple(touched);
        int counter = Utils.getCount(cis);
        long total_size = 0L;
        for (int i = 0; i < cis.size(); ++i) {
            CommanderAdapter.Item item;
            if (!cis.valueAt(i)) continue;
            int pos = cis.keyAt(i);
            if (counter == 1) {
                String item_name = adapter.getItemName(pos, false);
                if (!Utils.str(item_name)) {
                    item_name = adapter.getItemName(pos, true);
                }
                return filter_info + item_name;
            }
            if (!(adapter instanceof FSAdapter) || (item = adapter.getItem(adapter.getItemUri(pos))) == null || item.dir) continue;
            total_size += item.size;
        }
        String items = null;
        if (counter < 5) {
            items = this.p.c.getString(2131362036);
        }
        if (items == null || items.length() == 0 || "\u00a0".equals(items)) {
            items = this.p.c.getString(2131362035);
        }
        String res = "" + counter + " " + items;
        if (total_size > 0L) {
            res = res + " (" + Utils.getHumanSize(total_size) + "b)";
        }
        return filter_info + res;
    }

    public final int getSingle(boolean touched) {
        if (touched) {
            return this.getSelected();
        }
        SparseBooleanArray cis = this.flv.getCheckedItemPositions();
        int sel_pos = -1;
        for (int i = 0; i < cis.size(); ++i) {
            if (!cis.valueAt(i)) continue;
            if (sel_pos >= 0) {
                return this.getSelected();
            }
            sel_pos = cis.keyAt(i);
        }
        return sel_pos >= 0 ? sel_pos : this.getSelected();
    }

    public final SparseBooleanArray getMultiple(boolean touched) {
        int pos = this.getSelected();
        SparseBooleanArray cis = this.flv.getCheckedItemPositions();
        if (-1 == pos) {
            return cis;
        }
        for (int i = 0; i < cis.size(); ++i) {
            if (!cis.valueAt(i) || touched && cis.keyAt(i) != pos) continue;
            return cis;
        }
        return this.wrapToSparceArray(pos);
    }

    public final SparseBooleanArray wrapToSparceArray(int pos) {
        SparseBooleanArray cis = new SparseBooleanArray(1);
        cis.put(pos, true);
        return cis;
    }

    public final int getSelected() {
        int pos = this.flv.getSelectedItemPosition();
        if (pos != -1) {
            this.currentPosition = pos;
            return this.currentPosition;
        }
        return this.currentPosition;
    }

    public final void recoverAfterRefresh(String item_name) {
        try {
            this.reStoreChoosedItems();
            if (Utils.str(item_name)) {
                this.setSelection(item_name);
            } else {
                this.setSelection(this.currentPosition > 0 ? this.currentPosition : 0, 0);
            }
            if (this.was_current) {
                this.p.setPanelCurrent(this.which, false);
                this.was_current = false;
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"recoverAfterRefresh()", (Throwable)e);
        }
    }

    public final void recoverAfterRefresh(boolean this_current) {
        try {
            this.reStoreChoosedItems();
            this.flv.invalidateViews();
            if (this_current && !this.flv.isInTouchMode() && this.currentPosition > 0) {
                this.setSelection(this.currentPosition, this.flv.getHeight() / 2);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"recoverAfterRefresh()", (Throwable)e);
        }
    }

    public void storeChoosedItems() {
        try {
            SparseBooleanArray cis = this.flv.getCheckedItemPositions();
            CommanderAdapter ca = (CommanderAdapter)this.flv.getAdapter();
            int counter = 0;
            for (int i = 0; i < cis.size(); ++i) {
                if (!cis.valueAt(i) || cis.keyAt(i) <= 0) continue;
                ++counter;
            }
            this.listOfItemsChecked = null;
            if (counter > 0) {
                this.listOfItemsChecked = new String[counter];
                int j = 0;
                for (int i = 0; i < cis.size(); ++i) {
                    int k;
                    if (!cis.valueAt(i) || (k = cis.keyAt(i)) <= 0) continue;
                    this.listOfItemsChecked[j++] = ca.getItemName(k, true);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"storeChoosedItems()", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reStoreChoosedItems() {
        try {
            if (this.listOfItemsChecked == null || this.listOfItemsChecked.length == 0) {
                return;
            }
            ListAdapter la = this.flv.getAdapter();
            if (la != null) {
                CommanderAdapter ca = (CommanderAdapter)la;
                int n_items = la.getCount();
                for (int i = 1; i < n_items; ++i) {
                    String item_name = ca.getItemName(i, true);
                    boolean set = false;
                    for (int j = 0; j < this.listOfItemsChecked.length; ++j) {
                        String ci = this.listOfItemsChecked[j];
                        if (ci == null || ci.compareTo(item_name) != 0) continue;
                        set = true;
                        break;
                    }
                    this.flv.setItemChecked(i, set);
                }
                if (this.currentPosition >= 0) {
                    this.setSelection(this.currentPosition, 0);
                }
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"reStoreChoosedItems()", (Throwable)e);
        }
        finally {
            this.listOfItemsChecked = null;
            this.updateStatus();
        }
    }

    public void updateStatus() {
        if (this.status != null) {
            this.status.setText((CharSequence)this.getActiveItemsSummary(false));
        }
    }
}

